$INCLUDE "windowssdk.inc"

$USE "animation.lib"

ENUM DWRITE_FONT_WEIGHT
  DWRITE_FONT_WEIGHT_THIN = 0
  DWRITE_FONT_WEIGHT_EXTRA_LIGHT
  DWRITE_FONT_WEIGHT_ULTRA_LIGHT
  DWRITE_FONT_WEIGHT_LIGHT
  DWRITE_FONT_WEIGHT_SEMI_LIGHT
  DWRITE_FONT_WEIGHT_NORMAL
  DWRITE_FONT_WEIGHT_REGULAR
  DWRITE_FONT_WEIGHT_MEDIUM
  DWRITE_FONT_WEIGHT_DEMI_BOLD
  DWRITE_FONT_WEIGHT_SEMI_BOLD
  DWRITE_FONT_WEIGHT_BOLD
  DWRITE_FONT_WEIGHT_EXTRA_BOLD
  DWRITE_FONT_WEIGHT_ULTRA_BOLD
  DWRITE_FONT_WEIGHT_BLACK
  DWRITE_FONT_WEIGHT_HEAVY
  DWRITE_FONT_WEIGHT_EXTRA_BLACK
  DWRITE_FONT_WEIGHT_ULTRA_BLACK
ENDENUM

ENUM DWRITE_FONT_STYLE
  DWRITE_FONT_STYLE_NORMAL = 0
  DWRITE_FONT_STYLE_OBLIQUE
  DWRITE_FONT_STYLE_ITALIC
ENDENUM

ENUM DWRITE_FONT_STRETCH
  DWRITE_FONT_STRETCH_UNDEFINED = 0
  DWRITE_FONT_STRETCH_ULTRA_CONDENSED
  DWRITE_FONT_STRETCH_EXTRA_CONDENSED
  DWRITE_FONT_STRETCH_CONDENSED
  DWRITE_FONT_STRETCH_SEMI_CONDENSED
  DWRITE_FONT_STRETCH_NORMAL
  DWRITE_FONT_STRETCH_MEDIUM
  DWRITE_FONT_STRETCH_SEMI_EXPANDED
  DWRITE_FONT_STRETCH_EXPANDED
  DWRITE_FONT_STRETCH_EXTRA_EXPANDED
  DWRITE_FONT_STRETCH_ULTRA_EXPANDED
ENDENUM

ENUM DWRITE_TEXT_ALIGNMENT
  DWRITE_TEXT_ALIGNMENT_LEADING = 0
  DWRITE_TEXT_ALIGNMENT_TRAILING
  DWRITE_TEXT_ALIGNMENT_CENTER
  DWRITE_TEXT_ALIGNMENT_JUSTIFIED
ENDENUM

ENUM DWRITE_PARAGRAPH_ALIGNMENT
  DWRITE_PARAGRAPH_ALIGNMENT_NEAR = 0
  DWRITE_PARAGRAPH_ALIGNMENT_FAR
  DWRITE_PARAGRAPH_ALIGNMENT_CENTER
ENDENUM
'
' ------------------------------------------------------------------------------------------------------------------------------------------------
' Media Fundation Video Player
'------------------------------------------------------------------------------------------------------------------------------------------------
'
DECLARE CDECL IMPORT, MFVideoInit(INT hwnd), pointer ' returns 'mfdata'
DECLARE CDECL IMPORT, MFVideoLoadFromFile(pointer mfdata, WSTRING sURL), UINT64 
DECLARE CDECL IMPORT, MFVideoGetPosition(pointer mfdata), UINT64
DECLARE CDECL IMPORT, MFVideoSetPosition(pointer mfdata, UINT64 value), HRESULT
DECLARE CDECL IMPORT, MFVideoPlay(pointer mfdata) ' play - resume video
DECLARE CDECL IMPORT, MFVideoPause(pointer mfdata)
DECLARE CDECL IMPORT, MFVideoRefresh(pointer mfdata) ' fill the window client area and repaint the current video frame
DECLARE CDECL IMPORT, MFVideoIsPlaying(pointer mfdata), INT
DECLARE CDECL IMPORT, MFVideoLoop(pointer mfdata, INT loop)
DECLARE CDECL IMPORT, MFVideoShutdown(pointer mfdata)
'
' ------------------------------------------------------------------------------------------------------------------------------------------------
' Gif Player
'------------------------------------------------------------------------------------------------------------------------------------------------
'
DECLARE CDECL IMPORT, gifAttach(HWND handle, int timerID, wstring szFileName, pointer render), pointer ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, gifDetach(HWND handle, pointer gif)
DECLARE CDECL IMPORT, RenderGif(pointer gif, OPT int x1 = 0, OPT int y1 = 0, OPT int x2 = 0, OPT int y2 = 0), HRESULT
DECLARE CDECL IMPORT, gifOnTimer(HWND handle, pointer gif, int timerID), HRESULT
DECLARE CDECL IMPORT, GifGetSize(pointer gif, int width BYREF, int height BYREF)
'
' ------------------------------------------------------------------------------------------------------------------------------------------------
' Windows Animation Manager
'------------------------------------------------------------------------------------------------------------------------------------------------
'
' animation library
DECLARE CDECL IMPORT, UIAnimationInit(pointer updatefunction), HRESULT
DECLARE CDECL IMPORT, UIAnimationFinish()
' animation variable
DECLARE CDECL IMPORT, UIAnimationVariableAdd(double initial, double min, double max), pointer
DECLARE CDECL IMPORT, UIAnimationVariableRemove(pointer variable)
DECLARE CDECL IMPORT, UIAnimationVariableGetCurrentValue(pointer variable), double
' transition
DECLARE CDECL IMPORT, UIAnimationTransitionLinearAdd(double duration, double finalvalue), pointer ' constant speed
DECLARE CDECL IMPORT, UIAnimationTransitionAccDecAdd(double duration, double finalvalue, double accratio, double decratio), pointer ' accelerate - decelerate
DECLARE CDECL IMPORT, UIAnimationTransitionSmoothStopAdd(double duration, double finalvalue), pointer ' fast to slow until zero
DECLARE CDECL IMPORT, UIAnimationTransitionReversalAdd(double duration), pointer ' smoothly changes direction. The final value will be the same as the initial value
DECLARE CDECL IMPORT, UIAnimationTransitionRemove(pointer transition)
' storyboard
DECLARE CDECL IMPORT, UIAnimationStoryBoardAdd(pointer storyboard), pointer
DECLARE CDECL IMPORT, UIAnimationStoryBoardTransitionJoin(pointer storyboard, pointer transition, pointer variable), HRESULT
DECLARE CDECL IMPORT, UIAnimationStoryboardLoopForever(pointer storyboard, double duration) ' duration = duration of related transition
DECLARE CDECL IMPORT, UIAnimationStoryboardPlay(pointer storyboard), HRESULT
DECLARE CDECL IMPORT, UIAnimationStoryboardIsPlaying(pointer storyboard), INT
DECLARE CDECL IMPORT, UIAnimationStoryboardRemove(pointer storyboard)
'
'------------------------------------------------------------------------------------------------------------------------------------------------
' Direct2D
'------------------------------------------------------------------------------------------------------------------------------------------------
'
' library
DECLARE CDECL IMPORT, D2DInit(), HRESULT
DECLARE CDECL IMPORT, D2DFinish()
' renderer
DECLARE CDECL IMPORT, D2DRenderTargetCreate(HWND handle, uint width, uint height), pointer ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DRenderTargetResize(pointer render, int width, int height)  ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DRenderTargetDestroy(pointer render) ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DRenderBegin(pointer render) ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DRenderEnd(pointer render), HRESULT ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DFillSolidColor(pointer render, int red, int green, int blue, INT opacity) ' pointer to D2D_RENDERTARGET
DECLARE CDECL IMPORT, D2DRenderGetSize(pointer render, int width BYREF, int height BYREF)
' brush
DECLARE CDECL IMPORT, D2DSolidBrushCreate(pointer render, int red, int green, int blue, int opacity), pointer ' pointer to D2D_SOLIDBRUSH
DECLARE CDECL IMPORT, D2DRenderRectangle(pointer render, pointer solidbrush, int x1, int y1, int x2, int y2) ' pointer to D2D_SOLIDBRUSH
DECLARE CDECL IMPORT, D2DRenderOutline(pointer render, pointer solidbrush, int x1, int y1, int x2, int y2)
DECLARE CDECL IMPORT, D2DSolidBrushRelease(pointer solidbrush) ' pointer to D2D_SOLIDBRUSH
' text
DECLARE CDECL IMPORT, D2DTextFormatCreate(pointer render, pointer unicodeName, double size, int weight, int style, int stretch, int textalign, int paragraphalign), pointer ' pointer to D2D_TEXTFORMAT
DECLARE CDECL IMPORT, D2DTextFormatUpdate(pointer render, pointer unicodeName, double size, int weight, int style, int stretch, int textalign, int paragraphalign, pointer textformat) ' pointer to D2D_TEXTFORMAT
DECLARE CDECL IMPORT, D2DRenderText(pointer render, pointer solidbrush, pointer unicodeText, int x1, int y1, int x2, int y2, pointer textformat)
DECLARE CDECL IMPORT, D2DTextFormatRelease(pointer textformat)
' bitmap
DECLARE CDECL IMPORT, D2DBitmapLoadFromFile(pointer render, pointer unicodeString, uint width, uint height), pointer ' pointer to D2D_BITMAP
DECLARE CDECL IMPORT, D2DRenderBitmap(pointer render, pointer bitmap, INT x, INT y, INT dimx, INT dimy, INT opacity)  ' pointer to D2D_BITMAP
DECLARE CDECL IMPORT, D2DBitmapRelease(pointer bitmap)  ' pointer to D2D_BITMAP
