'// Loads the PBSoft ctrl dll
'// You can simply use LoadLibary to load and initialize the PBSCtrl.
'// Or call the InitPBSoftCtrls() procedure..
#if %Def( %NOLOADPBSOFTCTRL )
#else
Declare Function InitPBSoftCtrls Lib "PBSCTRL.DLL" Alias "InitPBSoftCtrls" () As Long

'// Both procedures return the hWnd of the Popup.
Declare Function POPUP_Show Lib "PBSCTRL.DLL" Alias "POPUP_Show" ( ByVal hWnd As Long, ByVal Text As String ) As Long
Declare Function POPUP_ShowParam Lib "PBSCTRL.DLL" Alias "POPUP_ShowParam" ( ByVal hWnd As Long, ByVal Text As String, ByVal X As Long, ByVal Y As Long ) As Long

#endif


%MOD_PBSCTRLS = 1


'===========================================================================

'Example:

'        Control Add "" & $BROWSEFORFOLDER, CbHndl, 100, "" _
'            , 10, 10, 100, 100 _
'            , %WS_CHILD Or %WS_VISIBLE Or %WS_TABSTOP _
'              Or %TVS_HASBUTTONS Or %TVS_LINESATROOT Or %TVS_HASLINES _
'            , %WS_EX_CLIENTEDGE

'        // Open the treeview?
'        Control Send CbHndl, %ID_BFF, %BFF_EXPANDFIRSTITEM, 1, 0


$BROWSEFORFOLDER = "BrowseForFolder"

'// Commands
%BFF_CLEAR              = %WM_USER + 10000   '// Remove all items from Treeview.
%BFF_REFRESH            = %WM_USER + 10001   '// Forces a repaint.
%BFF_PATH               = %WM_USER + 10002   '// New path, lParam is pszString
%BFF_PATHBYPIDL         = %WM_USER + 10003   '// New path, wParam = %CSIDL_..
%BFF_JUMPTOPATH         = %WM_USER + 10004   '// Set to path. Selects the item with corresponding path, lParam is pszString
%BFF_GETPATH            = %WM_USER + 10005   '// Returns path placed in provided buffer. wparam = size of empty buffer, lparam = pointer to buffer
%BFF_GETPATHLEN         = %WM_USER + 10006   '// Use this to prepare a buffer.
%BFF_EXPANDFIRSTITEM    = %WM_USER + 10007   '// Opens/closes the first treeview item, wParam is switch

'// Notifications (WM_COMMAND)
%BFF_READY      = 1
%BFF_SELCHANGE  = 2

Function BFF_GetPath( ByVal hWnd As Long ) As String

    Dim a As Long
    Dim T As String

    If hWnd = 0 Then Exit Function

    a = SendMessage( hWnd, %BFF_GETPATHLEN, 0, ByVal 0& )
    If a > 0 Then

        T = String$( a, 0 )
        a = SendMessage( hWnd, %BFF_GETPATH, a, ByVal StrPtr( T ) )

        Function = T

    End If

End Function

Function BFF_JumpToPath( ByVal hWnd As Long, ByVal sNewPath As String ) As Long

    If hWnd = 0 Then Exit Function

    Function = SendMessage( hWnd, %BFF_JUMPTOPATH, Len( sNewPath ), ByVal StrPtr( sNewPath ) )

End Function


'===========================================================================

$FOLDERVIEW = "FolderView"

%FLDV_VIEWMODE      = %WM_USER + 10000  '// Set's new viewmode, wParam is new viewmode, see %LVS_ICON etc..
%FLDV_SELECT        = %WM_USER + 10001  '// NOT IN USE YET
%FLDV_GETSELECT     = %WM_USER + 10002  '// Returns the currently selected item. wParam is index to search from, -1 for current
%FLDV_PATH          = %WM_USER + 10003  '// Set's new path, lParam is szString
%FLDV_GETPATH       = %WM_USER + 10004  '// Returns the currentpath. lParam is pointer to buffer, 0 for len only.
%FLDV_GETPATHFILE   = %WM_USER + 10005  '// Returns true path or filename. -1 for selected index
%FLDV_GETTEXT       = %WM_USER + 10006  '// Returns the currently selected item's text. wParam is nItem, -1 for current, lParam is pointer to buffer, 0 for len only
%FLDV_SHOWWHAT      = %WM_USER + 10007  '// wParam is one or more of %FLDV_SHOW_..., lParam is boolean, refresh now
%FLDV_EXECUTE       = %WM_USER + 10008  '// Executes the selected item, changes path or runs document, executes exe etc.., returns instance handle or -1 for valid path opened
%FLDV_SHOWPROP      = %WM_USER + 10009  '// Shows the Windows - properties dialog for the file selected.
%FLDV_CALLBACK      = %WM_USER + 10010  '// Provide a custom callback procedure, you are able to cancel adding one or more files. wParam = CodePtr(), lParam = custom value.

'// Bitwise selection.
%FLDV_SHOW_NONE     = 0
%FLDV_SHOW_FILES    = 1
%FLDV_SHOW_PATHS    = 2


'// Use this prototype for your custom callback.
'// hWnd = hWnd listview control
'// WFD, standard Windows structure, See WinApi.
'// Returning 1 will abort adding this file/path.
Declare Function FolderView_Callback( ByVal hWnd As Long, ByVal nReserved As Long, WFD As WIN32_FIND_DATA, ByVal lParam As Long ) As Long

Function FLDV_GetPath( ByVal hWnd As Long ) As String

    Dim a As Long
    Dim T As String

    If hWnd = 0 Then Exit Function

    a = SendMessage( hWnd, %FLDV_GETPATH, 0, ByVal 0& )
    If a > 0 Then

        T = String$( a, 0 )
        a = SendMessage( hWnd, %FLDV_GETPATH, a, ByVal StrPtr( T ) )

        Function = T

    End If

End Function

Function FLDV_GetPathFile( ByVal hWnd As Long ) As String

    Dim a As Long
    Dim T As String

    If hWnd = 0 Then Exit Function

    a = SendMessage( hWnd, %FLDV_GETPATHFILE, -1, ByVal 0& )
    If a > 0 Then

        T = String$( a, 0 )
        a = SendMessage( hWnd, %FLDV_GETPATHFILE, -1, ByVal StrPtr( T ) )

        Function = T

    End If

End Function

Function FLDV_GetFullFilePath( ByVal hWnd As Long ) As String

    If hWnd = 0 Then Exit Function

    Function = FLDV_GetPath( hWnd ) & FLDV_GetPathFile( hWnd )

End Function

Function FLDV_Path( ByVal hWnd As Long, ByVal sNewPath As String ) As Long

    If hWnd = 0 Then Exit Function

    '// Not really needed but i like to be sure you have a null.
    sNewPath = sNewPath & Chr$( 0 )

    Function = SendMessage( hWnd, %FLDV_PATH, 0, ByVal StrPtr( sNewPath ) )

End Function


'===========================================================================

$DRIVECOMBOBOX  = "DriveComboBox"
$DRIVELISTBOX   = "DriveListBox"

%DRB_BACKCOLOR   = %WM_USER + 1000   '// wParam is new RGB() (for added elements only).
%DRB_FORECOLOR   = %WM_USER + 1001   '// wParam is new RGB().
%DRB_GETBACKCOLOR= %WM_USER + 1002   '// Get backcolor
%DRB_GETFORECOLOR= %WM_USER + 1003   '// Get forecolor set.
%DRB_DRIVE       = %WM_USER + 1004   '// wParam is ordinal (1 to 26) value for selecting new device, returns 1 for succes.
%DRB_GETDRIVE    = %WM_USER + 1005   '// Returns the current device (1 to 26). 0 if non selected
%DRB_GETITEM     = %WM_USER + 1006   '// Substitute for LBGETTEXT, wParam is item, -1 for current, lParam = pszBuffer, 0 for returning length only.
%DRB_REFRESH     = %WM_USER + 1007   '// Refills the control.
%DRB_CLEAR       = %WM_USER + 1008   '// Empties control.

'===========================================================================

$DIRLISTBOX = "DirListBox"

%DLB_BACKCOLOR       = %WM_USER + 1000   '// wParam is new RGB()
%DLB_FORECOLOR       = %WM_USER + 1001   '// wParam is new RGB()
%DLB_GETBACKCOLOR    = %WM_USER + 1002   '// Get backcolor
%DLB_GETFORECOLOR    = %WM_USER + 1003   '// Get forecolor set.
%DLB_PATH            = %WM_USER + 1004   '// wParam is size of buffer set in lParam, 0 for szstring, lParam is buffer containing new path.
%DLB_GETPATH         = %WM_USER + 1005   '// Returns selected (open) path, wParam is size of buffer to fill, 0 for returning len required, lParam is buffer to fill.
%DLB_GETITEM         = %WM_USER + 1006   '// Returns selected item's path, wParam is size of buffer to fill, 0 for returning len required, lParam is buffer to fill.
%DLB_CLEAR           = %WM_USER + 1007   '// Clears control contents.
%DLB_REFRESH         = %WM_USER + 1008   '// Refills the control.

'===========================================================================

$FILECOMBOBOX = "FileComboBox"
$FILELISTBOX  = "FileListBox"

%FLB_BACKCOLOR      = %WM_USER + 1000   '// wParam is new RGB()
%FLB_GETBACKCOLOR   = %WM_USER + 1001   '// Get backcolor
%FLB_FORECOLOR      = %WM_USER + 1002   '// wParam is new RGB()
%FLB_GETFORECOLOR   = %WM_USER + 1003   '// Get forecolor set.
%FLB_PATH           = %WM_USER + 1004   '// wParam is size of buffer set in lParam, 0 for szstring, lParam is buffer containing new path.
%FLB_GETPATH        = %WM_USER + 1005   '// wParam is size of buffer to fill, 0 for returning len required, lParam is buffer to fill.
%FLB_GETITEM        = %WM_USER + 1006   '// wParam is size of buffer to fill, 0 for returning len required, lParam is buffer to fill.
%FLB_SHOWICONS      = %WM_USER + 1007   '// wParam is Boolean
%FLB_CLEAR          = %WM_USER + 1008   '// Empties control.
%FLB_REFRESH        = %WM_USER + 1009   '// Refills the control.

'===========================================================================

'// Checklistbox.
'// Select checks using Space or mouse.
$CHECKLISTBOX = "CheckListBox"

'// Custom messages to interact with the control.
%CLB_BACKCOLOR          = %WM_USER + 1000   'wParam = RGB()
%CLB_GETBACKCOLOR       = %WM_USER + 1001   'Returns the backcolor.
%CLB_FORECOLOR          = %WM_USER + 1002   'wParam = RGB()
%CLB_GETFORECOLOR       = %WM_USER + 1003   'Returns the forecolor.
%CLB_SETCHECK           = %WM_USER + 1004   'wParam = index, lParam = True/False
%CLB_GETCHECK           = %WM_USER + 1005   'wParam = index
%CLB_SETCHECKENABLED    = %WM_USER + 1006   'wParam = index, lParam = True/False
%CLB_GETCHECKENABLED    = %WM_USER + 1007   'wParam = index
%CLB_SHOWCHECKBOXES     = %WM_USER + 1008   'wParam = boolean, Shows/hides the checkboxes, they still exist when hidden.
%CLB_USE3DCHECKS        = %WM_USER + 1009   'wParam = boolean
%CLB_SETLINESPERITEM    = %WM_USER + 1010   'wParam = nCount (> 0), based on selected font.


'===========================================================================



'////////////////////////////////////////////////////////////////////////////////////
'// Threed button
'// Use windowclass:

$THREEDBUTTON = "ThreedButton"

'////////////////////////////////////////////////////////////////////////////////////

'// Commands
%TDB_BACKCOLOR      = %WM_USER + 1000   '// wParam is new RGB()
%TDB_GETBACKCOLOR   = %WM_USER + 1001   '// Get backcolor set
%TDB_FORECOLOR      = %WM_USER + 1002   '// wParam is new RGB()
%TDB_GETFORECOLOR   = %WM_USER + 1003   '// Get forecolor set.
%TDB_FONT3D         = %WM_USER + 1004   '// wParam = font3dtype, See %TDB_FONT3D_...
%TDB_GETFONT3D      = %WM_USER + 1005   '// Get font3dtype set.
%TDB_ICON           = %WM_USER + 1006   '// wParam = hIcon, lParam = icontype, See %TDB_ICON_...
%TDB_GETICON        = %WM_USER + 1007   '// Returns hIcon set.
%TDB_ALIGNTEXT      = %WM_USER + 1008   '// wParam = alignment, See %TDB_ALIGN_...
%TDB_GETALIGNTEXT   = %WM_USER + 1009   '// Get alignment set.
%TDB_OFFSETTEXT     = %WM_USER + 1010   '// wParam = horizontal offset, lParam = vertical offset.
%TDB_GETOFFSETTEXT  = %WM_USER + 1011   '// wParam = long ptr, lParam = long ptr ( VarPtr( a& ) )
%TDB_ALIGNICON      = %WM_USER + 1012   '// wParam = alignment, See %TDB_ALIGN_...
%TDB_GETALIGNICON   = %WM_USER + 1013   '// Get alignment set.
%TDB_OFFSETICON     = %WM_USER + 1014   '// wParam = horizontal offset, lParam = vertical offset.
%TDB_GETOFFSETICON  = %WM_USER + 1015   '// wParam = long ptr, lParam = long ptr ( VarPtr( a& ) )
%TDB_ANGLE          = %WM_USER + 1016   '// wParam = angle, note that you should use a TT font, Example 450 = 45 degrees.
%TDB_GETANGLE       = %WM_USER + 1017   '// Returns angle.

'// Alignment constants for bitmap and/or caption.
%TDB_ALIGN_LEFTJUSTIFYTOP      = 0
%TDB_ALIGN_LEFTJUSTIFYMIDDLE   = 1
%TDB_ALIGN_LEFTJUSTIFYBOTTOM   = 2
%TDB_ALIGN_RIGHTJUSTIFYTOP     = 3
%TDB_ALIGN_RIGHTJUSTIFYMIDDLE  = 4
%TDB_ALIGN_RIGHTJUSTIFYBOTTOM  = 5
%TDB_ALIGN_CENTERTOP           = 6
%TDB_ALIGN_CENTERMIDDLE        = 7
%TDB_ALIGN_CENTERBOTTOM        = 8

'// Font3D setting
%TDB_FONT3D_NORMAL            = 0
%TDB_FONT3D_RAISEDSHADELIGHT  = 1 '1 - RAISED W/LIGHT SHADING
%TDB_FONT3D_RAISEDSHADEHEAVY  = 2 '2 - RAISED W/HEAVY SHADING
%TDB_FONT3D_INSETSHADELIGHT   = 3 '3 - INSET W/LIGHT SHADING
%TDB_FONT3D_INSETSHADEHEAVY   = 4 '4 - INSET W/HEAVY SHADING


'////////////////////////////////////////////////////////////////////////////////////
'// Threed Panel
'// Use windowclass:

$THREEDPANEL = "ThreedPanel"

'////////////////////////////////////////////////////////////////////////////////////

%TDP_BACKCOLOR          = %WM_USER + 1000   '// wParam is new RGB()
%TDP_GETBACKCOLOR       = %WM_USER + 1001   '// Get backcolor
%TDP_FORECOLOR          = %WM_USER + 1002   '// wParam is new RGB()
%TDP_GETFORECOLOR       = %WM_USER + 1003   '// Get forecolor set.
%TDP_ALIGN              = %WM_USER + 1004   '// align ctrl to parent, see %TDP_ALIGN_...
%TDP_GETALIGN           = %WM_USER + 1005   '//
%TDP_ALIGNMENT          = %WM_USER + 1006   '// Caption alignment, See %TDP_ALIGNMENT_...
%TDP_GETALIGNMENT       = %WM_USER + 1007   '//
%TDP_FONT3D             = %WM_USER + 1008   '// wParam = font3dtype, See %TDP_FONT3D_...
%TDP_GETFONT3D          = %WM_USER + 1009   '// Get font3dtype set.
%TDP_BEVELINNER         = %WM_USER + 1010   '// See %TDP_BEVEL_...
%TDP_GETBEVELINNER      = %WM_USER + 1011   '//
%TDP_BEVELOUTER         = %WM_USER + 1012   '// See %TDP_BEVEL_...
%TDP_GETBEVELOUTER      = %WM_USER + 1013   '//
%TDP_BORDERWIDTH        = %WM_USER + 1014   '// Space between inner and outer bevel.
%TDP_GETBORDERWIDTH     = %WM_USER + 1015   '//

'// Enforce alignment by sending a WM_SIZE to the control.
%TDP_ALIGN_NONE     = 0
%TDP_ALIGN_LEFT     = 1
%TDP_ALIGN_TOP      = 2
%TDP_ALIGN_RIGHT    = 3
%TDP_ALIGN_BOTTOM   = 4
%TDP_ALIGN_ALL      = 5

'// Alignment constants for caption.
%TDP_ALIGNMENT_LEFTJUSTIFYTOP      = 0
%TDP_ALIGNMENT_LEFTJUSTIFYMIDDLE   = 1
%TDP_ALIGNMENT_LEFTJUSTIFYBOTTOM   = 2
%TDP_ALIGNMENT_RIGHTJUSTIFYTOP     = 3
%TDP_ALIGNMENT_RIGHTJUSTIFYMIDDLE  = 4
%TDP_ALIGNMENT_RIGHTJUSTIFYBOTTOM  = 5
%TDP_ALIGNMENT_CENTERTOP           = 6
%TDP_ALIGNMENT_CENTERMIDDLE        = 7
%TDP_ALIGNMENT_CENTERBOTTOM        = 8

%TDP_BEVEL_NONE     = 0
%TDP_BEVEL_SUNKEN   = 1
%TDP_BEVEL_RAISED   = 2

'// Font3D setting
%TDP_FONT3D_NORMAL            = 0
%TDP_FONT3D_RAISEDSHADELIGHT  = 1 '1 - RAISED W/LIGHT SHADING
%TDP_FONT3D_RAISEDSHADEHEAVY  = 2 '2 - RAISED W/HEAVY SHADING
%TDP_FONT3D_INSETSHADELIGHT   = 3 '3 - INSET W/LIGHT SHADING
%TDP_FONT3D_INSETSHADEHEAVY   = 4 '4 - INSET W/HEAVY SHADING

'////////////////////////////////////////////////////////////////////////////////////
'// LBGrid, small grid control.
'// Use windowclass:

$LBGRID = "LBGrid"

'// Custom messages to interact with the control.
%LBG_BACKCOLOR          = %WM_USER + 1000   'wParam = RGB()
%LBG_GETBACKCOLOR       = %WM_USER + 1001   'Returns the backcolor.
%LBG_FORECOLOR          = %WM_USER + 1002   'wParam = RGB()
%LBG_GETFORECOLOR       = %WM_USER + 1003   'Returns the forecolor.
%LBG_LINECOLOR          = %WM_USER + 1004   'wParam = RGB()
%LBG_GETLINECOLOR       = %WM_USER + 1005   'Returns the forecolor.
%LBG_BOXCOLOR           = %WM_USER + 1006   'wParam = RGB()
%LBG_GETBOXCOLOR        = %WM_USER + 1007   'Returns the forecolor.
%LBG_MAXROWS            = %WM_USER + 1008   'wParam = amount, removes additional rows.
%LBG_GETMAXROWS         = %WM_USER + 1009   'Returns maxrows.
%LBG_MAXCOLS            = %WM_USER + 1010   'wParam = amount, removes additional fields.
%LBG_GETMAXCOLS         = %WM_USER + 1011   'Returns maxcols.
%LBG_ROW                = %WM_USER + 1012   'Set's row.
%LBG_GETROW             = %WM_USER + 1013   'Returns selected row
%LBG_COL                = %WM_USER + 1014   'Set's col.
%LBG_GETCOL             = %WM_USER + 1015   'Returns selected col
%LBG_ROWCOL             = %WM_USER + 1016   'wParam = column, lParam = row.
%LBG_DEFAULTCOLWIDTH    = %WM_USER + 1017   'wParam = initial column width in pixels.
%LBG_GETDEFAULTCOLWIDTH = %WM_USER + 1018   'Returns default column width
%LBG_GETCELLRECT        = %WM_USER + 1019   'Lowrd(wParam) = Row, hiwrd(wParam) = Col, lParam = pointer to Rect, returns boolean.

'////////////////////////////////////////////////////////////////////////////////////
'// GridView, Grid control.
'// Use windowclass:
$GRIDVIEW = "GridView"

'/////////////////////////////////////////////////////////////////////////////////////////
'// Messages to the control.
'/////////////////////////////////////////////////////////////////////////////////////////

%GVW_BACKCOLOR      = %WM_USER + 10000  '// wParam is new RGB()
%GVW_GETBACKCOLOR   = %WM_USER + 10001  '// Get backcolor set.
%GVW_FORECOLOR      = %WM_USER + 10002  '// wParam is new RGB()
%GVW_GETFORECOLOR   = %WM_USER + 10003  '// Get forecolor set.
%GVW_LINECOLOR      = %WM_USER + 10004  '// wParam = RGB()
%GVW_GETLINECOLOR   = %WM_USER + 10005  '// Returns the linecolor.
%GVW_MAXCOLS        = %WM_USER + 10006  '// Set maxcols
%GVW_GETMAXCOLS     = %WM_USER + 10007  '// Returns maxcols
%GVW_MAXROWS        = %WM_USER + 10008  '// Set maxrows
%GVW_GETMAXROWS     = %WM_USER + 10009  '// Returns maxrows
%GVW_TEXT           = %WM_USER + 10010  '// Set text, wParam is pointer to GV_COORD, lParam is pointer to asciiz.
%GVW_GETTEXT        = %WM_USER + 10011  '// Returns text, wParam is pointer to GV_COORD, lParam is pointer to asciiz, 0 for len only.
%GVW_COLTEXT        = %WM_USER + 10012  '// Set text, wParam is Colnr, lParam is pointer to asciiz.
%GVW_GETCOLTEXT     = %WM_USER + 10013  '// Returns coltext, wParam is ColNr, lParam is pointer to asciiz, 0 for len only.
%GVW_COLALIGNMENT   = %WM_USER + 10014  '// Sets col alignment, wParam = Colnr, lParam = %LVCFMT_...
%GVW_DEFCOLWIDTH    = %WM_USER + 10015  '// When adding cols, this width is the default, use wParam in pixels.
%GVW_TEXTOFFSETX    = %WM_USER + 10016  '// Determines the start of the text in the cell, wParam is > 0
%GVW_GETTEXTOFFSETX = %WM_USER + 10017  '// Returns the start of the text in the cell.
%GVW_ROWHEIGHT      = %WM_USER + 10018  '// Sets new rowheight for all rows, wParam is pixels >= 4
%GVW_GETROWHEIGHT   = %WM_USER + 10019  '// Returns the rowheight set.
%GVW_COL            = %WM_USER + 10020  '// Sets focus to Col..
%GVW_GETCOL         = %WM_USER + 10021  '// Returns active col.
%GVW_ROW            = %WM_USER + 10022  '// Sets focus to row.., NOT implemented yet.
%GVW_GETROW         = %WM_USER + 10023  '// Returns active row.
%GVW_DELETEROW      = %WM_USER + 10024  '// Deletes the row set in wParam.
%GVW_INSERTROW      = %WM_USER + 10025  '// Not implemented yet, Inserts a row.
%GVW_DELETECOL      = %WM_USER + 10026  '// Not implemented yet, Deletes a column.
%GVW_INSERTCOL      = %WM_USER + 10027  '// Not implemented yet, Inserts a column.
%GVW_USERRESIZE_COL = %WM_USER + 10028  '// wParam is mode, See %GVW_USERRESIZE_MODE_... for specifics.
%GVW_USERRESIZE_ROW = %WM_USER + 10029  '// Not implemented.

'// UserResize mode flags.
%GVW_USERRESIZE_MODE_SIZEALL    = 0 '// Default, user may resize any column.
%GVW_USERRESIZE_MODE_SIZENONE   = 1 '// Prevent user resizing any column.
%GVW_USERRESIZE_MODE_SIZEBYNR   = 2 '// Prevent user resizing a specific column.
'// lParam is a array&() containing 1 or more elements,
'// the first element must specify the total elements to expect not counting the first one (0).
'// Example:
'// Dim UsrRes( 0 to 10 ) As Long
'// UsrRes( 0 ) = Ubound( UsrRes )
'// UsrRes( 1 ) = 4 ' Allow column 4 to be resized by user.
'// UsrRes( 2 ) = 5 ' Allow column 5 to be resized by user.
'// ... until UsrRes( 10 ) set.

'/////////////////////////////////////////////////////////////////////////////////////////
'// Notification messages from the control.
'/////////////////////////////////////////////////////////////////////////////////////////

'// Messages to the parent are sent by using structs.
'// By default:
'// wMsg(%GVM_NOTIFY), wParam(CtrlID), lParam(Pointer to GVW_Notify)
'// This forms the basis.
'// In the the lParam of the GVW_Notify-struct, might be a pointer toi additional data.
'// Like the GVW_COORD-struct for example.
'// GVW_Notify consists of:
'// 1) hWnd of the control.
'// 2) The notify message you should recognize. (Like: %GVN_ENTEREDIT)
'// 3) Pointer to additional data.

'// Message
%GVM_NOTIFY        = %WM_USER + 1000

'// Notifies
%GVN_ENTEREDIT     = 1  '// Cell is gonna be edited, you mat return 1 to prevent.
%GVN_LEAVEEDIT     = 2  '// Cell is edited or cancelled.

'// Main notify structure.
Type GVW_Notify

    hWnd    As Long
    cMsg    As Long
    lParam  As Long

End Type

'// Contains the row and col indexes.
Type GVW_COORD

    nCol As Dword
    nRow As Dword

End Type

'// Set's text by col/row
Function GV_SetText( _
      ByVal hDlg    As Long _
    , ByVal nCtrlId As Long _
    , ByVal nCol    As Long _
    , ByVal nRow    As Long _
    , ByVal sText   As String _
    ) As Long

    Dim GVCoord As GVW_COORD

    If hDlg = 0 Then Exit Function
    If nCtrlId Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    GVCoord.nCol = nCol
    GVCoord.nRow = nRow

    Function = SendMessage( hDlg, %GVW_TEXT, VarPtr( GVCoord ), ByVal StrPtr( sText ) )

End Function

Function GV_GetText( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal nCol As Long, ByVal nRow As Long ) As String

    Dim a       As Long
    Dim T       As String
    Dim GVCoord As GVW_COORD

    If hDlg = 0 Then Exit Function
    If nCtrlId Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    GVCoord.nCol = nCol
    GVCoord.nRow = nRow

    a = SendMessage( hDlg, %GVW_GETTEXT, VarPtr( GVCoord ), 0 )
    If a > 0 Then

        T = String$( a, 0 )
        SendMessage hDlg, %GVW_GETTEXT, VarPtr( GVCoord ), ByVal StrPtr( T )

    End If

    Function = T

End Function

'////////////////////////////////////////////////////////////////////////////////////
'// ColPick consist of two controls, a listbox and a combobox control.
'// They show, by default, the windows system colors.
'// It's possible to set these controls with any RGB() value and in any order you wish.
'// By default the controls are filled, if you wish to use your own colors,
'// Just clear the box (%CP_CLEAR) and add new colors (%CP_ADDCOLOR)
'// Internally the text is added using (C)LB_ADDSTRING, the color is stored in the itemdata.
'// When you wish to retrieve the selected color,
'// the combo and listbox send's the standard notifications to the parent.
'// You could then retrieve the itemdata.
'// You better use %CP_GETVALUE for both the controls instead of (C)LB_GETITEMDATA.
'// System colors in Windows are declared from %COLOR_SCROLLBAR to %COLOR_INFOBK
'// Since these values could be interpreted as RGB() values, the controls add these
'// values as negative numbers starting at an offset of 2 ( %COLOR_SCROLLBAR will be -2 )
'// You need to convert it back using: v& = ( -itemdata& - 2 )
'// If you need an RGB() value for all cases, you simply could use %CP_GETCOLOR.
'// System indexes are converted to RGB() values.

'// Windowclasses:
$COLPICKCOMBOBOX  = "ColPickComboBox"
$COLPICKLISTBOX   = "ColPickListBox"

'/////////////////////////////////////////////////////////////////////////////////////////
'// Messages to the control(s).
'/////////////////////////////////////////////////////////////////////////////////////////
%CP_BACKCOLOR       = %WM_USER + 10000   '// wParam is new RGB().
%CP_FORECOLOR       = %WM_USER + 10001   '// wParam is new RGB().
%CP_GETBACKCOLOR    = %WM_USER + 10002   '// Get backcolor set.
%CP_GETFORECOLOR    = %WM_USER + 10003   '// Get forecolor set.
%CP_CLEAR           = %WM_USER + 10004   '// Empties control.
%CP_SETMODE         = %WM_USER + 10005   '// See %CP_MODE_..., wParam is mode
%CP_GETMODE         = %WM_USER + 10006   '// See %CP_MODE_...
%CP_USECAPTION      = %WM_USER + 10007   '// Show captions, wParam is boolean.
%CP_GETUSECAPTION   = %WM_USER + 10008   '//
%CP_SELECTCOLOR     = %WM_USER + 10009   '// Show highlight colors on selected item.
%CP_GETSELECTCOLOR  = %WM_USER + 10010   '//
%CP_ADDCOLOR        = %WM_USER + 10011   '// Add a entry with specified color, wParam = RGB(), lParam = szString
                                        '// Use -1 for 'default' (Wich will be shown as CB or LB backcolor)
                                        '// Use -2 as base for system colors
                                        '// e.g. -2 will be %COLOR_SCROLLBAR, -3 will be %COLOR_BACKGROUND etc..
%CP_GETVALUE        = %WM_USER + 10012   '// Returns the value set using %CP_ADDCOLOR, wParam is listindex, -1 for current selected item
%CP_GETCOLOR        = %WM_USER + 10013   '// Returns RGB() of the System color our your custom color set, wParam is listindex, -1 for current selected item
%CP_GETCURSEL       = %WM_USER + 10014   '// Returns current selected item (values described in MSDN for CB and LB).

'// Mode
%CP_MODE_NONE       = 0 '// Not in use.
%CP_MODE_SYSTEM     = 1 '// Fill with system colors (Default)
%CP_MODE_QBCOLOR    = 2 '// Fill with 'Quickbasic' colors
%CP_MODE_PALETTE    = 3 '// Fill with Visual Basic 'palette' colors

'////////////////////////////////////////////////////////////////////////////////////
'// Color tabstrip, tab control for the ColPick controls.
'// Windowclass:
$COLORTABSTRIP = "ColorTabStrip"

'// Ctrl-id's
%ID_PALETTE = 100   '// Control id of Palette LB.
%ID_SYSTEM  = 101   '// Control id of System LB.
%ID_QB      = 102   '// Control id of QBColors LB.

'// %CP_ messages are routed to the currently visible LB control/Tab.
'// Use GetDlgItem( hWndColTabStrip, %ID_PALETTE ) to get the handle of the Palette listbox for example.


'////////////////////////////////////////////////////////////////////////////////////
'// HyperLinkLabel will send a WM_COMMAND -> BN_CLICKED to it's parent when clicked.
'// If the control HLL_AUTOEXECLINK is set, the control will execute the contents for you.
'// If not set, you should take action on BN_CLICKED yourself.
'// You can force execution it's contents by using the %HLL_EXECLINK call.
'////////////////////////////////////////////////////////////////////////////////////

'// Windowclass:
$HYPERLINKLABEL = "HyperLinkLabel"

'////////////////////////////////////////////////////////////////////////////////////
'// Use SendMessage API to interact with the control.
'////////////////////////////////////////////////////////////////////////////////////
%HLL_BACKCOLOR          = %WM_USER + 1000   '// wParam is new RGB()
%HLL_GETBACKCOLOR       = %WM_USER + 1001   '// Get backcolor
%HLL_FORECOLOR          = %WM_USER + 1002   '// wParam is new RGB()
%HLL_GETFORECOLOR       = %WM_USER + 1003   '// Get forecolor set.
%HLL_HIFORECOLOR        = %WM_USER + 1004   '// Forecolor for MouseHover, wParam is new RGB()
%HLL_GETHIFORECOLOR     = %WM_USER + 1005   '// Get forecolor set on mousehover.
%HLL_ALIGNMENT          = %WM_USER + 1006   '// wParam, 1 = Left (Default), 2 = right, 3 = center
%HLL_GETALIGNMENT       = %WM_USER + 1007   '// Returns alignment.
%HLL_AUTOEXECLINK       = %WM_USER + 1008   '// wParam is boolean, To let the control autom. execute the link when clicked (default on)
%HLL_GETAUTOEXECLINK    = %WM_USER + 1009   '// Returns current setting.
%HLL_EXECLINK           = %WM_USER + 1010   '// Send this message to execute the current contents of the link.
%HLL_MODE               = %WM_USER + 1011   '// NOT IMPLEMENTED YET, wParam set's new mode, See %HLL_MODE_...
%HLL_GETMODE            = %WM_USER + 1012   '// NOT IMPLEMENTED YET

'// Mode
%HLL_MODE_HYPERLINK     = 1 '// Control behavious like a hyperlink (default)
%HLL_MODE_HOVERBUTTON   = 2 '// Control behavious like a toolbarbutton, 3d edged.

'////////////////////////////////////////////////////////////////////////////////////
'// WebBrowse control.
'// Use WM_SETTEXT to jump to new URL
'// WM_NOTIFY and WB_HHN_NOTIFY are used to receive messages from the browser.
'////////////////////////////////////////////////////////////////////////////////////
$WEBBROWSER = "WebBrowseClass"

%WB_CALLBUTTON  = %WM_USER + 1000   '// Call the functionality under the button, see the %IDTB_.. constants.
%WB_SHOWBUTTON  = %WM_USER + 1001   '// Hide one or more buttons, see the %IDTB_.. constants.

'// MSIE internal commands
$WB_ABOUT           = "about:"                      '// Can be used to print any line in the browser
$WB_BLANK           = "about:Blank"                 '// Show an empty page
$WB_NAVCANCELLED    = "about:NavigationCanceled"    '// Show the cancelled page.
$WB_OFFLINEINFO     = "about:OfflineInformation"

'about:DesktopItemNavigationFailure

'// Button IDs, Remarked ones are not set and cannot be made visible or executed.
'%IDTB_EXPAND        = 200
'%IDTB_CONTRACT      = 201
%IDTB_STOP          = 202
%IDTB_REFRESH       = 203
%IDTB_BACK          = 204
%IDTB_HOME          = 205
'%IDTB_SYNC          = 206
%IDTB_PRINT         = 207
'%IDTB_OPTIONS       = 208
%IDTB_FORWARD       = 209
'%IDTB_NOTES         = 210
'%IDTB_BROWSE_FWD    = 211
'%IDTB_BROWSE_BACK   = 212
'%IDTB_CONTENTS      = 213
'%IDTB_INDEX         = 214
'%IDTB_SEARCH        = 215
'%IDTB_HISTORY       = 216
'%IDTB_FAVORITES     = 217
'%IDTB_JUMP1         = 218
'%IDTB_JUMP2         = 219
'%IDTB_CUSTOMIZE     = 221
%IDTB_ZOOM          = 222
'%IDTB_TOC_NEXT      = 223
'%IDTB_TOC_PREV      = 224

Type WB_HHN_NOTIFY

    hdr         As NMHDR
    pszUrl      As Asciiz Ptr

End Type

Type WB_HHNTRACK

    hdr         As NMHDR
    pszCurUrl   As Asciiz Ptr
    idAction    As Long
    phhWinType  As Long

End Type

#if Not %Def( %HHN_FIRST )

%HHN_FIRST          = ( 0 - 860 )

%HHN_NAVCOMPLETE    = ( %HHN_FIRST - 0 )
%HHN_TRACK          = ( %HHN_FIRST - 1 )
%HHN_WINDOW_CREATE  = ( %HHN_FIRST - 2 )

#endif

'// Navigateto.. (URL)
Function WB_NavigateTo( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal sURL As String ) As Long

    If hDlg = 0 Then Exit Function
    If nCtrlId Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %WM_SETTEXT, 0, StrPtr( sURL ) )

End Function

'// Call a button (even when hidden), for example, call the print dialog.
Function WB_CallButton( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal nIDButton As Long ) As Long

    If hDlg = 0 Then Exit Function
    If nCtrlId Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %WB_CALLBUTTON, nIDButton, 0 )

End Function

'// Shows or hides a button
'// When all buttons are hidden, the toolbar is removed.
Function WB_ShowButton( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal nIDButton As Long, ByVal bOnOff As Long ) As Long

    If hDlg = 0 Then Exit Function
    If nCtrlId Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %WB_SHOWBUTTON, nIDButton, IsTrue( bOnOff ) )

End Function

'// Shows or hides all known buttons.
Sub WB_ShowAllButtons( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal bOnOff As Long )

    WB_ShowButton hDlg, nCtrlId, %IDTB_STOP, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_REFRESH, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_BACK, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_HOME, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_PRINT, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_FORWARD, bOnOff
    WB_ShowButton hDlg, nCtrlId, %IDTB_ZOOM, bOnOff

End Sub


'////////////////////////////////////////////////////////////////////////////////////
'// RichPad richedit control.
'// You can use the same messages as you used to do with a standard richedit control
'// The RichPad is compatible with the RichPadEx class.
'// RichPad will ignore certain messages wich are only available for the RichPadEx.
'// Like %RPD_BUTTONHEIGHT and %RPD_GETBUTTONHEIGHT
'////////////////////////////////////////////////////////////////////////////////////

'// ClassName
$RICHPAD    = "RichPad"     '// Richeditcontrol without buttons.
$RICHPADEX  = "RichPadEx"   '// Richeditcontrol with buttons.

'// Example;

'    Control Add "" & $RICHPADEX, CbHndl, 100, "", 2, 2, 280, 260 _
'        , %WS_TABSTOP Or %WS_VISIBLE Or %WS_VSCROLL Or %WS_HSCROLL _
'        Or %ES_AUTOVSCROLL Or %ES_WANTRETURN _
'        Or %WS_CHILD _
'        Or %ES_MULTILINE _
'        , %WS_EX_CLIENTEDGE


'// Additional RichPad and RichPadEx messages:

%RPD_GETDLLNAME         = %WM_USER + 10000  '// Returns pointer to asciiz TEXT with currently used Richedit DLL (RICHED32.DLL or RICHED20.DLL etc..)
%RPD_GETCLASSNAME       = %WM_USER + 10001  '// Returns pointer to asciiz TEXT with currently used Richedit class (Richedit or RichEdit20A etc..
%RPD_GETVERSION         = %WM_USER + 10002  '// Returns pointer to asciiz TEXT filled with the Major and Minor version value like: "1.0" etc..
%RPD_RTFTEXT            = %WM_USER + 10003  '// lParam is pointer to asciiz buffer to set.
%RPD_GETRTFTEXTLEN      = %WM_USER + 10004  '// Returns length of RTF data, should be used with %RPD_GETRTFTEXT.
%RPD_GETRTFTEXT         = %WM_USER + 10005  '// wParam is buffer length, lParam is pointer to asciiz buffer to fill.
%RPD_MOVEWINDOW         = %WM_USER + 10006  '// lparam is Rect, Replacement for the MoveWindow() Api, Richedit has a weird (hidden) border, measurement is incorrect.
%RPD_GETWINDOWRECT      = %WM_USER + 10007  '// lParam is Rect, Replacement for the GetWindowRect() Api, Richedit has a weird (hidden) border, measurement is incorrect.
%RPD_BUTTONHEIGHT       = %WM_USER + 10008  '// wParam is new buttonsheight, Returns buttonsheight set (might differ)
%RPD_GETBUTTONHEIGHT    = %WM_USER + 10009  '// wParam is new buttonsheight, Returns buttonsheight set (might differ)
%RPD_CHARFORMAT         = %WM_USER + 10010  '// wParam is Len( CHARFORMAT ), lParam is pointer to your custom CHARFORMAT to set.
%RPD_GETCHARFORMAT      = %WM_USER + 10011  '// wParam is Len( CHARFORMAT ), lParam is pointer to your custom CHARFORMAT to fill.
%RPD_FONTATTRIBUTES     = %WM_USER + 10012  '// wParam is one or more %CFE_.. flags, lParam: 0 = overwrite all, 1 = Or, 2 = not
%RPD_GETFONTATTRIBUTES  = %WM_USER + 10013  '// Returns one or more %CFE_.. flags
%RPD_FONTNAME           = %WM_USER + 10014  '// lParam is pszString.
%RPD_GETFONTNAME        = %WM_USER + 10015  '// Returns pointer to pszString containing the fontname
%RPD_FONTSIZETWIP       = %WM_USER + 10016  '// wParam is new fontsize.
%RPD_GETFONTSIZETWIP    = %WM_USER + 10017  '// Returns fontsize.
%RPD_FONTSIZE           = %WM_USER + 10018  '// wParam is new fontsize in pixels, example: 115 is size 11.5
%RPD_GETFONTSIZE        = %WM_USER + 10019  '// Returns fontsize in pixels, example: 115 is size 11.5
%RPD_ALIGNMENT          = %WM_USER + 10020  '// wParam is new alignment, 0 = Left, 1 = Right, 2 = Center(!)
%RPD_GETALIGNMENT       = %WM_USER + 10021  '// Returns alignment, 0 = Left, 1 = Right, 2 = Center(!)
%RPD_COLOR              = %WM_USER + 10022  '// lParam is new RGB() value
%RPD_GETCOLOR           = %WM_USER + 10023  '// Returns RGB() value

'// Places RTF into the RichEdit control.
Function RPD_SetRTF( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal sRTFText As String ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = SendMessage( hDlg, %RPD_RTFTEXT, 0, ByVal StrPtr( sRTFText ) )

End Function

'// Returns RTF from the RichEdit control.
Function RPD_GetRTF( ByVal hDlg As Long, ByVal nCtrlId As Long ) As String

    Dim BufLen  As Long
    Dim Buffer  As String
    Dim psz     As Asciiz Ptr

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    BufLen = SendMessage( hDlg, %RPD_GETRTFTEXTLEN, 0, ByVal 0& )
    If BufLen = 0 Then Exit Function

    Buffer = String$( BufLen, 0 )
    Call SendMessage( hDlg, %RPD_GETRTFTEXT, BufLen, ByVal StrPtr( Buffer ) )

    Function = Rtrim$( Buffer, Chr$( 0 ) )

End Function

' "Times New Roman" for example..
Function RPD_SetFontName( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal sFontName As String ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = SendMessage( hDlg, %RPD_FONTNAME, 0, ByVal StrPtr( sFontName ) )

End Function

Function RPD_GetFontName( ByVal hDlg As Long, ByVal nCtrlId As Long ) As String

    Dim psz As Asciiz Ptr

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    psz = SendMessage( hDlg, %RPD_GETFONTNAME, 0, ByVal 0& )

    Function = @psz

End Function

Function RPD_SetFontSize( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal nFontSize As Single ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = SendMessage( hDlg, %RPD_FONTSIZE, Round( nFontSize * 10!, 0 ), ByVal 0& )

End Function

Function RPD_GetFontSize( ByVal hDlg As Long, ByVal nCtrlId As Long ) As Single

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = Round( SendMessage( hDlg, %RPD_GETFONTSIZE, 0, ByVal 0& ) / 10!, 1 )

End Function

Function RPD_SetFontAttr( ByVal hDlg As Long, ByVal nCtrlId As Long, ByVal nCFE_Flags As Long ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = SendMessage( hDlg, %RPD_FONTATTRIBUTES, nCFE_Flags, ByVal 0& )

End Function

Function RPD_GetFontAttr( ByVal hDlg As Long, ByVal nCtrlId As Long ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = SendMessage( hDlg, %RPD_GETFONTATTRIBUTES, 0, ByVal 0& )

End Function

'////////////////////////////////////////////////////////////////////////////////////
'// DropListBox.
'// For the listboxes, you can use the standard messages too.
'// You may hook the control to get more messages if needed.
'////////////////////////////////////////////////////////////////////////////////////

'// ClassName
$DROPLISTBOX = "DropListBox"

'// Properties.
%DROPLB_BACKCOLOR       = %WM_USER + 1000   '// wParam is new RGB(), -1 for default windows color.
%DROPLB_GETBACKCOLOR    = %WM_USER + 1001   '// Returns rgb used.
%DROPLB_FORECOLOR       = %WM_USER + 1002   '// wParam is new RGB(), -1 for default windows color.
%DROPLB_GETFORECOLOR    = %WM_USER + 1003   '// Returns rgb used.
%DROPLB_BACKCOLORLB     = %WM_USER + 1004   '// wParam is new RGB(), -1 for default windows color.
%DROPLB_GETBACKCOLORLB  = %WM_USER + 1005   '// Returns rgb used.
%DROPLB_FORECOLORLB     = %WM_USER + 1006   '// wParam is new RGB(), -1 for default windows color.
%DROPLB_GETFORECOLORLB  = %WM_USER + 1007   '// Returns rgb used.
%DROPLB_SORT            = %WM_USER + 1008   '// wParam is boolean, lparam is lb id, 0 for both, Recreates all controls!
%DROPLB_MULTISELECT     = %WM_USER + 1009   '// wParam is boolean, lparam is lb id, 0 for both, Recreates all controls!
%DROPLB_DRAGITEMS       = %WM_USER + 1010   '// Enable item dragging (in current LB only) wParam is boolean, lparam is lb id, 0 for both, Not in MULTISELECT mode.
%DROPLB_SHOWMOVEALL     = %WM_USER + 1011   '// wParam is boolean, shows/hides the 2 'MoveAll' buttons.
%DROPLB_BORDEROFFSET    = %WM_USER + 1012   '// wParam is new borderoffset.
%DROPLB_INSERTITEM      = %WM_USER + 1013   '// lParam is pointer to DROPLB_Item

'// Control's Id's..
%DROPLB_ID_LB1              = 100           '// Left listbox.
%DROPLB_ID_LB2              = 101           '// Right listbox.
%DROPLB_ID_BUTTONRIGHT      = 102           '// >
%DROPLB_ID_BUTTONLEFT       = 103           '// <
%DROPLB_ID_BUTTONRIGHTALL   = 104           '// >>
%DROPLB_ID_BUTTONLEFTALL    = 105           '// <<

Type DROPLB_Item

    nCtrlID         As Long         '// Listbox1 or 2 (See: %DROPLB_ID_LB..)
    pszItem         As Asciiz Ptr   '// Pointer to text.
    nItemData       As Long         '// Unique reference to item.
    nInsertIndex    As Long         '// Where to insert this item in the LB, -1 for adding.

End Type

'// hDlg, your window/dialog.
'// nCtrlId, the DROPLB control you created.
'// nListBoxId, listbox to fill, %DROPLB_ID_LB1 or 2..
'// sText, text to set.
'// nItemData, should be used and set to an unique entry value to distinguish items.
'// nInsertIndex, the listindex to place this item, -1 for adding.

Function DROPLB_InsertItem( _
     ByVal hDlg         As Long _
   , ByVal nCtrlId      As Long _
   , ByVal nListBoxId   As Long _
   , ByVal sText        As String _
   , ByVal nItemData    As Long _
   , ByVal nInsertIndex As Long _
   ) As Long

    Dim DLII As DROPLB_Item

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    DLII.nCtrlID        = nListBoxId
    DLII.pszItem        = StrPtr( sText )
    DLII.nItemData      = nItemData
    DLII.nInsertIndex   = nInsertIndex
    Function = SendMessage( hDlg, %DROPLB_INSERTITEM, 0, VarPtr( DLII ) )

End Function

'// Returns the itemdata of the specified listbox.
Function DROPLB_GetItemData( _
     ByVal hDlg         As Long _
   , ByVal nCtrlId      As Long _
   , ByVal nListBoxId   As Long _
   , ByVal nListIndex   As Long _
   ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    hDlg = GetDlgItem( hDlg, nListBoxId )

    Function = SendMessage( hDlg, %LB_GETITEMDATA, nListindex, ByVal 0& )

End Function

'// Returns the hWnd of a listbox on the DropListbox control.
Function DROPLB_GethWndListBox( _
     ByVal hDlg         As Long _
   , ByVal nCtrlId      As Long _
   , ByVal nListBoxId   As Long _
   ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )

    Function = GetDlgItem( hDlg, nListBoxId )

End Function


'////////////////////////////////////////////////////////////////////////////////////
'// ListBar, Outlookbar lookalike
'////////////////////////////////////////////////////////////////////////////////////

'Example:
'        Control Add "" & $LISTBAR, CbHndl, 100, "", 0, 0, 100, 100 _
'             , %WS_CHILD Or %WS_VSCROLL Or %WS_VISIBLE Or %LBS_NOINTEGRALHEIGHT _
'             , %WS_EX_CLIENTEDGE



'// Control's windowclassname
'// Control's windowclassname
$LISTBAR = "ListBar"

'// Public use
%LBAR_BACKCOLOR         = %WM_USER + 10000  '// wParam = RGB()
%LBAR_FORECOLOR         = %WM_USER + 10001  '// wParam = RGB()
%LBAR_DOWNBACKCOLOR     = %WM_USER + 10002  '// wParam = RGB()
%LBAR_ADDBUTTON         = %WM_USER + 10003  '// Add's a button, it's not possible to insert.
%LBAR_DELBUTTON         = %WM_USER + 10004  '// Removes's last button, you can not remove buttons before the last button.
%LBAR_ENABLEBUTTON      = %WM_USER + 10005  '// Enables/disables button, wParam is index, lParam is boolean.
%LBAR_GETENABLEDBUTTON  = %WM_USER + 10006  '// Returns Enabled/disabled status, wParam is index.
%LBAR_BUTTONHEIGHT      = %WM_USER + 10007  '// Set's new height for each button.
%LBAR_COUNTBUTTONS      = %WM_USER + 10008  '// Returns the number of buttons added.
%LBAR_BUTTON            = %WM_USER + 10009  '// Activates the desired button/panel, clears it's contents first.
%LBAR_GETBUTTON         = %WM_USER + 10010  '// Returns the currently selected button/panel
%LBAR_ADDICON           = %WM_USER + 10011  '// Add's an icon, wParam is hIcon, lParam pointer to asciiz containing caption.
%LBAR_DELICON           = %WM_USER + 10012  '// Removes's last icon
%LBAR_SELECTICON        = %WM_USER + 10013  '// Selects or deselects an icon, 0 for no icon selected.(Only in sticky mode)
%LBAR_GETSELECTEDICON   = %WM_USER + 10014  '// Returns selected icon.
%LBAR_BARSTYLE          = %WM_USER + 10015  '// wParam = style, See %LBAR_BARSTYLE_...
%LBAR_GETBARSTYLE       = %WM_USER + 10016
%LBAR_ITEMDATA          = %WM_USER + 10017  '// wParam = index (1 to nn..), lParam = Value&
%LBAR_GETITEMDATA       = %WM_USER + 10018  '// Returns itemdata, wParam = index (1 to nn..)
%LBAR_ICONSTART         = %WM_USER + 10019  '// wParam = start of icon, default = 8
%LBAR_GETICONSTART      = %WM_USER + 10020  '// Returns start of icon

'// ListBar style
%LBAR_BARSTYLE_OUTLOOK      = 0 '// Small rectangle around icon
%LBAR_BARSTYLE_TOOLBAR      = 1 '// Rectangle at border of item.
%LBAR_BARSTYLE_STICKY       = 2 '// Rectangle at border of item, maintains pressed state.
%LBAR_BARSTYLE_STICKYTOGGLE = 3 '// Rectangle at border of item, maintains pressed state, can be undone by user.


'// WM_NOTIFY code's
%LBARN_BUTTONCLICKED    = 1
%LBARN_ICONCLICKED      = 2

Type NM_LISTBAR

    hdr         As NMHDR
    action      As Dword    '// Not in use yet.
    nButton     As Long
    nIcon       As Long
    nItemData   As Long

End Type

'// Internal use

%LISTBAR_MAXBUTTONS = 30
%LISTBAR_TMRICON    = 998
%LISTBAR_TMRBUTTON  = 999

'////////////////////////////////////////////////////////////////////////////////////
'// PicBox, Picture box based on IPICTURE com interface.
'////////////////////////////////////////////////////////////////////////////////////

$PICBOX = "PicBox"

%PIC_BACKCOLOR          = %WM_USER + 10000  '// wParam = RGB(), -1 for no painting
%PIC_GETBACKCOLOR       = %WM_USER + 10001  '// Returns backcolor set.
%PIC_SIZE               = %WM_USER + 10002  '// wParam is mode, See %PIC_SIZE_...

%PIC_GETIMAGE           = %WM_USER + 10003  '// Returns copy of image as hBITMAP, you should destroy it yourself.
%PIC_GETHANDLE          = %WM_USER + 10004  '// Returns orignal handle, do not destroy!
%PIC_GETTYPE            = %WM_USER + 10005  '// Returns orignal handle's imagetype.
%PIC_GETRECT            = %WM_USER + 10006  '// Returns RECT, lParam is pointer to RECT

'// Image loading and unloading
%PIC_IMAGE_NONE         = %WM_USER + 11000  '// Removes existing image
%PIC_IMAGE_FILE         = %WM_USER + 11002  '// wParam = 0, lParam is pointer to asciiz filename.
%PIC_IMAGE_RESOURCEDATA = %WM_USER + 11004  '// Loads an image from RC_DATA resource, ideal for stored JPG's, lParam = pointer to resourcename
%PIC_IMAGE_DATA         = %WM_USER + 11005  '// wParam = length of data, lParam pointer to data, TIP: can be RC_DATA

%PIC_SIZE_NONE      = 0 '// Keeps control size.
%PIC_SIZE_PICTURE   = 1 '// Sizes control to loaded image.
'%PIC_SIZE_STRETCH   = 2 '// Unsupported yet.

'// IPICTURE picturetype constants
#if Not %Def( %PICTYPE_UNINITIALIZED )

%PICTYPE_UNINITIALIZED    = -1
%PICTYPE_NONE             = 0
%PICTYPE_BITMAP           = 1   ' + JPG
%PICTYPE_METAFILE         = 2
%PICTYPE_ICON             = 3
%PICTYPE_ENHMETAFILE      = 4

#endif

'// WM_NOTIFY
%PICN_BEGINPAINT    = 1 '// Picbox paint, before picture is redrawn.
%PICN_ENDPAINT      = 2 '// Picbox paint, after picture is redrawn.

Type NM_PICBOX

    hdr         As NMHDR        '// Normal notify header
    PS          As PAINTSTRUCT  '// Copy of paintstruct during WM_PAINT, contains hDC and coordinates.
    hImage      As Long         '// Imagehandle, do not destroy
    nImageType  As Long         '// Image type, See %PICTYPE_...

End Type

Function PIC_AutoSize( _
      ByVal hDlg    As Long _
    , ByVal nCtrlId As Long _
    , ByVal nMode   As Long _
    ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %PIC_SIZE, nMode, ByVal 0& )

End Function

Function PIC_LoadFromFile( _
      ByVal hDlg        As Long _
    , ByVal nCtrlId     As Long _
    , ByVal sFileName   As String _
    ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %PIC_IMAGE_FILE, 0, ByVal StrPtr( sFileName ) )

End Function

Function PIC_LoadFromRCDATA( _
      ByVal hDlg            As Long _
    , ByVal nCtrlId         As Long _
    , ByVal sResourceName   As String _
    ) As Long

    If nCtrlId > 0 Then hDlg = GetDlgItem( hDlg, nCtrlId )
    If hDlg = 0 Then Exit Function

    Function = SendMessage( hDlg, %PIC_IMAGE_RESOURCEDATA, 0, ByVal StrPtr( sResourceName ) )

End Function

'////////////////////////////////////////////////////////////////////////////////////
'// ComboBoxPane, shows any window as dropdownlist
'////////////////////////////////////////////////////////////////////////////////////

$COMBOBOXPANE = "ComboBoxPane"

%TCB_PANE_HANDLE    = %WM_USER + 11000  '// Set hWnd of window to use as dropdown.
%TCB_PANE_GETHANDLE = %WM_USER + 11001  '// Returns hWnd of window set.
%TCB_PANE_SHOW      = %WM_USER + 11002  '// Shows or hides dropdown, wParam is boolean.
%TCB_PANE_ALIGN     = %WM_USER + 11003  '// Align pane to combo, See %TCB_ALIGN_...
%TCB_PANE_GETALIGN  = %WM_USER + 11004  '// Returns autowidth setting

%TCB_ALIGN_NONE     = 0 '// Do nothing (does not even set top).
%TCB_ALIGN_LEFT     = 1 '// Align control to the left of comboboxpane  (no resize).
%TCB_ALIGN_RIGHT    = 2 '// Align control to the right of comboboxpane (no resize).
%TCB_ALIGN_CENTER   = 3 '// Align control to the right of comboboxpane (no resize).
%TCB_ALIGN_WIDTH    = 4 '// Size dropdown to same size of comboboxpane.

