$use "RMChart.lib"

Enum RMC_Colors
    DefCol=0x0
    AliceBlue = 0xFFF0F8FF
    AntiqueWhite = 0xFFFAEBD7
    Aquamarine = 0xFF7FFFD4
    ArmyGreen = 0xFF669966
    AutumnOrange = 0xFFFF6633
    AvocadoGreen = 0xFF669933
    Azure = 0xFFF0FFFF
    BabyBlue = 0xFF6699FF
    BananaYellow = 0xFFCCCC33
    Beige = 0xFFF5F5DC
    Bisque = 0xFFFFE4C4
    Black = 0xFF000000
    BlanchedAlmond = 0xFFFFEBCD
    Blue = 0xFF0000FF
    BlueViolet = 0xFF8A2BE2
    Brown = 0xFFA52A2A
    BurlyWood = 0xFFDEB887
    CadetBlue = 0xFF5F9EA0
    Chalk = 0xFFFFFF99
    Chartreuse = 0xFF7FFF00
    Chocolate = 0xFFD2691E
    Coral = 0xFFFF7F50
    CornflowerBlue = 0xFF6495ED
    Cornsilk = 0xFFFFF8DC
    Crimson = 0xFFDC143C
    Cyan = 0xFF00FFFF
    DarkBlue = 0xFF00008B
    DarkBrown = 0xFF663333
    DarkCrimson = 0xFF993366
    DarkCyan = 0xFF008B8B
    DarkGold = 0xFFCC9933
    DarkGoldenrod = 0xFFB8860B
    DarkGray = 0xFFA9A9A9
    DarkGreen = 0xFF006400
    DarkKhaki = 0xFFBDB76B
    DarkMagenta = 0xFF8B008B
    DarkOliveGreen = 0xFF556B2F
    DarkOrange = 0xFFFF8C00
    DarkOrchid = 0xFF9932CC
    DarkRed = 0xFF8B0000
    DarkSalmon = 0xFFE9967A
    DarkSeaGreen = 0xFF8FBC8B
    DarkSlateBlue = 0xFF483D8B
    DarkSlateGray = 0xFF2F4F4F
    DarkTurquoise = 0xFF00CED1
    DarkViolet = 0xFF9400D3
    DeepAzure = 0xFF6633FF
    DeepPink = 0xFFFF1493
    DeepPurple = 0xFF330066
    DeepRiver = 0xFF6600CC
    DeepRose = 0xFFCC3399
    DeepSkyBlue = 0xFF00BFFF
    DeepYellow = 0xFFFFCC00
    DesertBlue = 0xFF336699
    DimGray = 0xFF696969
    DodgerBlue = 0xFF1E90FF
    DullGreen = 0xFF99CC66
    EasterPurple = 0xFFCC99FF
    FadeGreen = 0xFF99CC99
    Firebrick = 0xFFB22222
    FloralWhite = 0xFFFFFAF0
    ForestGreen = 0xFF228B22
    Gainsboro = 0xFFDCDCDC
    GhostWhite = 0xFFF8F8FF
    GhostGreen = 0xFFCCFFCC
    Gold = 0xFFFFD700
    Goldenrod = 0xFFDAA520
    Grape = 0xFF663399
    GrassGreen = 0xFF009933
    Gray = 0xFF808080
    Green = 0xFF008000
    GreenYellow = 0xFFADFF2F
    Honeydew = 0xFFF0FFF0
    HotPink = 0xFFFF69B4
    IndianRed = 0xFFCD5C5C
    Indigo = 0xFF4B0082
    Ivory = 0xFFFFFFF0
    Khaki = 0xFFF0E68C
    KentuckyGreen = 0xFF339966
    Lavender = 0xFFE6E6FA
    LavenderBlush = 0xFFFFF0F5
    LawnGreen = 0xFF7CFC00
    LemonChiffon = 0xFFFFFACD
    LightBlue = 0xFFADD8E6
    LightCoral = 0xFFF08080
    LightCyan = 0xFFE0FFFF
    LightGoldenrod = 0xFFEEDD82
    LightGoldenrodYellow = 0xFFFAFAD2
    LightGray = 0xFFD3D3D3
    LightGreen = 0xFF90EE90
    LightOrange = 0xFFFF9933
    LightPink = 0xFFFFB6C1
    LightSalmon = 0xFFFFA07A
    LightSeaGreen = 0xFF20B2AA
    LightSkyBlue = 0xFF87CEFA
    LightSlateGray = 0xFF778899
    LightSteelBlue = 0xFFB0C4DE
    LightViolet = 0xFFFF99FF
    LightYellow = 0xFFFFFFE0
    Lime = 0xFF00FF00
    LimeGreen = 0xFF32CD32
    Linen = 0xFFFAF0E6
    Magenta = 0xFFFF00FF
    Maroon = 0xFF800000
    MartianGreen = 0xFF99CC33
    MediumAquamarine = 0xFF66CDAA
    MediumBlue = 0xFF0000CD
    MediumOrchid = 0xFFBA55D3
    MediumPurple = 0xFF9370DB
    MediumSeaGreen = 0xFF3CB371
    MediumSlateBlue = 0xFF7B68EE
    MediumSpringGreen = 0xFF00FA9A
    MediumTurquoise = 0xFF48D1CC
    MediumVioletRed = 0xFFC71585
    MidnightBlue = 0xFF191970
    MintCream = 0xFFF5FFFA
    MistyRose = 0xFFFFE4E1
    Moccasin = 0xFFFFE4B5
    MoonGreen = 0xFFCCFF66
    MossGreen = 0xFF336666
    NavajoWhite = 0xFFFFDEAD
    Navy = 0xFF000080
    OceanGreen = 0xFF669999
    OldLace = 0xFFFDF5E6
    Olive = 0xFF808000
    OliveDrab = 0xFF6B8E23
    Orange = 0xFFFFA500
    OrangeRed = 0xFFFF4500
    Orchid = 0xFFDA70D6
    PaleGoldenrod = 0xFFEEE8AA
    PaleGreen = 0xFF98FB98
    PaleTurquoise = 0xFFAFEEEE
    PaleVioletRed = 0xFFDB7093
    PaleYellow = 0xFFFFFFCC
    PapayaWhip = 0xFFFFEFD5
    PeachPuff = 0xFFFFDAB9
    Peru = 0xFFCD853F
    Pink = 0xFFFFC0CB
    Plum = 0xFFDDA0DD
    PowderBlue = 0xFFB0E0E6
    Purple = 0xFF800080
    Red = 0xFFFF0000
    RosyBrown = 0xFFBC8F8F
    RoyalBlue = 0xFF4169E1
    SaddleBrown = 0xFF8B4513
    Salmon = 0xFFFA8072
    Sand = 0xFFFFCC99
    SandyBrown = 0xFFF4A460
    SeaGreen = 0xFF2E8B57
    SeaShell = 0xFFFFF5EE
    Sienna = 0xFFA0522D
    Silver = 0xFFC0C0C0
    SkyBlue = 0xFF87CEEB
    SlateBlue = 0xFF6A5ACD
    SlateGray = 0xFF708090
    Snow = 0xFFFFFAFA
    SpringGreen = 0xFF00FF7F
    SteelBlue = 0xFF4682B4
    _Tan = 0xFFD2B48C
    Teal = 0xFF008080
    Thistle = 0xFFD8BFD8
    Tomato = 0xFFFF6347
    Transparent = 0xFFFFFFFE
    TropicalPink = 0xFFFF6666
    Turquoise = 0xFF40E0D0
    Violet = 0xFFEE82EE
    VioletRed = 0xFFD02090
    Walnut = 0xFF663300
    Wheat = 0xFFF5DEB3
    White = 0xFFFFFFFF
    WhiteSmoke = 0xFFF5F5F5
    Yellow = 0xFFFFFF00
    YellowGreen = 0xFF9ACD32
EndEnum

' No data symbol
 Const RMC_NO_DATA = 0xC521974F

Enum CtrlStyle
    RMC_CTRLSTYLEFLAT = 0
    RMC_CTRLSTYLEFLATSHADOW = 1
    RMC_CTRLSTYLE3D = 2
    RMC_CTRLSTYLE3DLIGHT = 3
    RMC_CTRLSTYLEIMAGE = 4
    RMC_CTRLSTYLEIMAGETILED = 5
EndEnum

Enum SeriesType
    RMC_BARSERIES = 1
    RMC_LINESERIES = 2
    RMC_GRIDLESSSERIES = 2
    RMC_VOLUMEBARSERIES = 4
    RMC_HIGHLOWSERIES = 5
    RMC_XYSERIES = 6
EndEnum

Enum BarSeriesType
    RMC_BARSINGLE = 1
    RMC_BARGROUP = 2
    RMC_BARSTACKED = 3
    RMC_BARSTACKED100 = 4
    RMC_FLOATINGBAR = 5
    RMC_FLOATINGBARGROUP = 6
EndEnum

Enum LineSeriesType
    RMC_LINE = 21
    RMC_AREA = 22
    RMC_LINE_INDEXED = 23
    RMC_AREA_INDEXED = 24
    RMC_AREA_STACKED = 25
    RMC_AREA_STACKED100 = 26
EndEnum

Enum BarSeriesStyle
    RMC_BAR_FLAT = 1
    RMC_BAR_FLAT_GRADIENT1 = 2
    RMC_BAR_FLAT_GRADIENT2 = 3
    RMC_BAR_HOVER = 4
    RMC_COLUMN_FLAT = 5
    RMC_BAR_3D = 6
    RMC_BAR_3D_GRADIENT = 7
    RMC_COLUMN_3D = 8
    RMC_COLUMN_3D_GRADIENT = 9
    RMC_COLUMN_FLUTED = 10
EndEnum

Enum CTypes                       ' only for tRMC_INFO
    RMC_VOLUMEBAR = 31
    RMC_HIGHLOW = 41
    RMC_GRIDLESS = 51
    RMC_XYCHART = 70
    RMC_GRIDBASED = 10
EndEnum

Enum LineSeriesStyle
    RMC_LINE_FLAT = 21
    RMC_LINE_FLAT_DOT = 19
    RMC_LINE_FLAT_DASH = 18
    RMC_LINE_FLAT_DASHDOT = 17
    RMC_LINE_FLAT_DASHDOTDOT = 16
    RMC_LINE_FASTLINE = 15
    RMC_LINE_CABLE = 22
    RMC_LINE_3D = 23
    RMC_LINE_3D_GRADIENT = 24
    RMC_AREA_FLAT = 25
    RMC_AREA_FLAT_GRADIENT_V = 26
    RMC_AREA_FLAT_GRADIENT_H = 27
    RMC_AREA_FLAT_GRADIENT_C = 28
    RMC_AREA_3D = 29
    RMC_AREA_3D_GRADIENT_V = 30
    RMC_AREA_3D_GRADIENT_H = 31
    RMC_AREA_3D_GRADIENT_C = 32
    RMC_LINE_FLAT_SHADOW = 33
    RMC_LINE_CABLE_SHADOW = 34
    RMC_LINE_SYMBOLONLY = 35
EndEnum

Enum LineSeriesLineStyle
    RMC_LSTYLE_LINE = 1
    RMC_LSTYLE_SPLINE = 2
    RMC_LSTYLE_STAIR = 3
    RMC_LSTYLE_LINE_AREA = 4       ' Draws a line and a transparent area
    RMC_LSTYLE_SPLINE_AREA = 5     ' Draws a spline and a transparent area
    RMC_LSTYLE_STAIR_AREA = 6      ' Draws a stair and a transparent area
EndEnum

Enum LineSeriesSymbol
    RMC_SYMBOL_NONE = 0
    RMC_SYMBOL_BULLET = 21
    RMC_SYMBOL_ROUND = 1
    RMC_SYMBOL_DIAMOND = 2
    RMC_SYMBOL_SQUARE = 3
    RMC_SYMBOL_STAR = 4
    RMC_SYMBOL_ARROW_DOWN = 5
    RMC_SYMBOL_ARROW_UP = 6
    RMC_SYMBOL_POINT = 7
    RMC_SYMBOL_CIRCLE = 8
    RMC_SYMBOL_RECTANGLE = 9
    RMC_SYMBOL_CROSS = 10
    RMC_SYMBOL_BULLET_SMALL = 22
    RMC_SYMBOL_ROUND_SMALL = 11
    RMC_SYMBOL_DIAMOND_SMALL = 12
    RMC_SYMBOL_SQUARE_SMALL = 13
    RMC_SYMBOL_STAR_SMALL = 14
    RMC_SYMBOL_ARROW_DOWN_SMALL = 15
    RMC_SYMBOL_ARROW_UP_SMALL = 16
    RMC_SYMBOL_POINT_SMALL = 17
    RMC_SYMBOL_CIRCLE_SMALL = 18
    RMC_SYMBOL_RECTANGLE_SMALL = 19
    RMC_SYMBOL_CROSS_SMALL = 20
EndEnum

Enum HighLowSeriesStyle
    RMC_OHLC = 1
    RMC_CANDLESTICK = 2
EndEnum

Enum GridlessSeriesStyle
    RMC_PIE_FLAT = 51
    RMC_PIE_GRADIENT = 52
    RMC_PIE_3D = 53
    RMC_PIE_3D_GRADIENT = 54
    RMC_DONUT_FLAT = 55
    RMC_DONUT_GRADIENT = 56
    RMC_DONUT_3D = 57
    RMC_DONUT_3D_GRADIENT = 58
    RMC_PYRAMIDE = 59
    RMC_PYRAMIDE3 = 60
EndEnum

Enum PieDonutAlignment
    RMC_FULL = 1
    RMC_HALF_TOP = 2
    RMC_HALF_RIGHT = 3
    RMC_HALF_BOTTOM = 4
    RMC_HALF_LEFT = 5
EndEnum

Enum XYSeriesStyle
    RMC_XY_LINE = 70
    RMC_XY_LINE_DOT = 69
    RMC_XY_LINE_DASH = 68
    RMC_XY_LINE_DASHDOT = 67
    RMC_XY_LINE_DASHDOTDOT = 66
    RMC_XY_SYMBOL = 71
    RMC_XY_CABLE = 73
EndEnum

Enum Hatchmodes
    RMC_HATCHBRUSH_OFF = 0
    RMC_HATCHBRUSH_ON = 1
    RMC_HATCHBRUSH_ONPRINTING = 2
EndEnum

Enum DAxisAlignment
    RMC_DATAAXISLEFT = 1
    RMC_DATAAXISRIGHT = 2
    RMC_DATAAXISTOP = 3
    RMC_DATAAXISBOTTOM = 4
EndEnum

Enum LAxisAlignment
    RMC_LABELAXISLEFT = 5
    RMC_LABELAXISRIGHT = 6
    RMC_LABELAXISTOP = 7
    RMC_LABELAXISBOTTOM = 8
EndEnum

Enum XAxisAlignment
    RMC_XAXISTOP = 11
    RMC_XAXISBOTTOM = 12
EndEnum

Enum YAxisAlignment
    RMC_YAXISLEFT = 9
    RMC_YAXISRIGHT = 10
EndEnum

Enum AxisType
    RMC_DATAAXIS = 1
    RMC_LABELAXIS = 2
EndEnum

Enum AxisLineStyle
    RMC_LINESTYLESOLID = 0
    RMC_LINESTYLEDASH = 1
    RMC_LINESTYLEDOT = 2
    RMC_LINESTYLEDASHDOT = 3
    RMC_LINESTYLENONE = 6
EndEnum

Enum LabelTextAlignment
    RMC_TEXTCENTER = 0
    RMC_TEXTLEFT = 1
    RMC_TEXTRIGHT = 2
    RMC_TEXTDOWNWARD = 3
    RMC_TEXTUPWARD = 4
EndEnum

Const RMC_LEGEND_NONE = -1
Enum LegendAlignment
    RMC_LEGEND_TOP = 1
    RMC_LEGEND_LEFT = 2
    RMC_LEGEND_RIGHT = 3
    RMC_LEGEND_BOTTOM = 4
    RMC_LEGEND_UL = 5
    RMC_LEGEND_UR = 6
    RMC_LEGEND_LL = 7
    RMC_LEGEND_LR = 8
    RMC_LEGEND_ONVLABELS = 9
    RMC_LEGEND_CUSTOM_TOP = 11
    RMC_LEGEND_CUSTOM_LEFT = 12
    RMC_LEGEND_CUSTOM_RIGHT = 13
    RMC_LEGEND_CUSTOM_BOTTOM = 14
    RMC_LEGEND_CUSTOM_UL = 15
    RMC_LEGEND_CUSTOM_UR = 16
    RMC_LEGEND_CUSTOM_LL = 17
    RMC_LEGEND_CUSTOM_LR = 18
    RMC_LEGEND_CUSTOM_CENTER = 19
    RMC_LEGEND_CUSTOM_CR = 20
    RMC_LEGEND_CUSTOM_CL = 21
EndEnum

Enum LegendStyle
    RMC_LEGENDNORECT = 1
    RMC_LEGENDRECT = 2
    RMC_LEGENDRECTSHADOW = 3
    RMC_LEGENDROUNDRECT = 4
    RMC_LEGENDROUNDRECTSHADOW = 5
EndEnum

Enum ValueLabels
    RMC_VLABEL_NONE = 0
    RMC_VLABEL_DEFAULT = 1
    RMC_VLABEL_PERCENT = 5
    RMC_VLABEL_ABSOLUTE = 6
    RMC_VLABEL_TWIN = 7
    RMC_VLABEL_LEGENDONLY = 8
    RMC_VLABEL_DEFAULT_NOZERO = 11
    RMC_VLABEL_PERCENT_NOZERO = 15
    RMC_VLABEL_ABSOLUTE_NOZERO = 16
    RMC_VLABEL_TWIN_NOZERO = 17
EndEnum

Enum BicolorMode
    RMC_BICOLOR_NONE = 0
    RMC_BICOLOR_DATAAXIS = 1
    RMC_BICOLOR_LABELAXIS = 2
    RMC_BICOLOR_BOTH = 3
EndEnum

'Enum RMCError
    Const RMC_ERROR_MAXINST = -1
    Const RMC_ERROR_MAXREGION = -2
    Const RMC_ERROR_MAXSERIES = -3
    Const RMC_ERROR_ALLOC = -4
    Const RMC_ERROR_NODATA = -5
    Const RMC_ERROR_CTRLID = -6
    Const RMC_ERROR_SERIESINDEX = -7
    Const RMC_ERROR_CREATEBITMAP = -8
    Const RMC_ERROR_WRONGREGION = -9
    Const RMC_ERROR_PARENTHANDLE = -10
    Const RMC_ERROR_CREATEWINDOW = -11
    Const RMC_ERROR_INIGDIP = -12
    Const RMC_ERROR_PRINT = -13
    Const RMC_ERROR_NOGDIP = -14
    Const RMC_ERROR_RMCFILE = -15
    Const RMC_ERROR_FILEFOUND = -16
    Const RMC_ERROR_READLINES = -17
    Const RMC_ERROR_XYAXIS = -18
    Const RMC_ERROR_LEGENDTEXT = -19
    Const RMC_ERROR_EMF = -20
    Const RMC_ERROR_NODATA_COUNT = -21
    Const RMC_ERROR_NODATA_ZERO = -22
    Const RMC_ERROR_NOCOLOR = -23
    Const RMC_ERROR_CLIPBOARD = -24
    Const RMC_ERROR_CBINFO = -25
    Const RMC_ERROR_FILECREATE = -26
    Const RMC_ERROR_DATAINDEX = -28
    Const RMC_ERROR_AXISALIGNMENT = -29
    Const RMC_ERROR_RANGE = -30
    Const RMC_ERROR_WRONGSERIESTYPE = -31
    Const RMC_ERROR_MAXCUSTOM = -50
    Const RMC_ERROR_CUSTOMINDEX = -51
  Const RMC_ERROR_LEGENDSIZE = 1
'EndEnum

Enum RMCFileType
    RMC_EMF = 1
    RMC_EMFPLUS = 2
    RMC_BMP = 3
EndEnum

' Custom Objects
Enum COType
    RMC_CO_TEXT = 1
    RMC_CO_BOX = 2
    RMC_CO_CIRCLE = 3
    RMC_CO_LINE = 4
    RMC_CO_IMAGE = 5
    RMC_CO_SYMBOL = 6
    RMC_CO_POLYGON = 7
EndEnum

' Line alignment for custom text
Enum COLineAlignment
    RMC_LINE_HORIZONTAL = 0
    RMC_LINE_UPWARD = 1
    RMC_LINE_DOWNWARD = 3
EndEnum

'Line style for Custom lines
Enum COLineStyle
    RMC_FLAT_LINE = 21
    RMC_DOT_LINE = 19
    RMC_DASH_LINE = 18
    RMC_DASHDOT_LINE = 17
    RMC_DASHDOTDOT_LINE = 16
EndEnum

' Anchors for custom lines
Enum COAnchor
    RMC_ANCHOR_NONE = 0
    RMC_ANCHOR_ROUND = 1
    RMC_ANCHOR_BULLET = 2
    RMC_ANCHOR_ARROW_CLOSED = 3
    RMC_ANCHOR_ARROW_OPEN = 4
EndEnum

' Styles for custom box/text
Enum COBoxStyle
    RMC_BOX_NONE = 0
    RMC_BOX_FLAT = 1
    RMC_BOX_ROUNDEDGE = 2
    RMC_BOX_RHOMBUS = 3
    RMC_BOX_GRADIENTH = 4
    RMC_BOX_GRADIENTV = 5
    RMC_BOX_3D = 6
    RMC_BOX_FLAT_SHADOW = 7
    RMC_BOX_GRADIENTH_SHADOW = 8
    RMC_BOX_GRADIENTV_SHADOW = 9
    RMC_BOX_3D_SHADOW = 10
EndEnum

' Styles for custom Circle
Enum COCircleStyle
    RMC_CIRCLE_FLAT = 1
    RMC_CIRCLE_BULLET = 2
EndEnum

' Zoom mode
Enum ZoomMode
    RMC_ZOOM_DISABLE = 0
    RMC_ZOOM_EXTERNAL = 1
    RMC_ZOOM_INTERNAL = 2
EndEnum

' nChartType in tRMC_INFO holds one of these when in zoom-|magnifier-mode
'Enum ZoomState
    Const RMC_ZOOM_MODE = -99
    Const RMC_MAGNIFIER_MODE = -98
'EndEnum

Enum RMCMouseButton
    RMC_MOUSEMOVE = 0x200
    RMC_LBUTTONDOWN = 0x201
    RMC_LBUTTONUP = 0x202
    RMC_LBUTTONDBLCLK = 0x203
    RMC_RBUTTONDOWN = 0x204
    RMC_RBUTTONUP = 0x205
    RMC_RBUTTONDBLCLK = 0x206
    RMC_MBUTTONDOWN = 0x207
    RMC_MBUTTONUP = 0x208
    RMC_MBUTTONDBLCLK = 0x209
    RMC_SHIFTLBUTTONDOWN = 0x20A
    RMC_SHIFTLBUTTONUP = 0x20B
    RMC_SHIFTLBUTTONDBLCLK = 0x20C
    RMC_SHIFTRBUTTONDOWN = 0x20D
    RMC_SHIFTRBUTTONUP = 0x20E
    RMC_SHIFTRBUTTONDBLCLK = 0x20F
    RMC_SHIFTMBUTTONDOWN = 0x210
    RMC_SHIFTMBUTTONUP = 0x211
    RMC_SHIFTMBUTTONDBLCLK = 0x212
    RMC_CTRLLBUTTONDOWN = 0x213
    RMC_CTRLLBUTTONUP = 0x214
    RMC_CTRLLBUTTONDBLCLK = 0x215
    RMC_CTRLRBUTTONDOWN = 0x216
    RMC_CTRLRBUTTONUP = 0x217
    RMC_CTRLRBUTTONDBLCLK = 0x218
    RMC_CTRLMBUTTONDOWN = 0x219
    RMC_CTRLMBUTTONUP = 0x21A
    RMC_CTRLMBUTTONDBLCLK = 0x21B
EndEnum

Type tRMC_INFO
    Def nXPos        As Int
    Def nYPos        As Int
    Def nXMove       As Int
    Def nYMove       As Int
    Def nRegionIndex As Int
    Def nRLeft       As Int
    Def nRTop        As Int
    Def nRRight      As Int
    Def nRBottom     As Int
    Def nSeriesIndex As Int
    Def nDataIndex   As Int
    Def nChartType   As Int
    Def nSLeft       As Int
    Def nSTop        As Int
    Def nSRight      As Int
    Def nSBottom     As Int
    Def nSTop2       As Int
    Def nSBottom2    As Int
    Def nGLeft       As Int
    Def nGTop        As Int
    Def nGRight      As Int
    Def nGBottom     As Int
    Def nGCol        As Int
    Def nGRow        As Int
    Def nData1       As Double
    Def nData2       As Double
    Def nData3       As Double
    Def nData4       As Double
    Def nVirtData1   As Double
    Def nVirtData2   As Double
    Def nVirtData3   As Double
    Def nVirtData4   As Double
EndType

Type tRMC_BARSERIES
    Def nType As BarSeriesType
    Def nStyle As BarSeriesStyle
    Def nIsLucent As Int
    Def nColor As RMC_Colors
    Def nIsHorizontal As Int
    Def nWhichDataAxis As Int
    Def nValueLabelOn As ValueLabels
    Def nPointsPerColumn As Int
    Def nHatchMode As Hatchmodes
EndType

Type tRMC_CAPTION
    Def nBackColor As RMC_Colors
    Def nTextColor As RMC_Colors
    Def nFontSize As Int
    Def nIsBold As Int
    Def sText[200] As IString
EndType

Type tRMC_CHART
    Def nTop As Int
    Def nLeft As Int
    Def nWidth As Int
    Def nHeight As Int
    Def nBackColor As RMC_Colors
    Def nCtrlStyle As CtrlStyle
    Def nExportOnly As Int
    Def sBgImage[100] As IString
    Def sFontName[50] As IString
    Def nToolTipWidth   As Int
    Def nBitmapBKColor  As Int
EndType

Type tRMC_DATAAXIS
    Def nAlignment As DAxisAlignment
    Def nMinValue As Double
    Def nMaxValue As Double
    Def nTickCount As Int
    Def nFontSize As Int
    Def nTextColor As RMC_Colors
    Def nLineColor As RMC_Colors
    Def nLinestyle As AxisLineStyle
    Def nDecimalDigits As Int
    Def sUnit[16] As IString
    Def sText[100] As IString
    Def sLabels[500] As IString
    Def nLabelAlignment As Int
EndType

Type tRMC_GRID
    Def nGridBackColor As RMC_Colors
    Def nAsGradient As Int
    Def nBiColor As BicolorMode
    Def nLeft As Int
    Def nTop As Int
    Def nWidth As Int
    Def nHeight As Int
EndType

Type tRMC_GRIDLESSSERIES
    Def nStyle As GridlessSeriesStyle
    Def nPieAlignment As PieDonutAlignment
    Def nExplodeMode As Int
    Def nIsLucent As Int
    Def nValueLabelOn As ValueLabels
    Def nHatchMode As Hatchmodes
    Def nStartAngle As Int
EndType

Type tRMC_LABELAXIS
    Def nCount As Int
    Def nTickCount As Int
    Def nAlignment As LAxisAlignment
    Def nFontSize As Int
    Def nTextColor As RMC_Colors
    Def nTextAlignment As LAxisAlignment
    Def nLineColor As RMC_Colors
    Def nLinestyle As AxisLineStyle
    Def sText[100] As IString
EndType

Type tRMC_LEGEND
    Def nLegendAlign As LegendAlignment
    Def nLegendBackColor As RMC_Colors
    Def nLegendStyle As LegendStyle
    Def nLegendTextColor As RMC_Colors
    Def nLegendFontSize As Int
    Def nLegendIsBold As Int
EndType

Type tRMC_LINESERIES
    Def nType As LineSeriesType
    Def nStyle As LineSeriesStyle
    Def nLinestyle As LineSeriesLineStyle
    Def nIsLucent As Int
    Def nColor As RMC_Colors
    Def nSeriesSymbol As LineSeriesSymbol
    Def nWhichDataAxis As Int
    Def nValueLabelOn As ValueLabels
    Def nHatchMode As Hatchmodes
EndType

Type tRMC_REGION
    Def nTop As Int
    Def nLeft As Int
    Def nWidth As Int
    Def nHeight As Int
    Def sFooter[200] As IString
    Def nShowBorder As Int
EndType

Type tRMC_XYAXIS
    Def nAlignment      As Int
    Def nMinValue       As Double
    Def nMaxValue       As Double
    Def nTickCount      As Int
    Def nFontSize       As Int
    Def nTextColor      As RMC_Colors
    Def nLineColor      As RMC_Colors
    Def nLinestyle      As AxisLineStyle
    Def nDecimalDigits  As Int
    Def nLabelAlignment As Int
    Def sUnit[16]       As IString
    Def sText[100]      As IString
    Def sLabels[500]    As IString
EndType

Type tRMC_XYSERIES
    Def nColor              As RMC_Colors
    Def nStyle              As XYSeriesStyle
    Def nLinestyle          As LineSeriesLineStyle
    Def nSeriesSymbol       As LineSeriesSymbol
    Def nWhichXAxis         As Int
    Def nWhichYAxis         As Int
    Def nValueLabelOn       As ValueLabels
EndType

Declare Import, RMC_AddBarSeries  Alias "RMC_ADDBARSERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstDataValue As Double ByRef, _
                            Opt nDataValuesCount As Int, _
                            Opt nType As BarSeriesType, _
                            Opt nStyle As BarSeriesStyle, _
                            Opt nIsLucent As Int, _
                            Opt nColor As RMC_Colors, _
                            Opt nIsHorizontal As Int, _
                            Opt nWhichDataAxis As Int, _
                            Opt nValueLabelOn As ValueLabels, _
                            Opt nPointsPerColumn As Int, _
                            Opt nHatchMode As Hatchmodes _
                            ), INT

Declare Import, RMC_AddBarSeriesI  Alias "RMC_ADDBARSERIESI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFirstDataValue As Double ByRef, _
                             nDataValuesCount As Int, _
                            T As tRMC_BARSERIES _
                            ), INT

Declare Import, RMC_AddCaption  Alias "RMC_ADDCAPTION" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt sCaption As String, _
                            Opt nTitelBackColor As RMC_Colors, _
                            Opt nTitelTextColor As RMC_Colors, _
                            Opt nTitelFontSize As Int, _
                            Opt nTitelIsBold As Int _
                            ), INT

Declare Import, RMC_AddCaptionI  Alias "RMC_ADDCAPTIONI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            T As tRMC_CAPTION _
                            ), INT

Declare Import, RMC_AddDataAxis  Alias "RMC_ADDDATAAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nAlignment As DAxisAlignment, _
                            Opt nMinValue As Double, _
                            Opt nMaxValue As Double, _
                            Opt nTickCount As Int, _
                            Opt nFontSize As Int, _
                            Opt nTextColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nLinestyle As AxisLineStyle, _
                            Opt nDecimalDigits As Int, _
                            Opt sUnit As String, _
                            Opt sText As String, _
                            Opt sLabels As String, _
                            Opt nLabelAlignment As Int), INT

Declare Import, RMC_AddDataAxisI  Alias "RMC_ADDDATAAXISI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            T As tRMC_DATAAXIS _
                            ), INT

Declare Import, RMC_AddGrid  Alias "RMC_ADDGRID" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nBackColor As RMC_Colors, _
                            Opt nAsGradient As Int, _
                            Opt nLeft As Int, _
                            Opt nTop As Int, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int, _
                            Opt nBiColor As BicolorMode _
                            ), INT

Declare Import, RMC_AddGridI  Alias "RMC_ADDGRIDI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            T As tRMC_GRID _
                            ), INT
                            
Declare Import, RMC_AddGridlessSeries  Alias "RMC_ADDGRIDLESSSERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstDataValue As Double ByRef, _
                            Opt nDataValuesCount As Int, _
                            Opt nFirstColorElement As Int, _
                            Opt nColorElementsCount As Int, _
                            Opt nStyle As GridlessSeriesStyle, _
                            Opt nAlignment As PieDonutAlignment, _
                            Opt nExplodeMode As Int, _
                            Opt nIsLucent As Int, _
                            Opt nValueLabelOn As ValueLabels, _
                            Opt nHatchMode As Hatchmodes, _
                            Opt nStartAngle As Int _
                            ), INT

Declare Import, RMC_AddGridlessSeriesI  Alias "RMC_ADDGRIDLESSSERIESI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFirstDataValue As Double ByRef, _
                             nDataValuesCount As Int, _
                             nFirstColorElement As Int ByRef , _
                             nColorElementsCount As Int, _
                             T As tRMC_GRIDLESSSERIES ByRef _
                            ), INT
                            
Declare Import, RMC_AddHighLowSeries  Alias "RMC_ADDHIGHLOWSERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstDataValue As Double ByRef, _
                            Opt nDataValuesCount As Int, _
                            Opt nFirstPPCValue As Int ByRef, _
                            Opt nPPCValuesCount As Int, _
                            Opt nStyle As HighLowSeriesStyle, _
                            Opt nWhichDataAxis As Int, _
                            Opt nColorLow As Int, _
                            Opt nColorHigh As Int _
                             ), INT

Declare Import, RMC_AddLabelAxis  Alias "RMC_ADDLABELAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLabels As String, _
                            Opt nCount As Int, _
                            Opt nTickCount As Int, _
                            Opt nAlignment As LAxisAlignment, _
                            Opt nFontSize As Int, _
                            Opt nTextColor As RMC_Colors, _
                            Opt nTextAlignment As LabelTextAlignment, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nLinestyle As AxisLineStyle, _
                            Opt sText As String _
                            ), INT

Declare Import, RMC_AddLabelAxisI  Alias "RMC_ADDLABELAXISI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLabels As String, _
                            T As tRMC_LABELAXIS _
                            ), INT
                            
Declare Import, RMC_AddLegend  Alias "RMC_ADDLEGEND" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLegend As String, _
                            Opt nLegendAlign As LegendAlignment, _
                            Opt nLegendBackColor As RMC_Colors, _
                            Opt nLegendStyle As LegendStyle, _
                            Opt nLegendTextColor As RMC_Colors, _
                            Opt nLegendFontSize As Int, _
                            Opt nLegendIsBold As Int _
                            ), INT

Declare Import, RMC_AddLegendI  Alias "RMC_ADDLEGENDI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLegend As String, _
                            T As tRMC_LEGEND _
                            ), INT
                            
Declare Import, RMC_AddLineSeries  Alias "RMC_ADDLINESERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstDataValue As Double ByRef, _
                            Opt nDataValuesCount As Int, _
                            Opt nFirstPPCValue As Int, _
                            Opt nPPCValuesCount As Int, _
                            Opt nChartType As LineSeriesType, _
                            Opt nStyle As LineSeriesStyle, _
                            Opt nLinestyle As LineSeriesLineStyle, _
                            Opt nIsLucent As Int, _
                            Opt nColor As RMC_Colors, _
                            Opt nSeriesSymbol As LineSeriesSymbol, _
                            Opt nWhichDataAxis As Int, _
                            Opt nValueLabelOn As ValueLabels, _
                            Opt nHatchMode As Hatchmodes _
                            ), INT

Declare Import, RMC_AddLineSeriesI  Alias "RMC_ADDLINESERIESI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFirstDataValue As Double ByRef, _
                             nDataValuesCount As Int, _
                             nFirstPPCValue As Int ByRef, _
                             nPPCValuesCount As Int, _
                            T As tRMC_LINESERIES _
                            ), INT
                            
Declare Import, RMC_AddRegion  Alias "RMC_ADDREGION" ( _
                             nCtrlId As Int, _
                            Opt nLeft As Int, _
                            Opt nTop As Int, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int, _
                            Opt sFooter As String, _
                            Opt nShowBorder As Int _
                            ), INT

Declare Import, RMC_AddRegionI  Alias "RMC_ADDREGIONI" ( _
                             nCtrlId As Int, _
                            T As tRMC_REGION _
                            ), INT
                            
Declare Import, RMC_AddToolTips  Alias "RMC_ADDTOOLTIPS" ( _
                             nCtrlId As Int, _
                             hWnd As Int, _
                            Opt nToolTipWidth As Int _
                            ), INT
                            
Declare Import, RMC_AddVolumeBarSeries  Alias "RMC_ADDVOLUMEBARSERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstDataValue As Double ByRef, _
                            Opt nDataValuesCount As Int, _
                            Opt nFirstPPCValue As Int, _
                            Opt nPPCValuesCount As Int, _
                            Opt nColor As RMC_Colors, _
                            Opt nWhichDataAxis As Int _
                            ), INT

Declare Import, RMC_AddXAxis  Alias "RMC_ADDXAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As XAxisAlignment, _
                            Opt nMinValue As Double, _
                            Opt nMaxValue As Double, _
                            Opt nTickCount As Int, _
                            Opt nFontSize As Int, _
                            Opt nTextColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nLinestyle As AxisLineStyle, _
                            Opt nDecimalDigits As Int, _
                            Opt sUnit As String, _
                            Opt sText As String, _
                            Opt sLables As String, _
                            Opt nLabelAlignment As Int _
                            ), INT

Declare Import, RMC_AddXAxisI  Alias "RMC_ADDXAXISI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            T As tRMC_XYAXIS _
                            ), INT

Declare Import, RMC_AddYAxis  Alias "RMC_ADDYAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As YAxisAlignment, _
                            Opt nMinValue As Double, _
                            Opt nMaxValue As Double, _
                            Opt nTickCount As Int, _
                            Opt nFontSize As Int, _
                            Opt nTextColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nLinestyle As AxisLineStyle, _
                            Opt nDecimalDigits As Int, _
                            Opt sUnit As String, _
                            Opt sText As String, _
                            Opt sLables As String, _
                            Opt nLabelAlignment As Int _
                            ), INT

Declare Import, RMC_AddYAxisI  Alias "RMC_ADDYAXISI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            T As tRMC_XYAXIS _
                            ), INT

Declare Import, RMC_AddXYSeries  Alias "RMC_ADDXYSERIES" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                            Opt nFirstXDataValue As Double ByRef, _
                            Opt nDataXValuesCount As Int, _
                            Opt nFirstYDataValue As Double ByRef, _
                            Opt nDataYValuesCount As Int, _
                            Opt nColor As RMC_Colors, _
                            Opt nStyle As XYSeriesStyle, _
                            Opt nLinestyle As LineSeriesLineStyle, _
                            Opt nSymbolStyle As LineSeriesSymbol, _
                            Opt nWhichXAxis As Int, _
                            Opt nWhichYAxis As Int, _
                            Opt nValueLabelOn As ValueLabels _
                            ), INT

Declare Import, RMC_AddXYSeriesI  Alias "RMC_ADDXYSERIESI" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nDataX As Double ByRef, _
                             nDataXCount As Int, _
                             nDataY As Double ByRef, _
                             nDataYCount As Int, _
                            T As tRMC_XYSERIES _
                            ), INT

Declare Import, RMC_CalcAverage  Alias "RMC_CALCAVERAGE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nAverage As Double ByRef, _
                             nXStart As Int ByRef, _
                             nYStart As Int ByRef, _
                             nXEnd As Int ByRef, _
                             nYEnd As Int ByRef, _
                            Opt sHighLowIndex As String _
                            ), INT
                            
Declare Import, RMC_CalcTrend  Alias "RMC_CALCTREND" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nFirstValue As Double ByRef, _
                             nLastValue As Double ByRef, _
                             nXStart As Int ByRef, _
                             nYStart As Int ByRef, _
                             nXEnd As Int ByRef, _
                             nYEnd As Int ByRef, _
                            Opt sHighLowIndex As String _
                            ), INT
                            
Declare Import, RMC_COBox  Alias "RMC_COBOX" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nLeft As Int, _
                             nTop As Int, _
                             nWidth As Int, _
                             nHeight As Int, _
                            Opt nStyle As COBoxStyle, _
                            Opt nBGColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nTransparency As Int _
                            ), INT

Declare Import, RMC_COCircle  Alias "RMC_COCIRCLE" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nXCenter As Int, _
                             nYCenter As Int, _
                             nWidth As Int, _
                            Opt nStyle As COCircleStyle, _
                            Opt nBGColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nTransparency As Int _
                            ), INT
                            
Declare Import, RMC_CODash  Alias "RMC_CODASH" ( _
                             nCtrlId As Int, _
                             nCOIndex As Int, _
                             nXStart As Int, _
                             nYStart As Int, _
                             nXEnd As Int, _
                             nYEnd As Int, _
                            Opt nStyle As COLineStyle, _
                            Opt nColor As RMC_Colors, _
                            Opt nAsSpline As Int, _
                            Opt nLineWidth As Int, _
                            Opt nStartCap As COAnchor, _
                            Opt nEndCap As COAnchor _
                            ), INT

Declare Import, RMC_CODelete  Alias "RMC_CODELETE" ( _
                             nCtrlId As Int, _
                             nIndex As Int _
                            ), INT

Declare Import, RMC_COGetTextWH  Alias "RMC_COGETTEXTWH" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nWH As Int ByRef _
                            ), Int

Declare Import, RMC_COImage  Alias "RMC_COIMAGE" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             sImagePath As String, _
                             nLeft As Int, _
                             nTop As Int, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int _
                            ), INT

Declare Import, RMC_COLine  Alias "RMC_COLINE" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nXPoints As Int BYREF, _
                             nYPoints As Int BYREF, _
                             nPointsCount As Int, _
                            Opt nStyle As COLineStyle, _
                            Opt nColor As RMC_Colors, _
                            Opt nAsSpline As Int, _
                            Opt nLineWidth As Int, _
                            Opt nStartCap As COAnchor, _
                            Opt nEndCap As COAnchor _
                            ), INT

Declare Import, RMC_COPolygon  Alias "RMC_COPOLYGON" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nXPoints As Int ByRef, _
                             nYPoints As Int ByRef, _
                             nPointsCount As Int, _
                            Opt nBGColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nAsSpline As Int, _
                            Opt nTransparency As Int _
                            ), INT

Declare Import, RMC_COSymbol  Alias "RMC_COSYMBOL" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nXCenter As Int, _
                             nYCenter As Int, _
                             nStyle As LineSeriesSymbol, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_COText  Alias "RMC_COTEXT" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             sText As String, _
                             nLeft As Int, _
                             nTop As Int, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int, _
                            Opt nStyle As COBoxStyle, _
                            Opt nBGColor As RMC_Colors, _
                            Opt nLineColor As RMC_Colors, _
                            Opt nTransparency As Int, _
                            Opt nLineAlignment As COLineAlignment, _
                            Opt nTextColor As RMC_Colors, _
                            Opt sTextProperties As String _
                            ), INT

Declare Import, RMC_COVisible  Alias "RMC_COVISIBLE" ( _
                             nCtrlId As Int, _
                             nIndex As Int, _
                             nHide As Int _
                            ), INT

Declare Import, RMC_CreateChartOnDC  Alias "RMC_CREATECHARTONDC" ( _
                             nParentDC As Int, _
                             nCtrlId As Int, _
                             nX As Int, _
                             nY As Int, _
                             nWidth As Int, _
                             nHeight As Int, _
                            Opt nBackColor As RMC_Colors, _
                            Opt nCtrlStyle As Int, _
                            Opt nExportOnly As Int, _
                            Opt sBgImage As String, _
                            Opt sFontName As String, _
                            Opt nBitmapBKColor As RMC_Colors _
                            ), INT

Declare Import, RMC_CreateChartOnDCI  Alias "RMC_CREATECHARTONDCI" ( _
                             nParentDC As Int, _
                             nCtrlId As Int, _
                            T As tRMC_CHART _
                            ), INT

Declare Import, RMC_CreateChartFromFileOnDC  Alias "RMC_CREATECHARTFROMFILEONDC" ( _
                             nParentDC As Int, _
                             nCtrlId As Int, _
                             nX As Int, _
                             nY As Int, _
                             nExportOnly As Int, _
                             sRMCFile As String _
                             ), INT

Declare Import, RMC_DeleteChart  Alias "RMC_DELETECHART" ( _
                             nCtrlId As Int _
                            ), INT

Declare Import, RMC_Draw  Alias "RMC_DRAW" ( _
                             nCtrlId As Int _
                            ), INT
                            
Declare Import, RMC_Draw2Clipboard  Alias "RMC_DRAW2CLIPBOARD" ( _
                             nCtrlId As Int, _
                            Opt nType As RMCFileType _
                            ), INT
                 
Declare Import, RMC_Draw2File  Alias "RMC_DRAW2FILE" ( _
                             nCtrlId As Int, _
                             sFileName As String, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int, _
                            Opt nJPGQualityLevel=0 As Int _
                            ), INT

Declare Import, RMC_Draw2Printer  Alias "RMC_DRAW2PRINTER" ( _
                             nCtrlId As Int, _
                            Opt nPrinterDC As Int, _
                            Opt nLeft As Int, _
                            Opt nTop As Int, _
                            Opt nWidth As Int, _
                            Opt nHeight As Int, _
                            Opt nType As RMCFileType _
                            ), INT
                            
Declare Import, RMC_GetChartSizeFromFile  Alias "RMC_GETCHARTSIZEFROMFILE" ( _
                             sRMCFile As String, _
                             nWidth As Int ByRef, _
                             nHeight As Int ByRef _
                            ), INT

Declare Import, RMC_GetImageSizeFromFile  Alias "RMC_GETIMAGESIZEFROMFILE" ( _
                             sImagePath As String, _
                             nWidth As Int ByRef, _
                             nHeight As Int ByRef _
                            ), INT
                            
Declare Import, RMC_GetCtrlWidth  Alias "RMC_GETCTRLWIDTH" ( _
                             nCtrlId As Int _
                            ), INT

Declare Import, RMC_GetCtrlHeight  Alias "RMC_GETCTRLHEIGHT" ( _
                             nCtrlId As Int _
                            ), INT
                            
Declare Import, RMC_GetData  Alias "RMC_GETDATA" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nDataIndex As Int, _
                             nData As Double ByRef, _
                            Opt nYData As Int _
                            ), Int

Declare Import, RMC_GetDataCount  Alias "RMC_GETDATACOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nDataCount As Int ByRef _
                            ), Int

Declare Import, RMC_GetDataLocation  Alias "RMC_GETDATALOCATION" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nData As Double, _
                             nXYPos As Int ByRef _
                            ), Int

Declare Import, RMC_GetDataLocationXY  Alias "RMC_GETDATALOCATIONXY" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeriesIndex As Int, _
                             nDataX As Double, _
                             nDataY As Double, _
                             nXPos As Int ByRef, _
                             nYPos As Int ByRef _
                            ), Int


Declare Import, RMC_GetGridLocation  Alias "RMC_GETGRIDLOCATION" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLeft As Int ByRef, _
                             nTop As Int ByRef, _
                             nRight As Int ByRef, _
                             nBottom As Int ByRef _
                            ), Int
                            
Declare Import, RMC_GetHighPart  Alias "RMC_GETHIGHPART" ( _
                            nParam As Double _
                           ), Int
                            
Declare Import, RMC_GetINFO  Alias "RMC_GETINFO" ( _
                             nCtrlId As Int, _
                             tINFO As tRMC_INFO ByRef, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nIndex As Int _
                            ), INT
            
Declare Import, RMC_GetINFOXY  Alias "RMC_GETINFOXY" ( _
                             nCtrlId As Int, _
                             tINFO As tRMC_INFO ByRef, _
                             nX As Int, _
                             nY As Int _
                            ), INT

Declare Import, RMC_GetLowPart  Alias "RMC_GETLOWPART" ( _
                            nParam As Double _
                           ), Int
                            
Declare Import, RMC_GetSeriesDataRange  Alias "RMC_GETSERIESDATARANGE" ( _
                            nCtrlId As Int, _
                            nRegion As Int, _
                            nSeries As Int, _
                            nFirst As Int ByRef, _
                            nLast As Int ByRef _
                           ), Int

Declare Import, RMC_GetVersion  Alias "RMC_GETVERSION" ( _
                            ), Double

Declare Import, RMC_Magnifier  Alias "RMC_MAGNIFIER" ( _
                             nCtrlId As Int, _
                             nEnable As Int, _
                            Opt nSize As Int, _
                            Opt nColor As Int, _
                            Opt nLineColor As Int, _
                            Opt nTransparency As Int _
                            ), INT
                            
Declare Import, RMC_Paint  Alias "RMC_PAINT" ( _
                             nCtrlId As Int _
                            ), INT

Declare Import, RMCvb_ReadDataFromFile  Alias "RMCVB_READDATAFROMFILE" ( _
                             aData[] As Double ByRef, _
                             sFileName As String ByRef, _
                             sLines As String ByRef, _
                             sFields As String ByRef, _
                             sFieldDelimiter As String ByRef, _
                            Opt nReverse As Int _
                            ), INT

Declare Import, RMCvb_ReadStringFromFile  Alias "RMCVB_READSTRINGFROMFILE" ( _
                             aValue[] As String ByRef, _
                             sFileName As String ByRef, _
                             sLines As String ByRef, _
                             sFields As String ByRef, _
                             sFieldDelimiter As String ByRef, _
                            Opt nReverse As Int _
                            ), INT

Declare Import, RMC_Reset  Alias "RMC_RESET" ( _
                             nCtrlId As Int _
                             ), INT

Declare Import, RMC_RND  ( _
                             n1 As Int, _
                             n2 As Int _
                            ), Int

Declare Import, RMCvb_Split2Double  Alias "RMCVB_SPLIT2DOUBLE" ( _
                             sData As String ByRef , _
                             aData[] As Double ByRef _
                            ), INT

Declare Import, RMCvb_Split2Long  Alias "RMCVB_SPLIT2LONG" ( _
                             sData As String ByRef , _
                             aData[] As Int ByRef _
                            ), INT

Declare Import, RMC_SetCaptionText  Alias "RMC_SETCAPTIONTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sText As String _
                            ), INT
                            
Declare Import, RMC_SetCaptionBGColor  Alias "RMC_SETCAPTIONBGCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetCaptionTextColor  Alias "RMC_SETCAPTIONTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetCaptionFontSize  Alias "RMC_SETCAPTIONFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int _
                            ), INT

Declare Import, RMC_SetCaptionFontBold  Alias "RMC_SETCAPTIONFONTBOLD" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontBold As Int _
                            ), INT
                 
Declare Import, RMC_SetCtrlBGColor  Alias "RMC_SETCTRLBGCOLOR" ( _
                             nCtrlId As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetCtrlBGImage  Alias "RMC_SETCTRLBGIMAGE" ( _
                             nCtrlId As Int, _
                             sBgImage As String _
                            ), INT

Declare Import, RMC_SetCtrlFont  Alias "RMC_SETCTRLFONT" ( _
                             nCtrlId As Int, _
                             sFontName As String _
                            ), INT

Declare Import, RMC_SetCtrlSize  Alias "RMC_SETCTRLSIZE" ( _
                             nCtrlId As Int, _
                             nWidth As Int, _
                             nHeight As Int, _
                            Opt nRelative As Int, _
                            Opt nRecalcMode As Int _
                            ), INT

Declare Import, RMC_SetCtrlStyle  Alias "RMC_SETCTRLSTYLE" ( _
                             nCtrlId As Int, _
                             nStyle As CtrlStyle _
                            ), INT

Declare Import, RMC_SetCustomToolTipText  Alias "RMC_SETCUSTOMTOOLTIPTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nDataIndex As Int, _
                             sText As String _
                            ), Int

Declare Import, RMC_SetDAXAlignment  Alias "RMC_SETDAXALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As DAxisAlignment _
                            ), INT

Declare Import, RMC_SetDAXDecimalDigits  Alias "RMC_SETDAXDECIMALDIGITS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nDecimalDigits As Int, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetDAXFontSize  Alias "RMC_SETDAXFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int _
                            ), INT

Declare Import, RMC_SetDAXLineColor  Alias "RMC_SETDAXLINECOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetDAXLineStyle  Alias "RMC_SETDAXLINESTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nStyle As AxisLineStyle _
                            ), INT
                  
Declare Import, RMC_SetDAXMaxValue  Alias "RMC_SETDAXMAXVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMaxValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetDAXMinValue  Alias "RMC_SETDAXMINVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMinValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetDAXText  Alias "RMC_SETDAXTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sText As String, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetDAXTextColor  Alias "RMC_SETDAXTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT
                  
Declare Import, RMC_SetDAXTickcount  Alias "RMC_SETDAXTICKCOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nTickCount As Int _
                            ), INT
                  
Declare Import, RMC_SetDAXUnit  Alias "RMC_SETDAXUNIT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sUnit As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetGridBGColor  Alias "RMC_SETGRIDBGCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetGridBiColor  Alias "RMC_SETGRIDBICOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nBiColor As Int _
                            ), INT

Declare Import, RMC_SetGridGradient  Alias "RMC_SETGRIDGRADIENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nHasGradient As Int _
                            ), INT

Declare Import, RMC_SetGridMargin  Alias "RMC_SETGRIDMARGIN" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLeft As Int, _
                             nTop As Int, _
                             nWidth As Int, _
                             nHeight As Int _
                            ), INT
                            
Declare Import, RMC_SetHelpingGrid  Alias "RMC_SETHELPINGGRID" ( _
                             nCtrlId As Int, _
                             nSize As Int, _
                            Opt nGridColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetLAXAlignment  Alias "RMC_SETLAXALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As LAxisAlignment _
                            ), INT

Declare Import, RMC_SetLAXCount  Alias "RMC_SETLAXCOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLabelAxisCount As Int _
                            ), INT

Declare Import, RMC_SetLAXFontSize  Alias "RMC_SETLAXFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int _
                            ), INT

Declare Import, RMC_SetLAXLabelAlignment  Alias "RMC_SETLAXLABELALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As LabelTextAlignment _
                            ), INT

Declare Import, RMC_SetLAXLabels  Alias "RMC_SETLAXLABELS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLabels As String _
                            ), INT

Declare Import, RMC_SetLAXLabelsFile  Alias "RMC_SETLAXLABELSFILE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sFileName As String, _
                            Opt sLines As String, _
                            Opt sFields As String, _
                            Opt sFieldDelimiter As String _
                            ), INT

Declare Import, RMC_SetLAXLabelsRange  Alias "RMC_SETLAXLABELSRANGE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFirst As Int, _
                             nLast As Int _
                            ), INT

Declare Import, RMC_SetLAXLineColor  Alias "RMC_SETLAXLINECOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetLAXLineStyle  Alias "RMC_SETLAXLINESTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nStyle As AxisLineStyle _
                            ), INT

Declare Import, RMC_SetLAXText  Alias "RMC_SETLAXTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sText As String _
                            ), INT
                  
Declare Import, RMC_SetLAXTextColor  Alias "RMC_SETLAXTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetLAXTickCount  Alias "RMC_SETLAXTICKCOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nTickCount As Int _
                            ), INT

Declare Import, RMC_SetLegendAlignment  Alias "RMC_SETLEGENDALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As LegendAlignment _
                            ), INT

Declare Import, RMC_SetLegendBGColor  Alias "RMC_SETLEGENDBGCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetLegendFontBold  Alias "RMC_SETLEGENDFONTBOLD" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontBold As Int _
                            ), INT

Declare Import, RMC_SetLegendFontSize  Alias "RMC_SETLEGENDFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int _
                            ), INT
                  
Declare Import, RMC_SetLegendHide  Alias "RMC_SETLEGENDHIDE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nHide As Int _
                            ), Int

Declare Import, RMC_SetLegendStyle  Alias "RMC_SETLEGENDSTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nStyle As LegendStyle _
                            ), INT

Declare Import, RMC_SetLegendText  Alias "RMC_SETLEGENDTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLegendText As String _
                            ), INT

Declare Import, RMC_SetLegendTextColor  Alias "RMC_SETLEGENDTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors _
                            ), INT

Declare Import, RMC_SetMouseClick  Alias "RMC_SETMOUSECLICK" ( _
                             nCtrlId As Int, _
                             nButton As Int, _
                             nX As Int, _
                             nY As Int, _
                             tINFO As tRMC_INFO ByRef _
                            ), INT

Declare Import, RMC_SetRegionFooter  Alias "RMC_SETREGIONFOOTER" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sFooter As String _
                            ), INT

Declare Import, RMC_SetRegionMargin  Alias "RMC_SETREGIONMARGIN" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLeft As Int, _
                             nTop As Int, _
                             nWidth As Int, _
                             nHeight As Int _
                            ), INT
                  
Declare Import, RMC_SetRegionBorder  Alias "RMC_SETREGIONBORDER" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nShowBorder As Int _
                            ), INT

Declare Import, RMC_SetRMCFile  Alias "RMC_SETRMCFILE" ( _
                             nCtrlId As Int, _
                             sRMCFile As String _
                            ), INT

Declare Import, RMC_SetSeriesColor  Alias "RMC_SETSERIESCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nColor As RMC_Colors, _
                            Opt nIndex As Int _
                            ), INT

Declare Import, RMC_SetSeriesExplodeMode  Alias "RMC_SETSERIESEXPLODEMODE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nExplodeMode As Int _
                            ), INT

Declare Import, RMC_SetSeriesStartAngle  Alias "RMC_SETSERIESSTARTANGLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nStartAngle As Int _
                            ), INT

Declare Import, RMC_SetSeriesData  Alias "RMC_SETSERIESDATA" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nData As Double ByRef , _
                             nDataCount As Int, _
                            Opt nYData As Int _
                            ), INT

Declare Import, RMC_SetSeriesDataFile  Alias "RMC_SETSERIESDATAFILE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             sFileName As String, _
                            Opt sLines As String, _
                            Opt sFields As String, _
                            Opt sFieldDelimiter As String, _
                            Opt nYData As Int _
                            ), INT

Declare Import, RMC_SetSeriesDataRange  Alias "RMC_SETSERIESDATARANGE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nFirst As Int, _
                             nLast As Int _
                            ), INT

Declare Import, RMC_SetSeriesSingleData  Alias "RMC_SETSERIESSINGLEDATA" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nData As Double, _
                             nDataIndex As Int, _
                            Opt nYData As Int _
                            ), INT

Declare Import, RMC_SetSeriesDataAxis  Alias "RMC_SETSERIESDATAAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nWhichAxis As Int _
                            ), INT
                 
Declare Import, RMC_SetSeriesHatchMode  Alias "RMC_SETSERIESHATCHMODE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nHatchMode As Hatchmodes _
                            ), INT
                  
Declare Import, RMC_SetSeriesHide  Alias "RMC_SETSERIESHIDE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nHide As Int _
                            ), INT

Declare Import, RMC_SetSeriesHighLowColor  Alias "RMC_SETSERIESHIGHLOWCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nColorLow As RMC_Colors, _
                             nColorHigh As RMC_Colors _
                            ), INT
                  
Declare Import, RMC_SetSeriesLinestyle  Alias "RMC_SETSERIESLINESTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nLinestyle As LineSeriesLineStyle _
                            ), INT
                  
Declare Import, RMC_SetSeriesLucent  Alias "RMC_SETSERIESLUCENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nLucent As Int _
                            ), INT

Declare Import, RMC_SetSeriesPPColumn  Alias "RMC_SETSERIESPPCOLUMN" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nPointsPerColumn As Int _
                            ), Int
                 
Declare Import, RMC_SetSeriesPPColumnArray  Alias "RMC_SETSERIESPPCOLUMNARRAY" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nFirstPPCValue As Int ByRef , _
                             nPPCValuesCount As Int _
                            ), Int

Declare Import, RMC_SetSeriesVertical  Alias "RMC_SETSERIESVERTICAL" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nVertical As Int _
                            ), INT
                  
Declare Import, RMC_SetSeriesStyle  Alias "RMC_SETSERIESSTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nStyle As Int _
                            ), INT

Declare Import, RMC_SetSeriesSymbol  Alias "RMC_SETSERIESSYMBOL" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nSymbol As LineSeriesSymbol _
                            ), INT

Declare Import, RMC_SetSeriesValuelabel  Alias "RMC_SETSERIESVALUELABEL" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nValuelabel As ValueLabels _
                            ), INT

Declare Import, RMC_SetSeriesXAxis  Alias "RMC_SETSERIESXAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nWhichXAxis As Int _
                            ), INT
                     
Declare Import, RMC_SetSeriesYAxis  Alias "RMC_SETSERIESYAXIS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nSeries As Int, _
                             nWhichYAxis As Int _
                            ), INT

Declare Import, RMC_SetSingleBarColors  Alias "RMC_SETSINGLEBARCOLORS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors ByRef , _
                             nColorCount As Int _
                            ), INT

Declare Import, RMC_SetToolTipWidth  Alias "RMC_SETTOOLTIPWIDTH" ( _
                             nCtrlId As Int, _
                             nWidth As Int _
                            ), Int

Declare Import, RMC_SetWatermark  Alias "RMC_SETWATERMARK" ( _
                             sWaterMark As String, _
                            Opt nWMColor As RMC_Colors, _
                            Opt nWMLucentValue As Int, _
                            Opt nAlignment As Int, _
                            Opt nFontSize As Int _
                            ), INT
Declare Import, RMC_SetXAXAlignment  Alias "RMC_SETXAXALIGNMENT" ( _
                           nCtrlId As Int, _
                           nRegion As Int, _
                           nAlignment As XAxisAlignment, _
                          Opt nAxisIndex As Int _
                          ), INT

Declare Import, RMC_SetYAXAlignment  Alias "RMC_SETYAXALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nAlignment As YAxisAlignment, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXDecimalDigits  Alias "RMC_SETXAXDECIMALDIGITS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nDecimalDigits As Int, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXDecimalDigits  Alias "RMC_SETYAXDECIMALDIGITS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nDecimalDigits As Int, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetXAXFontSize  Alias "RMC_SETXAXFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXFontSize  Alias "RMC_SETYAXFONTSIZE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nFontSize As Int, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXLabels  Alias "RMC_SETXAXLABELS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLabels As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetYAXLabels  Alias "RMC_SETYAXLABELS" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sLabels As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXLabelAlignment  Alias "RMC_SETXAXLABELALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLabelAlignment As Int, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetYAXLabelAlignment  Alias "RMC_SETYAXLABELALIGNMENT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nLabelAlignment As Int, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXLineColor  Alias "RMC_SETXAXLINECOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXLineColor  Alias "RMC_SETYAXLINECOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors, _
                            Opt nAxisIndex As Int _
                            ), INT
                 
Declare Import, RMC_SetXAXLineStyle  Alias "RMC_SETXAXLINESTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nStyle As AxisLineStyle, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetYAXLineStyle  Alias "RMC_SETYAXLINESTYLE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nStyle As AxisLineStyle, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXMaxValue  Alias "RMC_SETXAXMAXVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMaxValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXMaxValue  Alias "RMC_SETYAXMAXVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMaxValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXMinValue  Alias "RMC_SETXAXMINVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMinValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXMinValue  Alias "RMC_SETYAXMINVALUE" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nMinValue As Double, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXText  Alias "RMC_SETXAXTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sText As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetYAXText  Alias "RMC_SETYAXTEXT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sText As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXTextColor  Alias "RMC_SETXAXTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXTextColor  Alias "RMC_SETYAXTEXTCOLOR" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nColor As RMC_Colors, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetXAXTickcount  Alias "RMC_SETXAXTICKCOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nTickCount As Int, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetYAXTickcount  Alias "RMC_SETYAXTICKCOUNT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             nTickCount As Int, _
                            Opt nAxisIndex As Int _
                            ), INT
                  
Declare Import, RMC_SetXAXUnit  Alias "RMC_SETXAXUNIT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sUnit As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_SetYAXUnit  Alias "RMC_SETYAXUNIT" ( _
                             nCtrlId As Int, _
                             nRegion As Int, _
                             sUnit As String, _
                            Opt nAxisIndex As Int _
                            ), INT

Declare Import, RMC_ShowToolTips  Alias "RMC_SHOWTOOLTIPS" ( _
                             nCtrlId As Int, _
                             nX As Int, _
                             nY As Int _
                            ), INT

Declare Import, RMCvb_WriteRMCFile  Alias "RMCVB_WRITERMCFILE" ( _
                             nCtrlId As Int, _
                             sFileName As String ByRef _
                            ), INT

Declare Import, RMC_Zoom  Alias "RMC_ZOOM" ( _
                             nCtrlId As Int, _
                             nMode As Int, _
                            Opt nColor As Int, _
                            Opt nLineColor As Int, _
                            Opt nTransparency As Int _
                            ), INT

 Const RMC_USERWM = ""                      ' Your watermark
 Const RMC_USERWMCOLOR = Black              ' Color for the watermark
 Const RMC_USERWMLUCENT = 30                ' Lucent factor between 1(=not visible) and 255(=opaque)
 Const RMC_USERWMALIGN = RMC_TEXTCENTER     ' Alignment for the watermark
 Const RMC_USERFONTSIZE = 0                 ' Fontsize; if 0: maximal size is used
