
'************************************************
'                                               '
' Message box include file Version 1.0 by Andy. '
'                                               '
'************************************************

window MessageBox1
type mb1
     window WinName
     int    WinWidth
     int    WinDepth
     int    BottomLineAdjust
     uint   ScreenColour
     uint   TextColour
     uint   TextStyle
     string Font
     int    Size
     int    Weigth
     int    Line1Width
     int    Line2Width
     int    Line3Width
     int    Line1Depth
     int    Line2Depth
     int    Line3Depth
     int    LineSpacing
     int    Buttons
     int    ButtonSpacing
     int    DefaultButton
     int    Button1Width
     int    Button2Width
     int    Button3Width
     int    Button1Depth
     int    Button2Depth
     int    Button3Depth
     string Button1Text
     string Button2Text 
     string Button3Text
     uint   Icon 
endtype
def mb as mb1 
int mbAnswer = 0
int mbl,mbt,mbw,mbh

const mbInfo = 1
const mbQuestion = 2
const mbTriangle = 3
const mbStop = 4

'Set your defaults here...
mb.WinName = MessageBox1
mb.WinWidth = 500
mb.WinDepth = 0
mb.ScreenColour = rgb(0,0,0)
mb.TextColour = RGB(255,255,255)
mb.TextStyle = @CTEDITCENTER|0x200
mb.Line1Width = 500
mb.Line2Width = 500
mb.Line3Width = 500
mb.Line1Depth = 25
mb.Line2Depth = 25
mb.Line3Depth = 25
mb.LineSpacing = 20
mb.Font = "Arial" 						'Text font
mb.Size = 12 								'Text Font Size
mb.Weigth = 500 							'Text weight
mb.Buttons = 3 							'Number of buttons on screen
mb.ButtonSpacing = 10 					'Space buttons appart horizontal by.....
mb.Button1Width = 100
mb.Button2Width = 100
mb.Button3Width = 100
mb.Button1Depth = 25
mb.Button2Depth = 25
mb.Button3Depth = 25
mb.Button1Text = ""
mb.Button2Text = ""
mb.Button3Text = ""
mb.DefaultButton = 1
mb.BottomLineAdjust = 50 'Move the bottom of the window down by.....
mb.Icon = mbInfo

sub DoMessageBox(string Caption,string Line1,opt string Line2,opt string Line3)
OPENWINDOW mb.WinName,0,0,mb.WinWidth,mb.WinDepth,@TOPMOST|@CAPTION,0,Caption,&MessageBoxHandler
	uint Theme = mb.ScreenColour
	Setwindowcolor mb.WinName,Theme

   int mbStartAt = mb.LineSpacing

	CONTROL mb.WinName,@STATIC,"",0,mbStartAt,mb.Line1Width,mb.Line1Depth,mb.TextStyle,1
	SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,1
	SETCONTROLCOLOR mb.WinName,1,mb.TextColour,Theme

   if Line2 <> ""
      mb.LineSpacing = mb.LineSpacing + mbStartAt + 5
		CONTROL mb.WinName,@STATIC,"",0,mb.LineSpacing,mb.Line2Width,mb.Line2Depth,mb.TextStyle,2
		SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,2
		SETCONTROLCOLOR mb.WinName,2,mb.TextColour,Theme
   endif

   if Line3 <> ""
      mb.LineSpacing = mb.LineSpacing + mbStartAt + 5
		CONTROL mb.WinName,@STATIC,"",0,mb.LineSpacing,mb.Line3Width,mb.Line3Depth,mb.TextStyle,3
		SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,3
		SETCONTROLCOLOR mb.WinName,3,mb.TextColour,Theme
   endif

	setcontroltext(mb.WinName,1,Line1)
	setcontroltext(mb.WinName,2,Line2) 
	setcontroltext(mb.WinName,3,Line3)  
	
   if mb.Buttons > 1
      int ButtonAcrossStart = mb.WinWidth / 2 '250
      if mb.Buttons = 2
         int TotalButtonLength = mb.Button1Width + mb.ButtonSpacing + mb.Button2Width '100 + 10 + 100
      else
         TotalButtonLength = mb.Button1Width + mb.ButtonSpacing + mb.Button2Width + mb.ButtonSpacing + mb.Button3Width 
      endif
      TotalButtonLength = TotalButtonLength / 2 '105
      int AcrossHere = ButtonAcrossStart-TotalButtonLength
   endif

   mb.LineSpacing = mb.LineSpacing + mbStartAt + 25
	CONTROL mb.WinName,@BUTTON,mb.Button1Text,AcrossHere,mb.LineSpacing,mb.Button1Width,mb.Button1Depth,0,11
	SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,11
	SETCONTROLCOLOR mb.WinName,11,mb.TextColour,Theme

   if mb.Buttons >= 2
      AcrossHere = AcrossHere + mb.ButtonSpacing + mb.Button1Width
		CONTROL mb.WinName,@BUTTON,mb.Button2Text,AcrossHere,mb.LineSpacing,mb.Button2Width,mb.Button2Depth,0,12
		SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,12
		SETCONTROLCOLOR mb.WinName,12,mb.TextColour,Theme
   endif

   if mb.Buttons = 3
      AcrossHere = AcrossHere + mb.ButtonSpacing + mb.Button2Width
		CONTROL mb.WinName,@BUTTON,mb.Button3Text,AcrossHere,mb.LineSpacing,mb.Button3Width,mb.Button3Depth,0,13
		SETFONT mb.WinName,mb.Font,mb.Size,mb.Weigth,0,13
		SETCONTROLCOLOR mb.WinName,13,mb.TextColour,Theme
   endif

   CONTROL mb.WinName,@BUTTON,"",10,mbStartAt,50,50,@CTLBTNBITMAP,7
           if mb.Icon = 1 then SETCONTROLTEXT mb.WinName,7,GETSTARTPATH() + "info.bmp"
           if mb.Icon = 2 then SETCONTROLTEXT mb.WinName,7,GETSTARTPATH() + "question.bmp"
           if mb.Icon = 3 then SETCONTROLTEXT mb.WinName,7,GETSTARTPATH() + "triangle.bmp"
           if mb.Icon = 4 then SETCONTROLTEXT mb.WinName,7,GETSTARTPATH() + "stop.bmp"

   GETSIZE mb.WinName,mbl,mbt,mbw,mbh

   int mbDeepestButton = 0
   if mb.Button1Depth > mbDeepestButton
      mbDeepestButton = mb.Button1Depth
   endif
   if mb.Button2Depth > mbDeepestButton
      mbDeepestButton = mb.Button2Depth
   endif
   if mb.Button3Depth > mbDeepestButton
      mbDeepestButton = mb.Button3Depth
   endif
   int mbBottomLine = mb.LineSpacing + mbDeepestButton + mb.BottomLineAdjust
   setsize mb.WinName,mbl,mbt,mbw,mbBottomLine
   centerwindow mb.WinName
 
   if mb.DefaultButton = 1
 	   setfocus mb.WinName,11
	endif

   if mb.DefaultButton = 2
 	   setfocus mb.WinName,12
	endif

   if mb.DefaultButton = 3
 	   setfocus mb.WinName,13
	endif

WAITUNTIL IsWindowClosed(mb.WinName)

return 
endsub

SUB MessageBoxHandler(),INT
	 SELECT @MESSAGE
				CASE @IDCREATE
					  CENTERWINDOW mb.WinName

				CASE @IDCLOSEWINDOW
					  mbAnswer = 0
					  CLOSEWINDOW mb.WinName

				case @IDKEYDOWN
					  if @CODE = 37
						  setfocus mb.WinName,4
					  endif 
					  if @CODE = 39
						  setfocus mb.WinName,8
					  endif   

				CASE @IDCONTROL
					  SELECT @CONTROLID
								case 11 'Button 1
									  if @NOTIFYCODE = 0
										  mbAnswer = 1
										  closewindow mb.WinName
									  endif 

								case 12 'Button 2
									  if @NOTIFYCODE = 0
										  mbAnswer  = 2
										  closewindow mb.WinName
									  endif 

								case 13 'Button 3
									  if @NOTIFYCODE = 0
										  mbAnswer  = 3
										  closewindow mb.WinName
									  endif

					  ENDSELECT
    ENDSELECT
RETURN 0
ENDSUB
