'last macro 660

/**************************************
*
*	VfW.inc - Video for windows include file for WIN32
*
*	Copyright(c)1991-1995, Microsoft Corp.	All rights reserved.
*
*	This include files defines interfaces to the following
*	video components
*
*	COMPMAN	- Installable Compression Manager.
*	DRAWDIB	- Routines for drawing to the display.
*	VIDEO	- Video Capture Driver Interface
*
*	AVIFMT	- AVI File Format structure definitions.
*	MMREG	- FOURCC and other things
*
*	AVIFile	- Interface for reading AVI Files and AVI Streams
*	MCIWND	- MCI/AVI window class
*	AVICAP	- AVI Capture Window class
*
*	MSACM	- Audio compression manager.
*
*	The following symbols control inclusion of various parts of this file:
*
*	NOCOMPMAN	- dont include COMPMAN
*	NODRAWDIB	- dont include DRAWDIB
*	NOVIDEO	- dont include video capture interface
*
*	NOAVIFMT	- dont include AVI file format structs
*	NOMMREG	- dont include MMREG
*
*	NOAVIFILE	- dont include AVIFile interface
*	NOMCIWND	- dont include AVIWnd class.
*	NOAVICAP	- dont include AVICap class.
*
*	NOMSACM	- dont include ACM stuff.
*
* *************************************/

$ifndef __vfw_inc__
$define __vfw_inc__

'$use "sdk\Vfw32.Lib"
$use "custom\\sdkincludes.lib"
$use "msvfw32.lib"
$use "avifil32.lib"
$use "avicap32.lib"
/**************************************
*
*	types
*
* *************************************/

'$define VFWAPI	WINAPI
'$define VFWAPIV WINAPIV
'$define VFWAPI_INLINE	WINAPI_INLINE

/**************************************
*
*	VideoForWindowsVersion()- returns version of VfW
*
* *************************************/

declare import, VideoForWindowsVersion(),DWORD

/**************************************
*
*	call these to start stop using VfW from your app.
*
* *************************************/

declare import, InitVFW(),LONG
declare import, TermVFW(),LONG

/**************************************
*
*	do we need MMSYSTEM?
*
* *************************************/

$ifndef __mmsystem_inc__
 $ifndef NOVIDEO
	$ifndef NOAVICAP
	$ifndef __mmsystem_inc__
	$include "mmsystem.inc"
	$endif
	$endif
 $endif
$endif

/**************************************/
/*	*/
/*	Macros	*/
/*	*/
/*	should we define this??	*/
/*	*/
/**************************************/

$ifndef MKFOURCC_DEFINED
$define MKFOURCC_DEFINED
declare extern MKFOURCC(int ch0,int ch1,int ch2,int ch3),uint
/*$define MKFOURCC(ch0, ch1, ch2, ch3)	\
		((DWORD)(BYTE)(ch0)|((DWORD)(BYTE)(ch1)<< 8)|	\
		((DWORD)(BYTE)(ch2)<< 16)|((DWORD)(BYTE)(ch3)<< 24))*/
$endif

$ifndef __mmsystem_inc__
$define mmioFOURCC_DEFINED
	declare extern mmioFOURCC alias MKFOURCC(int ch0,int ch1,int ch2,int ch3),UINT
$endif

/**************************************
*
*	COMPMAN - Installable Compression Manager.
*
* *************************************/

$ifndef NOCOMPMAN

$define ICVERSION	0x0104

typedef HIC HANDLE	/* Handle to a Installable Compressor */

' this code biCompression means the DIB must be accesed via
' 48 bit pointers! using* ONLY* the selector given.
$define BI_1632	0x32333631	' '1632'

$ifndef mmioFOURCC_DEFINED
$define mmioFOURCC_DEFINED
declare extern mmioFOURCC(int ch0,int ch1,int ch2,int ch3),UINT
/*$define mmioFOURCC(ch0, ch1, ch2, ch3)				\
		((DWORD)(BYTE)(ch0)|((DWORD)(BYTE)(ch1)<< 8)|	\
		((DWORD)(BYTE)(ch2)<< 16)|((DWORD)(BYTE)(ch3)<< 24))*/
$endif

$ifndef aviTWOCC_DEFINED
$define aviTWOCC_DEFINED
'$define aviTWOCC(ch0, ch1)((USHORT)(BYTE)(ch0)|((USHORT)(BYTE)(ch1)<< 8))
declare extern aviTWOCC(int ch0,int ch1),UINT
$endif

$ifndef ICTYPE_VIDEO
$define ICTYPE_VIDEO	0x63646976'mmioFOURCC('v', 'i', 'd', 'c')
$define ICTYPE_AUDIO	0x63647561'mmioFOURCC('a', 'u', 'd', 'c')
$endif

$ifndef ICERR_OK
$define ICERR_OK	0
$define ICERR_DONTDRAW	1
$define ICERR_NEWPALETTE	2
$define ICERR_GOTOKEYFRAME	3
$define ICERR_STOPDRAWING 	4

$define ICERR_UNSUPPORTED	-1
$define ICERR_BADFORMAT	-2
$define ICERR_MEMORY	-3
$define ICERR_INTERNAL	-4
$define ICERR_BADFLAGS	-5
$define ICERR_BADPARAM	-6
$define ICERR_BADSIZE	-7
$define ICERR_BADHANDLE	-8
$define ICERR_CANTUPDATE	-9
$define ICERR_ABORT		-10
$define ICERR_ERROR	-100
$define ICERR_BADBITDEPTH	-200
$define ICERR_BADIMAGESIZE	-201

$define ICERR_CUSTOM	-400	' errors less than ICERR_CUSTOM...
$endif

/* Values for dwFlags of ICOpen()*/
$ifndef ICMODE_COMPRESS
$define ICMODE_COMPRESS		1
$define ICMODE_DECOMPRESS	2
$define ICMODE_FASTDECOMPRESS	3
$define ICMODE_QUERY	4
$define ICMODE_FASTCOMPRESS	5
$define ICMODE_DRAW	8
$endif
$define ICMODE_INTERNALF_FUNCTION32	0x8000	' Internal
$define ICMODE_INTERNALF_MASK		0x8000	' Internal

/* Flags for AVI file index */
$define AVIIF_LIST	0x00000001
$define AVIIF_TWOCC	0x00000002
$define AVIIF_KEYFRAME	0x00000010

/* quality flags */
$define ICQUALITY_LOW	0
$define ICQUALITY_HIGH	10000
$define ICQUALITY_DEFAULT	-1

/************************************
************************************/

$define ICM_USER	(DRV_USER+0x0000)

$define ICM_RESERVED_LOW	(DRV_USER+0x1000)
$define ICM_RESERVED_HIGH(DRV_USER+0x2000)
$define ICM_RESERVED	ICM_RESERVED_LOW

/************************************

	messages.

************************************/

$define ICM_GETSTATE	(ICM_RESERVED+0)	' Get compressor state
$define ICM_SETSTATE	(ICM_RESERVED+1)	' Set compressor state
$define ICM_GETINFO	(ICM_RESERVED+2)	' Query info about the compressor

$define ICM_CONFIGURE	(ICM_RESERVED+10)	' show the configure dialog
$define ICM_ABOUT	(ICM_RESERVED+11)	' show the about box

$define ICM_GETERRORTEXT	(ICM_RESERVED+12)	' get error text TBD Internal
$define ICM_GETFORMATNAME		(ICM_RESERVED+20)	' get a name for a format Internal
$define ICM_ENUMFORMATS			(ICM_RESERVED+21)	' cycle through formats Internal

$define ICM_GETDEFAULTQUALITY	(ICM_RESERVED+30)	' get the default value for quality
$define ICM_GETQUALITY	(ICM_RESERVED+31)	' get the current value for quality
$define ICM_SETQUALITY	(ICM_RESERVED+32)	' set the default value for quality

$define ICM_SET				(ICM_RESERVED+40)	' Tell the driver something
$define ICM_GET				(ICM_RESERVED+41)	' Ask the driver something

' Constants for ICM_SET:
$define ICM_FRAMERATE	0x526d7246'mmioFOURCC('F','r','m','R')
$define ICM_KEYFRAMERATE	0x5279654b'mmioFOURCC('K','e','y','R')

/************************************

	ICM specific messages.

************************************/

$define ICM_COMPRESS_GET_FORMAT	(ICM_USER+4)	' get compress format or size
$define ICM_COMPRESS_GET_SIZE	(ICM_USER+5)	' get output size
$define ICM_COMPRESS_QUERY	(ICM_USER+6)	' query support for compress
$define ICM_COMPRESS_BEGIN	(ICM_USER+7)	' begin a series of compress calls.
$define ICM_COMPRESS	(ICM_USER+8)	' compress a frame
$define ICM_COMPRESS_END	(ICM_USER+9)	' end of a series of compress calls.

$define ICM_DECOMPRESS_GET_FORMAT	(ICM_USER+10)	' get decompress format or size
$define ICM_DECOMPRESS_QUERY	(ICM_USER+11)	' query support for dempress
$define ICM_DECOMPRESS_BEGIN	(ICM_USER+12)	' start a series of decompress calls
$define ICM_DECOMPRESS	(ICM_USER+13)	' decompress a frame
$define ICM_DECOMPRESS_END	(ICM_USER+14)	' end a series of decompress calls
$define ICM_DECOMPRESS_SET_PALETTE	(ICM_USER+29)	' fill the DIB color table
$define ICM_DECOMPRESS_GET_PALETTE	(ICM_USER+30)	' fill the DIB color table

$define ICM_DRAW_QUERY	(ICM_USER+31)	' query support for dempress
$define ICM_DRAW_BEGIN	(ICM_USER+15)	' start a series of draw calls
$define ICM_DRAW_GET_PALETTE	(ICM_USER+16)	' get the palette needed for drawing
$define ICM_DRAW_UPDATE	(ICM_USER+17)	' update screen with current frame Internal
$define ICM_DRAW_START	(ICM_USER+18)	' start decompress clock
$define ICM_DRAW_STOP	(ICM_USER+19)	' stop decompress clock
$define ICM_DRAW_BITS	(ICM_USER+20)	' decompress a frame to screen Internal
$define ICM_DRAW_END	(ICM_USER+21)	' end a series of draw calls
$define ICM_DRAW_GETTIME	(ICM_USER+32)	' get value of decompress clock
$define ICM_DRAW	(ICM_USER+33)	' generalized "render" message
$define ICM_DRAW_WINDOW	(ICM_USER+34)	' drawing window has moved or hidden
$define ICM_DRAW_SETTIME	(ICM_USER+35)	' set correct value for decompress clock
$define ICM_DRAW_REALIZE	(ICM_USER+36)	' realize palette for drawing
$define ICM_DRAW_FLUSH		(ICM_USER+37)	' clear buffered frames
$define ICM_DRAW_RENDERBUFFER	(ICM_USER+38)	' draw undrawn things queue

$define ICM_DRAW_START_PLAY	(ICM_USER+39)	' start of a play
$define ICM_DRAW_STOP_PLAY	(ICM_USER+40)	' end of a play

$define ICM_DRAW_SUGGESTFORMAT	(ICM_USER+50)	' Like ICGetDisplayFormat
$define ICM_DRAW_CHANGEPALETTE	(ICM_USER+51)	' for animating palette

$define ICM_DRAW_IDLE	(ICM_USER+52)	' send each frame time Internal

$define ICM_GETBUFFERSWANTED	(ICM_USER+41)	' ask about prebuffering

$define ICM_GETDEFAULTKEYFRAMERATE	(ICM_USER+42)	' get the default value for key frames

$define ICM_DECOMPRESSEX_BEGIN	(ICM_USER+60)	' start a series of decompress calls
$define ICM_DECOMPRESSEX_QUERY	(ICM_USER+61)	' start a series of decompress calls
$define ICM_DECOMPRESSEX	(ICM_USER+62)	' decompress a frame
$define ICM_DECOMPRESSEX_END	(ICM_USER+63)	' end a series of decompress calls

$define ICM_COMPRESS_FRAMES_INFO	(ICM_USER+70)	' tell about compress to come
$define ICM_COMPRESS_FRAMES	(ICM_USER+71)	' compress a bunch of frames Internal
$define ICM_SET_STATUS_PROC		(ICM_USER+72)	' set status callback

/************************************
************************************/

type ICOPEN
	DWORD	dwSize	' sizeof(ICOPEN)
	DWORD	fccType	' 'vidc
	DWORD	fccHandler	'
	DWORD	dwVersion	' version of compman opening you
	DWORD	dwFlags	' LOWORD is type specific
	LRESULT	dwError	' error return.
	LPVOID	pV1Reserved	' Reserved
	LPVOID	pV2Reserved	' Reserved
	DWORD	dnDevNode	' Devnode for PnP devices
endtype

/************************************
************************************/

type ICINFO
	DWORD	dwSize	' sizeof(ICINFO)
	DWORD	fccType	' compressor type	'vidc' 'audc'
	DWORD	fccHandler	' compressor sub-type 'rle ' 'jpeg' 'pcm '
	DWORD	dwFlags	' flags LOWORD is type specific
	DWORD	dwVersion	' version of the driver
	DWORD	dwVersionICM	' version of the ICM used
	'
	' under Win32, the driver always returns UNICODE strings.
	'
	iwstring szName[16]	' short name
	iwstring szDescription[128]	' long name
	iwstring szDriver[128]	' driver that contains compressor
endtype

/* Flags for the <dwFlags> field of the <ICINFO> structure. */
$define VIDCF_QUALITY	0x0001	' supports quality
$define VIDCF_CRUNCH	0x0002	' supports crunching to a frame size
$define VIDCF_TEMPORAL	0x0004	' supports inter-frame compress
$define VIDCF_COMPRESSFRAMES 0x0008	' wants the compress all frames message
$define VIDCF_DRAW	0x0010	' supports drawing
$define VIDCF_FASTTEMPORALC	0x0020	' does not need prev frame on compress
$define VIDCF_FASTTEMPORALD	0x0080	' does not need prev frame on decompress
'$define VIDCF_QUALITYTIME	0x0040	' supports temporal quality

'$define VIDCF_FASTTEMPORAL	(VIDCF_FASTTEMPORALC|VIDCF_FASTTEMPORALD)

/************************************
************************************/

$define ICCOMPRESS_KEYFRAME	0x00000001

type ICCOMPRESS
	DWORD	dwFlags	' flags

	pointer	lpbiOutput	' output format
	LPVOID	lpOutput	' output data

	pointer	lpbiInput	' format of frame to compress
	LPVOID	lpInput	' frame data to compress

	pointer	lpckid	' ckid for data AVI file
	pointer	lpdwFlags	' flags the AVI index.
	LONG	lFrameNum	' frame number of seq.
	DWORD	dwFrameSize	' reqested size bytes.(if non zero)

	DWORD	dwQuality	' quality

	' these are new fields
	pointer	lpbiPrev	' format of previous frame
	LPVOID	lpPrev	' previous frame

endtype

/************************************
************************************/

$define ICCOMPRESSFRAMES_PADDING	0x00000001

type ICCOMPRESSFRAMES
	DWORD	dwFlags	' flags

	pointer	lpbiOutput	' output format
	LPARAM	lOutput	' output identifier

	pointer	lpbiInput	' format of frame to compress
	LPARAM	lInput	' input identifier

	LONG	lStartFrame	' start frame
	LONG	lFrameCount	' # of frames

	LONG	lQuality	' quality
	LONG	lDataRate	' data rate
	LONG	lKeyRate	' key frame rate

	DWORD		dwRate		' frame rate, as always
	DWORD		dwScale

	DWORD		dwOverheadPerFrame
	DWORD		dwReserved2

	FARPROC _GetData'(pointer GetData)(LPARAM lInput, LONG lFrame, LPVOID lpBits, LONG _len),LONG
	FARPROC PutData'(pointer PutData)(LPARAM lOutput, LONG lFrame, LPVOID lpBits, LONG _len),LONG
endtype

type ICSETSTATUSPROC
	DWORD		dwFlags
	LPARAM		lParam

	' return nonzero means abort operation progress

	FARPROC Status'(pointer Status)(LPARAM lParam, UINT message, LONG l),LONG
endtype
	' messages for Status callback
	$define ICSTATUS_START		0
	$define ICSTATUS_STATUS		1		' l == % done
	$define ICSTATUS_END		2
	$define ICSTATUS_ERROR		3		' l == error string(LPSTR)
	$define ICSTATUS_YIELD		4

/************************************
************************************/

$define ICDECOMPRESS_HURRYUP	0x80000000	' don't draw just buffer(hurry up!)
$define ICDECOMPRESS_UPDATE	0x40000000	' don't draw just update screen
$define ICDECOMPRESS_PREROLL	0x20000000	' this frame is before real start
$define ICDECOMPRESS_NULLFRAME	0x10000000	' repeat last frame
$define ICDECOMPRESS_NOTKEYFRAME	0x08000000	' this frame is not a key frame

type ICDECOMPRESS
	DWORD	dwFlags	' flags(from AVI index...)

	pointer	lpbiInput	' BITMAPINFO of compressed data
		' biSizeImage has the chunk size
	LPVOID	lpInput	' compressed data

	pointer	lpbiOutput ' DIB to decompress to
	LPVOID	lpOutput
	DWORD		ckid		' ckid from AVI file
endtype

type ICDECOMPRESSEX
	'
	' same as ICM_DECOMPRESS
	'
	DWORD	dwFlags

	pointer	lpbiSrc	' BITMAPINFO of compressed data
	LPVOID	lpSrc	' compressed data

	pointer	lpbiDst	' DIB to decompress to
	LPVOID	lpDst	' output data

	'
	' new for ICM_DECOMPRESSEX
	'
	int	xDst	' destination rectangle
	int	yDst
	int	dxDst
	int	dyDst

	int	xSrc	' source rectangle
	int	ySrc
	int	dxSrc
	int	dySrc

endtype

/************************************
************************************/

$define ICDRAW_QUERY	0x00000001	' test for support
$define ICDRAW_FULLSCREEN	0x00000002	' draw to full screen
$define ICDRAW_HDC	0x00000004	' draw to a HDC/HWND
$define ICDRAW_ANIMATE		0x00000008	 ' expect palette animation
$define ICDRAW_CONTINUE		0x00000010	 ' draw is a continuation of previous draw
$define ICDRAW_MEMORYDC		0x00000020	 ' DC is offscreen, by the way
$define ICDRAW_UPDATING		0x00000040	 ' We're updating, as opposed to playing
$define ICDRAW_RENDER	0x00000080	' used to render data not draw it
$define ICDRAW_BUFFER	0x00000100	' please buffer this data offscreen, we will need to update it

type ICDRAWBEGIN
	DWORD	dwFlags	' flags

	HPALETTE	hpal	' palette to draw with
	HWND	hwnd	' window to draw to
	HDC	hdc	' HDC to draw to

	int	xDst	' destination rectangle
	int	yDst
	int	dxDst
	int	dyDst

	pointer	lpbi	' format of frame to draw

	int	xSrc	' source rectangle
	int	ySrc
	int	dxSrc
	int	dySrc

	DWORD	dwRate	' frames/second =(dwRate/dwScale)
	DWORD	dwScale

endtype

/************************************
************************************/

$define ICDRAW_HURRYUP	0x80000000	' don't draw just buffer(hurry up!)
$define ICDRAW_UPDATE	0x40000000	' don't draw just update screen
$define ICDRAW_PREROLL		0x20000000	 ' this frame is before real start
$define ICDRAW_NULLFRAME	0x10000000	 ' repeat last frame
$define ICDRAW_NOTKEYFRAME	0x08000000	' this frame is not a key frame

type ICDRAW
	DWORD	dwFlags	' flags
	LPVOID		lpFormat	' format of frame to decompress
	LPVOID	lpData	' frame data to decompress
	DWORD	cbData
	LONG	lTime	' time drawbegin units(see dwRate and dwScale)
endtype

type ICDRAWSUGGEST'
	pointer 	lpbiIn		' format to be drawn
	pointer 	lpbiSuggest	' location for suggested format(or NULL to get size)
	int			dxSrc		' source extent or 0
	int			dySrc
	int			dxDst		' dest extent or 0
	int			dyDst
	HIC			hicDecompressor' decompressor you can talk to
endtype

/************************************
************************************/

type ICPALETTE
	DWORD	dwFlags	' flags(from AVI index...)
	int	iStart	' first palette to change
	int	iLen	' count of entries to change.
	pointer	lppe	' palette
endtype

/************************************

	ICM function declarations

************************************/

declare import,ICInfo(DWORD fccType,DWORD fccHandler,pointer lpicinfo),BOOL
declare import,ICInstall(DWORD fccType,DWORD fccHandler,LPARAM lParam,LPSTR szDesc,UINT wFlags),BOOL
declare import,ICRemove(DWORD fccType,DWORD fccHandler,UINT wFlags),BOOL
declare import,ICGetInfo(HIC hic,pointer picinfo,DWORD cb),LRESULT
declare import,ICOpen(DWORD fccType,DWORD fccHandler,UINT wMode),HIC
declare import,ICOpenFunction(DWORD fccType,DWORD fccHandler,UINT wMode,FARPROC lpfnHandler),HIC
declare import,ICClose(HIC hic),LRESULT
declare import,ICSendMessage(HIC hic,UINT msg,DWORD_PTR dw1,DWORD_PTR dw2),LRESULT

'this function is unsupported on Win32 as it is non-portable.
declare cdecl import, ICMessage(HIC hic, UINT msg, UINT cb, ...),LRESULT

/* Values for wFlags of ICInstall()*/
$define ICINSTALL_UNICODE	0x8000

$define ICINSTALL_FUNCTION	0x0001	' lParam is a DriverProc(function ptr)
$define ICINSTALL_DRIVER	0x0002	' lParam is a driver name(string)
$define ICINSTALL_HDRV	0x0004	' lParam is a HDRVR(driver handle)

$define ICINSTALL_DRIVERW	0x8002	' lParam is a unicode driver name

/************************************

	query macros

************************************/
$define ICMF_CONFIGURE_QUERY	0x00000001
$define ICMF_ABOUT_QUERY	0x00000001

declare import, ICQueryAbout(HIC hic),UINT'(ICSendMessage(hic, ICM_ABOUT, -1, ICMF_ABOUT_QUERY)== ICERR_OK)
declare import, ICAbout(HIC hic,HWND hwnd),UINT'	ICSendMessage(hic, ICM_ABOUT, hwnd, 0)
declare import, ICQueryConfigure(HIC hic),UINT '	(ICSendMessage(hic, ICM_CONFIGURE, -1, ICMF_CONFIGURE_QUERY)== ICERR_OK)
declare import, ICConfigure(HIC hic,HWND hwnd),UINT'	ICSendMessage(hic, ICM_CONFIGURE, hwnd, 0)

/************************************

	get/set state macros

************************************/

declare import, ICGetState(HIC hic,pointer pv,int cb),UINT 'ICSendMessage(hic, ICM_GETSTATE, pv, cb)
declare import, ICSetState(HIC hic,pointer pv,int cb),UINT 'ICSendMessage(hic, ICM_SETSTATE, pv, cb)
declare import, ICGetStateSize(HIC hic),UINT 'ICGetState(hic, NULL, 0)

/************************************

	get value macros

************************************/

'static DWORD dwICValue

declare import, ICGetDefaultQuality(HIC hic),UINT '	(ICSendMessage(hic, ICM_GETDEFAULTQUALITY, &dwICValue, sizeof(DWORD)), dwICValue)
declare import, ICGetDefaultKeyFrameRate(HIC hic),UINT '	(ICSendMessage(hic, ICM_GETDEFAULTKEYFRAMERATE, &dwICValue, sizeof(DWORD)), dwICValue)

/************************************

	draw window macro

***********************************
import UINT ICDrawWindow(HIC hic,pointer prc)\
	ICSendMessage(hic, ICM_DRAW_WINDOW,(DWORD_PTR)(LPVOID p)(prc), sizeof(WINRECT))
*/
/************************************

	compression functions

************************************/
/*
*	ICCompress()
*
*	compress a single frame
*
 */

declare cdecl import,ICCompress(HIC hic,DWORD dwFlags,pointer lpbiOutput,LPVOID lpData,pointer lpbiInput,LPVOID lpBits,pointer lpckid,pointer lpdwFlags,LONG lFrameNum,DWORD dwFrameSize,DWORD dwQuality,pointer lpbiPrev,LPVOID lpPrev),DWORD

/*
*	ICCompressBegin()
*
*	start compression from a source format(lpbiInput)to a dest
*	format(lpbiOuput)is supported.
*

$define ICCompressBegin(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_COMPRESS_BEGIN,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))
*/
/*
*	ICCompressQuery()
*
*	determines if compression from a source format(lpbiInput)to a dest
*	format(lpbiOuput)is supported.
*

$define ICCompressQuery(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_COMPRESS_QUERY,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))
 */
/*
*	ICCompressGetFormat()
*
*	get the output format,(format of compressed data)
*	if lpbiOutput is NULL return the size bytes needed for format.
*

$define ICCompressGetFormat(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_COMPRESS_GET_FORMAT,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))

$define ICCompressGetFormatSize(hic, lpbi)\
	(DWORD)ICCompressGetFormat(hic, lpbi, NULL)
 */
/*
*	ICCompressSize()
*
*	return the maximal size of a compressed frame
*

$define ICCompressGetSize(hic, lpbiInput, lpbiOutput)\
	(DWORD)ICSendMessage(hic, ICM_COMPRESS_GET_SIZE,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))

$define ICCompressEnd(hic)\
	ICSendMessage(hic, ICM_COMPRESS_END, 0, 0)
 */
/************************************

	decompression functions

************************************/

/*
*	ICDecompress()
*
*	decompress a single frame
*
 */
$define ICDECOMPRESS_HURRYUP	0x80000000	' don't draw just buffer(hurry up!)

declare cdecl import,ICDecompress(HIC hic,DWORD dwFlags,pointer	lpbiFormat,LPVOID lpData,pointer	lpbi,LPVOID lpBits),DWORD

/*
*	ICDecompressBegin()
*
*	start compression from a source format(lpbiInput)to a dest
*	format(lpbiOutput)is supported.
*

$define ICDecompressBegin(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_DECOMPRESS_BEGIN,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))
 */
/*
*	ICDecompressQuery()
*
*	determines if compression from a source format(lpbiInput)to a dest
*	format(lpbiOutput)is supported.
*

$define ICDecompressQuery(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_DECOMPRESS_QUERY,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))
 */
/*
*	ICDecompressGetFormat()
*
*	get the output format,(format of un-compressed data)
*	if lpbiOutput is NULL return the size bytes needed for format.
*

$define ICDecompressGetFormat(hic, lpbiInput, lpbiOutput)\
	((long l)ICSendMessage(hic, ICM_DECOMPRESS_GET_FORMAT,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput)))

$define ICDecompressGetFormatSize(hic, lpbi)\
	ICDecompressGetFormat(hic, lpbi, NULL)
 */
/*
*	ICDecompressGetPalette()
*
*	get the output palette
*

$define ICDecompressGetPalette(hic, lpbiInput, lpbiOutput)\
	ICSendMessage(hic, ICM_DECOMPRESS_GET_PALETTE,(DWORD_PTR)(LPVOID p)(lpbiInput),(DWORD_PTR)(LPVOID p)(lpbiOutput))

$define ICDecompressSetPalette(hic, lpbiPalette)\
	ICSendMessage(hic, ICM_DECOMPRESS_SET_PALETTE,(DWORD_PTR)(LPVOID p)(lpbiPalette), 0)

$define ICDecompressEnd(hic)\
	ICSendMessage(hic, ICM_DECOMPRESS_END, 0, 0)
 */
/************************************

	decompression(ex)functions

************************************/

' on Win16 these functions are macros that call ICMessage. ICMessage will
' not work on NT. rather than add new entrypoints we have given
' them as static inline functions

/*
*	ICDecompressEx()
*
*	decompress a single frame
*

static __inline LRESULT VFWAPI_INLINE
ICDecompressEx(HIC hic,DWORD dwFlags,pointer	lpbiSrc,LPVOID lpSrc,int xSrc,int ySrc,int dxSrc,int dySrc,pointer	lpbiDst,LPVOID lpDst,int xDst,int yDst,int dxDst,int dyDst)
	ICDECOMPRESSEX ic

	ic.dwFlags = dwFlags
	ic.lpbiSrc = lpbiSrc
	ic.lpSrc = lpSrc
	ic.xSrc = xSrc
	ic.ySrc = ySrc
	ic.dxSrc = dxSrc
	ic.dySrc = dySrc
	ic.lpbiDst = lpbiDst
	ic.lpDst = lpDst
	ic.xDst = xDst
	ic.yDst = yDst
	ic.dxDst = dxDst
	ic.dyDst = dyDst

	' note that ICM swaps round the length and pointer
	' length lparam2, pointer lparam1
	return ICSendMessage(hic, ICM_DECOMPRESSEX,(DWORD_PTR)&ic, sizeof(ic))
endtype
 */

/*
*	ICDecompressExBegin()
*
*	start compression from a source format(lpbiInput)to a dest
*	format(lpbiOutput)is supported.
*

static __inline LRESULT VFWAPI_INLINE
ICDecompressExBegin(HIC hic,DWORD dwFlags,pointer	lpbiSrc,LPVOID lpSrc,int xSrc,int ySrc,int dxSrc,int dySrc,pointer	lpbiDst,LPVOID lpDst,int xDst,int yDst,int dxDst,int dyDst)
	ICDECOMPRESSEX ic

	ic.dwFlags = dwFlags
	ic.lpbiSrc = lpbiSrc
	ic.lpSrc = lpSrc
	ic.xSrc = xSrc
	ic.ySrc = ySrc
	ic.dxSrc = dxSrc
	ic.dySrc = dySrc
	ic.lpbiDst = lpbiDst
	ic.lpDst = lpDst
	ic.xDst = xDst
	ic.yDst = yDst
	ic.dxDst = dxDst
	ic.dyDst = dyDst

	' note that ICM swaps round the length and pointer
	' length lparam2, pointer lparam1
	return ICSendMessage(hic, ICM_DECOMPRESSEX_BEGIN,(DWORD_PTR)&ic, sizeof(ic))
endtype */

/*
*	ICDecompressExQuery()
*

static __inline LRESULT VFWAPI_INLINE
ICDecompressExQuery(HIC hic,DWORD dwFlags,pointer	lpbiSrc,LPVOID lpSrc,int xSrc,int ySrc,int dxSrc,int dySrc,pointer	lpbiDst,LPVOID lpDst,int xDst,int yDst,int dxDst,int dyDst)
	ICDECOMPRESSEX ic

	ic.dwFlags = dwFlags
	ic.lpbiSrc = lpbiSrc
	ic.lpSrc = lpSrc
	ic.xSrc = xSrc
	ic.ySrc = ySrc
	ic.dxSrc = dxSrc
	ic.dySrc = dySrc
	ic.lpbiDst = lpbiDst
	ic.lpDst = lpDst
	ic.xDst = xDst
	ic.yDst = yDst
	ic.dxDst = dxDst
	ic.dyDst = dyDst

	' note that ICM swaps round the length and pointer
	' length lparam2, pointer lparam1
	return ICSendMessage(hic, ICM_DECOMPRESSEX_QUERY,(DWORD_PTR)&ic, sizeof(ic))
endtype

$define ICDecompressExEnd(hic)\
	ICSendMessage(hic, ICM_DECOMPRESSEX_END, 0, 0)
 */
/************************************

	drawing functions

************************************/

/*
*	ICDrawBegin()
*
*	start decompressing data with format(lpbiInput)directly to the screen
*
*	return zero if the decompressor supports drawing.
*
 */

$define ICDRAW_QUERY	0x00000001	' test for support
$define ICDRAW_FULLSCREEN	0x00000002	' draw to full screen
$define ICDRAW_HDC	0x00000004	' draw to a HDC/HWND

declare cdecl import,ICDrawBegin(HIC	hic,DWORD	dwFlags,HPALETTE	hpal,HWND	hwnd,HDC	hdc,int	xDst,int	yDst,int	dxDst,int	dyDst,pointer	lpbi,int	xSrc,int	ySrc,int	dxSrc,int	dySrc,DWORD	dwRate,DWORD	dwScale),DWORD

/*DWORD
*	ICDraw()
*
*	decompress data directly to the screen
*
 */

$define ICDRAW_HURRYUP	0x80000000	' don't draw just buffer(hurry up!)
$define ICDRAW_UPDATE	0x40000000	' don't draw just update screen

declare cdecl import,ICDraw(HIC	hic,DWORD	dwFlags,LPVOID	lpFormat,LPVOID	lpData,DWORD	cbData,LONG	lTime),DWORD

' ICMessage is not supported on Win32, so provide a static inline function
' to do the same job
/*static __inline LRESULT VFWAPI_INLINE
ICDrawSuggestFormat(HIC hic,pointer	lpbiIn,pointer	lpbiOut,int dxSrc,int dySrc,int dxDst,int dyDst,HIC hicDecomp)
	ICDRAWSUGGEST ic

	ic.lpbiIn = lpbiIn
	ic.lpbiSuggest = lpbiOut
	ic.dxSrc = dxSrc
	ic.dySrc = dySrc
	ic.dxDst = dxDst
	ic.dyDst = dyDst
	ic.hicDecompressor = hicDecomp

	' note that ICM swaps round the length and pointer
	' length lparam2, pointer lparam1
	return ICSendMessage(hic, ICM_DRAW_SUGGESTFORMAT,(DWORD_PTR)&ic, sizeof(ic))
endtype*/

/*
*	ICDrawQuery()
*
*	determines if the compressor is willing to render the specified format.
*

$define ICDrawQuery(hic, lpbiInput)\
	ICSendMessage(hic, ICM_DRAW_QUERY,(DWORD_PTR)(LPVOID p)(lpbiInput), 0)

$define ICDrawChangePalette(hic, lpbiInput)\
	ICSendMessage(hic, ICM_DRAW_CHANGEPALETTE,(DWORD_PTR)(LPVOID p)(lpbiInput), 0)

$define ICGetBuffersWanted(hic, lpdwBuffers)\
	ICSendMessage(hic, ICM_GETBUFFERSWANTED,(DWORD_PTR)(LPVOID p)(lpdwBuffers), 0)

$define ICDrawEnd(hic)\
	ICSendMessage(hic, ICM_DRAW_END, 0, 0)

$define ICDrawStart(hic)\
	ICSendMessage(hic, ICM_DRAW_START, 0, 0)

$define ICDrawStartPlay(hic, lFrom, lTo)\
	ICSendMessage(hic, ICM_DRAW_START_PLAY,(DWORD_PTR)(lFrom),(DWORD_PTR)(lTo))

$define ICDrawStop(hic)\
	ICSendMessage(hic, ICM_DRAW_STOP, 0, 0)

$define ICDrawStopPlay(hic)\
	ICSendMessage(hic, ICM_DRAW_STOP_PLAY, 0, 0)

$define ICDrawGetTime(hic, lplTime)\
	ICSendMessage(hic, ICM_DRAW_GETTIME,(DWORD_PTR)(LPVOID p)(lplTime), 0)

$define ICDrawSetTime(hic, lTime)\
	ICSendMessage(hic, ICM_DRAW_SETTIME,(DWORD_PTR)lTime, 0)

$define ICDrawRealize(hic, hdc, fBackground)\
	ICSendMessage(hic, ICM_DRAW_REALIZE,(DWORD_PTR)(UINT_PTR)(HDC dc)(hdc),(DWORD_PTR)(BOOL)(fBackground))

$define ICDrawFlush(hic)\
	ICSendMessage(hic, ICM_DRAW_FLUSH, 0, 0)

$define ICDrawRenderBuffer(hic)\
	ICSendMessage(hic, ICM_DRAW_RENDERBUFFER, 0, 0)
 */
/************************************

	Status callback functions

************************************/

/*
*	ICSetStatusProc()
*
*	Set the status callback function
*

' ICMessage is not supported on NT
static __inline LRESULT VFWAPI_INLINE
ICSetStatusProc(HIC hic,DWORD dwFlags,LRESULT lParam,LONG(pointer fpfnStatus)(LPARAM, UINT, long l))
	ICSETSTATUSPROC ic

	ic.dwFlags = dwFlags
	ic.lParam = lParam
	ic.Status = fpfnStatus

	' note that ICM swaps round the length and pointer
	' length lparam2, pointer lparam1
	return ICSendMessage(hic, ICM_SET_STATUS_PROC,(DWORD_PTR)&ic, sizeof(ic))
endtype
 */

/************************************

helper routines for DrawDib and MCIAVI...

***********************************

$define ICDecompressOpen(fccType, fccHandler, lpbiIn, lpbiOut)\
	ICLocate(fccType, fccHandler, lpbiIn, lpbiOut, ICMODE_DECOMPRESS)

$define ICDrawOpen(fccType, fccHandler, lpbiIn)\
	ICLocate(fccType, fccHandler, lpbiIn, NULL, ICMODE_DRAW)
*/

declare import,ICLocate(DWORD fccType,DWORD fccHandler,pointer lpbiIn,pointer lpbiOut,USHORT wFlags),HIC
declare import,ICGetDisplayFormat(HIC hic,pointer lpbiIn,pointer lpbiOut,int BitDepth,int dx,int dy),HIC

/************************************
Higher level functions
************************************/

declare import,ICImageCompress(HIC	hic,UINT	uiFlags,pointer	lpbiIn,LPVOID	lpBits,pointer	lpbiOut,LONG	lQuality,pointer	plSize),HANDLE

declare import,ICImageDecompress(HIC	hic,UINT	uiFlags,pointer	lpbiIn,LPVOID	lpBits,pointer	lpbiOut),HANDLE

' Structure used by ICSeqCompressFrame and ICCompressorChoose routines
' Make sure this matches the autodoc icm.c!
type COMPVARS
	LONG		cbSize		' set to sizeof(COMPVARS)before
					' calling ICCompressorChoose
	DWORD		dwFlags	' see below...
	HIC			hic		' HIC of chosen compressor
	DWORD	fccType	' basically ICTYPE_VIDEO
	DWORD	fccHandler	' handler of chosen compressor or
					' "" or "DIB "
	pointer 	lpbiIn		' input format
	pointer 	lpbiOut	' output format - will compress to this
	LPVOID		lpBitsOut
	LPVOID		lpBitsPrev
	LONG		lFrame
	LONG		lKey		' key frames how often?
	LONG		lDataRate	' desired data rate KB/Sec
	LONG		lQ		' desired quality
	LONG		lKeyCount
	LPVOID		lpState	' state of compressor
	LONG		cbState	' size of the state
endtype

' FLAGS for dwFlags element of COMPVARS structure:
' set this flag if you initialize COMPVARS before calling ICCompressorChoose
$define ICMF_COMPVARS_VALID	0x00000001	' COMPVARS contains valid data

'	allows user to choose compressor, quality etc...

declare import,ICCompressorChoose(HWND	hwnd,UINT	uiFlags,LPVOID	pvIn,LPVOID	lpData,pointer	pc,LPSTR	lpszTitle),BOOL

' defines for uiFlags
$define ICMF_CHOOSE_KEYFRAME	0x0001	' show KeyFrame Every box
$define ICMF_CHOOSE_DATARATE	0x0002	' show DataRate box
$define ICMF_CHOOSE_PREVIEW	0x0004	' allow expanded preview dialog
$define ICMF_CHOOSE_ALLCOMPRESSORS	0x0008	' don't only show those that
						' can handle the input format
						' or input data

declare import,ICSeqCompressFrameStart(pointer pc,pointer lpbiIn),BOOL
declare import,ICSeqCompressFrameEnd(pointer pc)

declare import,ICSeqCompressFrame(pointer	pc,UINT	uiFlags,LPVOID	lpBits,pointer pfKey,pointer plSize),LPVOID

declare import,ICCompressorFree(pointer pc)

$endif
/* NOCOMPMAN */

/*************************************
*
*	DRAWDIB - Routines for drawing to the display.
*
* ************************************/

$ifndef NODRAWDIB

typedef HDRAWDIB HANDLE /* hdd */

/***********************************

	DrawDib Flags

***********************************/
$define DDF_0001	0x0001	/* Internal */
$define DDF_UPDATE	0x0002	/* re-draw the last DIB */
$define DDF_SAME_HDC	0x0004	/* HDC same as last call(all setup)*/
$define DDF_SAME_DRAW	0x0008	/* draw params are the same */
$define DDF_DONTDRAW	0x0010	/* dont draw frame,pointer, just decompress */
$define DDF_ANIMATE	0x0020	/* allow palette animation */
$define DDF_BUFFER	0x0040	/* always buffer image */
$define DDF_JUSTDRAWIT	0x0080	/* just draw it with GDI */
$define DDF_FULLSCREEN	0x0100	/* use DisplayDib */
$define DDF_BACKGROUNDPAL	0x0200		/* Realize palette background */
$define DDF_NOTKEYFRAME	0x0400	/* this is a partial frame update, hint */
$define DDF_HURRYUP	0x0800	/* hurry up please! */
$define DDF_HALFTONE	0x1000	/* always halftone */
$define DDF_2000	0x2000	/* Internal */

$define DDF_PREROLL	DDF_DONTDRAW	/* Builing up a non-keyframe */
$define DDF_SAME_DIB	DDF_SAME_DRAW
$define DDF_SAME_SIZE	DDF_SAME_DRAW

/***********************************

	DrawDib functions

***********************************/
/*							' Internal
*	DrawDibInit()					' Internal
*							' Internal
*/							' Internal
'declare import, DrawDibInit(),BOOL			' Internal
							' Internal
/*
*	DrawDibOpen()
*
*/
declare import, DrawDibOpen(),HDRAWDIB

/*
*	DrawDibClose()
*
*/
declare import,DrawDibClose(HDRAWDIB hdd),BOOL

/*
* DrawDibGetBuffer()
*
*/
declare import,DrawDibGetBuffer(HDRAWDIB hdd,pointer lpbi,DWORD dwSize,DWORD dwFlags),LPVOID

/*							' Internal
*	DrawDibError()					' Internal
*/							' Internal
'extern UINT VFWAPI DrawDibError(HDRAWDIB hdd)		' Internal
							' Internal
/*
*	DrawDibGetPalette()
*
*	get the palette used for drawing DIBs
*
*/
declare import,DrawDibGetPalette(HDRAWDIB hdd),HPALETTE

/*
*	DrawDibSetPalette()
*
*	get the palette used for drawing DIBs
*
*/
declare import,DrawDibSetPalette(HDRAWDIB hdd,HPALETTE hpal),BOOL

/*
*	DrawDibChangePalette()
*/
declare import,DrawDibChangePalette(HDRAWDIB hdd,int iStart,int iLen,pointer lppe),BOOL

/*
*	DrawDibRealize()
*
*	realize the palette a HDD
*
*/
declare import,DrawDibRealize(HDRAWDIB hdd,HDC hdc,BOOL fBackground),UINT

/*
*	DrawDibStart()
*
*	start of streaming playback
*
*/
declare import,DrawDibStart(HDRAWDIB hdd,DWORD rate),BOOL

/*
*	DrawDibStop()
*
*	start of streaming playback
*
*/
declare import,DrawDibStop(HDRAWDIB hdd),BOOL

/*
*	DrawDibBegin()
*
*	prepare to draw
*
*/
declare import,DrawDibBegin(HDRAWDIB hdd,HDC hdc,int dxDst,int dyDst,pointer lpbi,int dxSrc,int dySrc,UINT wFlags),BOOL

/*
*	DrawDibDraw()
*
*	actualy draw a DIB to the screen.
*
*/
declare import,DrawDibDraw(HDRAWDIB hdd,HDC hdc,int xDst,int yDst,int dxDst,int dyDst,pointer lpbi,LPVOID lpBits,int xSrc,int ySrc,int dxSrc,int dySrc,UINT wFlags),BOOL

/*
*	DrawDibUpdate()
*
*	redraw the last image(may only be valid with DDF_BUFFER)
*/
'$define DrawDibUpdate(hdd, hdc, x, y)\
'	DrawDibDraw(hdd, hdc, x, y, 0, 0, NULL, NULL, 0, 0, 0, 0, DDF_UPDATE)
declare import, DrawDibUpdate alias DrawDibDraw(HDRAWDIB hdd,HDC hdc,int xDst,int yDst,opt int dxDst=0,opt int dyDst=0,pointer lpbi=0,opt LPVOID lpBits=0,opt int xSrc=0,opt int ySrc=0,opt int dxSrc=0,opt int dySrc=0,opt UINT wFlags=DDF_UPDATE),BOOL
/*
*	DrawDibEnd()
*/
declare import,DrawDibEnd(HDRAWDIB hdd),BOOL

/*
*	DrawDibTime()	[for debugging purposes only]
*/
type DRAWDIBTIME
	LONG	timeCount
	LONG	timeDraw
	LONG	timeDecompress
	LONG	timeDither
	LONG	timeStretch
	LONG	timeBlt
	LONG	timeSetDIBits
endtype

declare import,DrawDibTime(HDRAWDIB hdd,pointer lpddtime),BOOL

/* display profiling */
$define PD_CAN_DRAW_DIB	0x0001	/* if you can draw at all */
$define PD_CAN_STRETCHDIB	0x0002	/* basicly RC_STRETCHDIB */
$define PD_STRETCHDIB_1_1_OK	0x0004	/* is it fast? */
$define PD_STRETCHDIB_1_2_OK	0x0008	/* ... */
$define PD_STRETCHDIB_1_N_OK	0x0010	/* ... */

declare import,DrawDibProfileDisplay(pointer lpbi),LRESULT

$ifdef DRAWDIB_INCLUDE_STRETCHDIB
declare import, StretchDIB(pointer biDst,LPVOID lpDst, int DstX, int DstY, int DstXE, int DstYE,pointer biSrc,LPVOID lpSrc, int SrcX, int SrcY, int SrcXE, int SrcYE)
$endif

$endif
/* NODRAWDIB */

/**************************************
*
*	AVIFMT - AVI file format definitions
*
* *************************************/

$ifndef NOAVIFMT
	$ifndef _I_MMSYSTEM_INC__
		typedef FOURCC DWORD
	$endif

/* The following is a short description of the AVI file format.	Please
*	see the accompanying documentation for a full explanation.
*
*	An AVI file is the following RIFF form:
*
* 	RIFF('AVI'
* 		LIST('hdrl'
* 			avih(<MainAVIHeader>)
*	LIST('strl'
*	strh(<Stream header>)
*	strf(<Stream format>)
*	... additional header data
*	LIST('movi'
*		 { LIST('rec'
*				SubChunk...
*				)
*			| SubChunk endtype ....
*	)
*	[ <AVIIndex> ]
*	)
*
* 	The main file header specifies how many streams are present.	For
* 	each one, there must be a stream header chunk and a stream format
* 	chunk, enlosed a 'strl' LIST chunk.	The 'strf' chunk contains
* 	type-specific format information for a video stream, this should
* 	be a BITMAPINFO structure, including palette.	For an audio stream, _
* 	this should be a WAVEFORMAT(or PCMWAVEFORMAT)structure.
*
* 	The actual data is contained subchunks within the 'movi' LIST
* 	chunk.	The first two characters of each data chunk are the
* 	stream number with which that data is associated.
*
* 	Some defined chunk types:
*	Video Streams:
*	##db:	RGB DIB bits
*	##dc:	RLE8 compressed DIB bits
*	##pc:	Palette Change
*
*	Audio Streams:
*	##wb:	waveform audio bytes
*
*	The grouping into LIST 'rec' chunks implies only that the contents of
*	the chunk should be read into memory at the same time.	This
*	grouping is used for files specifically intended to be played from
*	CD-ROM.
*
*	The index chunk at the end of the file should contain one entry for
*	each data chunk the file.
*
*	Limitations for the current software:
* 	Only one video stream and one audio stream are allowed.
* 	The streams must start at the beginning of the file.
*
*
*	To register codec types please obtain a copy of the Multimedia
*	Developer Registration Kit from:
*
*	Microsoft Corporation
*	Multimedia Systems Group
*	Product Marketing
*	One Microsoft Way
*	Redmond, WA 98052-6399
*
 */

$ifndef mmioFOURCC_DEFINED
$define mmioFOURCC_DEFINED
/*$define mmioFOURCC(ch0, ch1, ch2, ch3)				\
		((DWORD)(BYTE)(ch0)|((DWORD)(BYTE)(ch1)<< 8)|	\
		((DWORD)(BYTE)(ch2)<< 16)|((DWORD)(BYTE)(ch3)<< 24))*/
	declare extern mmioFOURCC(int ch0,int ch1,int ch2,int ch3),UINT
$endif

/* Macro to make a TWOCC out of two characters */
$ifndef aviTWOCC_DEFINED
$define aviTWOCC_DEFINED
'$define aviTWOCC(ch0, ch1)((USHORT)(BYTE)(ch0)|((USHORT)(BYTE)(ch1)<< 8))
declare import, aviTWOCC(int ch0,int ch1),UINT
$endif

typedef TWOCC USHORT

' form types, list types
$define formtypeAVI	0x20495641'mmioFOURCC('A', 'V', 'I', ' ')
$define listtypeAVIHEADER	0x6c726468'mmioFOURCC('h', 'd', 'r', 'l')
$define ckidAVIMAINHDR	0x68697661'mmioFOURCC('a', 'v', 'i', 'h')
$define listtypeSTREAMHEADER	0x6c727473'mmioFOURCC('s', 't', 'r', 'l')
$define ckidSTREAMHEADER	0x68727473'mmioFOURCC('s', 't', 'r', 'h')
$define ckidSTREAMFORMAT	0x66727473'mmioFOURCC('s', 't', 'r', 'f')
$define ckidSTREAMHANDLERDATA	0x64727473'mmioFOURCC('s', 't', 'r', 'd')
$define ckidSTREAMNAME			0x6e727473'mmioFOURCC('s', 't', 'r', 'n')

$define listtypeAVIMOVIE	0x69766f6d'mmioFOURCC('m', 'o', 'v', 'i')
$define listtypeAVIRECORD	0x20636572'mmioFOURCC('r', 'e', 'c', ' ')

$define ckidAVINEWINDEX	0x31786469'mmioFOURCC('i', 'd', 'x', '1')

/*
* Stream types for the <fccType> field of the stream header.
*/
$define streamtypeVIDEO	0x73646976'mmioFOURCC('v', 'i', 'd', 's')
$define streamtypeAUDIO	0x73647561'mmioFOURCC('a', 'u', 'd', 's')
$define streamtypeMIDI		0x7364696d'mmioFOURCC('m', 'i', 'd', 's')
$define streamtypeTEXT	0x73747874'mmioFOURCC('t', 'x', 't', 's')

/* Basic chunk types */
$define cktypeDIBbits	0x6264'aviTWOCC('d', 'b')
$define cktypeDIBcompressed	0x6364'aviTWOCC('d', 'c')
$define cktypePALchange	0x6370'aviTWOCC('p', 'c')
$define cktypeWAVEbytes	0x6277'aviTWOCC('w', 'b')

/* Chunk id to use for extra chunks for padding. */
$define ckidAVIPADDING	0x4b4e554a'mmioFOURCC('J', 'U', 'N', 'K')

/*
* Useful macros
*
* Warning: These are nasty macro, and MS C 6.0 compiles some of them
* incorrectly if optimizations are on.	Ack.
*/

/* Macro to get stream number out of a FOURCC ckid
$define FromHex(n)	(((n)>= 'A')?((n)+ 10 - 'A'):((n)- '0'))
$define StreamFromFOURCC(fcc)((USHORT)((FromHex(LOBYTE(LOWORD(fcc)))<< 4)+ \
		(FromHex(HIBYTE(LOWORD(fcc))))))
*/
/* Macro to get TWOCC chunk type out of a FOURCC ckid
$define TWOCCFromFOURCC(fcc)	HIWORD(fcc)
*/
/* Macro to make a ckid for a chunk out of a TWOCC and a stream number
* from 0-255.

$define ToHex(n)	((BYTE)(((n)> 9)?((n)- 10 + 'A'):((n)+ '0')))
$define MAKEAVICKID(tcc, stream)\
		MAKELONG((ToHex((stream)& 0x0f)<< 8)| \
				(ToHex(((stream)& 0xf0)>> 4)), tcc)
*/

/*
* Main AVI File Header
*/

/* flags for use <dwFlags> AVIFileHdr */
$define AVIF_HASINDEX		0x00000010	' Index at end of file?
$define AVIF_MUSTUSEINDEX	0x00000020
$define AVIF_ISINTERLEAVED	0x00000100
$define AVIF_WASCAPTUREFILE	0x00010000
$define AVIF_COPYRIGHTED	0x00020000

/* The AVI File Header LIST chunk should be padded to this size */
$define AVI_HEADERSIZE	2048	' size of AVI header list

type MainAVIHeader
	DWORD		dwMicroSecPerFrame	' frame display rate(or 0)
	DWORD		dwMaxBytesPerSec	' max. transfer rate
	DWORD		dwPaddingGranularity	' pad to multiples of this
		' size normally 2K.
	DWORD		dwFlags		' the ever-present flags
	DWORD		dwTotalFrames		' # frames file
	DWORD		dwInitialFrames
	DWORD		dwStreams
	DWORD		dwSuggestedBufferSize

	DWORD		dwWidth
	DWORD		dwHeight

	DWORD		dwReserved[4]
endtype

/*
* Stream header
*/

$define AVISF_DISABLED			0x00000001

$define AVISF_VIDEO_PALCHANGES		0x00010000

type AVIStreamHeader
	FOURCC		fccType
	FOURCC		fccHandler
	DWORD		dwFlags	/* Contains AVITF_* flags */
	USHORT		wPriority
	USHORT		wLanguage
	DWORD		dwInitialFrames
	DWORD		dwScale
	DWORD		dwRate	/* dwRate / dwScale == samples/second */
	DWORD		dwStart
	DWORD		dwLength /* units above... */
	DWORD		dwSuggestedBufferSize
	DWORD		dwQuality
	DWORD		dwSampleSize
	WINRECT		rcFrame
endtype

/* Flags for index */
$define AVIIF_LIST	0x00000001 ' chunk is a 'LIST'
$define AVIIF_KEYFRAME	0x00000010 ' this frame is a key frame.
$define AVIIF_FIRSTPART	0x00000020 ' this frame is the start of a partial frame.
$define AVIIF_LASTPART	0x00000040 ' this frame is the end of a partial frame.
$define AVIIF_MIDPART	(AVIIF_LASTPART|AVIIF_FIRSTPART)

$define AVIIF_NOTIME		0x00000100 ' this frame doesn't take any time
$define AVIIF_COMPUSE	0x0FFF0000 ' these bits are for compressor use

type AVIINDEXENTRY
	DWORD		ckid
	DWORD		dwFlags
	DWORD		dwChunkOffset		' Position of chunk
	DWORD		dwChunkLength		' Length of chunk
endtype

/*
* Palette change chunk
*
* Used video streams.
*/
type AVIPALCHANGE
	BYTE		bFirstEntry	/* first entry to change */
	BYTE		bNumEntries	/* # entries to change(0 if 256)*/
	USHORT		wFlags		/* Mostly to preserve alignment... */
	PALETTEENTRY	peNew[1]	/* New color specifications */
endtype

$endif
/** NOAVIFMT */

/**************************************
*
*	MMREG.H(standard include file for MM defines, like FOURCC and things)
*
* *************************************/

$ifndef RC_INVOKED
'$include "pshpack8.inc"
$endif
$ifndef NOMMREG
	$include "mmreg.inc"
$endif

/**************************************
*
*	AVIFile - routines for reading/writing standard AVI files
*
* *************************************/

$ifndef NOAVIFILE

/*
*	Ansi - Unicode thunking.
*
*	Unicode or Ansi-only apps can call the avifile APIs.
*	any Win32 app who wants to use
*	any of the AVI COM interfaces must be UNICODE - the AVISTREAMINFO and
*	AVIFILEINFO structures used the Info methods of these interfaces are
*	the unicode variants, and no thunking to or from ansi takes place
*	except the AVIFILE api entrypoints.
*
*	For Ansi/Unicode thunking: for each entrypoint or structure that
*	uses chars or strings, two versions are declared the Win32 version, _
*	ApiNameW and ApiNameA. The default name ApiName is $defined to one or
*	other of these depending on whether UNICODE is defined(during
*	compilation of the app that is including this header). The source will
*	contain ApiName and ApiNameA(with ApiName being the Win16 implementation, _
*	and also $defined to ApiNameW, and ApiNameA being the thunk entrypoint).
*
 */

$ifndef mmioFOURCC_DEFINED
$define mmioFOURCC_DEFINED
declare extern mmioFOURCC(int ch0,int ch1,int ch2,int ch3),UINT
/*	$define mmioFOURCC(ch0, ch1, ch2, ch3)\
	((DWORD)(BYTE)(ch0)|((DWORD)(BYTE)(ch1)<< 8)|	\
	((DWORD)(BYTE)(ch2)<< 16)|((DWORD)(BYTE)(ch3)<< 24))*/
$endif

$ifndef streamtypeVIDEO
$define streamtypeVIDEO		0x73646976'mmioFOURCC('v', 'i', 'd', 's')
$define streamtypeAUDIO		0x73647561'mmioFOURCC('a', 'u', 'd', 's')
$define streamtypeMIDI		0x7364696d'mmioFOURCC('m', 'i', 'd', 's')
$define streamtypeTEXT		0x73747874'mmioFOURCC('t', 'x', 't', 's')
$endif

$ifndef AVIIF_KEYFRAME
$define AVIIF_KEYFRAME	0x00000010 ' this frame is a key frame.
$endif

' For GetFrame::SetFormat - use the best format for the display
$define AVIGETFRAMEF_BESTDISPLAYFMT	1

' Structures used by AVIStreamInfo & AVIFileInfo.
' These are related to, but not identical to, the header chunks
' an AVI file.

/*
*
*	--- AVISTREAMINFO ------------------------------------------------
*
*	for Unicode/Ansi thunking we need to declare three versions of this!
 */

type AVISTREAMINFOA
	DWORD		fccType
	DWORD	fccHandler
	DWORD	dwFlags	/* Contains AVITF_* flags */
	DWORD		dwCaps
	USHORT		wPriority
	USHORT		wLanguage
	DWORD	dwScale
	DWORD	dwRate /* dwRate / dwScale == samples/second */
	DWORD	dwStart
	DWORD	dwLength /* units above... */
	DWORD		dwInitialFrames
	DWORD	dwSuggestedBufferSize
	DWORD	dwQuality
	DWORD	dwSampleSize
	WINRECT	rcFrame
	DWORD		dwEditCount
	DWORD		dwFormatChangeCount
	istring		szName[64]
endtype
type AVISTREAMINFOW
	DWORD		fccType
	DWORD	fccHandler
	DWORD	dwFlags	/* Contains AVITF_* flags */
	DWORD		dwCaps
	USHORT		wPriority
	USHORT		wLanguage
	DWORD	dwScale
	DWORD	dwRate /* dwRate / dwScale == samples/second */
	DWORD	dwStart
	DWORD	dwLength /* units above... */
	DWORD		dwInitialFrames
	DWORD	dwSuggestedBufferSize
	DWORD	dwQuality
	DWORD	dwSampleSize
	WINRECT	rcFrame
	DWORD		dwEditCount
	DWORD		dwFormatChangeCount
	iwstring		szName[64]
endtype
$ifdef UNICODE
type AVISTREAMINFO
	DWORD		fccType
	DWORD	fccHandler
	DWORD	dwFlags	/* Contains AVITF_* flags */
	DWORD		dwCaps
	USHORT		wPriority
	USHORT		wLanguage
	DWORD	dwScale
	DWORD	dwRate /* dwRate / dwScale == samples/second */
	DWORD	dwStart
	DWORD	dwLength /* units above... */
	DWORD		dwInitialFrames
	DWORD	dwSuggestedBufferSize
	DWORD	dwQuality
	DWORD	dwSampleSize
	WINRECT	rcFrame
	DWORD		dwEditCount
	DWORD		dwFormatChangeCount
	iwstring		szName[64]
endtype
$else
type AVISTREAMINFO
	DWORD		fccType
	DWORD	fccHandler
	DWORD	dwFlags	/* Contains AVITF_* flags */
	DWORD		dwCaps
	USHORT		wPriority
	USHORT		wLanguage
	DWORD	dwScale
	DWORD	dwRate /* dwRate / dwScale == samples/second */
	DWORD	dwStart
	DWORD	dwLength /* units above... */
	DWORD		dwInitialFrames
	DWORD	dwSuggestedBufferSize
	DWORD	dwQuality
	DWORD	dwSampleSize
	WINRECT	rcFrame
	DWORD		dwEditCount
	DWORD		dwFormatChangeCount
	istring		szName[64]
endtype
$endif

$define AVISTREAMINFO_DISABLED			0x00000001
$define AVISTREAMINFO_FORMATCHANGES		0x00010000

/*
*	--- AVIFILEINFO ----------------------------------------------------
*
 */

type AVIFILEINFOA
	DWORD		dwMaxBytesPerSec	' max. transfer rate
	DWORD		dwFlags		' the ever-present flags
	DWORD		dwCaps
	DWORD		dwStreams
	DWORD		dwSuggestedBufferSize

	DWORD		dwWidth
	DWORD		dwHeight

	DWORD		dwScale
	DWORD		dwRate	/* dwRate / dwScale == samples/second */
	DWORD		dwLength

	DWORD		dwEditCount

	istring		szFileType[64]		' descriptive string for file type?
endtype
type AVIFILEINFOW
	DWORD		dwMaxBytesPerSec	' max. transfer rate
	DWORD		dwFlags		' the ever-present flags
	DWORD		dwCaps
	DWORD		dwStreams
	DWORD		dwSuggestedBufferSize

	DWORD		dwWidth
	DWORD		dwHeight

	DWORD		dwScale
	DWORD		dwRate	/* dwRate / dwScale == samples/second */
	DWORD		dwLength

	DWORD		dwEditCount

	iwstring		szFileType[64]		' descriptive string for file type?
endtype
$ifdef UNICODE
type AVIFILEINFO
	DWORD		dwMaxBytesPerSec	' max. transfer rate
	DWORD		dwFlags		' the ever-present flags
	DWORD		dwCaps
	DWORD		dwStreams
	DWORD		dwSuggestedBufferSize

	DWORD		dwWidth
	DWORD		dwHeight

	DWORD		dwScale
	DWORD		dwRate	/* dwRate / dwScale == samples/second */
	DWORD		dwLength

	DWORD		dwEditCount

	iwstring		szFileType[64]		' descriptive string for file type?
endtype
$else
type AVIFILEINFO
	DWORD		dwMaxBytesPerSec	' max. transfer rate
	DWORD		dwFlags		' the ever-present flags
	DWORD		dwCaps
	DWORD		dwStreams
	DWORD		dwSuggestedBufferSize

	DWORD		dwWidth
	DWORD		dwHeight

	DWORD		dwScale
	DWORD		dwRate	/* dwRate / dwScale == samples/second */
	DWORD		dwLength

	DWORD		dwEditCount

	istring		szFileType[64]		' descriptive string for file type?
endtype
$endif

' Flags for dwFlags
$define AVIFILEINFO_HASINDEX		0x00000010
$define AVIFILEINFO_MUSTUSEINDEX	0x00000020
$define AVIFILEINFO_ISINTERLEAVED	0x00000100
$define AVIFILEINFO_WASCAPTUREFILE	0x00010000
$define AVIFILEINFO_COPYRIGHTED		0x00020000

' Flags for dwCaps
$define AVIFILECAPS_CANREAD		0x00000001
$define AVIFILECAPS_CANWRITE		0x00000002
$define AVIFILECAPS_ALLKEYFRAMES	0x00000010
$define AVIFILECAPS_NOCOMPRESSION	0x00000020

typedef AVISAVECALLBACK pointer'BOOL(pointer AVISAVECALLBACK)(int i)

/************************************/
/* Declaration for the AVICOMPRESSOPTIONS structure.	Make sure it 	*/
/* matches the AutoDoc avisave.c !!!		*/
/************************************/

type AVICOMPRESSOPTIONS
	DWORD	fccType			/* stream type */
	DWORD	fccHandler	/* compressor */
	DWORD	dwKeyFrameEvery	/* keyframe rate */
	DWORD	dwQuality	/* compress quality 0-10,000 */
	DWORD	dwBytesPerSecond	/* bytes per second */
	DWORD	dwFlags	/* flags... see below */
	LPVOID	lpFormat	/* save format */
	DWORD	cbFormat
	LPVOID	lpParms	/* compressor options */
	DWORD	cbParms
	DWORD	dwInterleaveEvery	/* for non-video streams only */
endtype

' Defines for the dwFlags field of the AVICOMPRESSOPTIONS struct
' Each of these flags determines if the appropriate field the structure
'(dwInterleaveEvery, dwBytesPerSecond, and dwKeyFrameEvery)is payed
' attention to.	See the autodoc avisave.c for details.
$define AVICOMPRESSF_INTERLEAVE		0x00000001	' interleave
$define AVICOMPRESSF_DATARATE		0x00000002	' use a data rate
$define AVICOMPRESSF_KEYFRAMES		0x00000004	' use keyframes
$define AVICOMPRESSF_VALID		0x00000008	' has valid data?

$ifndef __ole2_inc__
$include "ole2.inc"
$endif

/*	-	-	-	-	-	-	-	-	*/

/*** AVI Stream Interface* *********************/

'IAVIStream

interface IAVIStream ' IUnknown
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod Create(LPARAM lParam1, LPARAM lParam2),HRESULT
	stdmethod Info(pointer psi, LONG lSize),HRESULT
	stdmethod FindSample(LONG lPos, LONG lFlags),long
	stdmethod ReadFormat(LONG lPos, LPVOID lpFormat,pointer lpcbFormat),HRESULT
	stdmethod SetFormat(LONG lPos,LPVOID lpFormat, LONG cbFormat),HRESULT
	stdmethod _Read(LONG lStart, LONG lSamples,LPVOID lpBuffer, LONG cbBuffer,pointer plBytes,pointer plSamples),HRESULT
	stdmethod _Write(LONG lStart, LONG lSamples,LPVOID lpBuffer, LONG cbBuffer,DWORD dwFlags,pointer plSampWritten,pointer plBytesWritten),HRESULT
	stdmethod _Delete(LONG lStart, LONG lSamples),HRESULT
	stdmethod ReadData(DWORD fcc, LPVOID lp,pointer lpcb),HRESULT
	stdmethod WriteData(DWORD fcc, LPVOID lp, LONG cb),HRESULT
'# ifdef _WIN32
	stdmethod SetInfo(pointer lpInfo,LONG cbInfo),HRESULT
'# else
'	stdmethod Reserved1)	(),HRESULT
'	stdmethod Reserved2)	(),HRESULT
'	stdmethod Reserved3)	(),HRESULT
'	stdmethod Reserved4)	(),HRESULT
'	stdmethod Reserved5)	(),HRESULT
'# endif
endinterface

'IAVIStreaming

interface IAVIStreaming ' IUnknown
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod Begin(LONG	lStart,	_
			LONG	lEnd,LONG	lRate),HRESULT
	stdmethod _End(),HRESULT
endinterface

'IAVIEditStream

interface IAVIEditStream ' IUnknown
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod Cut(pointer plStart,pointer plLength,pointer ppResult),HRESULT
	stdmethod Copy(pointer plStart,pointer plLength,pointer ppResult),HRESULT
	stdmethod Paste(pointer plPos,pointer plLength,pointer pstream,LONG lStart,LONG lEnd),HRESULT
	stdmethod Clone(pointer ppResult),HRESULT
	stdmethod SetInfo(pointer lpInfo,LONG cbInfo),HRESULT
endinterface

/*** AVI File Interface* *********************/

'IAVIPersistFile

interface IAVIPersistFile ' IPersistFile
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod GetClassID(pointer pClassID),HRESULT
	stdmethod IsDirty(),HRESULT
	stdmethod Load(pointer pszFileName,DWORD dwMode),HRESULT
	stdmethod Save(pointer pszFileName,BOOL fRemember),HRESULT
	stdmethod SaveCompleted(pointer pszFileName),HRESULT
	stdmethod GetCurFile(pointer ppszFileName),HRESULT
'IAVIPersistFile
	stdmethod Reserved1(),HRESULT
endinterface

'IAVIFile

interface IAVIFile ' IUnknown
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod Info(pointer pfi,LONG lSize),HRESULT
	stdmethod GetStream(pointer ppStream,DWORD fccType,LONG lParam),HRESULT
	stdmethod CreateStream(pointer ppStream,pointer psi),HRESULT
	stdmethod WriteData(DWORD ckid,LPVOID lpData,LONG cbData),HRESULT
	stdmethod ReadData(DWORD ckid,LPVOID lpData,pointer lpcbData),HRESULT
	stdmethod EndRecord(),HRESULT
	stdmethod DeleteStream(DWORD fccType, LONG lParam),HRESULT
'	stdmethod Open(LPCSTR szFile, UINT mode),HRESULT
endinterface

/*** GetFrame Interface* *********************/

interface IGetFrame ' IUnknown
	stdmethod QueryInterface(pointer riid,pointer ppvObject),HRESULT
	stdmethod AddRef(),ULONG
	stdmethod Release(),ULONG
	stdmethod GetFrame(LONG lPos),LPVOID
'	STDMETHOD_(LPVOID,GetFrameData)(LONG lPos),HRESULT
	stdmethod Begin(LONG lStart, LONG lEnd, LONG lRate),HRESULT
	stdmethod _End(),HRESULT
	stdmethod SetFormat(pointer lpbi, LPVOID lpBits, int x, int y, int dx, int dy),HRESULT

'	STDMETHOD(DrawFrameStart)(),HRESULT
'	STDMETHOD(DrawFrame)(LONG lPos, HDC hdc, int x, int y, int dx, int dy),HRESULT
'	STDMETHOD(DrawFrameEnd)(),HRESULT
endinterface

/*** GUIDs* *********************/

'$define extern _name, l, w1, w2)\
'	DEFINE_GUID(name, l, w1, w2, 0xC0,0,0,0,0,0,0,0x46)

extern _IID_IAVIFile as GUID',	0x00020020, 0, 0)
extern _IID_IAVIStream as GUID',	0x00020021, 0, 0)
extern _IID_IAVIStreaming as GUID',	0x00020022, 0, 0)
extern _IID_IGetFrame as GUID',	0x00020023, 0, 0)
extern _IID_IAVIEditStream as GUID',	0x00020024, 0, 0)
extern _IID_IAVIPersistFile as GUID',	0x00020025, 0, 0)
$ifndef UNICODE
extern _CLSID_AVISimpleUnMarshal as GUID',	0x00020009, 0, 0)
$endif

extern _CLSID_AVIFile as GUID',	0x00020000, 0, 0)

$define	AVIFILEHANDLER_CANREAD		0x0001
$define	AVIFILEHANDLER_CANWRITE		0x0002
$define	AVIFILEHANDLER_CANACCEPTNONRGB	0x0004

' functions

declare import, AVIFileInit(),HRESULT	' Call this first!
declare import, AVIFileExit(),HRESULT
declare import, AVIFileAddRef(pointer pfile),ULONG
declare import, AVIFileRelease(pointer pfile),ULONG
declare import, AVIFileOpenA(pointer ppfile, LPCSTR szFile, UINT uMode,pointer lpHandler),HRESULT
declare import, AVIFileOpenW(pointer ppfile, LPCWSTR szFile, UINT uMode,pointer lpHandler),HRESULT
declare import, AVIFileInfoA(pointer pfile,pointer pfi, LONG lSize),HRESULT
declare import, AVIFileInfoW(pointer pfile,pointer pfi, LONG lSize),HRESULT
declare import, AVIFileCreateStreamA(pointer pfile,pointer ppavi,pointer psi),HRESULT
declare import, AVIFileCreateStreamW(pointer pfile,pointer ppavi,pointer psi),HRESULT
declare import, AVIFileGetStream(pointer pfile,pointer ppavi, DWORD fccType, LONG lParam),HRESULT
declare import, AVIStreamAddRef(pointer pavi),ULONG
declare import, AVIStreamRelease(pointer pavi),ULONG
declare import, AVIFileWriteData(pointer pfile,DWORD ckid,LPVOID lpData,LONG cbData),HRESULT
declare import, AVIFileReadData(pointer pfile,DWORD ckid,LPVOID lpData,pointer lpcbData),HRESULT
declare import, AVIFileEndRecord(pointer pfile),HRESULT
declare import, AVIStreamInfoA(pointer pavi,pointer psi, LONG lSize),HRESULT
declare import, AVIStreamInfoW(pointer pavi,pointer psi, LONG lSize),HRESULT
declare import, AVIStreamFindSample(pointer pavi, LONG lPos, LONG lFlags),long
declare import, AVIStreamReadFormat(pointer pavi, LONG lPos,LPVOID lpFormat,pointer lpcbFormat),HRESULT
declare import, AVIStreamSetFormat(pointer pavi, LONG lPos,LPVOID lpFormat,LONG cbFormat),HRESULT
declare import, AVIStreamReadData(pointer pavi, DWORD fcc, LPVOID lp,pointer lpcb),HRESULT
declare import, AVIStreamWriteData(pointer pavi, DWORD fcc, LPVOID lp, LONG cb),HRESULT
declare import, AVIStreamRead(pointer pavi,LONG lStart,LONG lSamples,LPVOID lpBuffer,LONG cbBuffer,pointer plBytes,pointer plSamples),HRESULT
declare import, AVIStreamWrite(pointer pavi,LONG lStart, LONG lSamples,LPVOID lpBuffer, LONG cbBuffer, DWORD dwFlags,pointer plSampWritten,pointer plBytesWritten),HRESULT
$ifdef UNICODE
declare import, AVIFileOpen alias AVIFileOpenW(pointer ppfile, LPCWSTR szFile, UINT uMode,pointer lpHandler),HRESULT
declare import, AVIFileInfo alias AVIFileInfoW(pointer pfile,pointer pfi, LONG lSize),HRESULT
declare import, AVIFileCreateStream alias AVIFileCreateStreamW(pointer pfile,pointer ppavi,pointer psi),HRESULT
declare import, AVIStreamInfo alias AVIStreamInfoW(pointer pavi,pointer psi, LONG lSize),HRESULT
$else
declare import, AVIFileOpen alias AVIFileOpenA(pointer ppfile, LPCSTR szFile, UINT uMode,pointer lpHandler),HRESULT
declare import, AVIFileInfo alias AVIFileInfoA(pointer pfile,pointer pfi, LONG lSize),HRESULT
declare import, AVIFileCreateStream alias AVIFileCreateStreamA(pointer pfile,pointer ppavi,pointer psi),HRESULT
declare import, AVIStreamInfo alias AVIStreamInfoA(pointer pavi,pointer psi, LONG lSize),HRESULT
$endif


$define AVISTREAMREAD_CONVENIENT	(-1)


' Right now, these just use AVIStreamInfo()to get information, then
' return some of it.	Can they be more efficient?
declare import, AVIStreamStart(pointer pavi),long
declare import, AVIStreamLength(pointer pavi),long
declare import, AVIStreamTimeToSample(pointer pavi, LONG lTime),long
declare import, AVIStreamSampleToTime(pointer pavi, LONG lSample),long

declare import, AVIStreamBeginStreaming(pointer pavi, LONG lStart, LONG lEnd, LONG lRate),HRESULT
declare import, AVIStreamEndStreaming(pointer pavi),HRESULT

' helper functions for using IGetFrame
declare import, AVIStreamGetFrameOpen(pointer pavi,pointer lpbiWanted),pointer
declare import, AVIStreamGetFrame(pointer pg, LONG lPos),LPVOID
declare import, AVIStreamGetFrameClose(pointer pg),HRESULT

' !!! We need some way to place an advise on a stream....
'	AVIStreamHasChanged	(pointer pavi),STDAPI

' Shortcut function
declare import, AVIStreamOpenFromFileA(pointer ppavi, LPCSTR szFile,DWORD fccType, LONG lParam,UINT mode,pointer pclsidHandler),HRESULT
declare import, AVIStreamOpenFromFileW(pointer ppavi, LPCWSTR szFile,DWORD fccType, LONG lParam,UINT mode,pointer pclsidHandler),HRESULT
$ifdef UNICODE
declare import, AVIStreamOpenFromFile alias AVIStreamOpenFromFileW(pointer ppavi, LPCWSTR szFile,DWORD fccType, LONG lParam,UINT mode,pointer pclsidHandler),HRESULT
$else
declare import, AVIStreamOpenFromFile alias AVIStreamOpenFromFileA(pointer ppavi, LPCSTR szFile,DWORD fccType, LONG lParam,UINT mode,pointer pclsidHandler),HRESULT
$endif

' Use to create disembodied streams
declare import, AVIStreamCreate(pointer ppavi, LONG lParam1, LONG lParam2,pointer pclsidHandler),HRESULT

'	AVIAPI AVIGetHandler	(pointer pavi, PAVISTREAMHANDLER psh),PHANDLER
'	AVIAPI AVIGetStream	(PHANDLER p),pointer

' flags for AVIStreamFindSample
$define FIND_DIR	0x0000000F	' direction
$define FIND_NEXT	0x00000001	' go forward
$define FIND_PREV	0x00000004	' go backward
$define FIND_FROM_START 0x00000008	' start at the logical beginning

$define FIND_TYPE	0x000000F0	' type mask
$define FIND_KEY	0x00000010	' find key frame.
$define FIND_ANY	0x00000020	' find any(non-empty)sample
$define FIND_FORMAT	0x00000040	' find format change

$define FIND_RET	0x0000F000	' return mask
$define FIND_POS	0x00000000	' return logical position
$define FIND_LENGTH	0x00001000	' return logical size
$define FIND_OFFSET	0x00002000	' return physical position
$define FIND_SIZE	0x00003000	' return physical size
$define FIND_INDEX	0x00004000	' return physical index position

'	stuff to support backward compat.
declare import, AVIStreamFindKeyFrame alias AVIStreamFindSample(pointer pavi, LONG lPos, LONG lFlags),long

'$define FindKeyFrame	FindSample
'declare import, FindKeyFrame alias FindSample

declare import, AVIStreamClose	alias AVIStreamRelease(pointer pavi),ULONG
declare import, AVIFileClose alias AVIFileRelease(pointer pfile),ULONG
declare import, AVIStreamInit alias AVIFileInit(),HRESULT
declare import, AVIStreamExit alias AVIFileExit(),HRESULT

$define SEARCH_NEAREST	FIND_PREV
$define SEARCH_BACKWARD FIND_PREV
$define SEARCH_FORWARD	FIND_NEXT
$define SEARCH_KEY	FIND_KEY
$define SEARCH_ANY	FIND_ANY

'	helper macros.
/*
$define	AVIStreamSampleToSample(pavi1, pavi2, l)\
		AVIStreamTimeToSample(pavi1,AVIStreamSampleToTime(pavi2, l))

$define	AVIStreamNextSample(pavi, l)\
		AVIStreamFindSample(pavi,l+1,FIND_NEXT|FIND_ANY)

$define	AVIStreamPrevSample(pavi, l)\
		AVIStreamFindSample(pavi,l-1,FIND_PREV|FIND_ANY)

$define	AVIStreamNearestSample(pavi, l)\
		AVIStreamFindSample(pavi,l,FIND_PREV|FIND_ANY)

$define	AVIStreamNextKeyFrame(pavi,l)\
		AVIStreamFindSample(pavi,l+1,FIND_NEXT|FIND_KEY)

$define	AVIStreamPrevKeyFrame(pavi, l)\
		AVIStreamFindSample(pavi,l-1,FIND_PREV|FIND_KEY)

$define	AVIStreamNearestKeyFrame(pavi, l)\
		AVIStreamFindSample(pavi,l,FIND_PREV|FIND_KEY)

$define	AVIStreamIsKeyFrame(pavi, l)\
		(AVIStreamNearestKeyFrame(pavi,l)== l)

$define	AVIStreamPrevSampleTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamPrevSample(pavi,AVIStreamTimeToSample(pavi,t)))

$define	AVIStreamNextSampleTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamNextSample(pavi,AVIStreamTimeToSample(pavi,t)))

$define	AVIStreamNearestSampleTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamNearestSample(pavi,AVIStreamTimeToSample(pavi,t)))

$define	AVIStreamNextKeyFrameTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamNextKeyFrame(pavi,AVIStreamTimeToSample(pavi, t)))

$define	AVIStreamPrevKeyFrameTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamPrevKeyFrame(pavi,AVIStreamTimeToSample(pavi, t)))

$define	AVIStreamNearestKeyFrameTime(pavi, t)\
		AVIStreamSampleToTime(pavi, AVIStreamNearestKeyFrame(pavi,AVIStreamTimeToSample(pavi, t)))

$define	AVIStreamStartTime(pavi)\
		AVIStreamSampleToTime(pavi, AVIStreamStart(pavi))

$define	AVIStreamLengthTime(pavi)\
		AVIStreamSampleToTime(pavi, AVIStreamLength(pavi))

$define	AVIStreamEnd(pavi)\
		(AVIStreamStart(pavi)+ AVIStreamLength(pavi))

$define	AVIStreamEndTime(pavi)\
		AVIStreamSampleToTime(pavi, AVIStreamEnd(pavi))

$define	AVIStreamSampleSize(pavi, lPos, plSize)\
		AVIStreamRead(pavi,lPos,1,NULL,0,plSize,NULL)

$define	AVIStreamFormatSize(pavi, lPos, plSize)\
		AVIStreamReadFormat(pavi,lPos,NULL,plSize)

$define	AVIStreamDataSize(pavi, fcc, plSize)\
		AVIStreamReadData(pavi,fcc,NULL,plSize)
*/
/**************************************
*
*	AVISave routines and structures
*
* *************************************/

$ifndef comptypeDIB
$define comptypeDIB	0x20424944'mmioFOURCC('D', 'I', 'B', ' ')
$endif

declare import, AVIMakeCompressedStream(pointer ppsCompressed,pointer ppsSource,pointer lpOptions,pointer pclsidHandler),HRESULT
declare import, AVISaveA(LPCSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer pfile,pointer lpOptions,...),HRESULT
declare import, AVISaveW(LPCWSTR szFile,pointer pclsidHandler,AVISAVECALLBACK	lpfnCallback,int nStreams,pointer pfile,pointer lpOptions,...),HRESULT
declare import, AVISaveVA(LPCSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer ppavi,pointer plpOptions),HRESULT
declare import, AVISaveVW(LPCWSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer ppavi,pointer plpOptions),HRESULT
declare import, AVISaveOptions(HWND hwnd,UINT uiFlags,int nStreams,pointer ppavi,pointer plpOptions),INT_PTR
declare import, AVISaveOptionsFree(int nStreams,pointer plpOptions),HRESULT
declare import, AVIBuildFilterA(LPSTR lpszFilter, LONG cbFilter, BOOL fSaving),HRESULT
declare import, AVIBuildFilterW(LPWSTR lpszFilter, LONG cbFilter, BOOL fSaving),HRESULT
$ifdef UNICODE
declare import, AVISave alias AVISaveW(LPCWSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer pfile,pointer lpOptions,...),HRESULT
declare import, AVISaveV alias AVISaveVW(LPCWSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer ppavi,pointer plpOptions),HRESULT
declare import, AVIBuildFilter	alias AVIBuildFilterW(LPWSTR lpszFilter, LONG cbFilter, BOOL fSaving),HRESULT
$else
declare import, AVISave alias AVISaveA(LPCSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer pfile,pointer lpOptions,...),HRESULT
declare import, AVISaveV alias AVISaveVA(LPCSTR szFile,pointer pclsidHandler,AVISAVECALLBACK lpfnCallback,int nStreams,pointer ppavi,pointer plpOptions),HRESULT
declare import, AVIBuildFilter	alias AVIBuildFilterA(LPSTR lpszFilter, LONG cbFilter, BOOL fSaving),HRESULT
$endif

' FLAGS FOR uiFlags:
' Same as the flags for ICCompressorChoose(see compman.h)
' These determine what the compression options dialog for video streams
' will look like.

declare import, AVIMakeFileFromStreams(pointer ppfile,int nStreams,pointer papStreams),HRESULT
declare import, AVIMakeStreamFromClipboard(UINT cfFormat, HANDLE hGlobal,pointer ppstream),HRESULT

/**************************************
*
*	Clipboard routines
*
* *************************************/

declare import, AVIPutFileOnClipboard(pointer pf),HRESULT
declare import, AVIGetFromClipboard(pointer lppf),HRESULT
declare import, AVIClearClipboard(),HRESULT

/**************************************
*
*	Editing routines
*
* *************************************/
declare import, CreateEditableStream(pointer ppsEditable,pointer psSource),HRESULT
declare import, EditStreamCut(pointer pavi,pointer plStart,pointer plLength,pointer ppResult),HRESULT
declare import, EditStreamCopy(pointer pavi,pointer plStart,pointer plLength,pointer ppResult),HRESULT
declare import, EditStreamPaste(pointer pavi,pointer plPos,pointer plLength,pointer pstream, LONG lStart, LONG lEnd),HRESULT
declare import, EditStreamClone(pointer pavi,pointer ppResult),HRESULT
declare import, EditStreamSetNameA(pointer pavi, LPCSTR lpszName),HRESULT
declare import, EditStreamSetNameW(pointer pavi, LPCWSTR lpszName),HRESULT
declare import, EditStreamSetInfoA(pointer pavi,pointer lpInfo, LONG cbInfo),HRESULT
declare import, EditStreamSetInfoW(pointer pavi,pointer lpInfo, LONG cbInfo),HRESULT
$ifdef UNICODE
declare import, EditStreamSetName	alias EditStreamSetNameW(pointer pavi, LPCWSTR lpszName),HRESULT
declare import, EditStreamSetInfo	alias EditStreamSetInfoW(pointer pavi,pointer lpInfo, LONG cbInfo),HRESULT
$else
declare import, EditStreamSetName	alias EditStreamSetNameA(pointer pavi, LPCSTR lpszName),HRESULT
declare import, EditStreamSetInfo	alias EditStreamSetInfoA(pointer pavi,pointer lpInfo, LONG cbInfo),HRESULT
$endif

/*	-	-	-	-	-	-	-	-	*/

$ifndef AVIERR_OK
$define AVIERR_OK	0

'$define MAKE_AVIERR(error)	MAKE_SCODE(SEVERITY_ERROR, FACILITY_ITF, 0x4000 + error)

' !!! Questions to be answered:
' How can you get a string form of these errors?
' Which of these errors should be replaced by errors SCODE.H?
$define AVIERR_UNSUPPORTED	(0x80044000|101)
$define AVIERR_BADFORMAT	(0x80044000|102)
$define AVIERR_MEMORY	(0x80044000|103)
$define AVIERR_INTERNAL	(0x80044000|104)
$define AVIERR_BADFLAGS	(0x80044000|105)
$define AVIERR_BADPARAM	(0x80044000|106)
$define AVIERR_BADSIZE	(0x80044000|107)
$define AVIERR_BADHANDLE	(0x80044000|108)
$define AVIERR_FILEREAD	(0x80044000|109)
$define AVIERR_FILEWRITE	(0x80044000|110)
$define AVIERR_FILEOPEN	(0x80044000|111)
$define AVIERR_COMPRESSOR	(0x80044000|112)
$define AVIERR_NOCOMPRESSOR	(0x80044000|113)
$define AVIERR_READONLY		(0x80044000|114)
$define AVIERR_NODATA		(0x80044000|115)
$define AVIERR_BUFFERTOOSMALL	(0x80044000|116)
$define AVIERR_CANTCOMPRESS	(0x80044000|117)
$define AVIERR_USERABORT	(0x80044000|198)
$define AVIERR_ERROR	(0x80044000|199)
$endif
$endif
/* NOAVIFILE */

/**************************************
*
*	MCIWnd - Window class for MCI objects
*
* *************************************/
$ifndef NOMCIWND
/*----------------------------------------------------------------------------*\
*
*	MCIWnd
*
*	MCIWnd window class header file.
*
*	the MCIWnd window class is a window class for controling MCI devices
*	MCI devices include, wave files, midi files, AVI Video, cd audio, _
*	vcr, video disc, and others..
*
*	to learn more about MCI and mci command sets see the
*	"Microsoft Multimedia Programmers's guide" the Win31 SDK
*
*	the easiest use of the MCIWnd class is like so:
*
*	hwnd = MCIWndCreate(hwndParent, hInstance, 0, "chimes.wav")
*	...
*	MCIWndPlay(hwnd)
*	MCIWndStop(hwnd)
*	MCIWndPause(hwnd)
*	....
*	MCIWndDestroy(hwnd)
*
*	this will create a window with a play/pause, stop and a playbar
*	and start the wave file playing.
*
*	mciwnd.h defines macros for all the most common MCI commands, but
*	any string command can be used if needed.
*
*	Note: unlike the mciSendString()API, no alias or file name needs
*	to be specifed, since the device to use is implied by the window handle.
*
*	MCIWndSendString(HWND hwnd, "setaudio stream to 2")
*
*	(C)Copyright Microsoft Corp. 1991-1995.	All rights reserved.
*
*	You have a royalty-free right to use, modify, reproduce and
*	distribute the Sample Files(and/or any modified version)in
*	any way you find useful, provided that you agree that
*	Microsoft has no warranty obligations or liability for any
*	Sample Application Files.
*
*	If you did not get this from Microsoft Sources, then it may not be the
*	most current version.	This sample code particular will be updated
*	and include more documentation.
*
*	Sources are:
*	CompuServe: WINSDK forum, MDK section.
*	Anonymous FTP from ftp.uu.net vendor\microsoft\multimedia
*
*	WIN32:
*
*	MCIWnd supports both ansi and unicode interfaces. For any message that
*	takes or returns a text string, two versions of the message are defined, _
*	appended with A or W for Ansi or Wide Char. The message or api itself
*	is defined to be one or other of these depending on whether you have
*	UNICODE defined your application.
*	Thus for the api MCIWndCreate, there are fact two apis, _
*	MCIWndCreateA and MCIWndCreateW. If you call MCIWndCreate, this will be
*	re-routed to MCIWndCreateA unless UNICODE is defined when building your
*	application. any one application, you can mix calls to the
*	Ansi and Unicode entrypoints.
*
*	If you use SendMessage instead of the macros below such as MCIWndOpen(), _
*	you will see that the messages have changed for WIN32, to support Ansi
*	and Unicode entrypoints. particular, MCI_OPEN has been replaced by
*	MCWNDM_OPENA, or MCIWNDM_OPENW(MCIWNDM_OPEN is defined to be one or
*	other of these).
*
*	Also, note that the WIN32 implementation of MCIWnd uses UNICODE
*	so all apis and messages supporting ANSI strings do so by mapping them
*	UNICODE strings and then calling the corresponding UNICODE entrypoint.
*
* ----------------------------------------------------------------------------*/

'$ifdef __cplusplus
' MFC Redefines SendMessage, so make sure we get the global one....
'$define SendMessageA ::SendMessage	/* SendMessage C++*/
'$else
'declare import, SendMessageA alias SendMessageA(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam),LRESULT	/* SendMessage C */
'$endif
/* __cplusplus */
$define MCIWND_WINDOW_CLASS "MCIWndClass"

declare cdecl import,MCIWndCreateA(HWND hwndParent,HINSTANCE hInstance,DWORD dwStyle,LPCSTR szFile),HWND
declare cdecl import,MCIWndCreateW(HWND hwndParent,HINSTANCE hInstance,DWORD dwStyle,LPCWSTR szFile),HWND

$ifdef UNICODE
declare cdecl import,MCIWndCreate alias MCIWndCreateW(HWND hwndParent,HINSTANCE hInstance,DWORD dwStyle,LPCWSTR szFile),HWND
$else
declare cdecl import,MCIWndCreate alias MCIWndCreateA(HWND hwndParent,HINSTANCE hInstance,DWORD dwStyle,LPCSTR szFile),HWND
$endif

declare cdecl import, MCIWndRegisterClass(),BOOL

' Flags for the MCIWndOpen command
$define MCIWNDOPENF_NEW		0x0001	' open a new file

' window styles
$define MCIWNDF_NOAUTOSIZEWINDOW	0x0001	' when movie size changes
$define MCIWNDF_NOPLAYBAR	0x0002	' no toolbar
$define MCIWNDF_NOAUTOSIZEMOVIE	0x0004	' when window size changes
$define MCIWNDF_NOMENU	0x0008	' no popup menu from RBUTTONDOWN
$define MCIWNDF_SHOWNAME	0x0010	' show name caption
$define MCIWNDF_SHOWPOS	0x0020	' show position caption
$define MCIWNDF_SHOWMODE	0x0040	' show mode caption
$define MCIWNDF_SHOWALL	0x0070	' show all

$define MCIWNDF_NOTIFYMODE	0x0100	' tell parent of mode change
$define MCIWNDF_NOTIFYPOS	0x0200	' tell parent of pos change
$define MCIWNDF_NOTIFYSIZE	0x0400	' tell parent of size change
$define MCIWNDF_NOTIFYERROR	0x1000	' tell parent of an error
$define MCIWNDF_NOTIFYALL	0x1F00	' tell all

$define MCIWNDF_NOTIFYANSI		0x0080

' The MEDIA notification includes a text string.
' To receive notifications ANSI instead of unicode set the
' MCIWNDF_NOTIFYANSI style bit. The macro below includes this bit
' by default unless you define UNICODE your application.

$define MCIWNDF_NOTIFYMEDIAA	0x0880	' tell parent of media change
$define MCIWNDF_NOTIFYMEDIAW	0x0800	' tell parent of media change

$ifdef UNICODE
$define MCIWNDF_NOTIFYMEDIA	MCIWNDF_NOTIFYMEDIAW
$else
$define MCIWNDF_NOTIFYMEDIA	MCIWNDF_NOTIFYMEDIAA
$endif

$define MCIWNDF_RECORD	0x2000	' Give a record button
$define MCIWNDF_NOERRORDLG	0x4000	' Show Error Dlgs for MCI cmds?
$define MCIWNDF_NOOPEN			0x8000	' Don't allow user to open things

' can macros
$ifdef UNICODE
declare import, MCIWndCanPlay	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_PLAY,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanRecord	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_RECORD,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanSave	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_SAVE,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanWindow	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_WINDOW,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanEject	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_EJECT,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanConfig	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_CAN_CONFIG,opt int x=0,opt int x=0),BOOL
declare import, MCIWndPaletteKick	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_PALETTEKICK,opt int x=0,opt int x=0),BOOL
$else
declare import, MCIWndCanPlay	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_PLAY,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanRecord	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_RECORD,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanSave	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_SAVE,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanWindow	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_WINDOW,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanEject	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_EJECT,opt int x=0,opt int x=0),BOOL
declare import, MCIWndCanConfig	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_CAN_CONFIG,opt int x=0,opt int x=0),BOOL
declare import, MCIWndPaletteKick	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_PALETTEKICK,opt int x=0,opt int x=0),BOOL
$endif

'ok $define MCIWndSave(HWND hwnd, szFile)	(long)SendMessageA(HWND hwnd, MCI_SAVE, 0,(LPARAM)(LPVOID p)(szFile)),long
'ok $define MCIWndSaveDialog(hwnd)	MCIWndSave(HWND hwnd, -1)
declare extern MCIWndSaveDialogA alias SendMessage_HLM_A(HWND hwnd,opt int szFile=-1,opt int msg=MCI_SAVE),long
declare extern MCIWndSaveDialogW alias SendMessage_HLM_W(HWND hwnd,opt int szFile=-1,opt int msg=MCI_SAVE),long

' if you dont give a device it will use the current device....
'$define MCIWndNew(HWND hwnd, lp)	SendMessageA(HWND hwnd, MCIWNDM_NEW, 0,(LPARAM)(LPVOID p)(lp)),long
declare extern MCIWndNewA alias SendMessage_HLM_A(HWND hwnd,pointer lp, opt int msg=MCIWNDM_NEW),long
declare extern MCIWndNewW alias SendMessage_HLM_W(HWND hwnd,pointer lp, opt int msg=MCIWNDM_NEW),long
$ifdef UNICODE
declare extern MCIWndSaveDialog alias SendMessage_HLM_W(HWND hwnd,opt int szFile=-1,opt int msg=MCI_SAVE),long
declare extern MCIWndNew alias SendMessage_HLM_W(HWND hwnd,pointer lp, opt int msg=MCIWNDM_NEW),long
declare import, MCIWndRecord	alias SendMessageW(HWND hwnd, int x=MCI_RECORD, opt int x=0,opt int x=0),long
'$define MCIWndOpen(HWND hwnd, sz, f)	SendMessageW(HWND hwnd, MCIWNDM_OPEN,(WPARAM)(UINT)(f),(LPARAM)(LPVOID p)(sz))
declare extern MCIWndOpen alias SendMessage_HLWM_W(HWND hwnd,pointer sz, int f, opt int msg=MCIWNDM_OPEN),long
declare import, MCIWndOpenDialog	alias SendMessageW(HWND hwnd,opt int msg=MCIWNDM_OPEN,opt int x=-1, opt int x=0),long
declare import, MCIWndClose	alias SendMessageW(HWND hwnd,opt int x=MCI_CLOSE, opt int x=0,opt int x=0),long
declare import, MCIWndPlay	alias SendMessageW(HWND hwnd,opt int x=MCI_PLAY, opt int x=0,opt int x=0),long
declare import, MCIWndStop	alias SendMessageW(HWND hwnd,opt int x=MCI_STOP, opt int x=0,opt int x=0),long
declare import, MCIWndPause	alias SendMessageW(HWND hwnd,opt int x=MCI_PAUSE, opt int x=0,opt int x=0),long
declare import, MCIWndResume	alias SendMessageW(HWND hwnd,opt int x=MCI_RESUME, opt int x=0,opt int x=0),long
'extern int MCIWndSeek(HWND hwnd, int lPos)'	SendMessageW(HWND hwnd, MCI_SEEK, 0,(LPARAM)(long l)(lPos)),long
declare import, MCIWndEject	alias SendMessageW(HWND hwnd,opt int x=MCIWNDM_EJECT, opt int x=0,opt int x=0),long
$else
declare extern MCIWndSaveDialog alias SendMessage_HLM_A(HWND hwnd,opt int szFile=-1,opt int msg=MCI_SAVE),long
declare extern MCIWndNew alias SendMessage_HLM_A(HWND hwnd,pointer lp, opt int msg=MCIWNDM_NEW),long
declare import, MCIWndRecord	alias SendMessageA(HWND hwnd, int x=MCI_RECORD, opt int x=0,opt int x=0),long
'$define MCIWndOpen(HWND hwnd, sz, f)	SendMessageA(HWND hwnd, MCIWNDM_OPEN,(WPARAM)(UINT)(f),(LPARAM)(LPVOID p)(sz))
declare extern MCIWndOpen alias SendMessage_HLWM_A(HWND hwnd,pointer sz, int f, opt int msg=MCIWNDM_OPEN),long
declare import, MCIWndOpenDialog	alias SendMessageA(HWND hwnd,opt int msg=MCIWNDM_OPEN,opt int x=-1, opt int x=0),long
declare import, MCIWndClose	alias SendMessageA(HWND hwnd,opt int x=MCI_CLOSE, opt int x=0,opt int x=0),long
declare import, MCIWndPlay	alias SendMessageA(HWND hwnd,opt int x=MCI_PLAY, opt int x=0,opt int x=0),long
declare import, MCIWndStop	alias SendMessageA(HWND hwnd,opt int x=MCI_STOP, opt int x=0,opt int x=0),long
declare import, MCIWndPause	alias SendMessageA(HWND hwnd,opt int x=MCI_PAUSE, opt int x=0,opt int x=0),long
declare import, MCIWndResume	alias SendMessageA(HWND hwnd,opt int x=MCI_RESUME, opt int x=0,opt int x=0),long
declare extern MCIWndSeek(HWND hwnd, int lPos),int'	SendMessageA(HWND hwnd, MCI_SEEK, 0,(LPARAM)(long l)(lPos)),long
declare import, MCIWndEject	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_EJECT, opt int x=0,opt int x=0),long
$endif

declare extern MCIWndHome(HWND hwnd),int'	MCIWndSeek(HWND hwnd, MCIWND_START)
declare extern MCIWndEnd(HWND hwnd),int'	MCIWndSeek(HWND hwnd, MCIWND_END)

'$define MCIWndGetSource(HWND hwnd, prc)	(long)SendMessageA(HWND hwnd, MCIWNDM_GET_SOURCE, 0,(LPARAM)(RECT*)(prc))
'$define MCIWndPutSource(HWND hwnd, prc)	(long)SendMessageA(HWND hwnd, MCIWNDM_PUT_SOURCE, 0,(LPARAM)(RECT*)(prc))

'$define MCIWndGetDest(HWND hwnd, prc)	(long)SendMessageA(HWND hwnd, MCIWNDM_GET_DEST, 0,(LPARAM)(RECT*)(prc))
'$define MCIWndPutDest(HWND hwnd, prc)	(long)SendMessageA(HWND hwnd, MCIWNDM_PUT_DEST, 0,(LPARAM)(RECT*)(prc))

declare import, MCIWndPlayReverse	alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_PLAYREVERSE, opt int x=0, opt int x=0),long
'$define MCIWndPlayFrom(HWND hwnd, lPos)	(long)SendMessageA(HWND hwnd, MCIWNDM_PLAYFROM, 0,(LPARAM)(long l)(lPos))
'$define MCIWndPlayTo(HWND hwnd, lPos)	(long)SendMessageA(HWND hwnd, MCIWNDM_PLAYTO,	0,(LPARAM)(long l)(lPos))
'$define MCIWndPlayFromTo(HWND hwnd, lStart, lEnd)(MCIWndSeek(HWND hwnd, lStart), MCIWndPlayTo(HWND hwnd, lEnd))

declare import, MCIWndGetDeviceID alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETDEVICEID,opt int x=0,opt int x=0),UINT
declare import, MCIWndGetAlias alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETALIAS,opt int x=0,opt int x=0),UINT
declare import, MCIWndGetPosition alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETPOSITION,opt int x=0,opt int x=0),long
declare import, MCIWndGetStart alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETSTART,opt int x=0, opt int x=0),long
declare import, MCIWndGetLength alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETLENGTH,opt int x=0,opt int x=0),long
declare import, MCIWndGetEnd alias SendMessageA(HWND hwnd, opt int x=MCIWNDM_GETEND,opt int x=0,opt int x=0),long
declare extern MCIWndGetMode(HWND hwnd,int lp,int _len),int'(long)SendMessageA(HWND hwnd, MCIWNDM_GETMODE,(WPARAM)(UINT)(len),(LPARAM)(LPTSTR)(lp))
'$define MCIWndGetPositionString(HWND hwnd, lp, len)(long)SendMessageA(HWND hwnd, MCIWNDM_GETPOSITION,(WPARAM)(UINT)(len),(LPARAM)(LPTSTR)(lp))

declare extern MCIWndStep(HWND hwnd, int n),int'	(long)SendMessageA(HWND hwnd, MCI_STEP, 0,(LPARAM)(long l)(n))

declare import, MCIWndDestroy	alias SendMessageA(HWND hwnd,opt int x=WM_CLOSE, opt int x=0,opt int x=0)
declare import, MCIWndGetZoom	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETZOOM,opt int x=0,opt int x=0),UINT
declare import, MCIWndGetVolume	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETVOLUME,opt int x=0,opt int x=0),long
declare import, MCIWndGetSpeed	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETSPEED,opt int x=0,opt int x=0),long
declare import, MCIWndValidateMedia	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_VALIDATEMEDIA,opt int x=0,opt int x=0)
'$define MCIWndSetZoom(HWND hwnd,iZoom)	(VOID)SendMessageA(HWND hwnd, MCIWNDM_SETZOOM, 0,(LPARAM)(UINT)(iZoom))
'$define MCIWndSetVolume(HWND hwnd,iVol)	(long)SendMessageA(HWND hwnd, MCIWNDM_SETVOLUME, 0,(LPARAM)(UINT)(iVol))
'$define MCIWndSetSpeed(HWND hwnd,iSpeed)(long)SendMessageA(HWND hwnd, MCIWNDM_SETSPEED, 0,(LPARAM)(UINT)(iSpeed))
'$define MCIWndSetTimeFormat(HWND hwnd, lp)(long)SendMessageA(HWND hwnd, MCIWNDM_SETTIMEFORMAT, 0,(LPARAM)(LPTSTR)(lp))
'$define MCIWndGetTimeFormat(HWND hwnd, lp, len)(long)SendMessageA(HWND hwnd, MCIWNDM_GETTIMEFORMAT,(WPARAM)(UINT)(len),(LPARAM)(LPTSTR)(lp))

declare import, MCIWndGetRepeat	alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETREPEAT,opt int x=0,opt int x=0),BOOL
'$define MCIWndSetRepeat(HWND hwnd,f)	()SendMessageA(HWND hwnd, MCIWNDM_SETREPEAT, 0,(LPARAM)(BOOL)(f))

'$define MCIWndUseFrames(hwnd)	MCIWndSetTimeFormat(HWND hwnd, TEXT("frames"))
'$define MCIWndUseTime(hwnd)	MCIWndSetTimeFormat(HWND hwnd, TEXT("ms"))
/*
$define MCIWndSetActiveTimer(HWND hwnd, active)				\
	(VOID)SendMessageA(HWND hwnd, MCIWNDM_SETACTIVETIMER,			\
	(WPARAM)(UINT)(active), 0)
$define MCIWndSetInactiveTimer(HWND hwnd, inactive)				\
	(VOID)SendMessageA(HWND hwnd, MCIWNDM_SETINACTIVETIMER,		\
	(WPARAM)(UINT)(inactive), 0)
$define MCIWndSetTimers(HWND hwnd, active, inactive)					\
		(VOID)SendMessageA(HWND hwnd, MCIWNDM_SETTIMERS,(WPARAM)(UINT)(active), \
		(LPARAM)(UINT)(inactive))
$define MCIWndGetActiveTimer(hwnd)					\
	(UINT)SendMessageA(HWND hwnd, MCIWNDM_GETACTIVETIMER,	0, 0)
$define MCIWndGetInactiveTimer(hwnd)					\
	(UINT)SendMessageA(HWND hwnd, MCIWNDM_GETINACTIVETIMER, 0, 0)

$define MCIWndRealize(HWND hwnd, fBkgnd)(long)SendMessageA(HWND hwnd, MCIWNDM_REALIZE,(WPARAM)(BOOL)(fBkgnd),0)
$define MCIWndSendString(HWND hwnd, sz)	(long)SendMessageA(HWND hwnd, MCIWNDM_SENDSTRING, 0,(LPARAM)(LPTSTR)(sz))
$define MCIWndReturnString(HWND hwnd, lp, len)	(long)SendMessageA(HWND hwnd, MCIWNDM_RETURNSTRING,(WPARAM)(UINT)(len),(LPARAM)(LPVOID p)(lp))
$define MCIWndGetError(HWND hwnd, lp, len)(long)SendMessageA(HWND hwnd, MCIWNDM_GETERROR,(WPARAM)(UINT)(len),(LPARAM)(LPVOID p)(lp))
$define MCIWndActivate(HWND hwnd, f)	()SendMessageA(HWND hwnd, WM_ACTIVATE,(WPARAM)(BOOL)(f), 0)
*/
declare import, MCIWndGetPalette alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETPALETTE,opt int x=0,opt int x=0),HPALETTE
'$define MCIWndSetPalette(HWND hwnd, hpal)(long)SendMessageA(HWND hwnd, MCIWNDM_SETPALETTE,(WPARAM)(HPALETTE)(hpal), 0)
'$define MCIWndGetFileName(HWND hwnd, lp, len)(long)SendMessageA(HWND hwnd, MCIWNDM_GETFILENAME,(WPARAM)(UINT)(len),(LPARAM)(LPVOID p)(lp))
'$define MCIWndGetDevice(HWND hwnd, lp, len)	(long)SendMessageA(HWND hwnd, MCIWNDM_GETDEVICE,(WPARAM)(UINT)(len),(LPARAM)(LPVOID p)(lp))

declare import, MCIWndGetStyles alias SendMessageA(HWND hwnd,opt int x=MCIWNDM_GETSTYLES,opt int x=0,opt int x=0),UINT
declare extern MCIWndChangeStyles(HWND hwnd,int mask,int value),int'(long)SendMessageA(HWND hwnd, MCIWNDM_CHANGESTYLES,(WPARAM)(UINT)(mask),(LPARAM)(long l)(value))
'$define MCIWndOpenInterface(HWND hwnd, pUnk)	(long)SendMessageA(HWND hwnd, MCIWNDM_OPENINTERFACE, 0,(LPARAM)(LPUNKNOWN)(pUnk))
'$define MCIWndSetOwner(HWND hwnd, hwndP)	(long)SendMessageA(HWND hwnd, MCIWNDM_SETOWNER,(WPARAM)(hwndP), 0)

' Messages an app will send to MCIWND

' all the text-related messages are defined of order above(they need
' to be defined before the MCIWndOpen()macros

$define MCIWNDM_GETDEVICEID	(WM_USER + 100)
$define MCIWNDM_GETSTART	(WM_USER + 103)
$define MCIWNDM_GETLENGTH	(WM_USER + 104)
$define MCIWNDM_GETEND		(WM_USER + 105)
$define MCIWNDM_EJECT		(WM_USER + 107)
$define MCIWNDM_SETZOOM		(WM_USER + 108)
$define MCIWNDM_GETZOOM	(WM_USER + 109)
$define MCIWNDM_SETVOLUME	(WM_USER + 110)
$define MCIWNDM_GETVOLUME	(WM_USER + 111)
$define MCIWNDM_SETSPEED	(WM_USER + 112)
$define MCIWNDM_GETSPEED	(WM_USER + 113)
$define MCIWNDM_SETREPEAT	(WM_USER + 114)
$define MCIWNDM_GETREPEAT	(WM_USER + 115)
$define MCIWNDM_REALIZE	(WM_USER + 118)
$define MCIWNDM_VALIDATEMEDIA	(WM_USER + 121)
$define MCIWNDM_PLAYFROM	(WM_USER + 122)
$define MCIWNDM_PLAYTO	(WM_USER + 123)
$define MCIWNDM_GETPALETTE	(WM_USER + 126)
$define MCIWNDM_SETPALETTE	(WM_USER + 127)
$define MCIWNDM_SETTIMERS	(WM_USER + 129)
$define MCIWNDM_SETACTIVETIMER	(WM_USER + 130)
$define MCIWNDM_SETINACTIVETIMER(WM_USER + 131)
$define MCIWNDM_GETACTIVETIMER	(WM_USER + 132)
$define MCIWNDM_GETINACTIVETIMER(WM_USER + 133)
$define MCIWNDM_CHANGESTYLES	(WM_USER + 135)
$define MCIWNDM_GETSTYLES	(WM_USER + 136)
$define MCIWNDM_GETALIAS	(WM_USER + 137)
$define MCIWNDM_PLAYREVERSE	(WM_USER + 139)
$define MCIWNDM_GET_SOURCE	(WM_USER + 140)
$define MCIWNDM_PUT_SOURCE	(WM_USER + 141)
$define MCIWNDM_GET_DEST	(WM_USER + 142)
$define MCIWNDM_PUT_DEST	(WM_USER + 143)
$define MCIWNDM_CAN_PLAY	(WM_USER + 144)
$define MCIWNDM_CAN_WINDOW	(WM_USER + 145)
$define MCIWNDM_CAN_RECORD	(WM_USER + 146)
$define MCIWNDM_CAN_SAVE	(WM_USER + 147)
$define MCIWNDM_CAN_EJECT	(WM_USER + 148)
$define MCIWNDM_CAN_CONFIG	(WM_USER + 149)
$define MCIWNDM_PALETTEKICK	(WM_USER + 150)
$define MCIWNDM_OPENINTERFACE	(WM_USER + 151)
$define MCIWNDM_SETOWNER	(WM_USER + 152)

'define both A and W messages
$define MCIWNDM_SENDSTRINGA	(WM_USER + 101)
$define MCIWNDM_GETPOSITIONA	(WM_USER + 102)
$define MCIWNDM_GETMODEA	(WM_USER + 106)
$define MCIWNDM_SETTIMEFORMATA	(WM_USER + 119)
$define MCIWNDM_GETTIMEFORMATA	(WM_USER + 120)
$define MCIWNDM_GETFILENAMEA	(WM_USER + 124)
$define MCIWNDM_GETDEVICEA	(WM_USER + 125)
$define MCIWNDM_GETERRORA	(WM_USER + 128)
$define MCIWNDM_NEWA		(WM_USER + 134)
$define MCIWNDM_RETURNSTRINGA	(WM_USER + 138)
$define MCIWNDM_OPENA		(WM_USER + 153)

$define MCIWNDM_SENDSTRINGW	(WM_USER + 201)
$define MCIWNDM_GETPOSITIONW	(WM_USER + 202)
$define MCIWNDM_GETMODEW	(WM_USER + 206)
$define MCIWNDM_SETTIMEFORMATW	(WM_USER + 219)
$define MCIWNDM_GETTIMEFORMATW	(WM_USER + 220)
$define MCIWNDM_GETFILENAMEW	(WM_USER + 224)
$define MCIWNDM_GETDEVICEW	(WM_USER + 225)
$define MCIWNDM_GETERRORW	(WM_USER + 228)
$define MCIWNDM_NEWW		(WM_USER + 234)
$define MCIWNDM_RETURNSTRINGW	(WM_USER + 238)
$define MCIWNDM_OPENW		(WM_USER + 252)

' map defaults to A or W depending on app's UNICODE setting
$ifdef UNICODE
$define MCIWNDM_SENDSTRING	MCIWNDM_SENDSTRINGW
$define MCIWNDM_GETPOSITION	MCIWNDM_GETPOSITIONW
$define MCIWNDM_GETMODE	MCIWNDM_GETMODEW
$define MCIWNDM_SETTIMEFORMAT	MCIWNDM_SETTIMEFORMATW
$define MCIWNDM_GETTIMEFORMAT	MCIWNDM_GETTIMEFORMATW
$define MCIWNDM_GETFILENAME	MCIWNDM_GETFILENAMEW
$define MCIWNDM_GETDEVICE	MCIWNDM_GETDEVICEW
$define MCIWNDM_GETERROR	MCIWNDM_GETERRORW
$define MCIWNDM_NEW	MCIWNDM_NEWW
$define MCIWNDM_RETURNSTRING	MCIWNDM_RETURNSTRINGW
$define MCIWNDM_OPEN		MCIWNDM_OPENW
$else
$define MCIWNDM_SENDSTRING	MCIWNDM_SENDSTRINGA
$define MCIWNDM_GETPOSITION	MCIWNDM_GETPOSITIONA
$define MCIWNDM_GETMODE	MCIWNDM_GETMODEA
$define MCIWNDM_SETTIMEFORMAT	MCIWNDM_SETTIMEFORMATA
$define MCIWNDM_GETTIMEFORMAT	MCIWNDM_GETTIMEFORMATA
$define MCIWNDM_GETFILENAME	MCIWNDM_GETFILENAMEA
$define MCIWNDM_GETDEVICE	MCIWNDM_GETDEVICEA
$define MCIWNDM_GETERROR	MCIWNDM_GETERRORA
$define MCIWNDM_NEW	MCIWNDM_NEWA
$define MCIWNDM_RETURNSTRING	MCIWNDM_RETURNSTRINGA
$define MCIWNDM_OPEN		MCIWNDM_OPENA
$endif

' note that the source text for MCIWND will thus contain
' support for eg MCIWNDM_SENDSTRING(both the 16-bit entrypoint and
' win32 mapped to MCIWNDM_SENDSTRINGW), and MCIWNDM_SENDSTRINGA(the
' win32 ansi thunk).

' Messages MCIWND will send to an app
' !!! Use less messages and use a code instead to indicate the type of notify? /* Internal */
$define MCIWNDM_NOTIFYMODE	(WM_USER + 200)	' wp = hwnd, lp = mode
$define MCIWNDM_NOTIFYPOS	(WM_USER + 201)	' wp = hwnd, lp = pos
$define MCIWNDM_NOTIFYSIZE	(WM_USER + 202)	' wp = hwnd
$define MCIWNDM_NOTIFYMEDIA	(WM_USER + 203)	' wp = hwnd, lp = fn
$define MCIWNDM_NOTIFYERROR	(WM_USER + 205)	' wp = hwnd, lp = error

' special seek values for START and END
$define MCIWND_START	-1
$define MCIWND_END	-2

$ifndef MCI_PLAY
	/* MCI command message identifiers */
$ifndef _WIN32
	' win32 apps send MCIWNDM_OPEN
	$define MCI_OPEN	0x0803
$endif
	$define MCI_CLOSE	0x0804
	$define MCI_PLAY	0x0806
	$define MCI_SEEK	0x0807
	$define MCI_STOP	0x0808
	$define MCI_PAUSE	0x0809
	$define MCI_STEP	0x080E
	$define MCI_RECORD	0x080F
	$define MCI_SAVE	0x0813
	$define MCI_CUT	0x0851
	$define MCI_COPY	0x0852
	$define MCI_PASTE	0x0853
	$define MCI_RESUME	0x0855
	$define MCI_DELETE	0x0856
$endif

$ifndef MCI_MODE_NOT_READY
	/* return values for 'status mode' command */
	$define MCI_MODE_NOT_READY	(524)
	$define MCI_MODE_STOP	(525)
	$define MCI_MODE_PLAY	(526)
	$define MCI_MODE_RECORD	(527)
	$define MCI_MODE_SEEK	(528)
	$define MCI_MODE_PAUSE	(529)
	$define MCI_MODE_OPEN	(530)
$endif

$endif
/* NOAVIFILE */
/**************************************
*
*	VIDEO - Video Capture Driver Interface
*
* *************************************/

$ifndef NOAVICAP')|| !defined(NOVIDEO)
$ifndef NOVIDEO
$ifndef _RCINVOKED

/* video data types */
typedef HVIDEO HANDLE	' generic handle

$endif
'	' ifndef RCINVOKED

/**************************************

		version api

**************************************/

'declare import, VideoForWindowsVersion(),DWORD

/**************************************

		Error Return Values

**************************************/
$define DV_ERR_OK	(0)	/* No error */
$define DV_ERR_BASE	(1)	/* Error Base */
$define DV_ERR_NONSPECIFIC	(DV_ERR_BASE)
$define DV_ERR_BADFORMAT	(DV_ERR_BASE + 1)
				/* unsupported video format */
$define DV_ERR_STILLPLAYING	(DV_ERR_BASE + 2)
				/* still something playing */
$define DV_ERR_UNPREPARED	(DV_ERR_BASE + 3)
				/* header not prepared */
$define DV_ERR_SYNC	(DV_ERR_BASE + 4)
				/* device is synchronous */
$define DV_ERR_TOOMANYCHANNELS	(DV_ERR_BASE + 5)
				/* number of channels exceeded */
$define DV_ERR_NOTDETECTED	(DV_ERR_BASE + 6)	/* HW not detected */
$define DV_ERR_BADINSTALL	(DV_ERR_BASE + 7)	/* Can not get Profile */
$define DV_ERR_CREATEPALETTE	(DV_ERR_BASE + 8)
$define DV_ERR_SIZEFIELD	(DV_ERR_BASE + 9)
$define DV_ERR_PARAM1		(DV_ERR_BASE + 10)
$define DV_ERR_PARAM2		(DV_ERR_BASE + 11)
$define DV_ERR_CONFIG1		(DV_ERR_BASE + 12)
$define DV_ERR_CONFIG2		(DV_ERR_BASE + 13)
$define DV_ERR_FLAGS		(DV_ERR_BASE + 14)
$define DV_ERR_13		(DV_ERR_BASE + 15)

$define DV_ERR_NOTSUPPORTED	(DV_ERR_BASE + 16)	/* function not suported */
$define DV_ERR_NOMEM	(DV_ERR_BASE + 17)	/* out of memory */
$define DV_ERR_ALLOCATED	(DV_ERR_BASE + 18)	/* device is allocated */
$define DV_ERR_BADDEVICEID	(DV_ERR_BASE + 19)
$define DV_ERR_INVALHANDLE	(DV_ERR_BASE + 20)
$define DV_ERR_BADERRNUM	(DV_ERR_BASE + 21)
$define DV_ERR_NO_BUFFERS	(DV_ERR_BASE + 22)	/* out of buffers */

$define DV_ERR_MEM_CONFLICT	(DV_ERR_BASE + 23)	/* Mem conflict detected */
$define DV_ERR_IO_CONFLICT	(DV_ERR_BASE + 24)	/* I/O conflict detected */
$define DV_ERR_DMA_CONFLICT	(DV_ERR_BASE + 25)	/* DMA conflict detected */
$define DV_ERR_INT_CONFLICT	(DV_ERR_BASE + 26)	/* Interrupt conflict detected */
$define DV_ERR_PROTECT_ONLY	(DV_ERR_BASE + 27)	/* Can not run standard mode */
$define DV_ERR_LASTERROR	(DV_ERR_BASE + 27)

'$define DV_IDS_PROFILING	(DV_ERR_BASE + 900)
'$define DV_IDS_LISTBOX	(DV_ERR_BASE + 901)

$define DV_ERR_USER_MSG	(DV_ERR_BASE + 1000)/* Hardware specific errors */

/**************************************

		Callback Messages

Note that the values for all installable driver callback messages are
identical,(ie. MM_DRVM_DATA has the same value for capture drivers, _
installable video codecs, and the audio compression manager).
**************************************/
$ifndef _RCINVOKED

$ifndef MM_DRVM_OPEN
$define MM_DRVM_OPEN	0x3D0
$define MM_DRVM_CLOSE	0x3D1
$define MM_DRVM_DATA	0x3D2
$define MM_DRVM_ERROR	0x3D3
$endif

$define DV_VM_OPEN	MM_DRVM_OPEN	' Obsolete messages
$define DV_VM_CLOSE	MM_DRVM_CLOSE
$define DV_VM_DATA	MM_DRVM_DATA
$define DV_VM_ERROR	MM_DRVM_ERROR

/**************************************

		Structures

**************************************/
/* video data block header */
type VIDEOHDR
	pointer	lpData	/* pointer to locked data buffer */
	DWORD	dwBufferLength	/* Length of data buffer */
	DWORD	dwBytesUsed	/* Bytes actually used */
	DWORD	dwTimeCaptured	/* Milliseconds from start of stream */
	DWORD_PTR	dwUser	/* for client's use */
	DWORD	dwFlags	/* assorted flags(see defines)*/
	DWORD_PTR	dwReserved[4]	/* reserved for driver */
endtype

/* dwFlags field of VIDEOHDR */
$define VHDR_DONE	0x00000001	/* Done bit */
$define VHDR_PREPARED	0x00000002	/* Set if this header has been prepared */
$define VHDR_INQUEUE	0x00000004	/* Reserved for driver */
$define VHDR_KEYFRAME	0x00000008	/* Key Frame */
$define VHDR_VALID	0x0000000F	/* valid flags */	/* Internal */

/* Channel capabilities structure */
type CHANNEL_CAPS
	DWORD	dwFlags	/* Capability flags*/
	DWORD	dwSrcRectXMod	/* Granularity of src rect x */
	DWORD	dwSrcRectYMod	/* Granularity of src rect y */
	DWORD	dwSrcRectWidthMod	/* Granularity of src rect width */
	DWORD	dwSrcRectHeightMod	/* Granularity of src rect height */
	DWORD	dwDstRectXMod	/* Granularity of dst rect x */
	DWORD	dwDstRectYMod	/* Granularity of dst rect y */
	DWORD	dwDstRectWidthMod	/* Granularity of dst rect width */
	DWORD	dwDstRectHeightMod	/* Granularity of dst rect height */
endtype

/* dwFlags of CHANNEL_CAPS */
$define VCAPS_OVERLAY	0x00000001	/* overlay channel */
$define VCAPS_SRC_CAN_CLIP	0x00000002	/* src rect can clip */
$define VCAPS_DST_CAN_CLIP	0x00000004	/* dst rect can clip */
$define VCAPS_CAN_SCALE	0x00000008	/* allows src != dst */

/**************************************

			API Flags

**************************************/

' Types of channels to open with the videoOpen function
$define VIDEO_EXTERNALIN		0x0001
$define VIDEO_EXTERNALOUT		0x0002
$define VIDEO_IN			0x0004
$define VIDEO_OUT			0x0008

' Is a driver dialog available for this channel?
$define VIDEO_DLG_QUERY			0x0010

' videoConfigure(both GET and SET)
$define VIDEO_CONFIGURE_QUERY		0x8000

' videoConfigure(SET only)
$define VIDEO_CONFIGURE_SET		0x1000

' videoConfigure(GET only)
$define VIDEO_CONFIGURE_GET		0x2000
$define VIDEO_CONFIGURE_QUERYSIZE	0x0001

$define VIDEO_CONFIGURE_CURRENT		0x0010
$define VIDEO_CONFIGURE_NOMINAL		0x0020
$define VIDEO_CONFIGURE_MIN		0x0040
$define VIDEO_CONFIGURE_MAX		0x0080

/**************************************

			CONFIGURE MESSAGES

**************************************/
$define DVM_USER	0x4000

$define DVM_CONFIGURE_START		0x1000
$define DVM_CONFIGURE_END		0x1FFF

$define DVM_PALETTE			(DVM_CONFIGURE_START + 1)
$define DVM_FORMAT			(DVM_CONFIGURE_START + 2)
$define DVM_PALETTERGB555		(DVM_CONFIGURE_START + 3)
$define DVM_SRC_RECT			(DVM_CONFIGURE_START + 4)
$define DVM_DST_RECT			(DVM_CONFIGURE_START + 5)

$endif
/* ifndef _RCINVOKED */

$endif
$endif
/* NOVIDEO */

/**************************************
*
*	AVICAP - Window class for AVI capture
*
* *************************************/

$ifndef NOAVICAP
'# ifdef __cplusplus
/* SendMessage C++*/
'$define AVICapSM(HWND hwnd,m,w,l)((::IsWindow(hwnd))? ::SendMessage(HWND hwnd,m,w,l): 0)
'# else
/* SendMessage C */
$ifdef UNICODE
declare import, AVICapSM alias SendMessageW(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam),LRESULT
$else
declare import, AVICapSM alias SendMessageA(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam),LRESULT
$endif
'# endif
/* __cplusplus */

$ifndef RC_INVOKED

' ------------------------------------------------------------------
'	Window Messages	WM_CAP... which can be sent to an AVICAP window
' ------------------------------------------------------------------

' UNICODE
' The Win32 version of AVICAP on NT supports UNICODE applications:
' for each API or message that takes a char or string parameter, there are
' two versions, ApiNameA and ApiNameW. The default name ApiName is $defined
' to one or other depending on whether UNICODE is defined. Apps can call
' the A and W apis directly, and mix them.
' The 32-bit AVICAP on NT uses unicode exclusively internally.
' ApiNameA()will be implemented as a call to ApiNameW()together with
' translation of strings.

' Defines start of the message range
$define WM_CAP_START	WM_USER

' start of unicode messages
$define WM_CAP_UNICODE_START	WM_USER+100

$define WM_CAP_GET_CAPSTREAMPTR	(WM_CAP_START+	1)

$define WM_CAP_SET_CALLBACK_ERRORW	(WM_CAP_UNICODE_START+	2)
$define WM_CAP_SET_CALLBACK_STATUSW	(WM_CAP_UNICODE_START+	3)
$define WM_CAP_SET_CALLBACK_ERRORA	(WM_CAP_START+	2)
$define WM_CAP_SET_CALLBACK_STATUSA	(WM_CAP_START+	3)
$ifdef UNICODE
$define WM_CAP_SET_CALLBACK_ERROR	WM_CAP_SET_CALLBACK_ERRORW
$define WM_CAP_SET_CALLBACK_STATUS	WM_CAP_SET_CALLBACK_STATUSW
$else
$define WM_CAP_SET_CALLBACK_ERROR	WM_CAP_SET_CALLBACK_ERRORA
$define WM_CAP_SET_CALLBACK_STATUS	WM_CAP_SET_CALLBACK_STATUSA
$endif

$define WM_CAP_SET_CALLBACK_YIELD	(WM_CAP_START+	4)
$define WM_CAP_SET_CALLBACK_FRAME	(WM_CAP_START+	5)
$define WM_CAP_SET_CALLBACK_VIDEOSTREAM(WM_CAP_START+	6)
$define WM_CAP_SET_CALLBACK_WAVESTREAM	(WM_CAP_START+	7)
$define WM_CAP_GET_USER_DATA		(WM_CAP_START+	8)
$define WM_CAP_SET_USER_DATA		(WM_CAP_START+	9)

$define WM_CAP_DRIVER_CONNECT	(WM_CAP_START+	10)
$define WM_CAP_DRIVER_DISCONNECT	(WM_CAP_START+	11)

$define WM_CAP_DRIVER_GET_NAMEA	(WM_CAP_START+	12)
$define WM_CAP_DRIVER_GET_VERSIONA	(WM_CAP_START+	13)
$define WM_CAP_DRIVER_GET_NAMEW	(WM_CAP_UNICODE_START+	12)
$define WM_CAP_DRIVER_GET_VERSIONW	(WM_CAP_UNICODE_START+	13)
$ifdef UNICODE
$define WM_CAP_DRIVER_GET_NAME	WM_CAP_DRIVER_GET_NAMEW
$define WM_CAP_DRIVER_GET_VERSION	WM_CAP_DRIVER_GET_VERSIONW
$else
$define WM_CAP_DRIVER_GET_NAME	WM_CAP_DRIVER_GET_NAMEA
$define WM_CAP_DRIVER_GET_VERSION	WM_CAP_DRIVER_GET_VERSIONA
$endif

$define WM_CAP_DRIVER_GET_CAPS	(WM_CAP_START+	14)

$define WM_CAP_FILE_SET_CAPTURE_FILEA	(WM_CAP_START+	20)
$define WM_CAP_FILE_GET_CAPTURE_FILEA	(WM_CAP_START+	21)
$define WM_CAP_FILE_SAVEASA	(WM_CAP_START+	23)
$define WM_CAP_FILE_SAVEDIBA	(WM_CAP_START+	25)
$define WM_CAP_FILE_SET_CAPTURE_FILEW	(WM_CAP_UNICODE_START+	20)
$define WM_CAP_FILE_GET_CAPTURE_FILEW	(WM_CAP_UNICODE_START+	21)
$define WM_CAP_FILE_SAVEASW	(WM_CAP_UNICODE_START+	23)
$define WM_CAP_FILE_SAVEDIBW	(WM_CAP_UNICODE_START+	25)
$ifdef UNICODE
$define WM_CAP_FILE_SET_CAPTURE_FILE	WM_CAP_FILE_SET_CAPTURE_FILEW
$define WM_CAP_FILE_GET_CAPTURE_FILE	WM_CAP_FILE_GET_CAPTURE_FILEW
$define WM_CAP_FILE_SAVEAS	WM_CAP_FILE_SAVEASW
$define WM_CAP_FILE_SAVEDIB	WM_CAP_FILE_SAVEDIBW
$else
$define WM_CAP_FILE_SET_CAPTURE_FILE	WM_CAP_FILE_SET_CAPTURE_FILEA
$define WM_CAP_FILE_GET_CAPTURE_FILE	WM_CAP_FILE_GET_CAPTURE_FILEA
$define WM_CAP_FILE_SAVEAS	WM_CAP_FILE_SAVEASA
$define WM_CAP_FILE_SAVEDIB	WM_CAP_FILE_SAVEDIBA
$endif

' out of order to save on ifdefs
$define WM_CAP_FILE_ALLOCATE	(WM_CAP_START+	22)
$define WM_CAP_FILE_SET_INFOCHUNK	(WM_CAP_START+	24)

$define WM_CAP_EDIT_COPY	(WM_CAP_START+	30)

$define WM_CAP_SET_AUDIOFORMAT	(WM_CAP_START+	35)
$define WM_CAP_GET_AUDIOFORMAT	(WM_CAP_START+	36)

$define WM_CAP_DLG_VIDEOFORMAT	(WM_CAP_START+	41)
$define WM_CAP_DLG_VIDEOSOURCE	(WM_CAP_START+	42)
$define WM_CAP_DLG_VIDEODISPLAY	(WM_CAP_START+	43)
$define WM_CAP_GET_VIDEOFORMAT	(WM_CAP_START+	44)
$define WM_CAP_SET_VIDEOFORMAT	(WM_CAP_START+	45)
$define WM_CAP_DLG_VIDEOCOMPRESSION	(WM_CAP_START+	46)

$define WM_CAP_SET_PREVIEW	(WM_CAP_START+	50)
$define WM_CAP_SET_OVERLAY	(WM_CAP_START+	51)
$define WM_CAP_SET_PREVIEWRATE	(WM_CAP_START+	52)
$define WM_CAP_SET_SCALE	(WM_CAP_START+	53)
$define WM_CAP_GET_STATUS	(WM_CAP_START+	54)
$define WM_CAP_SET_SCROLL	(WM_CAP_START+	55)

$define WM_CAP_GRAB_FRAME	(WM_CAP_START+	60)
$define WM_CAP_GRAB_FRAME_NOSTOP	(WM_CAP_START+	61)

$define WM_CAP_SEQUENCE	(WM_CAP_START+	62)
$define WM_CAP_SEQUENCE_NOFILE	(WM_CAP_START+	63)
$define WM_CAP_SET_SEQUENCE_SETUP	(WM_CAP_START+	64)
$define WM_CAP_GET_SEQUENCE_SETUP	(WM_CAP_START+	65)

$define WM_CAP_SET_MCI_DEVICEA	(WM_CAP_START+	66)
$define WM_CAP_GET_MCI_DEVICEA	(WM_CAP_START+	67)
$define WM_CAP_SET_MCI_DEVICEW	(WM_CAP_UNICODE_START+	66)
$define WM_CAP_GET_MCI_DEVICEW	(WM_CAP_UNICODE_START+	67)
$ifdef UNICODE
$define WM_CAP_SET_MCI_DEVICE	WM_CAP_SET_MCI_DEVICEW
$define WM_CAP_GET_MCI_DEVICE	WM_CAP_GET_MCI_DEVICEW
$else
$define WM_CAP_SET_MCI_DEVICE	WM_CAP_SET_MCI_DEVICEA
$define WM_CAP_GET_MCI_DEVICE	WM_CAP_GET_MCI_DEVICEA
$endif

$define WM_CAP_STOP	(WM_CAP_START+	68)
$define WM_CAP_ABORT	(WM_CAP_START+	69)

$define WM_CAP_SINGLE_FRAME_OPEN	(WM_CAP_START+	70)
$define WM_CAP_SINGLE_FRAME_CLOSE	(WM_CAP_START+	71)
$define WM_CAP_SINGLE_FRAME	(WM_CAP_START+	72)

$define WM_CAP_PAL_OPENA	(WM_CAP_START+	80)
$define WM_CAP_PAL_SAVEA	(WM_CAP_START+	81)
$define WM_CAP_PAL_OPENW	(WM_CAP_UNICODE_START+	80)
$define WM_CAP_PAL_SAVEW	(WM_CAP_UNICODE_START+	81)
$ifdef UNICODE
$define WM_CAP_PAL_OPEN	WM_CAP_PAL_OPENW
$define WM_CAP_PAL_SAVE	WM_CAP_PAL_SAVEW
$else
$define WM_CAP_PAL_OPEN	WM_CAP_PAL_OPENA
$define WM_CAP_PAL_SAVE	WM_CAP_PAL_SAVEA
$endif

$define WM_CAP_PAL_PASTE	(WM_CAP_START+	82)
$define WM_CAP_PAL_AUTOCREATE	(WM_CAP_START+	83)
$define WM_CAP_PAL_MANUALCREATE	(WM_CAP_START+	84)

' Following added post VFW 1.1
$define WM_CAP_SET_CALLBACK_CAPCONTROL	(WM_CAP_START+	85)

' Defines end of the message range
$define WM_CAP_UNICODE_END	WM_CAP_PAL_SAVEW
$define WM_CAP_END	WM_CAP_UNICODE_END

' ------------------------------------------------------------------
'	Message crackers for above
' ------------------------------------------------------------------

' message wrapper macros are defined for the default messages only. Apps
' that wish to mix Ansi and UNICODE message sending will have to
' reference the _A and _W messages directly

'$define capSetCallbackOnError(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_ERROR, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnError alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_ERROR),BOOL
'$define capSetCallbackOnStatus(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_STATUS, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnStatus alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_STATUS),BOOL
'$define capSetCallbackOnYield(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_YIELD, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnYield alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_YIELD),BOOL
'$define capSetCallbackOnFrame(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_FRAME, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnFrame alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_FRAME),BOOL
'$define capSetCallbackOnVideoStream(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_VIDEOSTREAM, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnVideoStream alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_VIDEOSTREAM),BOOL
'$define capSetCallbackOnWaveStream(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_WAVESTREAM, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnWaveStream alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_WAVESTREAM),BOOL
'$define capSetCallbackOnCapControl(hwnd, fpProc)	AVICapSM(HWND hwnd, WM_CAP_SET_CALLBACK_CAPCONTROL, 0, LPVOID fpProc),BOOL
declare extern capSetCallbackOnCapControl alias SendMessage_HLM_A(HWND hwnd, FARPROC fpProc, opt int msg=WM_CAP_SET_CALLBACK_CAPCONTROL),BOOL

'$define capSetUserData(hwnd, lUser)	AVICapSM(HWND hwnd, WM_CAP_SET_USER_DATA, 0,(LPARAM)lUser)),BOOL
declare extern capSetUserData alias SendMessage_HLM_A(HWND hwnd, pointer lUser, opt int msg=WM_CAP_SET_USER_DATA),BOOL
'$define capGetUserData(hwnd)	AVICapSM(HWND hwnd, WM_CAP_GET_USER_DATA, 0, 0))
declare extern capGetUserData alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_GET_USER_DATA),pointer

'$define capDriverConnect(hwnd, i)	AVICapSM(HWND hwnd, WM_CAP_DRIVER_CONNECT, i, 0)),BOOL
declare extern capDriverConnect alias SendMessage_HWM_A(HWND hwnd, int index, opt int msg=WM_CAP_DRIVER_CONNECT),BOOL
'$define capDriverDisconnect(hwnd)	AVICapSM(HWND hwnd, WM_CAP_DRIVER_DISCONNECT, 0, 0)),BOOL
declare extern capDriverDisconnect alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_DRIVER_DISCONNECT),BOOL

'$define capDriverGetName(hwnd, szName, wSize)	AVICapSM(HWND hwnd, WM_CAP_DRIVER_GET_NAME,(wSize), LPTSTR szName)),BOOL
'$define capDriverGetVersion(hwnd, szVer, wSize)	AVICapSM(HWND hwnd, WM_CAP_DRIVER_GET_VERSION,(WPARAM)(wSize),(LPARAM)(LPVOID p)(LPTSTR)(szVer))),BOOL
'$define capDriverGetCaps(hwnd, s, wSize)	AVICapSM(HWND hwnd, WM_CAP_DRIVER_GET_CAPS,(WPARAM)(wSize),(LPARAM)(LPVOID p)(pointer)(s))),BOOL
declare extern capDriverGetCaps alias SendMessage_HLWM_A(HWND hwnd,pointer s,int size, opt int msg=WM_CAP_DRIVER_GET_CAPS),BOOL

'$define capFileSetCaptureFile(hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_FILE_SET_CAPTURE_FILE, 0,(LPARAM)(LPVOID p)(LPTSTR)(szName))),BOOL
'$define capFileGetCaptureFile(hwnd, szName, wSize)(AVICapSM(HWND hwnd, WM_CAP_FILE_GET_CAPTURE_FILE,(WPARAM)(wSize),(LPARAM)(LPVOID p)(LPTSTR)(szName))),BOOL
'$define capFileAlloc(hwnd, dwSize)	(AVICapSM(HWND hwnd, WM_CAP_FILE_ALLOCATE, 0,(LPARAM)(DWORD)(dwSize))),BOOL
'$define capFileSaveAs(hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_FILE_SAVEAS, 0,(LPARAM)(LPVOID p)(LPTSTR)(szName))),BOOL
'$define capFileSetInfoChunk(hwnd, lpInfoChunk)	(AVICapSM(HWND hwnd, WM_CAP_FILE_SET_INFOCHUNK,(WPARAM)0,(LPARAM)(pointer)(lpInfoChunk))),BOOL
'$define capFileSaveDIB(hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_FILE_SAVEDIB, 0,(LPARAM)(LPVOID p)(LPTSTR)(szName))),BOOL

'$define capEditCopy(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_EDIT_COPY, 0, 0)),BOOL
declare extern capEditCopy alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_EDIT_COPY),BOOL

'$define capSetAudioFormat(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_SET_AUDIOFORMAT,(WPARAM)(wSize),(LPARAM)(LPVOID p)(pointer p)(s))),BOOL
'$define capGetAudioFormat(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_GET_AUDIOFORMAT,(WPARAM)(wSize),(LPARAM)(LPVOID p)(pointer p)(s))),DWORD
'$define capGetAudioFormatSize(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_GET_AUDIOFORMAT,(WPARAM)0,(LPARAM)0L)),DWORD
declare extern capGetAudioFormatSize alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_GET_AUDIOFORMAT),BOOL

'$define capDlgVideoFormat(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_DLG_VIDEOFORMAT, 0, 0)),BOOL
declare extern capDlgVideoFormat alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_DLG_VIDEOFORMAT),BOOL
'$define capDlgVideoSource(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_DLG_VIDEOSOURCE, 0, 0)),BOOL
declare extern capDlgVideoSource alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_DLG_VIDEOSOURCE),BOOL

'$define capDlgVideoDisplay(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_DLG_VIDEODISPLAY, 0, 0)),BOOL
declare extern capDlgVideoDisplay alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_DLG_VIDEODISPLAY),BOOL

'$define capDlgVideoCompression(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_DLG_VIDEOCOMPRESSION, 0, 0)),BOOL
declare extern capDlgVideoCompression alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_DLG_VIDEOCOMPRESSION),BOOL

'$define capGetVideoFormat(HWND hwnd, s, wSize)	AVICapSM(HWND hwnd, WM_CAP_GET_VIDEOFORMAT, wSize, LPVOID s),DWORD
declare extern capGetVideoFormat alias SendMessage_HLWM_A(HWND hwnd, pointer pbi, int size, opt int msg=WM_CAP_GET_VIDEOFORMAT),BOOL

'$define capGetVideoFormatSize(hwnd)				(AVICapSM(HWND hwnd, WM_CAP_GET_VIDEOFORMAT, 0, 0)),DWORD
declare extern capGetVideoFormatSize alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_GET_VIDEOFORMAT),BOOL

'$define capSetVideoFormat(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_SET_VIDEOFORMAT,(WPARAM)(wSize),(LPARAM)(LPVOID p)(s))),BOOL
declare extern capSetVideoFormat alias SendMessage_HLWM_A(HWND hwnd, pointer s, int wSize, opt int msg=WM_CAP_SET_VIDEOFORMAT),BOOL

'$define capPreview(HWND hwnd, f)	(AVICapSM(HWND hwnd, WM_CAP_SET_PREVIEW,(WPARAM)(BOOL)(f), 0)),BOOL
declare extern capPreview alias SendMessage_HWM_A(HWND hwnd, BOOL f, opt int msg=WM_CAP_SET_PREVIEW),BOOL

'$define capPreviewRate(HWND hwnd, wMS)	(AVICapSM(HWND hwnd, WM_CAP_SET_PREVIEWRATE,(WPARAM)(wMS), 0)),BOOL
declare extern capPreviewRate alias SendMessage_HWM_A(HWND hwnd, int wMS, opt int msg=WM_CAP_SET_PREVIEWRATE),BOOL

'$define capOverlay(HWND hwnd, f)	(AVICapSM(HWND hwnd, WM_CAP_SET_OVERLAY,(WPARAM)(BOOL)(f), 0)),BOOL
declare extern capOverlay alias SendMessage_HWM_A(HWND hwnd, BOOL f, opt int msg=WM_CAP_SET_OVERLAY),BOOL
'$define capPreviewScale(HWND hwnd, f)	(AVICapSM(HWND hwnd, WM_CAP_SET_SCALE, f, 0),BOOL
declare extern capPreviewScale alias SendMessage_HWM_A(HWND hwnd, BOOL f, opt int msg=WM_CAP_SET_SCALE),BOOL
'$define capGetStatus(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_GET_STATUS, wSize,pointer s),BOOL
declare extern capGetStatus alias SendMessage_HLWM_A(HWND hwnd, pointer s, int wSize, opt int msg=WM_CAP_GET_STATUS),BOOL
'$define capSetScrollPos(HWND hwnd, lpP)	(AVICapSM(HWND hwnd, WM_CAP_SET_SCROLL, 0, pointer lpP),BOOL
declare extern capSetScrollPos alias SendMessage_HLM_A(HWND hwnd, pointer lpP, opt int msg=WM_CAP_SET_SCROLL),BOOL

'$define capGrabFrame(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_GRAB_FRAME, 0, 0),BOOL
declare extern capGrabFrame alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_GRAB_FRAME),BOOL
'$define capGrabFrameNoStop(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_GRAB_FRAME_NOSTOP, 0, 0),BOOL
declare extern capGrabFrameNoStop alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_GRAB_FRAME_NOSTOP),BOOL

'$define capCaptureSequence(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_SEQUENCE, 0, 0),BOOL
declare extern capCaptureSequence alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_SEQUENCE),BOOL
'$define capCaptureSequenceNoFile(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_SEQUENCE_NOFILE, 0, 0),BOOL
declare extern capCaptureSequenceNoFile alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_SEQUENCE_NOFILE),BOOL
'$define capCaptureStop(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_STOP, 0, 0),BOOL
declare extern capCaptureStop alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_STOP),BOOL
'$define capCaptureAbort(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_ABORT, 0, 0)),BOOL
declare extern capCaptureAbort alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_ABORT),BOOL

'$define capCaptureSingleFrameOpen(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_SINGLE_FRAME_OPEN, 0, 0)),BOOL
declare extern capCaptureSingleFrameOpen alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_SINGLE_FRAME_OPEN),BOOL
'$define capCaptureSingleFrameClose(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_SINGLE_FRAME_CLOSE, 0, 0),BOOL
declare extern capCaptureSingleFrameClose alias SendMessage_HM_A(HWND hwnd, opt int msg=WM_CAP_SINGLE_FRAME_CLOSE),BOOL
'$define capCaptureSingleFrame(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_SINGLE_FRAME, 0, 0),BOOL

'$define capCaptureGetSetup(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_GET_SEQUENCE_SETUP, wSize,pointer s),BOOL
'$define capCaptureSetSetup(HWND hwnd, s, wSize)	(AVICapSM(HWND hwnd, WM_CAP_SET_SEQUENCE_SETUP, wSize,pointer s),BOOL

'$define capSetMCIDeviceName(HWND hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_SET_MCI_DEVICE, 0, LPTSTR szName),BOOL
'$define capGetMCIDeviceName(HWND hwnd, szName, wSize)	(AVICapSM(HWND hwnd, WM_CAP_GET_MCI_DEVICE, wSize, LPTSTR szName),BOOL

'$define capPaletteOpen(HWND hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_PAL_OPEN, 0, LPTSTR szName),BOOL
'$define capPaletteSave(HWND hwnd, szName)	(AVICapSM(HWND hwnd, WM_CAP_PAL_SAVE, 0, LPTSTR szName),BOOL
'$define capPalettePaste(hwnd)	(AVICapSM(HWND hwnd, WM_CAP_PAL_PASTE, 0, 0),BOOL
'$define capPaletteAuto(HWND hwnd, iFrames, iColors)	(AVICapSM(HWND hwnd, WM_CAP_PAL_AUTOCREATE,(WPARAM)(iFrames),(LPARAM)(DWORD)(iColors))),BOOL
'$define capPaletteManual(HWND hwnd, fGrab, iColors)	(AVICapSM(HWND hwnd, WM_CAP_PAL_MANUALCREATE,(WPARAM)(fGrab),(LPARAM)(DWORD)(iColors))),BOOL

' ------------------------------------------------------------------
'	Structures
' ------------------------------------------------------------------

type CAPDRIVERCAPS
	UINT	wDeviceIndex	' Driver index system.ini
	BOOL	fHasOverlay	' Can device overlay?
	BOOL	fHasDlgVideoSource	' Has Video source dlg?
	BOOL	fHasDlgVideoFormat	' Has Format dlg?
	BOOL	fHasDlgVideoDisplay	' Has External dlg?
	BOOL	fCaptureInitialized	' Driver ready to capture?
	BOOL	fDriverSuppliesPalettes	' Can driver make palettes?

' following always NULL on Win32.
	HANDLE	hVideoIn	' Driver channel
	HANDLE	hVideoOut	' Driver channel
	HANDLE	hVideoExtIn	' Driver Ext channel
	HANDLE	hVideoExtOut	' Driver Ext channel
endtype

type CAPSTATUS
	UINT	uiImageWidth	' Width of the image
	UINT	uiImageHeight	' Height of the image
	BOOL	fLiveWindow	' Now Previewing video?
	BOOL	fOverlayWindow	' Now Overlaying video?
	BOOL	fScale	' Scale image to client?
	POINT	ptScroll	' Scroll position
	BOOL	fUsingDefaultPalette	' Using default driver palette?
	BOOL	fAudioHardware	' Audio hardware present?
	BOOL	fCapFileExists	' Does capture file exist?
	DWORD	dwCurrentVideoFrame	' # of video frames cap'td
	DWORD	dwCurrentVideoFramesDropped' # of video frames dropped
	DWORD	dwCurrentWaveSamples	' # of wave samples cap'td
	DWORD	dwCurrentTimeElapsedMS	' Elapsed capture duration
	HPALETTE	hPalCurrent	' Current palette use
	BOOL	fCapturingNow	' Capture progress?
	DWORD	dwReturn	' Error value after any operation
	UINT	wNumVideoAllocated	' Actual number of video buffers
	UINT	wNumAudioAllocated	' Actual number of audio buffers
endtype

		' Default values parenthesis
type CAPTUREPARMS
	DWORD	dwRequestMicroSecPerFrame	' Requested capture rate
	BOOL	fMakeUserHitOKToCapture	' Show "Hit OK to cap" dlg?
	UINT	wPercentDropForError	' Give error msg if >(10%)
	BOOL	fYield	' Capture via background task?
	DWORD	dwIndexSize	' Max index size frames(32K)
	UINT	wChunkGranularity	' Junk chunk granularity(2K)
	BOOL	fUsingDOSMemory	' Use DOS buffers?
	UINT	wNumVideoRequested	' # video buffers, If 0, autocalc
	BOOL	fCaptureAudio	' Capture audio?
	UINT	wNumAudioRequested	' # audio buffers, If 0, autocalc
	UINT	vKeyAbort	' Virtual key causing abort
	BOOL	fAbortLeftMouse	' Abort on left mouse?
	BOOL	fAbortRightMouse	' Abort on right mouse?
	BOOL	fLimitEnabled	' Use wTimeLimit?
	UINT	wTimeLimit	' Seconds to capture
	BOOL	fMCIControl	' Use MCI video source?
	BOOL	fStepMCIDevice	' Step MCI device?
	DWORD	dwMCIStartTime	' Time to start MS
	DWORD	dwMCIStopTime	' Time to stop MS
	BOOL	fStepCaptureAt2x	' Perform spatial averaging 2x
	UINT	wStepCaptureAverageFrames	' Temporal average n Frames
	DWORD	dwAudioBufferSize	' Size of audio bufs(0 = default)
	BOOL	fDisableWriteCache	' Attempt to disable write cache
	UINT	AVStreamMaster	' Which stream controls length?
endtype

' ------------------------------------------------------------------
'	AVStreamMaster
'	Since Audio and Video streams generally use non-synchronized capture
'	clocks, this flag determines whether the audio stream is to be considered
'	the master or controlling clock when writing the AVI file:
'	AVSTREAMMASTER_AUDIO	- Audio is master, video frame duration is forced
'	to match audio duration(VFW 1.0, 1.1 default)
'	AVSTREAMMASTER_NONE	- No master, audio and video streams may be of
'	different lengths
' ------------------------------------------------------------------
$define AVSTREAMMASTER_AUDIO	0 /* Audio master(VFW 1.0, 1.1)*/
$define AVSTREAMMASTER_NONE	1 /* No master */

type CAPINFOCHUNK
	FOURCC	fccInfoID	' Chunk ID, "ICOP" for copyright
	LPVOID	lpData	' pointer to data
	LONG	cbData	' size of lpData
endtype

' ------------------------------------------------------------------
'	Callback Definitions
' ------------------------------------------------------------------

typedef CAPYIELDCALLBACK int'(CALLBACK* CAPYIELDCALLBACK)	(HWND hWnd),LRESULT
typedef CAPSTATUSCALLBACKW int'(CALLBACK* CAPSTATUSCALLBACKW)(HWND hWnd, int nID, LPCWSTR lpsz),LRESULT
typedef CAPERRORCALLBACKW int'(CALLBACK* CAPERRORCALLBACKW)	(HWND hWnd, int nID, LPCWSTR lpsz),LRESULT
typedef CAPSTATUSCALLBACK int'(CALLBACK* CAPSTATUSCALLBACK)(HWND hWnd, int nID, LPCSTR lpsz),LRESULT
typedef CAPERRORCALLBACK int'(CALLBACK* CAPERRORCALLBACK)	(HWND hWnd, int nID, LPCSTR lpsz),LRESULT
typedef CAPVIDEOCALLBACK int'(CALLBACK* CAPVIDEOCALLBACK)	(HWND hWnd,pointer lpVHdr),LRESULT
typedef CAPWAVECALLBACK int'(CALLBACK* CAPWAVECALLBACK)	(HWND hWnd, LPWAVEHDR lpWHdr),LRESULT
typedef CAPCONTROLCALLBACK int'(CALLBACK* CAPCONTROLCALLBACK)(HWND hWnd, int nState),LRESULT

' ------------------------------------------------------------------
'	CapControlCallback states
' ------------------------------------------------------------------
$define CONTROLCALLBACK_PREROLL	1 /* Waiting to start capture */
$define CONTROLCALLBACK_CAPTURING	2 /* Now capturing */

' ------------------------------------------------------------------
'	The only exported functions from AVICAP.DLL
' ------------------------------------------------------------------

declare import, capCreateCaptureWindowA(LPCSTR lpszWindowName,DWORD dwStyle,int x, int y, int nWidth, int nHeight,HWND hwndParent, int nID),HWND
declare import, capCreateCaptureWindowW(LPCWSTR lpszWindowName,DWORD dwStyle,int x, int y, int nWidth, int nHeight,HWND hwndParent, int nID),HWND
declare import, capGetDriverDescriptionA(UINT wDriverIndex,LPSTR lpszName, int cbName,LPSTR lpszVer, int cbVer),BOOL
declare import, capGetDriverDescriptionW(UINT wDriverIndex,LPWSTR lpszName, int cbName,LPWSTR lpszVer, int cbVer),BOOL

$ifdef UNICODE
declare import, capCreateCaptureWindow alias capCreateCaptureWindowW(LPCWSTR lpszWindowName,DWORD dwStyle,int x, int y, int nWidth, int nHeight,HWND hwndParent, int nID),HWND
declare import, capGetDriverDescription alias capGetDriverDescriptionW(UINT wDriverIndex,LPWSTR lpszName, int cbName,LPWSTR lpszVer, int cbVer),BOOL
$else
declare import, capCreateCaptureWindow alias capCreateCaptureWindowA(LPCSTR lpszWindowName,DWORD dwStyle,int x, int y, int nWidth, int nHeight,HWND hwndParent, int nID),HWND
declare import, capGetDriverDescription alias capGetDriverDescriptionA(UINT wDriverIndex,LPSTR lpszName, int cbName,LPSTR lpszVer, int cbVer),BOOL
$endif

$endif
/* RC_INVOKED */

' ------------------------------------------------------------------
' New Information chunk IDs
' ------------------------------------------------------------------
$define infotypeDIGITIZATION_TIME	0x54494449'mmioFOURCC('I','D','I','T')
$define infotypeSMPTE_TIME	0x504d5349'mmioFOURCC('I','S','M','P')

' ------------------------------------------------------------------
' String IDs from status and error callbacks
' ------------------------------------------------------------------

$define IDS_CAP_BEGIN	300	/* "Capture Start" */
$define IDS_CAP_END	301	/* "Capture End" */

$define IDS_CAP_INFO	401	/* "%s" */
$define IDS_CAP_OUTOFMEM	402	/* "Out of memory" */
$define IDS_CAP_FILEEXISTS	403	/* "File '%s' exists -- overwrite it?" */
$define IDS_CAP_ERRORPALOPEN	404	/* "Error opening palette '%s'" */
$define IDS_CAP_ERRORPALSAVE	405	/* "Error saving palette '%s'" */
$define IDS_CAP_ERRORDIBSAVE	406	/* "Error saving frame '%s'" */
$define IDS_CAP_DEFAVIEXT	407	/* "avi" */
$define IDS_CAP_DEFPALEXT	408	/* "pal" */
$define IDS_CAP_CANTOPEN	409	/* "Cannot open '%s'" */
$define IDS_CAP_SEQ_MSGSTART	410	/* "Select OK to start capture\nof video sequence\nto %s." */
$define IDS_CAP_SEQ_MSGSTOP	411	/* "Hit ESCAPE or click to end capture" */

$define IDS_CAP_VIDEDITERR	412	/* "An error occurred while trying to run VidEdit." */
$define IDS_CAP_READONLYFILE	413	/* "The file '%s' is a read-only file." */
$define IDS_CAP_WRITEERROR	414	/* "Unable to write to file '%s'.\nDisk may be full." */
$define IDS_CAP_NODISKSPACE	415	/* "There is no space to create a capture file on the specified device." */
$define IDS_CAP_SETFILESIZE	416	/* "Set File Size" */
$define IDS_CAP_SAVEASPERCENT	417	/* "SaveAs: %2ld%%	Hit Escape to abort." */

$define IDS_CAP_DRIVER_ERROR	418	/* Driver specific error message */

$define IDS_CAP_WAVE_OPEN_ERROR	419	/* "Error: Cannot open the wave input device.\nCheck sample size, frequency, and channels." */
$define IDS_CAP_WAVE_ALLOC_ERROR	420	/* "Error: out of memory for wave buffers." */
$define IDS_CAP_WAVE_PREPARE_ERROR	421	/* "Error: Cannot prepare wave buffers." */
$define IDS_CAP_WAVE_ADD_ERROR	422	/* "Error: Cannot add wave buffers." */
$define IDS_CAP_WAVE_SIZE_ERROR	423	/* "Error: Bad wave size." */

$define IDS_CAP_VIDEO_OPEN_ERROR	424	/* "Error: Cannot open the video input device." */
$define IDS_CAP_VIDEO_ALLOC_ERROR	425	/* "Error: out of memory for video buffers." */
$define IDS_CAP_VIDEO_PREPARE_ERROR 426	/* "Error: Cannot prepare video buffers." */
$define IDS_CAP_VIDEO_ADD_ERROR	427	/* "Error: Cannot add video buffers." */
$define IDS_CAP_VIDEO_SIZE_ERROR	428	/* "Error: Bad video size." */

$define IDS_CAP_FILE_OPEN_ERROR	429	/* "Error: Cannot open capture file." */
$define IDS_CAP_FILE_WRITE_ERROR	430	/* "Error: Cannot write to capture file.	Disk may be full." */
$define IDS_CAP_RECORDING_ERROR	431	/* "Error: Cannot write to capture file.	Data rate too high or disk full." */
$define IDS_CAP_RECORDING_ERROR2	432	/* "Error while recording" */
$define IDS_CAP_AVI_INIT_ERROR	433	/* "Error: Unable to initialize for capture." */
$define IDS_CAP_NO_FRAME_CAP_ERROR	434	/* "Warning: No frames captured.\nConfirm that vertical sync interrupts\nare configured and enabled." */
$define IDS_CAP_NO_PALETTE_WARN	435	/* "Warning: Using default palette." */
$define IDS_CAP_MCI_CONTROL_ERROR	436	/* "Error: Unable to access MCI device." */
$define IDS_CAP_MCI_CANT_STEP_ERROR 437	/* "Error: Unable to step MCI device." */
$define IDS_CAP_NO_AUDIO_CAP_ERROR	438	/* "Error: No audio data captured.\nCheck audio card settings." */
$define IDS_CAP_AVI_DRAWDIB_ERROR	439	/* "Error: Unable to draw this data format." */
$define IDS_CAP_COMPRESSOR_ERROR	440	/* "Error: Unable to initialize compressor." */
$define IDS_CAP_AUDIO_DROP_ERROR	441	/* "Error: Audio data was lost during capture, reduce capture rate." */
$define IDS_CAP_AUDIO_DROP_COMPERROR 442	/* "Error: Audio data was lost during capture.	Try capturing without compressing." */

/* status string IDs */
$define IDS_CAP_STAT_LIVE_MODE	500	/* "Live window" */
$define IDS_CAP_STAT_OVERLAY_MODE	501	/* "Overlay window" */
$define IDS_CAP_STAT_CAP_INIT	502	/* "Setting up for capture - Please wait" */
$define IDS_CAP_STAT_CAP_FINI	503	/* "Finished capture, now writing frame %ld" */
$define IDS_CAP_STAT_PALETTE_BUILD	504	/* "Building palette map" */
$define IDS_CAP_STAT_OPTPAL_BUILD	505	/* "Computing optimal palette" */
$define IDS_CAP_STAT_I_FRAMES	506	/* "%d frames" */
$define IDS_CAP_STAT_L_FRAMES	507	/* "%ld frames" */
$define IDS_CAP_STAT_CAP_L_FRAMES	508	/* "Captured %ld frames" */
$define IDS_CAP_STAT_CAP_AUDIO	509	/* "Capturing audio" */
$define IDS_CAP_STAT_VIDEOCURRENT	510	/* "Captured %ld frames(%ld dropped)%d.%03d sec." */
$define IDS_CAP_STAT_VIDEOAUDIO	511	/* "Captured %d.%03d sec.	%ld frames(%ld dropped)(%d.%03d fps).	%ld audio bytes(%d,%03d sps)" */
$define IDS_CAP_STAT_VIDEOONLY	512	/* "Captured %d.%03d sec.	%ld frames(%ld dropped)(%d.%03d fps)" */
$define IDS_CAP_STAT_FRAMESDROPPED	513	/* "Dropped %ld of %ld frames(%d.%02d%%)during capture." */
$endif
/* NOAVIFILE */

/**************************************
*
*	ACM(Audio compression manager)
*
* *************************************/

$ifndef NOMSACM
	$ifndef __msacm_inc__
	$include "msacm.inc"
	$endif
$endif

/**************************************
*
*	FilePreview dialog.
*
* *************************************/
$ifdef OFN_READONLY

declare import,GetOpenFileNamePreviewA(pointer lpofn),BOOL
declare import,GetOpenFileNamePreviewW(pointer lpofn),BOOL
declare import,GetSaveFileNamePreviewA(pointer lpofn),BOOL
declare import,GetSaveFileNamePreviewW(pointer lpofn),BOOL

$ifdef UNICODE
declare import,GetOpenFileNamePreview alias GetOpenFileNamePreviewW(pointer lpofn),BOOL
declare import,GetSaveFileNamePreview alias GetSaveFileNamePreviewW(pointer lpofn),BOOL
$else
declare import,GetOpenFileNamePreview alias GetOpenFileNamePreviewA(pointer lpofn),BOOL
declare import,GetSaveFileNamePreview alias GetSaveFileNamePreviewA(pointer lpofn),BOOL
$endif

$endif

$ifndef RC_INVOKED
$include "poppack.inc"
$endif

$endif
/* _INC_VFW */
