/****************************************************************************
 *  Catfood Software RLIB.DLL - MButton Module                              *
 *                                                                          *
 *  This module allows the creation of a MButton control from a Static      *
 *  control. A MButton control acts like a "roll-over" button on a web page *
 *  which displays one image when inactive, a second image when the cursor  *
 *  is over the button and a third when the button is clicked on. If the    *
 *  button is clicked a WM_COMMAND message is sent to a nominated window.   *
 ****************************************************************************
 *  (c)Copyright 1997-1998 Catfood Software. This software may be used      *
 *  without charge provided that Catfood Software is credited in your about *
 *  box or splash screen including the Catfood URL: http://www.catfood.net/ *
 *  While every effort has been made to ensure that RLIB is free from       *
 *  defects you may not use this software without accepting that Catfood    *
 *  Software is indemnified from all liabilities resulting from the use of  *
 *  RLIB.                                                                   *
 ****************************************************************************
 *  Ver   Date        Who  Description                                      *
 *  1.00  06-07-1998  RDE  First RLIB version                               *
 ****************************************************************************/

#ifndef _MBUTTON_H
#define _MBUTTON_H

#ifdef __cplusplus
extern "C" {            // C declarations for C++
#endif	// __cplusplus 

/****************************************************************************
 *  Function               Summary                                 Ordinal  *
 ****************************************************************************
 *  MButtonSubclassStatic  Subclass a Static control creating a    @9       *                       
 *                         MButton control                                  *
 ****************************************************************************/


/****************************************************************************
 *  MBUTTON_DATA                                                            *
 ****************************************************************************
 *  Description:  Structure used to pass data to the MButtonSubclassStatic  *
 *                function.                                                 *
 *                                                                          *
 *  Members:      dwSize        Size of this structure                      *
 *                hStatic       HWND of the Static control to subclass      *
 *                hInstRes      HINSTANCE to use when loading resources     *
 *                dwImageOff    Image Resource ID to display normally       *
 *                dwImageOn     Image Resource ID to display when the       *
 *                              cursor is over the button                   *
 *                dwImageClick  Image Resource ID to display when clicked   *
 *                crTrans       Transparant colour                          *
 *                bTrans        Enable transparency                         *
 *                hWndTarget    Window to send command to when button is    *
 *                              clicked                                     *
 *                dwCommand     Command to send to hWndTarget               *
 ****************************************************************************/

typedef struct tagMBUTTON_DATA
{
	DWORD		dwSize;
	HWND		hStatic;
	HINSTANCE	hInstRes;
	DWORD		dwImageOff;
	DWORD		dwImageOn;
	DWORD		dwImageClick;
	COLORREF	crTrans;
	BOOL		bTrans;
	HWND		hWndTarget;
	DWORD		dwCommand;
} MBUTTON_DATA, *PMBUTTON_DATA;


/****************************************************************************
 *  MButtonSubclassStatic                                                   *
 ****************************************************************************
 *  Description:  Subclass a Static control to make a MButton control. The  *
 *                Static control must have the "Notify" style set. If the   *
 *                control is a tab stop then the "On" image will be used to *
 *                indicate that the window has focus                        *
 *                                                                          *
 *  Parameters:   pmbd  MBUTTON_DATA structure - see above for member       *
 *                                                                          *
 *  Returns:      BOOL  TRUE for success                                    *
 *                      FALSE for failure                                   *
 ****************************************************************************/

BOOL MButtonSubclassStatic(PMBUTTON_DATA pmbd);

#ifdef __cplusplus
}
#endif	// __cplusplus

#endif // _MBUTTON_H

