/****************************************************************************
 *  Catfood Software RLIB.DLL - Hyperlink Module                            *
 *                                                                          *
 *  This module allows the creation of a Hyperlink control from a Static    *
 *  control. The Hyperlink uses the text property of the Static control as  *
 *  the URL. The URL is blue and underlined. When the cursor is over the    *
 *  URL it is changed to a hand. If the user left-clicks the control then   *
 *  the default browser is launched to load the URL.                        *
 ****************************************************************************
 *  (c)Copyright 1997-1998 Catfood Software. This software may be used      *
 *  without charge provided that Catfood Software is credited in your about *
 *  box or splash screen including the Catfood URL: http://www.catfood.net/ *
 *  While every effort has been made to ensure that RLIB is free from       *
 *  defects you may not use this software without accepting that Catfood    *
 *  Software is indemnified from all liabilities resulting from the use of  *
 *  RLIB.                                                                   *
 ****************************************************************************
 *  Ver   Date        Who  Description                                      *
 *  1.00  29-06-1998  RDE  First RLIB version                               *
 ****************************************************************************/

#ifndef _HYPERLINK_H
#define _HYPERLINK_H

#ifdef __cplusplus
extern "C" {            // C declarations for C++
#endif	// __cplusplus 

/****************************************************************************
 *  Function                 Summary                               Ordinal  *
 ****************************************************************************
 *  HyperlinkSubclassStatic  Subclass a Static control creating    @1       *                       
 *                           a Hyperlink control                            *
 ****************************************************************************/


/****************************************************************************
 *  HyperlinkSubclassStatic                                                 *
 ****************************************************************************
 *  Description:  Subclass a Static control to make a Hyperlink control.    *
 *                The Static control must have the "Notify" style set. The  *
 *                text property of the control is used for the URL.         *
 *                                                                          *
 *  Parameters:   hStatic  HWND of the Static control to subclass           *
 *                                                                          *
 *  Returns:      BOOL     TRUE for success                                 *
 *                         FALSE for failure                                *
 ****************************************************************************/

BOOL HyperlinkSubclassStatic(HWND hStatic);



#ifdef __cplusplus
}
#endif	// __cplusplus

#endif // _HYPERLINK_H

