/****************************************************************************
 *  Catfood Software RLIB.DLL - GDIMagic Module                             *
 *                                                                          *
 *  This module contains some GDI functions to perform transparant BitBlt   *
 *  and StretchBlt.                                                         *
 ****************************************************************************
 *  (c)Copyright 1997-1998 Catfood Software. This software may be used      *
 *  without charge provided that Catfood Software is credited in your about *
 *  box or splash screen including the Catfood URL: http://www.catfood.net/ *
 *  While every effort has been made to ensure that RLIB is free from       *
 *  defects you may not use this software without accepting that Catfood    *
 *  Software is indemnified from all liabilities resulting from the use of  *
 *  RLIB.                                                                   *
 ****************************************************************************
 *  Ver   Date        Who  Description                                      *
 *  1.00  08-07-1998  RDE  First version                                    *
 ****************************************************************************/

#ifndef _GDIMAGIC_H
#define _GDIMAGIC_H

#ifdef __cplusplus
extern "C" {            // C declarations for C++
#endif	// __cplusplus 

/****************************************************************************
 *  Function     Summary                                           Ordinal  *
 ****************************************************************************
 *  TBitBlt      Transparent BitBlt                                @10      *
 *  TStretchBlt  Transparent StretchBlt                            @11      *
 ****************************************************************************/


/****************************************************************************
 *  TBitBlt                                                                 *
 ****************************************************************************
 *  Description:  Transparent BitBlt                                        *
 *                                                                          *
 *  Parameters:   Same as Win32 BitBlt except crTrans, the transparent      *
 *                colour in the source bitmap.                              *
 *                                                                          *
 *  Returns:      BOOL     TRUE for success                                 *
 *                         FALSE for failure                                *
 ****************************************************************************/

BOOL TBitBlt (
	HDC hdcDest,
	int nXDest,
	int nYDest,
	int nWidth,
	int nHeight,
	HDC hdcSrc,
	int nXSrc,
	int nYSrc,
	COLORREF crTrans
);


/****************************************************************************
 *  TStretchBlt                                                             *
 ****************************************************************************
 *  Description:  Transparent StretchBlt                                    *
 *                                                                          *
 *  Parameters:   Same as Win32 StretchBlt except crTrans, the transparent  *
 *                colour in the source bitmap.                              *
 *                                                                          *
 *  Returns:      BOOL     TRUE for success                                 *
 *                         FALSE for failure                                *
 ****************************************************************************/

BOOL TStretchBlt (
	HDC hdcDest,
	int nXOriginDest,
	int nYOriginDest,
	int nWidthDest,
	int nHeightDest,
	HDC hdcSrc,
	int nXOriginSrc,
	int nYOriginSrc,
	int nWidthSrc,
	int nHeightSrc,
	COLORREF crTrans
);


#ifdef __cplusplus
}
#endif	// __cplusplus

#endif // _GDIMAGIC_H

