/****************************************************************************
 *  Catfood Software RLIB.DLL - AClock Module                               *
 *                                                                          *
 *  This module subclasses a static control and creates an analog clock.    *
 ****************************************************************************
 *  (c)Copyright 1997-1998 Catfood Software. This software may be used      *
 *  without charge provided that Catfood Software is credited in your about *
 *  box or splash screen including the Catfood URL: http://www.catfood.net/ *
 *  While every effort has been made to ensure that RLIB is free from       *
 *  defects you may not use this software without accepting that Catfood    *
 *  Software is indemnified from all liabilities resulting from the use of  *
 *  RLIB.                                                                   *
 ****************************************************************************
 *  Ver   Date        Who  Description                                      *
 *  1.00  13-07-1998  RDE  First version                                    *
 ****************************************************************************/

#ifndef _ACLOCK_H
#define _ACLOCK_H

#ifdef __cplusplus
extern "C" {            // C declarations for C++
#endif	// __cplusplus 

/****************************************************************************
 *  Function               Summary                                 Ordinal  *
 ****************************************************************************
 *  AClockSubclassStatic   Subclass a Static control creating an   @12      *                       
 *                         analog clock control                             *
 ****************************************************************************/


/****************************************************************************
 *  ACLOCK_DATA                                                             *
 ****************************************************************************
 *  Description:  Structure used to pass data to the AClockSubclassStatic   *
 *                function.                                                 *
 *                                                                          *
 *  Members:      dwSize        Size of this structure                      *
 *                hStatic       HWND of the Static control to subclass      *
 *                crBack        Background colour                           *
 *                crFore        Foreground colour                           *
 *                uiUpdate      Update frequency in milliseconds            *
 *                fTZ           Time difference from GMT                    *
 ****************************************************************************/

typedef struct tagACLOCK_DATA
{
	DWORD		dwSize;
	HWND		hStatic;
	COLORREF	crBack;
	COLORREF	crFore;
	UINT		uiUpdate;
	float		fTZ;
} ACLOCK_DATA, *PACLOCK_DATA;


/****************************************************************************
 *  AClockSubclassStatic                                                    *
 ****************************************************************************
 *  Description:  Subclass a Static control to make an AClock control       *
 *                                                                          *
 *  Parameters:   pacd  ACLOCK_DATA structure - see above for members       *
 *                                                                          *
 *  Returns:      BOOL  TRUE for success                                    *
 *                      FALSE for failure                                   *
 ****************************************************************************/

BOOL AClockSubclassStatic(PACLOCK_DATA pacd);

#ifdef __cplusplus
}
#endif	// __cplusplus

#endif // _MBUTTON_H

