#include <commctrl.h>
#include <string.h>
#include <stdio.h>
#include <winspool.h>
#include <wchar.h>
#include <objbase.h>

#define PLATFORM_WIN32 0
#define PLATFORM_WIN32_WINDOWS 1
#define PLATFORM_WIN32_NT 2
#define PLATFORM_WIN32_CE 3

typedef struct driverInfo
{
DWORD version;
char printer[256];
char enviro[256];
char driver[256];
char data[256];
char config[256];
} driverData;

driverData dd2;
driverData * dd2Ptr;

typedef struct stringInfo
{
char rtnStg[256];
} stringData;

stringData sd;
stringData * sdPtr;

typedef struct pointInfo
{
long x;
long y;
} pointData;

pointData xy;
pointData * xyPtr;

typedef struct pi2Info
{
DWORD attrs;
DWORD priority;
DWORD dpriority;
DWORD startTime;
DWORD untilTime;
DWORD status;
DWORD jobs;
DWORD appm;
DWORD dmValid;
char server[256];
char printer[256];
char share[256];
char port[256];
char driver[256];
char comment[256];
char location[256];
char sepfile[256];
char processor[256];
char datatype[256];
char parameters[256];
} pi2Data;

pi2Data pi2;
pi2Data * pi2Ptr;

typedef struct devmInfo
{
WORD version;
WORD driverVersion;
WORD publicSize;
WORD privateSize;
DWORD fields;
DWORD dither;
short orientation;
short paperSize;
short paperLength;
short paperWidth;
short scale;
short copies;
short paperName;
short quality;
short color;
short duplex;
short ydpi;
short ttfont;
short collate;
char printer[32];
char formName[32];
} devmData;

devmData devm;
devmData * devmPtr;

typedef struct nwInfo
{
DWORD count;
DWORD attrs;
char printer[256];
char server[256];
} nwData;

nwData nw[30];
nwData * nwPtr;

typedef struct lpInfo
{
DWORD count;
DWORD attrs;
DWORD priority;
DWORD dpriority;
DWORD start;
DWORD until;
DWORD status;
DWORD jobs;
DWORD appm;
DWORD fields;
DWORD dither;
short orientation;
short paperSize;
short paperLength;
short paperWidth;
short scale;
short copies;
short source;
short quality;
short color;
short duplex;
short ydpi;
short ttfont;
short collate;
char printer[256];
char server[256];
char port[256];
char share[256];
char comment[256];
char location[256];
char driver[256];
char sepfile[256];
char processor[256];
char datatype[256];
char parameters[256];
char driverName[32];
char formName[32];
} lpData;

lpData lp[30];
lpData * lpPtr;

typedef struct ppInfo
{
DWORD count;
DWORD portType;
DWORD reserved;
char port[256];
char monitor[256];
char details[256];
} ppData;

ppData pp[30];
ppData * ppPtr;

extern int Printer_OpenDefault(DWORD);
extern int XPrinter_OpenDefault(DWORD,char *,char *,char *,char *,DEVMODE *,DWORD);
extern HDC Printer_CreatePDC(void);
extern HDC XPrinter_CreatePDC(char *,char *,char *,DEVMODE *);
extern HANDLE Printer_GetHandle(void);
extern int Printer_Pause(void);
extern int Printer_Resume(void);
extern int Printer_Purge(void);
extern int Printer_SetDefaultNT(char *);
extern int Printer_SetDefault98(char *);
extern int Printer_AddConnection(char *);
extern int Printer_DeleteConnection(char *);
extern HANDLE Dialog_Connection(HWND);
extern int Dialog_Port(char *,HWND,char *);
extern int Dialog_AdvancedProperties(HWND);
extern int Dialog_Properties(HWND,HANDLE);
extern int Dialog_PageSetup(int,HWND,int,int,long,long,long,long,int,long,long,long,long,int,long,long,int,int,int);
extern int Dialog_PrintSetup(int,HWND,WORD,WORD,WORD,WORD,int,int,int,int,int,int);
extern int Dialog_Print(int,HWND,WORD,WORD,WORD,WORD,int,int,int,int,int,int);
extern int Dialog_PropertySheet(int flag,HWND wndw,int measurement,int mo,long l1,long t1,long r1,long b1,int mmo,long l2,long t2,long r2,long b2,int po,long x,long y,int pbo,int oo,int wo);
extern HANDLE Printer_AddPrinter(char *,char *,char *,char *,char *);
extern int Printer_DeletePrinter(HANDLE);
extern int Printer_AddDriver(char *,DWORD,char *,char *,char *,char *,char *);
extern driverData * Printer_GetDriver(HANDLE,char *);
extern int Job_Pause(DWORD);
extern int Job_Resume(DWORD);
extern int Job_Delete(DWORD);
extern int Job_Restart(DWORD);
extern int Document_Open(char *,char *,char *);
extern int Page_New(void);
extern int Page_String(int,int,char *,int);
extern int Page_Clipboard(int,int);
extern int Page_Print(void);
extern int Document_Abort(void);
extern int Document_Close(void);
extern int RawDocument_Open(char *,char *,char *);
extern int RawPage_New(void);
extern int RawPage_Buffer(LPVOID,DWORD);
extern int RawPage_Clipboard(void);
extern int RawPage_Print(void);
extern int RawDocument_Close(void);
extern int Brush_CreateHatch(COLORREF,long);
extern int Brush_CreateSolid(COLORREF);
extern int Brush_CreateHollow(void);
extern void Brush_DeleteHatch(void);
extern void Brush_DeleteSolid(void);
extern void Brush_DeleteHollow(void);
extern int Font_Create(int,int,int,int,int,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,DWORD,char *);
extern void Font_Delete(void);
extern int Pen_Create(int,int,COLORREF);
extern int Pen_CreateSolid(int,COLORREF);
extern void Pen_Delete(void);
extern void Pen_DeleteSolid(void);
extern int Pen_UseDefined(int);
extern int Font_UseDefined(int);
extern int Brush_UseDefined(int);
extern void Pen_DeleteDefined(void);
extern void Font_DeleteDefined(void);
extern void Brush_DeleteDefined(void);
extern int Brush_CreateBMPattern(int,int,UINT,UINT,CONST VOID *);
extern void Brush_DeleteBMPattern(void);
extern int Draw_Ellipse(int left,int top,int right,int bottom);
extern int Draw_Rectangle(int left,int top,int right,int bottom);
extern int Draw_RoundRectangle(int,int,int,int,int,int);
extern int Draw_LineTo(int,int);
extern pointData * Draw_MoveCursorTo(int,int);
extern int Draw_PolyLine(CONST VOID *,int);
extern int Draw_PolyLineTo(CONST VOID *,int);
extern int Draw_FilledRectangle(long,long,long,long);
extern int Draw_Arc(int,int,int,int,int,int,int,int);
extern int Draw_ArcTo(int,int,int,int,int,int,int,int);
extern int Draw_AngleArc(int,int,DWORD,float,float);
extern int Draw_PolyBezier(CONST VOID *,int);
extern int Draw_PolyBezierTo(CONST VOID *,int);
extern int Draw_Border(int,int,int,int,UINT,UINT);
extern int Draw_Chord(int,int,int,int,int,int,int,int);
extern int Draw_FramedRectangle(int,int,int,int,HGDIOBJ);
extern int Draw_Pie(int,int,int,int,int,int,int,int);
extern int Draw_Bitmap(HDC,int,int,int,int,int,int,DWORD);
extern int Draw_ResizedBitmap(HDC,int,int,int,int,int,int,int,int,DWORD);
extern int Draw_PatternedBitmap(int,int,int,int,DWORD);
extern COLORREF BGColor_GetCurrentColor(void);
extern COLORREF BGColor_SetCurrentColor(COLORREF);
extern int BGMode_GetCurrentMode(void);
extern int BGMode_SetTransparentMode(void);
extern int BGMode_SetOpaqueMode(void);
extern int BGMode_SetCurrentMode(int);
extern int MapMode_SetCurrentMode(int);
extern int MapMode_GetCurrentMode(void);
extern DWORD MapperFlags_SetGetFlags(DWORD);
extern int GraphicsMode_SetCompatible(void);
extern int GraphicsMode_SetAdvanced(void);
extern int GraphicsMode_SetCurrentMode(int);
extern int ArcDirection_SetAntiClockwise(void);
extern int ArcDirection_SetClockwise(void);
extern int ArcDirection_GetDirection(void);
extern int PrintPaper_SetPortrait(int);
extern int PrintPaper_SetLandscape(int);
extern int PrintQuality_SetLow(int);
extern int PrintQuality_SetMedium(int);
extern int PrintQuality_SetHigh(int);
extern int PrintQuality_SetDraft(int);
extern int PrintColor_SetColor(int);
extern int PrintColor_SetBW(int);
extern int PrintDuplex_SetHorizontal(int);
extern int PrintDuplex_SetVertical(int);
extern int PrintDuplex_SetSimple(int);
extern int PrintTTFont_SetBitmap(int);
extern int PrintTTFont_SetDownload(int);
extern int PrintTTFont_SetSubstitute(int);
extern int PrintScale_SetHalfSize(int);
extern int PrintScale_SetSize(int,short);
extern int PrintCopies_SetSize(int,short);
extern int PrintPaper_SetWidth(int,short);
extern int PrintPaper_SetLength(int,short);
extern int PrintDPI_SetYResolution(int,short);
extern int PrintDPI_SetXResolution(int,short);
extern int PrintPaper_SetLetter(int);
extern int PrintPaper_SetLegal(int);
extern int PrintPaper_SetA4(int);
extern int PrintPaper_SetCSheet(int);
extern int PrintPaper_SetDSheet(int);
extern int PrintPaper_SetESheet(int);
extern int PrintPaper_SetLetterSmall(int);
extern int PrintPaper_SetTabloid(int);
extern int PrintPaper_SetLedger(int);
extern int PrintPaper_SetStatement(int);
extern int PrintPaper_SetExecutive(int);
extern int PrintPaper_SetA3(int);
extern int PrintPaper_SetA4Small(int);
extern int PrintPaper_SetA5(int);
extern int PrintPaper_SetB4(int);
extern int PrintPaper_SetB5(int);
extern int PrintPaper_SetFolio(int);
extern int PrintPaper_SetQuarto(int);
extern int PrintPaper_Set10x14(int);
extern int PrintPaper_Set11x17(int);
extern int PrintPaper_SetNote(int);
extern int PrintPaper_SetEnv9(int);
extern int PrintPaper_SetEnv10(int);
extern int PrintPaper_SetEnv11(int);
extern int PrintPaper_SetEnv12(int);
extern int PrintPaper_SetEnv14(int);
extern int PrintPaper_SetEnvDL(int);
extern int PrintPaper_SetEnvC5(int);
extern int PrintPaper_SetEnvC3(int);
extern int PrintPaper_SetEnvC4(int);
extern int PrintPaper_SetEnvC6(int);
extern int PrintPaper_SetEnvC65(int);
extern int PrintPaper_SetEnvB4(int);
extern int PrintPaper_SetEnvB5(int);
extern int PrintPaper_SetEnvB6(int);
extern int PrintPaper_SetItaly(int);
extern int PrintPaper_SetMonarch(int);
extern int PrintPaper_SetPersonal(int);
extern int PrintPaper_SetFFUS(int);
extern int PrintPaper_SetSFFGerman(int);
extern int PrintPaper_SetLFFGerman(int);
extern int PrintCollate_SetTrue(int);
extern int PrintCollate_SetFalse(int);
extern int PrintDither_SetNone(int);
extern int PrintDither_SetCoarse(int);
extern int PrintDither_SetFine(int);
extern int PrintDither_SetLineArt(int);
extern int PrintDither_SetGrayScale(int);
extern int PrintDevice_SetName(int,char *);
extern int PrintAttr_SetDefault(int);
extern int PrintAttr_SetDirect(int);
extern int PrintAttr_SetCompleteTest(int);
extern int PrintAttr_SetEnableBidi(int);
extern int PrintAttr_SetEnableDevQ(int);
extern int PrintAttr_SetKeepPrintedJobs(int);
extern int PrintAttr_SetQueued(int);
extern int PrintAttr_SetShared(int);
extern int PrintAttr_SetWorkOffline(int);
extern int PrintAttr_SetValue(int,DWORD);
extern int PrintPriority_SetValue(int,DWORD);
extern int PrintDefaultPriority_SetValue(int,DWORD);
extern int PrintStartTime_SetValue(int,DWORD);
extern int PrintUntilTime_SetValue(int,DWORD);
extern int PrintPrinter_SetName(int,char *);
extern int PrintShare_SetName(int,char *);
extern int PrintPort_SetName(int,char *);
extern int PrintDriver_SetName(int,char *);
extern int PrintComment_SetName(int,char *);
extern int PrintLocation_SetName(int,char *);
extern int PrintSepFile_SetName(int,char *);
extern int PrintProcessor_SetName(int,char *);
extern int PrintDatatype_SetName(int,char *);
extern int PrintParameters_SetName(int,char *);
extern short PrintPaper_GetValue(void);
extern short PrintQuality_GetValue(void);
extern short PrintColor_GetValue(void);
extern short PrintDuplex_GetValue(void);
extern short PrintTTFont_GetValue(void);
extern short PrintScale_GetValue(void);
extern short PrintCopies_GetValue(void);
extern short PrintPaperWidth_GetValue(void);
extern short PrintPaperLength_GetValue(void);
extern short PrintYDPI_GetValue(void);
extern short PrintSize_GetValue(void);
extern short PrintCollate_GetValue(void);
extern DWORD PrintDither_GetValue(void);
extern DWORD PrintAttr_GetValue(void);
extern DWORD PrintPriority_GetValue(void);
extern DWORD PrintDefaultPriority_GetValue(void);
extern DWORD PrintStartTime_GetValue(void);
extern DWORD PrintUntilTime_GetValue(void);
extern DWORD PrintStatus_GetValue(void);
extern DWORD PrintJobCount_GetValue(void);
extern DWORD PrintAveragePPM_GetValue(void);
extern stringData * PrintForm_GetName(void);
extern stringData * PrintDevice_GetName(void);
extern stringData * PrintPrinter_GetName(void);
extern stringData * PrintShare_GetName(void);
extern stringData * PrintPort_GetName(void);
extern stringData * PrintDriver_GetName(void);
extern stringData * PrintComment_GetName(void);
extern stringData * PrintLocation_GetName(void);
extern stringData * PrintSepFile_GetName(void);
extern stringData * PrintProcessor_GetName(void);
extern stringData * PrintDatatype_GetName(void);
extern stringData * PrintParameters_GetName(void);
extern pi2Data * PI2_GetAllInfo(void);
extern devmData * DM_GetAllInfo(void);
extern nwData * Enum_RegLocalPrinters(void);
extern lpData * Enum_LocalPrinters(void);
extern ppData * Enum_Ports(char *);
extern int XPrinter_DeletePDC(HANDLE);
extern int Printer_Close(HANDLE);
extern int Printer_CloseDefault(void);
extern int Get_WinVer(void);
extern int Dialog_ControlPanel(char *);

char * UnicodeToAnsi(OLECHAR *);

// PrinterDLL Internal Functions.
int Memory_Allocate(DWORD);
int Memory_Free(void);
int Printer_GetPI(void);
void Printer_FreePI(void);
int Set_DMValue(int,DWORD,short);
short Get_DMValue(DWORD);
int Set_DMDWValue(int,DWORD,DWORD);
DWORD Get_DMDWValue(DWORD);
int Set_PIDWValue(int,DWORD,DWORD);
int Set_PISTGValue(int,DWORD,char *);
int Printer_CreateDC(void);
int Printer_DeleteDC(void);
int Launch_CPL(char *);

static HINSTANCE hInstance;

HGLOBAL Memory_Handle;
char * Memory_LockPtr;
DWORD memSize=0;

PRINTER_INFO_2 *prt_pi=NULL;
DEVMODE *pDevMode=NULL;

JOB_INFO_2 job_i2[1000];
JOB_INFO_2 job2;
HDC prt_dc=NULL;
HANDLE prt_Handle=NULL;
HGDIOBJ *newHBrush;
HGDIOBJ *oldHBrush;
HGDIOBJ *newSBrush;
HGDIOBJ *oldSBrush;
HGDIOBJ *newFont;
HGDIOBJ *oldFont;
HGDIOBJ *newPen;
HGDIOBJ *oldPen;
HGDIOBJ *newSPen;
HGDIOBJ *oldSPen;
HGDIOBJ *newOPen;
HGDIOBJ *oldOPen;
HGDIOBJ *newOFont;
HGDIOBJ *oldOFont;
HGDIOBJ *newOBrush;
HGDIOBJ *oldOBrush;
HGDIOBJ *newPBrush;
HGDIOBJ *oldPBrush;
HGDIOBJ *newBMBrush;
HGDIOBJ *oldEBrush;
HGDIOBJ *newEBrush;

signed long rtn=0;
char prt_error=0,prt_opened=0;
char prt_name[50];
char port_name[50];
char driver_name[50];

int __declspec(dllexport) Printer_OpenDefault(DWORD mbSize)
{
PRINTER_DEFAULTS prt_defaults;
char stgbuf[120];
char *printer, *driver, *port;
if (SUCCEEDED(CoInitialize(NULL)))
{
Memory_Allocate(mbSize);
GetProfileString("windows","device",",,,",stgbuf,120);
if ((printer=strtok(stgbuf,(const char *) ",")) &&
    (driver=strtok((char *) NULL,(const char *) ", ")) &&
    (port=strtok((char *) NULL,(const char *) ", ")))
strcpy(prt_name,printer);
strcpy(port_name,port);
strcpy(driver_name,driver);
ZeroMemory(&prt_defaults,sizeof(prt_defaults));
prt_defaults.DesiredAccess=PRINTER_ALL_ACCESS;
if (OpenPrinter(prt_name,&prt_Handle,&prt_defaults))
{
prt_opened=1;
Printer_GetPI();
if (prt_pi)
{
Printer_CreateDC();
if (prt_dc)
return 3;
return 2;
}
return 1;
}
}
return 0;
}

int __declspec(dllexport) XPrinter_OpenDefault(DWORD mbSize,char * printer,char * port,char * driver,char * dtype,DEVMODE * dm,DWORD access)
{
PRINTER_DEFAULTS prt_defaults;
Memory_Allocate(mbSize);
strcpy(prt_name,printer);
strcpy(port_name,port);
strcpy(driver_name,driver);
ZeroMemory(&prt_defaults,sizeof(prt_defaults));
prt_defaults.pDatatype=dtype;
prt_defaults.pDevMode=dm;
prt_defaults.DesiredAccess=access;
if (OpenPrinter(prt_name,&prt_Handle,&prt_defaults))
{
prt_opened=1;
Printer_GetPI();
if (prt_pi)
return 2;
return 1;
}
return 0;
}

HDC __declspec(dllexport) Printer_CreatePDC(void)
{
HDC pdc_Handle=NULL;
pdc_Handle=CreateDC(prt_pi->pDriverName,prt_pi->pPrinterName,NULL,prt_pi->pDevMode);
if (pdc_Handle)
return pdc_Handle;
return NULL;
}

HDC __declspec(dllexport) XPrinter_CreatePDC(char * driver,char * printer,char * output,DEVMODE * dm)
{
HDC pdc_Handle=NULL;
if (strcmp(driver,"")==0)
driver=NULL;
if (strcmp(printer,"")==0)
printer=NULL;
if (strcmp(output,"")==0)
output=NULL;
pdc_Handle=CreateDC(driver,printer,output,dm);
if (pdc_Handle)
return pdc_Handle;
return NULL;
}

HANDLE __declspec(dllexport) Printer_GetHandle(void)
{
if (prt_Handle)
return prt_Handle;
return NULL;
}

int __declspec(dllexport) Printer_Pause(void)
{
if (prt_Handle)
{
if (SetPrinter(prt_Handle,0,0,PRINTER_CONTROL_PAUSE))
return 1;
}
return 0;
}

int __declspec(dllexport) Printer_Resume(void)
{
if (prt_Handle)
{
if (SetPrinter(prt_Handle,0,0,PRINTER_CONTROL_RESUME))
return 1;
}
return 0;
}

int __declspec(dllexport) Printer_Purge(void)
{
if (prt_Handle)
{
if (SetPrinter(prt_Handle,0,0,PRINTER_CONTROL_PURGE))
return 1;
}
return 0;
}

int __declspec(dllexport) Printer_AddConnection(char * printerName)
{
if (AddPrinterConnection(printerName))
return 1;
return 0;
}

int __declspec(dllexport) Printer_DeleteConnection(char * printerName)
{
if (DeletePrinterConnection(printerName))
return 1;
return 0;
}

HANDLE __declspec(dllexport) Dialog_Connection(HWND wndw)
{
Printer_DeleteDC();
HANDLE hPrinter=NULL;
hPrinter=ConnectToPrinterDlg(wndw,0);
Printer_CreateDC();
return hPrinter;
}

int __declspec(dllexport) Dialog_Port(char * serverName,HWND wndw,char * portName)
{
if (strcmp(serverName,"")==0)
serverName=NULL;
if (ConfigurePort(serverName,wndw,portName))
return 1;
return 0;
}

int __declspec(dllexport) Dialog_AdvancedProperties(HWND wndw)
{
int rv=0;
Printer_DeleteDC();
rtn=AdvancedDocumentProperties(wndw,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,prt_pi->pDevMode);
if (rtn==TRUE)
{
rv=1;
prt_pi->pSecurityDescriptor=NULL;
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=2;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=3;
}
}
Printer_CreateDC();
return rv;
}

int __declspec(dllexport) Dialog_Properties(HWND wndw,HANDLE hPrinter)
{
if (hPrinter)
return PrinterProperties(wndw,hPrinter);
return 0;
}

int __declspec(dllexport) Dialog_PageSetup(int flag,HWND wndw,int measurement,int mo,long l1,long t1,long r1,long b1,int mmo,long l2,long t2,long r2,long b2,int po,long x,long y,int pbo,int oo,int wo)
{
PAGESETUPDLG psd;
DEVNAMES *dnPtr=NULL;
LPDEVNAMES dnLock=NULL;
DEVMODE *dmPtr=NULL;
LPDEVMODE dmLock=NULL;
int rv=0;
Printer_DeleteDC();
ZeroMemory(&psd,sizeof(psd));
psd.lStructSize=sizeof(psd);
psd.hwndOwner=wndw;
psd.hDevMode=NULL;
psd.hDevNames=NULL;
psd.Flags=PSD_DEFAULTMINMARGINS;
if (measurement)
psd.Flags=psd.Flags|PSD_INTHOUSANDTHSOFINCHES;
else
psd.Flags=psd.Flags|PSD_INHUNDREDTHSOFMILLIMETERS;
if (mo==1)
psd.Flags=psd.Flags|PSD_MARGINS;
else if (mo==2)
psd.Flags=psd.Flags|PSD_DISABLEMARGINS;
if (mmo)
psd.Flags=psd.Flags|PSD_MINMARGINS;
if (po==0)
psd.Flags=psd.Flags|PSD_DISABLEPAPER;
if (pbo==0)
psd.Flags=psd.Flags|PSD_DISABLEPRINTER;
if (oo==0)
psd.Flags=psd.Flags|PSD_DISABLEORIENTATION;
if (wo==0)
psd.Flags=psd.Flags|PSD_NOWARNING;
psd.ptPaperSize.x=x;
psd.ptPaperSize.y=y;
psd.rtMinMargin.top=t2;
psd.rtMinMargin.left=l2;
psd.rtMinMargin.right=r2;
psd.rtMinMargin.bottom=b2;
psd.rtMargin.top=t1;
psd.rtMargin.left=l1;
psd.rtMargin.right=r1;
psd.rtMargin.bottom=b1;
if (PageSetupDlg(&psd)==TRUE)
{
dmPtr=psd.hDevMode;
dnPtr=psd.hDevNames;
if (dnPtr!=NULL)
{
dnLock=(LPDEVNAMES)GlobalLock(dnPtr);
if (dnLock!=NULL)
{
if (dmPtr!=NULL)
{
dmLock=(LPDEVMODE)GlobalLock(dmPtr);
if (dmLock!=NULL)
{
prt_dc=CreateDC((LPSTR)dnLock+dnLock->wDriverOffset,(LPSTR)dnLock+dnLock->wDeviceOffset,(LPSTR)dnLock+dnLock->wOutputOffset,dmLock);
if (prt_dc)
{
rv=1;
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,dmLock,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=2;
if (flag)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=3;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=4;
}
}
}
}
GlobalUnlock(dmPtr);
}
}
GlobalUnlock(dnPtr);
}
}
//if (dnPtr!=NULL)
//GlobalFree(dnPtr);
//if (dmPtr!=NULL)
//GlobalFree(dmPtr);
}
if (prt_dc==NULL)
Printer_CreateDC();
return rv;
}

int __declspec(dllexport) Dialog_PrintSetup(int flag,HWND wndw,WORD fp,WORD tp,WORD minp,WORD maxp,int fo,int po,int so,int wo,int pn,int ss)
{
PRINTDLG pd;
DEVNAMES *dnPtr=NULL;
LPDEVNAMES dnLock=NULL;
DEVMODE *dmPtr=NULL;
LPDEVMODE dmLock=NULL;
int rv=0;
Printer_DeleteDC();
ZeroMemory(&pd,sizeof(pd));
pd.lStructSize=sizeof(pd);
pd.hwndOwner=wndw;
pd.hDevMode=NULL;
pd.hDevNames=NULL;
pd.Flags=PD_ALLPAGES|PD_RETURNDC|PD_USEDEVMODECOPIESANDCOLLATE|PD_PRINTSETUP;
if (fo==0)
pd.Flags=pd.Flags|PD_HIDEPRINTTOFILE;
if (po==0)
pd.Flags=pd.Flags|PD_NOPAGENUMS;
if (so==0)
pd.Flags=pd.Flags|PD_NOSELECTION;
if (wo==0)
pd.Flags=pd.Flags|PD_NOWARNING;
if (pn)
pd.Flags=pd.Flags|PD_PAGENUMS;
if (ss)
pd.Flags=pd.Flags|PD_SELECTION;
pd.nFromPage=fp;
pd.nToPage=tp;
pd.nMinPage=minp;
pd.nMaxPage=maxp;
if ((pd.nFromPage<pd.nMinPage) || (pd.nFromPage>pd.nMaxPage))
pd.nFromPage=pd.nMinPage;
if ((pd.nToPage>pd.nMaxPage) || (pd.nToPage<pd.nMinPage))
pd.nToPage=pd.nMaxPage;
pd.nCopies=1;
if (PrintDlg(&pd)==TRUE)
{
dmPtr=pd.hDevMode;
dnPtr=pd.hDevNames;
if (dnPtr!=NULL)
{
dnLock=(LPDEVNAMES)GlobalLock(dnPtr);
if (dnLock!=NULL)
{
if (dmPtr!=NULL)
{
dmLock=(LPDEVMODE)GlobalLock(dmPtr);
if (dmLock!=NULL)
{
prt_dc=CreateDC((LPSTR)dnLock+dnLock->wDriverOffset,(LPSTR)dnLock+dnLock->wDeviceOffset,(LPSTR)dnLock+dnLock->wOutputOffset,dmLock);
if (prt_dc)
{
rv=1;
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,dmLock,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=2;
if (flag)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=3;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=4;
}
}
}
}
GlobalUnlock(dmPtr);
}
}
GlobalUnlock(dnPtr);
}
}
//if (dnPtr!=NULL)
//GlobalFree(dnPtr);
//if (dmPtr!=NULL)
//GlobalFree(dmPtr);
}
if (prt_dc==NULL)
Printer_CreateDC();
return rv;
}

int __declspec(dllexport) Dialog_Print(int flag,HWND wndw,WORD fp,WORD tp,WORD minp,WORD maxp,int fo,int po,int so,int wo,int pn,int ss)
{
PRINTDLG pd;
DEVNAMES *dnPtr=NULL;
LPDEVNAMES dnLock=NULL;
DEVMODE *dmPtr=NULL;
LPDEVMODE dmLock=NULL;
int rv=0;
Printer_DeleteDC();
ZeroMemory(&pd,sizeof(pd));
pd.lStructSize=sizeof(pd);
pd.hwndOwner=wndw;
pd.hDevMode=NULL;
pd.hDevNames=NULL;
pd.Flags=PD_ALLPAGES|PD_USEDEVMODECOPIESANDCOLLATE;
if (fo==0)
pd.Flags=pd.Flags|PD_HIDEPRINTTOFILE;
if (po==0)
pd.Flags=pd.Flags|PD_NOPAGENUMS;
if (so==0)
pd.Flags=pd.Flags|PD_NOSELECTION;
if (wo==0)
pd.Flags=pd.Flags|PD_NOWARNING;
if (pn)
pd.Flags=pd.Flags|PD_PAGENUMS;
if (ss)
pd.Flags=pd.Flags|PD_SELECTION;
pd.nFromPage=fp;
pd.nToPage=tp;
pd.nMinPage=minp;
pd.nMaxPage=maxp;
if ((pd.nFromPage<pd.nMinPage) || (pd.nFromPage>pd.nMaxPage))
pd.nFromPage=pd.nMinPage;
if ((pd.nToPage>pd.nMaxPage) || (pd.nToPage<pd.nMinPage))
pd.nToPage=pd.nMaxPage;
pd.nCopies=1;
if (PrintDlg(&pd)==TRUE)
{
dmPtr=pd.hDevMode;
dnPtr=pd.hDevNames;
if (dnPtr!=NULL)
{
dnLock=(LPDEVNAMES)GlobalLock(dnPtr);
if (dnLock!=NULL)
{
if (dmPtr!=NULL)
{
dmLock=(LPDEVMODE)GlobalLock(dmPtr);
if (dmLock!=NULL)
{
prt_dc=CreateDC((LPSTR)dnLock+dnLock->wDriverOffset,(LPSTR)dnLock+dnLock->wDeviceOffset,(LPSTR)dnLock+dnLock->wOutputOffset,dmLock);
if (prt_dc)
{
rv=1;
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,dmLock,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=2;
if (flag)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=3;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=4;
}
}
}
}
GlobalUnlock(dmPtr);
}
}
GlobalUnlock(dnPtr);
}
}
//if (dnPtr!=NULL)
//GlobalFree(dnPtr);
//if (dmPtr!=NULL)
//GlobalFree(dmPtr);
}
if (prt_dc==NULL)
Printer_CreateDC();
return rv;
}

int __declspec(dllexport) Dialog_PropertySheet(int flag,HWND wndw,int measurement,int mo,long l1,long t1,long r1,long b1,int mmo,long l2,long t2,long r2,long b2,int po,long x,long y,int pbo,int oo,int wo)
{
//LPPRINTDLGEX pPDX=NULL;
//LPPRINTPAGERANGE pPageRanges=NULL;
DEVNAMES *dnPtr=NULL;
LPDEVNAMES dnLock=NULL;
DEVMODE *dmPtr=NULL;
LPDEVMODE dmLock=NULL;
int rv=0;
Printer_DeleteDC();

Printer_CreateDC();
return rv;
}

HANDLE __declspec(dllexport) Printer_AddPrinter(char * serverName,char * printerName,char * portName,char * driverName,char * processorName)
{
PRINTER_INFO_2 *pi;
HANDLE hPrinter=NULL;
pi=(PRINTER_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,sizeof(PRINTER_INFO_2));
if (pi!=NULL)
{
if (strcmp(serverName,"")==0)
serverName=NULL;
pi[0].pPrinterName=printerName;
pi[0].pPortName=portName;
pi[0].pDriverName=driverName;
pi[0].pPrintProcessor=processorName;
hPrinter=AddPrinter(serverName,2,pi);
GlobalFree(pi);
}
return hPrinter;
}

int __declspec(dllexport) Printer_DeletePrinter(HANDLE hPrinter)
{
if (hPrinter)
{
if (DeletePrinter(hPrinter))
{
hPrinter=NULL;
return 1;
}
}
return 0;
}

int __declspec(dllexport) Printer_AddDriver(char * serverName,DWORD version,char * driverName,char * environment,char * driverPath,char * dataFile,char * configFile)
{
DRIVER_INFO_2 *di=NULL;
int rv=0;
di=(DRIVER_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,sizeof(DRIVER_INFO_2));
if (di!=NULL)
{
if (strcmp(serverName,"")==0)
serverName=NULL;
di->cVersion=version;
di->pName=driverName;
di->pEnvironment=environment;
di->pDriverPath=driverPath;
di->pDataFile=dataFile;
di->pConfigFile=configFile;
rv=2;
if (AddPrinterDriver(serverName,2,di))
rv=1;
GlobalFree(di);
}
return rv+GetLastError();
}

driverData * __declspec(dllexport) Printer_GetDriver(HANDLE hPrinter,char * environment)
{
DRIVER_INFO_2 *di=NULL;
int rv=0;
DWORD needed=0;
if (hPrinter)
{
if (strcmp(environment,"")==0)
environment=NULL;
rtn=GetPrinterDriver(hPrinter,NULL,2,0,0,&needed);
if (rtn==0)
{
rtn=GetLastError();
if (rtn==ERROR_INSUFFICIENT_BUFFER)
{
di=(DRIVER_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,needed);
if (di!=NULL)
{
if (GetPrinterDriver(hPrinter,environment,2,(LPBYTE)di,needed,&needed))
{
rv=1;
dd2.version=di->cVersion;
strcpy(dd2.printer,di->pName);
strcpy(dd2.enviro,di->pEnvironment);
strcpy(dd2.driver,di->pDriverPath);
strcpy(dd2.data,di->pDataFile);
strcpy(dd2.config,di->pConfigFile);
}
GlobalFree(di);
if (rv)
return &dd2;
}
}
}
}
return NULL;
}

int __declspec(dllexport) Job_Pause(DWORD jid)
{
if (prt_Handle)
{
if (SetJob(prt_Handle,jid,0,0,JOB_CONTROL_PAUSE))
return 1;
}
return 0;
}

int __declspec(dllexport) Job_Resume(DWORD jid)
{
if (prt_Handle)
{
if (SetJob(prt_Handle,jid,0,0,JOB_CONTROL_RESUME))
return 1;
}
return 0;
}

int __declspec(dllexport) Job_Delete(DWORD jid)
{
if (prt_Handle)
{
if (SetJob(prt_Handle,jid,0,0,JOB_CONTROL_CANCEL))
return 1;
}
return 0;
}

int __declspec(dllexport) Job_Restart(DWORD jid)
{
if (prt_Handle)
{
if (SetJob(prt_Handle,jid,0,0,JOB_CONTROL_RESTART))
return 1;
}
return 0;
}

int __declspec(dllexport) Document_Open(char * docName,char * outName,char * dtName)
{
DOCINFO docInfo;
int pjid=-1;
if ((prt_Handle) && (prt_dc))
{
docInfo.cbSize=sizeof(DOCINFO);
docInfo.lpszDocName=docName;
if (strcmp(outName,"")==0)
docInfo.lpszOutput=NULL;
else
docInfo.lpszOutput=outName;
docInfo.lpszDatatype=dtName;
docInfo.fwType=0;
pjid=StartDoc(prt_dc,&docInfo);
if (pjid>0)
return pjid;
}
return 0;
}

int __declspec(dllexport) Page_New(void)
{
if ((prt_Handle) && (prt_dc))
{
rtn=StartPage(prt_dc);
if (rtn>0)
return 1;
}
return 0;
}

int __declspec(dllexport) Page_String(int x,int y,char * buffer,int bufSize)
{
if ((prt_Handle) && (prt_dc))
{
rtn=TextOut(prt_dc,x,y,buffer,bufSize);
if (rtn)
return 1;
}
return 0;
}

int __declspec(dllexport) Page_Clipboard(int x,int y)
{
HANDLE get_Handle;
if ((prt_Handle) && (prt_dc))
{
if (OpenClipboard(NULL))
{
get_Handle=GetClipboardData(CF_TEXT);
if (get_Handle!=NULL)
{
if (strlen(get_Handle)<=memSize)
{
ZeroMemory(Memory_LockPtr,strlen(get_Handle));
CopyMemory(Memory_LockPtr,get_Handle,strlen(get_Handle));
}
else
{
ZeroMemory(Memory_LockPtr,memSize);
CopyMemory(Memory_LockPtr,get_Handle,memSize);
}
}
CloseClipboard();
}
if (strlen(get_Handle)<=memSize)
rtn=TextOut(prt_dc,x,y,Memory_LockPtr,strlen(get_Handle));
else
rtn=TextOut(prt_dc,x,y,Memory_LockPtr,memSize);
if (rtn)
return 1;
}
return 0;
}

int __declspec(dllexport) Page_Print(void)
{
if ((prt_Handle) && (prt_dc))
{
rtn=EndPage(prt_dc);
if (rtn>0)
return 1;
}
return 0;
}

int __declspec(dllexport) Document_Abort(void)
{
if ((prt_Handle) && (prt_dc))
{
rtn=AbortDoc(prt_dc);
if ((rtn!=SP_ERROR) && (rtn>0))
return 1;
}
return 0;
}

int __declspec(dllexport) Document_Close(void)
{
if ((prt_Handle) && (prt_dc))
{
rtn=EndDoc(prt_dc);
if (rtn>0)
return 1;
}
return 0;
}

int __declspec(dllexport) RawDocument_Open(char * docName,char * outName,char * dtName)
{
DOC_INFO_1 docInfo1;
int pjid=-1;
if (prt_Handle)
{
docInfo1.pDocName=docName;
if (strcmp(outName,"")==0)
docInfo1.pOutputFile=NULL;
else
docInfo1.pOutputFile=outName;
docInfo1.pDatatype=dtName;
pjid=StartDocPrinter(prt_Handle,1,&docInfo1);
if (pjid)
return pjid;
}
return 0;
}

int __declspec(dllexport) RawPage_New(void)
{
if (prt_Handle)
{
rtn=StartPagePrinter(prt_Handle);
if (rtn)
return 1;
}
return 0;
}

int __declspec(dllexport) RawPage_Buffer(LPVOID buffer,DWORD bufSize)
{
DWORD bw;
if (prt_Handle)
{
rtn=WritePrinter(prt_Handle,buffer,bufSize,&bw);
if (rtn)
return bw;
}
return 0;
}

int __declspec(dllexport) RawPage_Clipboard(void)
{
HANDLE get_Handle;
DWORD bw;
if (prt_Handle)
{
if (OpenClipboard(NULL))
{
get_Handle=GetClipboardData(CF_TEXT);
if (get_Handle!=NULL)
{
if (strlen(get_Handle)<=memSize)
{
ZeroMemory(Memory_LockPtr,strlen(get_Handle));
CopyMemory(Memory_LockPtr,get_Handle,strlen(get_Handle));
}
else
{
ZeroMemory(Memory_LockPtr,memSize);
CopyMemory(Memory_LockPtr,get_Handle,memSize);
}
}
CloseClipboard();
}
if (strlen(get_Handle)<=memSize)
rtn=WritePrinter(prt_Handle,Memory_LockPtr,strlen(get_Handle),&bw);
else
rtn=WritePrinter(prt_Handle,Memory_LockPtr,memSize,&bw);
if (rtn)
return bw;
}
return 0;
}

int __declspec(dllexport) RawPage_Print(void)
{
if (prt_Handle)
{
rtn=EndPagePrinter(prt_Handle);
if (rtn)
return 1;
}
return 0;
}

int __declspec(dllexport) RawDocument_Close(void)
{
if (prt_Handle)
{
rtn=EndDocPrinter(prt_Handle);
if (rtn)
return 1;
}
return 0;
}

int __declspec(dllexport) Brush_CreateHatch(COLORREF colour,long hstyle)
{
LOGBRUSH lb;
lb.lbStyle=BS_HATCHED;
lb.lbColor=colour;
lb.lbHatch=hstyle;
if ((prt_Handle) && (prt_dc))
{
newHBrush=CreateBrushIndirect(&lb);
if (newHBrush!=NULL)
{
oldHBrush=SelectObject(prt_dc,newHBrush);
if (oldHBrush!=NULL)
return 1;
}
}
return 0;
}

int __declspec(dllexport) Brush_CreateHollow(void)
{
LOGBRUSH lb;
lb.lbStyle=BS_HOLLOW;
lb.lbColor=0;
lb.lbHatch=0;
if ((prt_Handle) && (prt_dc))
{
newEBrush=CreateBrushIndirect(&lb);
if (newEBrush!=NULL)
{
oldEBrush=SelectObject(prt_dc,newEBrush);
if (oldEBrush!=NULL)
return 1;
}
}
return 0;
}

int __declspec(dllexport) Brush_CreateSolid(COLORREF colour)
{
if ((prt_Handle) && (prt_dc))
{
newSBrush=CreateSolidBrush(colour);
if (newSBrush!=NULL)
{
oldSBrush=SelectObject(prt_dc,newSBrush);
if (oldSBrush!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Brush_DeleteHatch(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldHBrush!=NULL)
{
SelectObject(prt_dc,oldHBrush);
oldHBrush=NULL;
}
if (newHBrush!=NULL)
{
if (DeleteObject(newHBrush))
newHBrush=NULL;
}
}
}

void __declspec(dllexport) Brush_DeleteSolid(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldSBrush!=NULL)
{
SelectObject(prt_dc,oldSBrush);
oldSBrush=NULL;
}
if (newSBrush!=NULL)
{
if (DeleteObject(newSBrush))
newSBrush=NULL;
}
}
}

void __declspec(dllexport) Brush_DeleteHollow(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldEBrush!=NULL)
{
SelectObject(prt_dc,oldEBrush);
oldEBrush=NULL;
}
if (newEBrush!=NULL)
{
if (DeleteObject(newEBrush))
newEBrush=NULL;
}
}
}

int __declspec(dllexport) Font_Create(int h,int w,int esc,int ori,int weight,DWORD ita,DWORD unl,DWORD strike,DWORD cs,DWORD op,DWORD cp,DWORD quality,DWORD pitch,char *fontName)
{
int hsize=0,wsize=0;
if ((prt_Handle) && (prt_dc))
{
hsize=-MulDiv(h,GetDeviceCaps(prt_dc,LOGPIXELSX),72);
wsize=-MulDiv(w,GetDeviceCaps(prt_dc,LOGPIXELSY),72);
newFont=CreateFont(hsize,wsize,esc,ori,weight,ita,unl,strike,cs,op,cp,quality,pitch,fontName);
if (newFont!=NULL)
{
oldFont=SelectObject(prt_dc,newFont);
if (oldFont!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Font_Delete(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldFont!=NULL)
{
SelectObject(prt_dc,oldFont);
oldFont=NULL;
}
if (newFont!=NULL)
{
if (DeleteObject(newFont))
newFont=NULL;
}
}
}

int __declspec(dllexport) Pen_Create(int style,int width,COLORREF colour)
{
if ((prt_Handle) && (prt_dc))
{
newPen=CreatePen(style,width,colour);
if (newPen!=NULL)
{
oldPen=SelectObject(prt_dc,newPen);
if (oldPen!=NULL)
return 1;
}
}
return 0;
}

int __declspec(dllexport) Pen_CreateSolid(int width,COLORREF colour)
{
if ((prt_Handle) && (prt_dc))
{
newSPen=CreatePen(PS_SOLID,width,colour);
if (newSPen!=NULL)
{
oldSPen=SelectObject(prt_dc,newSPen);
if (oldSPen!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Pen_Delete(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldPen!=NULL)
{
SelectObject(prt_dc,oldPen);
oldPen=NULL;
}
if (newPen!=NULL)
{
if (DeleteObject(newPen))
newPen=NULL;
}
}
}

void __declspec(dllexport) Pen_DeleteSolid(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldSPen!=NULL)
{
SelectObject(prt_dc,oldSPen);
oldSPen=NULL;
}
if (newSPen!=NULL)
{
if (DeleteObject(newSPen))
newSPen=NULL;
}
}
}

int __declspec(dllexport) Pen_UseDefined(int obj)
{
if ((prt_Handle) && (prt_dc))
{
newOPen=GetStockObject(obj);
if (newOPen!=NULL)
{
oldOPen=SelectObject(prt_dc,newOPen);
if (oldOPen!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Pen_DeleteDefined(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldOPen!=NULL)
{
SelectObject(prt_dc,oldOPen);
oldOPen=NULL;
}
if (newOPen!=NULL)
{
if (DeleteObject(newOPen))
newOPen=NULL;
}
}
}

int __declspec(dllexport) Font_UseDefined(int obj)
{
if ((prt_Handle) && (prt_dc))
{
newOFont=GetStockObject(obj);
if (newOFont!=NULL)
{
oldOFont=SelectObject(prt_dc,newOFont);
if (oldOFont!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Font_DeleteDefined(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldOFont!=NULL)
{
SelectObject(prt_dc,oldOFont);
oldOFont=NULL;
}
if (newOFont!=NULL)
{
if (DeleteObject(newOFont))
newOFont=NULL;
}
}
}

int __declspec(dllexport) Brush_UseDefined(int obj)
{
if ((prt_Handle) && (prt_dc))
{
newOBrush=GetStockObject(obj);
if (newOBrush!=NULL)
{
oldOBrush=SelectObject(prt_dc,newOBrush);
if (oldOBrush!=NULL)
return 1;
}
}
return 0;
}

void __declspec(dllexport) Brush_DeleteDefined(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldOBrush!=NULL)
{
SelectObject(prt_dc,oldOBrush);
oldOBrush=NULL;
}
if (newOBrush!=NULL)
{
if (DeleteObject(newOBrush))
newOBrush=NULL;
}
}
}

int __declspec(dllexport) Brush_CreateBMPattern(int bmw,int bmh,UINT bmp,UINT bitspp,CONST VOID *bmArray)
{
if ((prt_Handle) && (prt_dc))
{
newBMBrush=CreateBitmap(bmw,bmh,bmp,bitspp,bmArray);
if (newBMBrush!=NULL)
{
newPBrush=CreatePatternBrush(newBMBrush);
if (newPBrush!=NULL)
{
oldPBrush=SelectObject(prt_dc,newPBrush);
if (oldPBrush!=NULL)
return 1;
}
}
}
return 0;
}

void __declspec(dllexport) Brush_DeleteBMPattern(void)
{
if ((prt_Handle) && (prt_dc))
{
if (oldPBrush!=NULL)
{
SelectObject(prt_dc,oldPBrush);
oldPBrush=NULL;
}
if (newPBrush!=NULL)
{
if (DeleteObject(newPBrush))
newPBrush=NULL;
}
if (newBMBrush!=NULL)
{
if (DeleteObject(newBMBrush))
newBMBrush=NULL;
}
}
}

int __declspec(dllexport) Draw_Ellipse(int left,int top,int right,int bottom)
{
if ((prt_Handle) && (prt_dc))
{
if (Ellipse(prt_dc,left,top,right,bottom))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Rectangle(int left,int top,int right,int bottom)
{
if ((prt_Handle) && (prt_dc))
{
if (Rectangle(prt_dc,left,top,right,bottom))
return 1;
}
return 0;
}


int __declspec(dllexport) Draw_RoundRectangle(int left,int top,int right,int bottom,int width,int height)
{
if ((prt_Handle) && (prt_dc))
{
if (RoundRect(prt_dc,left,top,right,bottom,width,height))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_LineTo(int x,int y)
{
if ((prt_Handle) && (prt_dc))
{
if (LineTo(prt_dc,x,y))
return 1;
}
return 0;
}

pointData * __declspec(dllexport) Draw_MoveCursorTo(int x,int y)
{
POINT oldPos;
if ((prt_Handle) && (prt_dc))
{
if (MoveToEx(prt_dc,x,y,&oldPos))
{
xy.x=oldPos.x;
xy.y=oldPos.y;
return &xy;
}
}
return NULL;
}

int __declspec(dllexport) Draw_PolyLine(CONST VOID *pointsArray,int numPoints)
{
if ((prt_Handle) && (prt_dc))
{
if (Polyline(prt_dc,pointsArray,numPoints))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_PolyLineTo(CONST VOID *pointsArray,int numPoints)
{
if ((prt_Handle) && (prt_dc))
{
if (PolylineTo(prt_dc,pointsArray,numPoints))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_FilledRectangle(long left,long top,long right,long bottom)
{
RECT fr;
fr.left=left;
fr.top=top;
fr.right=right;
fr.bottom=bottom;
if ((prt_Handle) && (prt_dc))
{
if (FillRect(prt_dc,&fr,0))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Arc(int left,int top,int right,int bottom,int xpoint,int ypoint,int xarc,int yarc)
{
if ((prt_Handle) && (prt_dc))
{
if (Arc(prt_dc,left,top,right,bottom,xpoint,ypoint,xarc,yarc))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_ArcTo(int left,int top,int right,int bottom,int xrad1,int yrad1,int xrad2,int yrad2)
{
if ((prt_Handle) && (prt_dc))
{
if (ArcTo(prt_dc,left,top,right,bottom,xrad1,yrad1,xrad2,yrad2))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_AngleArc(int x,int y,DWORD radius,float start,float sweep)
{
if ((prt_Handle) && (prt_dc))
{
if (AngleArc(prt_dc,x,y,radius,start,sweep))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_PolyBezier(CONST VOID *pointsArray,int numPoints)
{
if ((prt_Handle) && (prt_dc))
{
if (PolyBezier(prt_dc,pointsArray,numPoints))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_PolyBezierTo(CONST VOID *pointsArray,int numPoints)
{
if ((prt_Handle) && (prt_dc))
{
if (PolyBezierTo(prt_dc,pointsArray,numPoints))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Border(int left,int top,int right,int bottom,UINT edge,UINT border)
{
RECT der;
der.left=left;
der.top=top;
der.right=right;
der.bottom=bottom;
if ((prt_Handle) && (prt_dc))
{
if (DrawEdge(prt_dc,&der,edge,border))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Chord(int left,int top,int right,int bottom,int xrad1,int yrad1,int xrad2,int yrad2)
{
if ((prt_Handle) && (prt_dc))
{
if (Chord(prt_dc,left,top,right,bottom,xrad1,yrad1,xrad2,yrad2))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_FramedRectangle(int left,int top,int right,int bottom,HGDIOBJ hBrush)
{
RECT frr;
frr.left=left;
frr.top=top;
frr.right=right;
frr.bottom=bottom;
if ((prt_Handle) && (prt_dc))
{
if (FrameRect(prt_dc,&frr,hBrush))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Pie(int left,int top,int right,int bottom,int xrad1,int yrad1,int xrad2,int yrad2)
{
if ((prt_Handle) && (prt_dc))
{
if (Pie(prt_dc,left,top,right,bottom,xrad1,yrad1,xrad2,yrad2))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_Bitmap(HDC src_dc,int x1,int y1,int x,int y,int w,int h,DWORD method)
{
if ((prt_Handle) && (prt_dc))
{
if (BitBlt(prt_dc,x,y,w,h,src_dc,x1,y1,method))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_ResizedBitmap(HDC src_dc,int x1,int y1,int w1,int h1,int x,int y,int w,int h,DWORD method)
{
if ((prt_Handle) && (prt_dc))
{
if (StretchBlt(prt_dc,x,y,w,h,src_dc,x1,y1,w1,h1,method))
return 1;
}
return 0;
}

int __declspec(dllexport) Draw_PatternedBitmap(int x,int y,int w,int h,DWORD method)
{
if ((prt_Handle) && (prt_dc))
{
if (PatBlt(prt_dc,x,y,w,h,method))
return 1;
}
return 0;
}

COLORREF __declspec(dllexport) BGColor_GetCurrentColor(void)
{
COLORREF colour=0;
if ((prt_Handle) && (prt_dc))
{
colour=GetBkColor(prt_dc);
if (colour!=CLR_INVALID)
return colour;
}
return 0;
}

COLORREF __declspec(dllexport) BGColor_SetCurrentColor(COLORREF colour)
{
COLORREF oldColour=0;
if ((prt_Handle) && (prt_dc))
{
oldColour=SetBkColor(prt_dc,colour);
if (oldColour!=CLR_INVALID)
return oldColour;
return CLR_INVALID;
}
return 0;
}

int __declspec(dllexport) BGMode_GetCurrentMode(void)
{
int curBGMode=0;
if ((prt_Handle) && (prt_dc))
{
curBGMode=GetBkMode(prt_dc);
if (curBGMode==OPAQUE)
return 2;
if (curBGMode==TRANSPARENT)
return 1;
}
return 0;
}

int __declspec(dllexport) BGMode_SetTransparentMode(void)
{
int oldBGMode=0;
if ((prt_Handle) && (prt_dc))
{
oldBGMode=SetBkMode(prt_dc,TRANSPARENT);
if (oldBGMode==OPAQUE)
return 2;
if (oldBGMode==TRANSPARENT)
return 1;
}
return 0;
}

int __declspec(dllexport) BGMode_SetOpaqueMode(void)
{
int oldBGMode=0;
if ((prt_Handle) && (prt_dc))
{
oldBGMode=SetBkMode(prt_dc,OPAQUE);
if (oldBGMode==OPAQUE)
return 2;
if (oldBGMode==TRANSPARENT)
return 1;
}
return 0;
}

int __declspec(dllexport) BGMode_SetCurrentMode(int curBGMode)
{
int oldBGMode=0;
if ((prt_Handle) && (prt_dc))
{
oldBGMode=SetBkMode(prt_dc,curBGMode);
if (oldBGMode==OPAQUE)
return 2;
if (oldBGMode==TRANSPARENT)
return 1;
}
return 0;
}

int __declspec(dllexport) MapMode_SetCurrentMode(int newMapMode)
{
int oldMapMode=0;
if ((prt_Handle) && (prt_dc))
oldMapMode=SetMapMode(prt_dc,newMapMode);
return oldMapMode;
}

int __declspec(dllexport) MapMode_GetCurrentMode(void)
{
int curMapMode=0;
if ((prt_Handle) && (prt_dc))
curMapMode=GetMapMode(prt_dc);
return curMapMode;
}

DWORD __declspec(dllexport) MapperFlags_SetGetFlags(DWORD newMFlags)
{
DWORD oldMFlags=0;
if ((prt_Handle) && (prt_dc))
oldMFlags=SetMapperFlags(prt_dc,newMFlags);
if (oldMFlags!=GDI_ERROR)
return oldMFlags;
return 0;
}

int __declspec(dllexport) GraphicsMode_SetCompatible(void)
{
if ((prt_Handle) && (prt_dc))
return SetGraphicsMode(prt_dc,GM_COMPATIBLE);
return 0;
}

int __declspec(dllexport) GraphicsMode_SetAdvanced(void)
{
if ((prt_Handle) && (prt_dc))
return SetGraphicsMode(prt_dc,GM_ADVANCED);
return 0;
}

int __declspec(dllexport) GraphicsMode_SetCurrentMode(int newGMode)
{
if ((prt_Handle) && (prt_dc))
return SetGraphicsMode(prt_dc,newGMode);
return 0;
}

int __declspec(dllexport) ArcDirection_SetAntiClockwise(void)
{
if ((prt_Handle) && (prt_dc))
return SetArcDirection(prt_dc,AD_COUNTERCLOCKWISE);
return 0;
}

int __declspec(dllexport) ArcDirection_SetClockwise(void)
{
if ((prt_Handle) && (prt_dc))
return SetArcDirection(prt_dc,AD_CLOCKWISE);
return 0;
}

int __declspec(dllexport) ArcDirection_GetDirection(void)
{
if ((prt_Handle) && (prt_dc))
return GetArcDirection(prt_dc);
return 0;
}


int __declspec(dllexport) PrintPaper_SetPortrait(int lgf)
{
return Set_DMValue(lgf,DM_ORIENTATION,DMORIENT_PORTRAIT);
}

int __declspec(dllexport) PrintPaper_SetLandscape(int lgf)
{
return Set_DMValue(lgf,DM_ORIENTATION,DMORIENT_LANDSCAPE);
}

int __declspec(dllexport) PrintQuality_SetLow(int lgf)
{
return Set_DMValue(lgf,DM_PRINTQUALITY,DMRES_LOW);
}

int __declspec(dllexport) PrintQuality_SetMedium(int lgf)
{
return Set_DMValue(lgf,DM_PRINTQUALITY,DMRES_MEDIUM);
}

int __declspec(dllexport) PrintQuality_SetHigh(int lgf)
{
return Set_DMValue(lgf,DM_PRINTQUALITY,DMRES_HIGH);
}

int __declspec(dllexport) PrintQuality_SetDraft(int lgf)
{
return Set_DMValue(lgf,DM_PRINTQUALITY,DMRES_DRAFT);
}

int __declspec(dllexport) PrintColor_SetColor(int lgf)
{
return Set_DMValue(lgf,DM_COLOR,DMCOLOR_COLOR);
}

int __declspec(dllexport) PrintColor_SetBW(int lgf)
{
return Set_DMValue(lgf,DM_COLOR,DMCOLOR_MONOCHROME);
}

int __declspec(dllexport) PrintDuplex_SetHorizontal(int lgf)
{
return Set_DMValue(lgf,DM_DUPLEX,DMDUP_HORIZONTAL);
}

int __declspec(dllexport) PrintDuplex_SetVertical(int lgf)
{
return Set_DMValue(lgf,DM_DUPLEX,DMDUP_VERTICAL);
}

int __declspec(dllexport) PrintDuplex_SetSimple(int lgf)
{
return Set_DMValue(lgf,DM_DUPLEX,DMDUP_SIMPLEX);
}

int __declspec(dllexport) PrintTTFont_SetBitmap(int lgf)
{
return Set_DMValue(lgf,DM_TTOPTION,DMTT_BITMAP);
}

int __declspec(dllexport) PrintTTFont_SetDownload(int lgf)
{
return Set_DMValue(lgf,DM_TTOPTION,DMTT_DOWNLOAD);
}

int __declspec(dllexport) PrintTTFont_SetSubstitute(int lgf)
{
return Set_DMValue(lgf,DM_TTOPTION,DMTT_SUBDEV);
}

int __declspec(dllexport) PrintScale_SetHalfSize(int lgf)
{
return Set_DMValue(lgf,DM_SCALE,50);
}

int __declspec(dllexport) PrintScale_SetSize(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_SCALE,sSize);
}

int __declspec(dllexport) PrintCopies_SetSize(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_COPIES,sSize);
}

int __declspec(dllexport) PrintPaper_SetWidth(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_PAPERWIDTH,sSize);
}

int __declspec(dllexport) PrintPaper_SetLength(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_PAPERLENGTH,sSize);
}

int __declspec(dllexport) PrintDPI_SetYResolution(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_YRESOLUTION,sSize);
}

int __declspec(dllexport) PrintDPI_SetXResolution(int lgf,short sSize)
{
return Set_DMValue(lgf,DM_PRINTQUALITY,sSize);
}

int __declspec(dllexport) PrintPaper_SetLetter(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_LETTER);
}

int __declspec(dllexport) PrintPaper_SetLegal(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_LEGAL);
}

int __declspec(dllexport) PrintPaper_SetA4(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_A4);
}

int __declspec(dllexport) PrintPaper_SetCSheet(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_CSHEET);
}

int __declspec(dllexport) PrintPaper_SetDSheet(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_DSHEET);
}

int __declspec(dllexport) PrintPaper_SetESheet(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ESHEET);
}

int __declspec(dllexport) PrintPaper_SetLetterSmall(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_LETTERSMALL);
}

int __declspec(dllexport) PrintPaper_SetTabloid(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_TABLOID);
}

int __declspec(dllexport) PrintPaper_SetLedger(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_LEDGER);
}

int __declspec(dllexport) PrintPaper_SetStatement(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_STATEMENT);
}

int __declspec(dllexport) PrintPaper_SetExecutive(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_EXECUTIVE);
}

int __declspec(dllexport) PrintPaper_SetA3(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_A3);
}

int __declspec(dllexport) PrintPaper_SetA4Small(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_A4SMALL);
}

int __declspec(dllexport) PrintPaper_SetA5(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_A5);
}

int __declspec(dllexport) PrintPaper_SetB4(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_B4);
}

int __declspec(dllexport) PrintPaper_SetB5(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_B5);
}

int __declspec(dllexport) PrintPaper_SetFolio(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_FOLIO);
}

int __declspec(dllexport) PrintPaper_SetQuarto(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_QUARTO);
}

int __declspec(dllexport) PrintPaper_Set10x14(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_10X14);
}

int __declspec(dllexport) PrintPaper_Set11x17(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_11X17);
}

int __declspec(dllexport) PrintPaper_SetNote(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_NOTE);
}

int __declspec(dllexport) PrintPaper_SetEnv9(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_9);
}

int __declspec(dllexport) PrintPaper_SetEnv10(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_10);
}

int __declspec(dllexport) PrintPaper_SetEnv11(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_11);
}

int __declspec(dllexport) PrintPaper_SetEnv12(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_12);
}

int __declspec(dllexport) PrintPaper_SetEnv14(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_14);
}

int __declspec(dllexport) PrintPaper_SetEnvDL(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_DL);
}

int __declspec(dllexport) PrintPaper_SetEnvC5(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_C5);
}

int __declspec(dllexport) PrintPaper_SetEnvC3(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_C3);
}

int __declspec(dllexport) PrintPaper_SetEnvC4(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_C4);
}

int __declspec(dllexport) PrintPaper_SetEnvC6(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_C6);
}

int __declspec(dllexport) PrintPaper_SetEnvC65(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_C65);
}

int __declspec(dllexport) PrintPaper_SetEnvB4(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_B4);
}

int __declspec(dllexport) PrintPaper_SetEnvB5(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_B5);
}

int __declspec(dllexport) PrintPaper_SetEnvB6(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_B6);
}

int __declspec(dllexport) PrintPaper_SetItaly(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_ITALY);
}

int __declspec(dllexport) PrintPaper_SetMonarch(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_MONARCH);
}

int __declspec(dllexport) PrintPaper_SetPersonal(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_ENV_PERSONAL);
}

int __declspec(dllexport) PrintPaper_SetFFUS(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_FANFOLD_US);
}

int __declspec(dllexport) PrintPaper_SetSFFGerman(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_FANFOLD_STD_GERMAN);
}

int __declspec(dllexport) PrintPaper_SetLFFGerman(int lgf)
{
return Set_DMValue(lgf,DM_PAPERSIZE,DMPAPER_FANFOLD_LGL_GERMAN);
}

int __declspec(dllexport) PrintDither_SetNone(int lgf)
{
return Set_DMDWValue(lgf,DM_DITHERTYPE,DMDITHER_NONE);
}

int __declspec(dllexport) PrintDither_SetCoarse(int lgf)
{
return Set_DMDWValue(lgf,DM_DITHERTYPE,DMDITHER_COARSE);
}

int __declspec(dllexport) PrintDither_SetFine(int lgf)
{
return Set_DMDWValue(lgf,DM_DITHERTYPE,DMDITHER_FINE);
}

int __declspec(dllexport) PrintDither_SetLineArt(int lgf)
{
return Set_DMDWValue(lgf,DM_DITHERTYPE,DMDITHER_LINEART);
}

int __declspec(dllexport) PrintDither_SetGrayScale(int lgf)
{
return Set_DMDWValue(lgf,DM_DITHERTYPE,DMDITHER_GRAYSCALE);
}

int __declspec(dllexport) PrintCollate_SetTrue(int lgf)
{
return Set_DMDWValue(lgf,DM_COLLATE,DMCOLLATE_TRUE);
}

int __declspec(dllexport) PrintCollate_SetFalse(int lgf)
{
return Set_DMDWValue(lgf,DM_COLLATE,DMCOLLATE_FALSE);
}

int __declspec(dllexport) PrintDevice_SetName(int lgf,char * formName)
{
int rv=0;
if (prt_pi)
{
Printer_DeleteDC();
if (prt_pi->pDevMode->dmFields & DM_FORMNAME)
{
prt_pi->pDevMode->dmFields=DM_FORMNAME;
strcpy(prt_pi->pDevMode->dmFormName,formName);
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,prt_pi->pDevMode,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=1;
if (lgf)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=2;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=3;
}
}
}
}
Printer_CreateDC();
}
return rv;
}

int __declspec(dllexport) PrintAttr_SetDefault(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_DEFAULT);
}

int __declspec(dllexport) PrintAttr_SetDirect(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_DIRECT);
}

int __declspec(dllexport) PrintAttr_SetCompleteTest(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST);
}

int __declspec(dllexport) PrintAttr_SetEnableBidi(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_ENABLE_BIDI);
}

int __declspec(dllexport) PrintAttr_SetEnableDevQ(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_ENABLE_DEVQ);
}

int __declspec(dllexport) PrintAttr_SetKeepPrintedJobs(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS);
}

int __declspec(dllexport) PrintAttr_SetQueued(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_QUEUED);
}

int __declspec(dllexport) PrintAttr_SetShared(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_SHARED);
}

int __declspec(dllexport) PrintAttr_SetWorkOffline(int lgf)
{
return Set_PIDWValue(lgf,1,PRINTER_ATTRIBUTE_WORK_OFFLINE);
}

int __declspec(dllexport) PrintAttr_SetValue(int lgf,DWORD vle)
{
return Set_PIDWValue(lgf,1,vle);
}

int __declspec(dllexport) PrintPriority_SetValue(int lgf,DWORD vle)
{
return Set_PIDWValue(lgf,2,vle);
}

int __declspec(dllexport) PrintDefaultPriority_SetValue(int lgf,DWORD vle)
{
return Set_PIDWValue(lgf,3,vle);
}

int __declspec(dllexport) PrintStartTime_SetValue(int lgf,DWORD vle)
{
return Set_PIDWValue(lgf,4,vle);
}

int __declspec(dllexport) PrintUntilTime_SetValue(int lgf,DWORD vle)
{
return Set_PIDWValue(lgf,5,vle);
}

int __declspec(dllexport) PrintPrinter_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,1,stgName);
}

int __declspec(dllexport) PrintShare_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,2,stgName);
}

int __declspec(dllexport) PrintPort_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,3,stgName);
}

int __declspec(dllexport) PrintDriver_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,4,stgName);
}

int __declspec(dllexport) PrintComment_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,5,stgName);
}

int __declspec(dllexport) PrintLocation_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,6,stgName);
}

int __declspec(dllexport) PrintSepFile_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,7,stgName);
}

int __declspec(dllexport) PrintProcessor_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,8,stgName);
}

int __declspec(dllexport) PrintDatatype_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,9,stgName);
}

int __declspec(dllexport) PrintParameters_SetName(int lgf,char * stgName)
{
return Set_PISTGValue(lgf,10,stgName);
}

short __declspec(dllexport) PrintPaper_GetValue(void)
{
return Get_DMValue(DM_ORIENTATION);
}

short __declspec(dllexport) PrintQuality_GetValue(void)
{
return Get_DMValue(DM_PRINTQUALITY);
}

short __declspec(dllexport) PrintColor_GetValue(void)
{
return Get_DMValue(DM_COLOR);
}

short __declspec(dllexport) PrintDuplex_GetValue(void)
{
return Get_DMValue(DM_DUPLEX);
}

short __declspec(dllexport) PrintTTFont_GetValue(void)
{
return Get_DMValue(DM_TTOPTION);
}

short __declspec(dllexport) PrintScale_GetValue(void)
{
return Get_DMValue(DM_SCALE);
}

short __declspec(dllexport) PrintCopies_GetValue(void)
{
return Get_DMValue(DM_COPIES);
}

short __declspec(dllexport) PrintPaperWidth_GetValue(void)
{
return Get_DMValue(DM_PAPERWIDTH);
}

short __declspec(dllexport) PrintPaperLength_GetValue(void)
{
return Get_DMValue(DM_PAPERLENGTH);
}

short __declspec(dllexport) PrintPaperSize_GetValue(void)
{
return Get_DMValue(DM_PAPERSIZE);
}

short __declspec(dllexport) PrintYDPI_GetValue(void)
{
return Get_DMValue(DM_YRESOLUTION);
}

short __declspec(dllexport) PrintCollate_GetValue(void)
{
return Get_DMValue(DM_COLLATE);
}

DWORD __declspec(dllexport) PrintDither_GetValue(void)
{
return Get_DMDWValue(DM_DITHERTYPE);
}

DWORD __declspec(dllexport) PrintAttr_GetValue(void)
{
if (prt_pi)
{
return prt_pi->Attributes;
}
return 0;
}

DWORD __declspec(dllexport) PrintPriority_GetValue(void)
{
if (prt_pi)
{
return prt_pi->Priority;
}
return 0;
}

DWORD __declspec(dllexport) PrintDefaultPriority_GetValue(void)
{
if (prt_pi)
{
return prt_pi->DefaultPriority;
}
return 0;
}

DWORD __declspec(dllexport) PrintStartTime_GetValue(void)
{
if (prt_pi)
{
return prt_pi->StartTime;
}
return 0;
}

DWORD __declspec(dllexport) PrintUntilTime_GetValue(void)
{
if (prt_pi)
{
return prt_pi->UntilTime;
}
return 0;
}

DWORD __declspec(dllexport) PrintStatus_GetValue(void)
{
if (prt_pi)
{
return prt_pi->Status;
}
return 0;
}

DWORD __declspec(dllexport) PrintJobCount_GetValue(void)
{
if (prt_pi)
{
return prt_pi->cJobs;
}
return 0;
}

DWORD __declspec(dllexport) PrintAveragePPM_GetValue(void)
{
if (prt_pi)
{
return prt_pi->AveragePPM;
}
return 0;
}

stringData * __declspec(dllexport) PrintForm_GetName(void)
{
if (prt_pi->pDevMode->dmFields & DM_FORMNAME)
{
strcpy(sd.rtnStg,prt_pi->pDevMode->dmFormName);
if (strcmp(sd.rtnStg,"")==0)
return NULL;
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintDevice_GetName(void)
{
if (prt_pi)
{
strcpy(sd.rtnStg,prt_pi->pDevMode->dmDeviceName);
if (strcmp(sd.rtnStg,"")==0)
return NULL;
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintPrinter_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pPrinterName==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pPrinterName);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintShare_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pShareName==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pShareName);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintPort_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pPortName==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pPortName);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintDriver_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pDriverName==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pDriverName);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintComment_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pComment==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pComment);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintLocation_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pLocation==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pLocation);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintSepFile_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pSepFile==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pSepFile);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintProcessor_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pPrintProcessor==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pPrintProcessor);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintDatatype_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pDatatype==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pDatatype);
return &sd;
}
return NULL;
}

stringData * __declspec(dllexport) PrintParameters_GetName(void)
{
if (prt_pi)
{
if (prt_pi->pParameters==NULL)
return NULL;
strcpy(sd.rtnStg,prt_pi->pParameters);
return &sd;
}
return NULL;
}

pi2Data * __declspec(dllexport) PI2_GetAllInfo(void)
{
if (prt_pi)
{
pi2.attrs=prt_pi->Attributes;
pi2.priority=prt_pi->Priority;
pi2.dpriority=prt_pi->DefaultPriority;
pi2.startTime=prt_pi->StartTime;
pi2.untilTime=prt_pi->UntilTime;
pi2.status=prt_pi->Status;
pi2.jobs=prt_pi->cJobs;
pi2.appm=prt_pi->AveragePPM;
if (prt_pi->pDevMode!=NULL)
pi2.dmValid=1;
else
pi2.dmValid=0;
if (prt_pi->pServerName!=NULL)
strcpy(pi2.server,prt_pi->pServerName);
else
strcpy(pi2.server,"");
if (prt_pi->pPrinterName!=NULL)
strcpy(pi2.printer,prt_pi->pPrinterName);
else
strcpy(pi2.printer,"");
if (prt_pi->pShareName!=NULL)
strcpy(pi2.share,prt_pi->pShareName);
else
strcpy(pi2.share,"");
if (prt_pi->pPortName!=NULL)
strcpy(pi2.port,prt_pi->pPortName);
else
strcpy(pi2.port,"");
if (prt_pi->pDriverName!=NULL)
strcpy(pi2.driver,prt_pi->pDriverName);
else
strcpy(pi2.driver,"");
if (prt_pi->pComment!=NULL)
strcpy(pi2.comment,prt_pi->pComment);
else
strcpy(pi2.comment,"");
if (prt_pi->pLocation!=NULL)
strcpy(pi2.location,prt_pi->pLocation);
else
strcpy(pi2.location,"");
if (prt_pi->pSepFile!=NULL)
strcpy(pi2.sepfile,prt_pi->pSepFile);
else
strcpy(pi2.sepfile,"");
if (prt_pi->pPrintProcessor!=NULL)
strcpy(pi2.processor,prt_pi->pPrintProcessor);
else
strcpy(pi2.processor,"");
if (prt_pi->pDatatype!=NULL)
strcpy(pi2.datatype,prt_pi->pDatatype);
else
strcpy(pi2.datatype,"");
if (prt_pi->pParameters!=NULL)
strcpy(pi2.parameters,prt_pi->pParameters);
else
strcpy(pi2.parameters,"");
return &pi2;
}
return NULL;
}

devmData * __declspec(dllexport) DM_GetAllInfo(void)
{
if (prt_pi->pDevMode)
{
devm.version=prt_pi->pDevMode->dmSpecVersion;
devm.driverVersion=prt_pi->pDevMode->dmDriverVersion;
devm.publicSize=prt_pi->pDevMode->dmSize;
devm.privateSize=prt_pi->pDevMode->dmDriverExtra;
devm.fields=prt_pi->pDevMode->dmFields;
devm.dither=prt_pi->pDevMode->dmDitherType;
devm.orientation=prt_pi->pDevMode->dmOrientation;
devm.paperSize=prt_pi->pDevMode->dmPaperSize;
devm.paperLength=prt_pi->pDevMode->dmPaperLength;
devm.paperWidth=prt_pi->pDevMode->dmPaperWidth;
devm.scale=prt_pi->pDevMode->dmScale;
devm.copies=prt_pi->pDevMode->dmCopies;
devm.paperName=prt_pi->pDevMode->dmDefaultSource;
devm.quality=prt_pi->pDevMode->dmPrintQuality;
devm.color=prt_pi->pDevMode->dmColor;
devm.duplex=prt_pi->pDevMode->dmDuplex;
devm.ydpi=prt_pi->pDevMode->dmYResolution;
devm.ttfont=prt_pi->pDevMode->dmTTOption;
devm.collate=prt_pi->pDevMode->dmCollate;
strcpy(devm.printer,prt_pi->pDevMode->dmDeviceName);
strcpy(devm.formName,prt_pi->pDevMode->dmFormName);
return &devm;
}
return NULL;
}

nwData * __declspec(dllexport) Enum_RegLocalPrinters(void)
{
PRINTER_INFO_4 *lpi4=NULL;
DWORD needed=0,returned=0;
int counter=0;
nw[0].count=0;
rtn=EnumPrinters(PRINTER_ENUM_LOCAL,NULL,4,0,0,&needed,&returned);
if (rtn==0)
{
rtn=GetLastError();
if (rtn==ERROR_INSUFFICIENT_BUFFER)
{
lpi4=(PRINTER_INFO_4 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,needed);
if (lpi4!=NULL)
{
rtn=EnumPrinters(PRINTER_ENUM_LOCAL,NULL,4,(LPBYTE)lpi4,needed,&needed,&returned);
if (rtn)
{
if (returned>0)
{
nw[0].count=returned;
for (counter=0;counter<returned;counter++)
{
nw[counter].attrs=lpi4[counter].Attributes;
if (lpi4[counter].pPrinterName!=NULL)
strcpy(nw[counter].printer,lpi4[counter].pPrinterName);
else
strcpy(nw[counter].printer,"");
if (lpi4[counter].pServerName!=NULL)
strcpy(nw[counter].server,lpi4[counter].pServerName);
else
strcpy(nw[counter].server,"");
}
}
}
GlobalFree(lpi4);
}
}
}
if (returned>0)
return nw;
return NULL;
}

lpData * __declspec(dllexport) Enum_LocalPrinters(void)
{
PRINTER_INFO_2 *lpi2=NULL;
DEVMODE * dmPtr=NULL;
DWORD needed=0,returned=0;
int counter=0;
lp[0].count=0;
rtn=EnumPrinters(PRINTER_ENUM_LOCAL,NULL,2,0,0,&needed,&returned);
if (rtn==0)
{
rtn=GetLastError();
if (rtn==ERROR_INSUFFICIENT_BUFFER)
{
lpi2=(PRINTER_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,needed);
if (lpi2!=NULL)
{
rtn=EnumPrinters(PRINTER_ENUM_LOCAL,NULL,2,(LPBYTE)lpi2,needed,&needed,&returned);
if (rtn)
{
if (returned>0)
{
lp[0].count=returned;
for (counter=0;counter<returned;counter++)
{
lp[counter].attrs=lpi2[counter].Attributes;
lp[counter].priority=lpi2[counter].Priority;
lp[counter].dpriority=lpi2[counter].DefaultPriority;
lp[counter].start=lpi2[counter].StartTime;
lp[counter].until=lpi2[counter].UntilTime;
lp[counter].status=lpi2[counter].Status;
lp[counter].jobs=lpi2[counter].cJobs;
lp[counter].appm=lpi2[counter].AveragePPM;
if (lpi2[counter].pPrinterName!=NULL)
strcpy(lp[counter].printer,lpi2[counter].pPrinterName);
else
strcpy(lp[counter].printer,"");
if (lpi2[counter].pServerName!=NULL)
strcpy(lp[counter].server,lpi2[counter].pServerName);
else
strcpy(lp[counter].server,"");
if (lpi2[counter].pShareName!=NULL)
strcpy(lp[counter].share,lpi2[counter].pShareName);
else
strcpy(lp[counter].share,"");
if (lpi2[counter].pPortName!=NULL)
strcpy(lp[counter].port,lpi2[counter].pPortName);
else
strcpy(lp[counter].port,"");
if (lpi2[counter].pComment!=NULL)
strcpy(lp[counter].comment,lpi2[counter].pComment);
else
strcpy(lp[counter].comment,"");
if (lpi2[counter].pLocation!=NULL)
strcpy(lp[counter].location,lpi2[counter].pLocation);
else
strcpy(lp[counter].location,"");
if (lpi2[counter].pDriverName!=NULL)
strcpy(lp[counter].driver,lpi2[counter].pDriverName);
else
strcpy(lp[counter].driver,"");
if (lpi2[counter].pSepFile!=NULL)
strcpy(lp[counter].sepfile,lpi2[counter].pSepFile);
else
strcpy(lp[counter].sepfile,"");
if (lpi2[counter].pPrintProcessor!=NULL)
strcpy(lp[counter].processor,lpi2[counter].pPrintProcessor);
else
strcpy(lp[counter].processor,"");
if (lpi2[counter].pDatatype!=NULL)
strcpy(lp[counter].datatype,lpi2[counter].pDatatype);
else
strcpy(lp[counter].datatype,"");
if (lpi2[counter].pParameters!=NULL)
strcpy(lp[counter].parameters,lpi2[counter].pParameters);
else
strcpy(lp[counter].parameters,"");
dmPtr=lpi2[counter].pDevMode;
if (dmPtr!=NULL)
{
lp[counter].dither=dmPtr->dmDitherType;
lp[counter].fields=dmPtr->dmFields;
lp[counter].orientation=dmPtr->dmOrientation;
lp[counter].paperSize=dmPtr->dmPaperSize;
lp[counter].paperLength=dmPtr->dmPaperLength;
lp[counter].paperWidth=dmPtr->dmPaperWidth;
lp[counter].scale=dmPtr->dmScale;
lp[counter].copies=dmPtr->dmCopies;
lp[counter].source=dmPtr->dmDefaultSource;
lp[counter].quality=dmPtr->dmPrintQuality;
lp[counter].color=dmPtr->dmColor;
lp[counter].duplex=dmPtr->dmDuplex;
lp[counter].ydpi=dmPtr->dmYResolution;
lp[counter].ttfont=dmPtr->dmTTOption;
lp[counter].collate=dmPtr->dmCollate;
strcpy(lp[counter].driverName,lpi2[counter].pDevMode->dmDeviceName);
if (strcmp(lp[counter].driverName,"")==0)
strcpy(lp[counter].driverName,"");
strcpy(lp[counter].formName,lpi2[counter].pDevMode->dmFormName);
if (strcmp(lp[counter].formName,"")==0)
strcpy(lp[counter].formName,"");
}
}
}
}
GlobalFree(lpi2);
}
}
}
if (returned>0)
return lp;
return NULL;
}

ppData * __declspec(dllexport) Enum_Ports(char * serverName)
{
PORT_INFO_2 *pppi2=NULL;
DWORD needed=0,returned=0;
int counter=0;
pp[0].count=0;
if (strcmp(serverName,"")==0)
serverName=NULL;
rtn=EnumPorts(serverName,2,0,0,&needed,&returned);
if (rtn==0)
{
rtn=GetLastError();
if (rtn==ERROR_INSUFFICIENT_BUFFER)
{
pppi2=(PORT_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,needed);
if (pppi2!=NULL)
{
rtn=EnumPorts(serverName,2,(LPBYTE)pppi2,needed,&needed,&returned);
if (rtn)
{
if (returned>0)
{
pp[0].count=returned;
for (counter=0;counter<returned;counter++)
{
pp[counter].portType=pppi2[counter].fPortType;
if (pppi2[counter].pPortName!=NULL)
strcpy(pp[counter].port,pppi2[counter].pPortName);
else
strcpy(pp[counter].port,"");
if (pppi2[counter].pMonitorName!=NULL)
strcpy(pp[counter].monitor,pppi2[counter].pMonitorName);
else
strcpy(pp[counter].monitor,"");
if (pppi2[counter].pDescription!=NULL)
strcpy(pp[counter].details,pppi2[counter].pDescription);
else
strcpy(pp[counter].details,"");
}
}
}
GlobalFree(pppi2);
}
}
}
if (returned>0)
return pp;
return NULL;
}

int __declspec(dllexport) XPrinter_DeletePDC(HANDLE dc_Handle)
{
if (dc_Handle)
{
if (DeleteDC(dc_Handle))
{
dc_Handle=NULL;
return 1;
}
}
return 0;
}

int __declspec(dllexport) Printer_Close(HANDLE hPrinter)
{
if (hPrinter)
{
if (ClosePrinter(hPrinter))
{
hPrinter=NULL;
prt_opened=0;
CoUninitialize();
return 1;
}
}
CoUninitialize();
return 0;
}

int __declspec(dllexport) Printer_CloseDefault(void)
{
int err=0;
rtn=Printer_DeleteDC();
if (rtn!=1)
err=1;
Printer_FreePI();
if (prt_pi!=NULL)
err=2;
rtn=Printer_Close(prt_Handle);
if (rtn!=1)
err=3;
rtn=Memory_Free();
if (rtn!=1)
err=4;
CoUninitialize();
return err;
}

int __declspec(dllexport) Get_WinVer(void)
{
OSVERSIONINFO osvi;
osvi.dwOSVersionInfoSize=sizeof(osvi);
if (GetVersionEx(&osvi))
{
if (osvi.dwPlatformId==PLATFORM_WIN32_WINDOWS)
{
// Windows 95, 98 and ME.
if (osvi.dwMajorVersion==4)
{
if (osvi.dwMinorVersion==10)
{
// Windows 98.
if (osvi.dwBuildNumber==1998)
return 0x39382020;
else if ((osvi.dwBuildNumber>1998) && (osvi.dwBuildNumber<2183))
return 0x39385331;
else if (osvi.dwBuildNumber>2182)
return 0x39385345;
else
return 0x3F3F3938;
}
else if (osvi.dwMinorVersion<10)
{
// Windows 95.
if (osvi.dwBuildNumber==950)
return 0x39352020;
else if ((osvi.dwBuildNumber>950) && (osvi.dwBuildNumber<1081))
return 0x39355331;
else if (osvi.dwBuildNumber>1080)
return 0x39355232;
else
return 0x3F3F3935;
}
else if (osvi.dwMinorVersion==90)
{
// Windows ME.
if (osvi.dwBuildNumber==3000)
return 0x4D452020;
else
return 0x3F3F4D45;
}
}
}
else if (osvi.dwPlatformId==PLATFORM_WIN32_NT)
{
// Windows NT, XP and 2000.
if (osvi.dwMajorVersion==3)
{
// Windows NT 3.51.
if (osvi.dwMinorVersion==51)
{
if (osvi.dwBuildNumber==1057)
return 0x4E543335;
else
return 0x3F3F4E54;
}
}
else if (osvi.dwMajorVersion==4)
{
// Windows NT 4.
if (osvi.dwMinorVersion==0)
{
if (osvi.dwBuildNumber==1381)
return 0x4E543420;
else
return 0x3F3F4E54;
}
}
else if (osvi.dwMajorVersion==5)
{
// Windows 2000 / XP.
if (osvi.dwMinorVersion==0)
{
// Windows 2000/2000Pro.
if (osvi.dwBuildNumber==2195)
return 0x32303030;
else
return 0x3F3F3230;
}
else if (osvi.dwMinorVersion==1)
// XP.
return 0x58502020;
else
return 0x3F3F5850;
}
}
else if (osvi.dwPlatformId==PLATFORM_WIN32_CE)
{
// Pocket Phone, Small Devices, etc.
}
}
return -1;
}

int __declspec(dllexport) Dialog_ControlPanel(char * cplName)
{
return Launch_CPL(cplName);
}

//------------------------------------- Printer Declarations ---------------------------------------------

char * UnicodeToAnsi(OLECHAR * szW)
{
static char szA[256];
szA[0]=0;
if (szW==NULL)
return "";
WideCharToMultiByte(CP_ACP,0,szW,-1,szA,256,NULL,NULL);
return szA;
}

//------------------------------------------- DLL Code ---------------------------------------------------

int Memory_Allocate(DWORD pbSize)
{
if (pbSize<5000)
pbSize=5000;
Memory_Handle=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE,pbSize);
if (Memory_Handle)
{
Memory_LockPtr=(char *)GlobalLock(Memory_Handle);
if (Memory_LockPtr)
{
memSize=pbSize;
return 2;
}
return 1;
}
return 0;
}

int Memory_Free(void)
{
if (Memory_LockPtr)
GlobalUnlock(Memory_Handle);
if (Memory_Handle)
{
if (GlobalFree(Memory_Handle)==NULL)
{
Memory_Handle=NULL;
return 1;
}
}
return 0;
}

int Printer_GetPI(void)
{
DWORD needed=0,need=0;
if (prt_Handle)
{
rtn=GetPrinter(prt_Handle,2,0,0,&needed);
if (rtn==0)
{
rtn=GetLastError();
if (rtn==ERROR_INSUFFICIENT_BUFFER)
{
prt_pi=(PRINTER_INFO_2 *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,needed);
if (prt_pi!=NULL)
{
rtn=GetPrinter(prt_Handle,2,(LPBYTE)prt_pi,needed,&needed);
if (rtn)
{
if (prt_pi->pDevMode==NULL)
{
need=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,NULL,NULL,0);
if (need)
{
pDevMode=(DEVMODE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,need);
if (pDevMode!=NULL)
{
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,pDevMode,NULL,DM_OUT_BUFFER);
if (rtn==IDOK)
{
prt_pi->pDevMode=pDevMode;
}
}
}
}
return 1;
}
else
Printer_FreePI();
}
}
}
}
return 0;
}

void Printer_FreePI(void)
{
if (pDevMode)
{
if (GlobalFree(pDevMode)==NULL)
pDevMode=NULL;
}
if (prt_pi)
{
if (GlobalFree(prt_pi)==NULL)
prt_pi=NULL;
}
}

int Set_DMValue(int flag,DWORD field,short vle)
{
int rv=0;
if ((prt_pi) && (prt_pi->pDevMode))
{
Printer_DeleteDC();
if (prt_pi->pDevMode->dmFields & field)
{
prt_pi->pDevMode->dmFields=field;
if (field==DM_ORIENTATION)
prt_pi->pDevMode->dmOrientation=vle;
else if (field==DM_PRINTQUALITY)
prt_pi->pDevMode->dmPrintQuality=vle;
else if (field==DM_DUPLEX)
prt_pi->pDevMode->dmDuplex=vle;
else if (field==DM_COLOR)
prt_pi->pDevMode->dmColor=vle;
else if (field==DM_TTOPTION)
prt_pi->pDevMode->dmTTOption=vle;
else if (field==DM_SCALE)
prt_pi->pDevMode->dmScale=vle;
else if (field==DM_COPIES)
prt_pi->pDevMode->dmCopies=vle;
else if (field==DM_PAPERWIDTH)
prt_pi->pDevMode->dmPaperWidth=vle;
else if (field==DM_PAPERLENGTH)
prt_pi->pDevMode->dmPaperLength=vle;
else if (field==DM_PAPERSIZE)
prt_pi->pDevMode->dmPaperSize=vle;
else if (field==DM_YRESOLUTION)
prt_pi->pDevMode->dmYResolution=vle;
else if (field==DM_COLLATE)
prt_pi->pDevMode->dmCollate=vle;
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,prt_pi->pDevMode,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=1;
if (flag)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=2;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=3;
}
}
}
}
Printer_CreateDC();
}
return rv;
}

short Get_DMValue(DWORD field)
{
short rv=0;
if ((prt_pi) && (prt_pi->pDevMode))
{
if (prt_pi->pDevMode->dmFields & field)
{
if (field==DM_ORIENTATION)
rv=prt_pi->pDevMode->dmOrientation;
else if (field==DM_PRINTQUALITY)
rv=prt_pi->pDevMode->dmPrintQuality;
else if (field==DM_DUPLEX)
rv=prt_pi->pDevMode->dmDuplex;
else if (field==DM_COLOR)
rv=prt_pi->pDevMode->dmColor;
else if (field==DM_TTOPTION)
rv=prt_pi->pDevMode->dmTTOption;
else if (field==DM_SCALE)
rv=prt_pi->pDevMode->dmScale;
else if (field==DM_COPIES)
rv=prt_pi->pDevMode->dmCopies;
else if (field==DM_PAPERWIDTH)
rv=prt_pi->pDevMode->dmPaperWidth;
else if (field==DM_PAPERLENGTH)
rv=prt_pi->pDevMode->dmPaperLength;
else if (field==DM_PAPERSIZE)
rv=prt_pi->pDevMode->dmPaperSize;
else if (field==DM_YRESOLUTION)
rv=prt_pi->pDevMode->dmYResolution;
else if (field==DM_COLLATE)
rv=prt_pi->pDevMode->dmCollate;
}
}
return rv;
}

int Set_DMDWValue(int flag,DWORD field,DWORD vle)
{
int rv=0;
if ((prt_pi) && (prt_pi->pDevMode))
{
Printer_DeleteDC();
if (prt_pi->pDevMode->dmFields & field)
{
prt_pi->pDevMode->dmFields=field;
if (field==DM_DITHERTYPE)
prt_pi->pDevMode->dmDitherType=vle;
prt_pi->pSecurityDescriptor=NULL;
rtn=DocumentProperties(NULL,prt_Handle,prt_pi->pPrinterName,prt_pi->pDevMode,prt_pi->pDevMode,DM_IN_BUFFER|DM_OUT_BUFFER);
if (rtn==IDOK)
{
rv=1;
if (flag)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
{
rv=2;
rtn=SendMessageTimeout(HWND_BROADCAST,WM_DEVMODECHANGE,0L,(LPARAM)(LPCSTR)prt_pi->pPrinterName,SMTO_NORMAL,1000,NULL);
if (rtn==TRUE)
rv=3;
}
}
}
}
Printer_CreateDC();
}
return rv;
}

DWORD Get_DMDWValue(DWORD field)
{
DWORD rv=0;
if ((prt_pi) && (prt_pi->pDevMode))
{
if (prt_pi->pDevMode->dmFields & field)
{
if (field==DM_DITHERTYPE)
rv=prt_pi->pDevMode->dmDitherType;
}
}
return rv;
}

int Set_PIDWValue(int flag,DWORD field,DWORD vle)
{
int rv=0;
if (prt_pi)
{
Printer_DeleteDC();
if (field==1)
prt_pi->Attributes=vle;
else if (field==2)
prt_pi->Priority=vle;
else if (field==3)
prt_pi->DefaultPriority=vle;
else if (field==4)
prt_pi->StartTime=vle;
else if (field==5)
prt_pi->UntilTime=vle;
else if (field==6)
prt_pi->cJobs=vle;
else if (field==6)
prt_pi->AveragePPM=vle;
if (flag)
{
prt_pi->pSecurityDescriptor=NULL;
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
rv=1;
}
Printer_CreateDC();
}
return rv;
}

int Set_PISTGValue(int lgf,DWORD field,char * piName)
{
int rv=0;
if (prt_pi)
{
Printer_DeleteDC();
if (strcmp(piName,"")==0)
piName=NULL;
if (field==1)
prt_pi->pPrinterName=piName;
else if (field==2)
prt_pi->pShareName=piName;
else if (field==3)
prt_pi->pPortName=piName;
else if (field==4)
prt_pi->pDriverName=piName;
else if (field==5)
prt_pi->pComment=piName;
else if (field==6)
prt_pi->pLocation=piName;
else if (field==7)
prt_pi->pSepFile=piName;
else if (field==8)
prt_pi->pPrintProcessor=piName;
else if (field==9)
prt_pi->pDatatype=piName;
else if (field==10)
prt_pi->pParameters=piName;
if (lgf)
{
rtn=SetPrinter(prt_Handle,2,(LPBYTE)prt_pi,0);
if (rtn)
rv=1;
}
Printer_CreateDC();
}
return rv;
}

int Printer_CreateDC(void)
{
prt_dc=CreateDC(prt_pi->pDriverName,prt_pi->pPrinterName,NULL,prt_pi->pDevMode);
if (prt_dc)
return 1;
return 0;
}

int Printer_DeleteDC(void)
{
if (prt_dc)
{
if (DeleteDC(prt_dc))
{
prt_dc=NULL;
return 1;
}
}
return 0;
}

int Launch_CPL(char * pApplet)
{
PROCESS_INFORMATION pi;
STARTUPINFO si;
char CPLApplet[50];
si.cb=sizeof(STARTUPINFO);
si.lpReserved=NULL;
si.lpDesktop=NULL;
si.lpTitle=NULL;
si.dwFlags=STARTF_USESHOWWINDOW;
si.wShowWindow=SW_SHOWNORMAL;
si.cbReserved2=0;
si.lpReserved2=NULL;
wsprintf(CPLApplet,"CONTROL.EXE %s",pApplet);
if (CreateProcess(NULL,CPLApplet,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi))
{
CloseHandle(pi.hThread);
CloseHandle(pi.hProcess);
return 1;
}
return 0;
}

//------------------------------------------ Default DLL Code ---------------------------------------------

BOOL WINAPI __declspec(dllexport) LibMain(HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)
{
switch (fdwReason)
{
case DLL_PROCESS_ATTACH:
// The DLL is being loaded for the first time by a given process.
// Perform per-process initialization here.
// If the initialization is successful, return TRUE. Otherwise. return FALSE.
hInstance=hDLLInst;
break;
case DLL_PROCESS_DETACH:
// The DLL is being unloaded by a given process.
// Do any per-process clean up here, such as undoing what was done in DLL_PROCESS_ATTACH.
// The return value is ignored.
break;
case DLL_THREAD_ATTACH:
// A thread is being created in a process that has already loaded this DLL.
// Perform any per-thread initialization here. The return value is ignored.
break;
case DLL_THREAD_DETACH:
// A thread is exiting cleanly in a process that has already loaded this DLL.
// Perform any per-thread clean up here. The return value is ignored.
break;
}
return TRUE;
}
