#ifndef _INNOSTAGE_GUI_ENHANCED_LABEL_
#define _INNOSTAGE_GUI_ENHANCED_LABEL_

#include <string>
#include <vector>
using namespace std;

#undef DLL_EXPORT
#ifdef COMPILE_DLL
	#define DLL_EXPORT __declspec(dllexport) 
#else
	#define DLL_EXPORT
#endif







namespace InnoStage
{
	namespace GUI
	{
		class EnhancedLabel
		{
			friend LRESULT CALLBACK _EnhancedLabelProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);



		public:
			DLL_EXPORT EnhancedLabel(HWND hWnd);
			DLL_EXPORT EnhancedLabel(HWND hWnd, UINT id);
			DLL_EXPORT ~EnhancedLabel();
			DLL_EXPORT bool SubClass(void);

			DLL_EXPORT static bool Register(const TCHAR* productName, 
											const TCHAR* companyName, 
											const TCHAR* productDescription,
											const TCHAR* regProductKey, unsigned int regPKLength,
											const TCHAR* regAuthID, unsigned int regAILength);

			// ----------------------------------------------------
			// ENUM - Border
			// ----------------------------------------------------
			typedef enum
			{
				/// <Summary>Top side of the Rectangle</Summary>
				BorderSideTop = 0,
				/// <Summary>Bottom side of the Rectangle</Summary>
				BorderSideBottom = 1,
				/// <Summary>Left side of the Rectangle</Summary>
				BorderSideLeft = 2,
				/// <Summary>Right side of the Rectangle</Summary>
				BorderSideRight = 3
			}BorderSide;

			// ----------------------------------------------------
			// ENUM - Highlight Style
			// ----------------------------------------------------
			typedef enum
			{
				/// <Summary>Highlight Border Only</Summary>
				HighlightStyleBorderOnly = 0,
				/// <Summary>Highlight Background Only</Summary>
				HighlightStyleBackgroundOnly = 1,
				/// <Summary>Highlight Text Only</Summary>
				HighlightStyleTextOnly = 2,
				/// <Summary>Highlight Border and Background</Summary>
				HighlightStyleBorderBackground = 3,
				/// <Summary>Highlight Border and Text</Summary>
				HighlightStyleBorderText = 4,
				/// <Summary>Highlight Background and Text</Summary>
				HighlightStyleBackgroundText = 5,
				/// <Summary>Highlight Left Side of Rectangle Only</Summary>
				HighlightStyleLeftBorderOnly = 6,
				/// <Summary>Highlight Right Side of Rectangle Only</Summary>
				HighlightStyleRightBorderOnly = 7,
				/// <Summary>Highlight Bottom Side of Rectangle Only</Summary>
				HighlightStyleBottomBorderOnly = 8,
			}HighlightStyle;



			DLL_EXPORT
			void EnableHighQualitySmoothingMode(bool enable);
			DLL_EXPORT
			void EnableClearType(bool enable);
			// ----------------------------------------------------
			// Highlight (Body + Header)
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetBodyHighlightStyle(bool enblehighlight, HighlightStyle style, 
									   COLORREF highlight, COLORREF texthighlight,
									   unsigned int alphableding, unsigned int borderwidth,
									   unsigned int offsetx, unsigned int offsety);
			DLL_EXPORT
			bool SetHeaderHighlightStyle(bool enblehighlight, HighlightStyle style, 
										 COLORREF highlight, COLORREF texthighlight,
										 unsigned int alphableding, unsigned int borderwidth,
										 unsigned int offsetx, unsigned int offsety);
			DLL_EXPORT
			bool SetLinkBarHighlightStyle(bool enblehighlight, HighlightStyle style, 
										  COLORREF highlight, COLORREF texthighlight,
										  unsigned int alphableding, unsigned int borderwidth,
										  unsigned int offsetx, unsigned int offsety);

			// ----------------------------------------------------
			// WM_COMMANDs
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetHeaderOnClickCommand(int cmdID);
			DLL_EXPORT
			bool SetBodyOnClickCommand(int cmdID);

			// ----------------------------------------------------
			// LABEL Body
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetBodyBorder(BorderSide borderside, 
							   COLORREF color, unsigned int alphablending,
							   unsigned int width, 
							   unsigned int indentx, unsigned int indenty);
			DLL_EXPORT
			bool SetBodyBackgroundImage(HBITMAP bitmap, bool scale, 
										bool grayscale);
			DLL_EXPORT
			bool SetBodyBackgroundGradient(COLORREF first, COLORREF second,
										   bool horizontal);

			// ----------------------------------------------------
			// LABEL Header
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetHeaderIndent(unsigned int x, unsigned int y);
			DLL_EXPORT
			bool SetHeaderHeight(unsigned int height);
			DLL_EXPORT
			bool SetHeaderBorder(BorderSide borderside,
								 COLORREF color, unsigned int alphablending,
								 unsigned int width, 
								 unsigned int indentx, unsigned int indenty);
			DLL_EXPORT
			bool SetHeaderBackgroundImage(HBITMAP bitmap, bool scale, 
										  bool grayscale);
			DLL_EXPORT
			bool SetHeaderBackgroundGradient(COLORREF first, COLORREF second,
											 bool horizontal);

			// ----------------------------------------------------
			// LABEL Details
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetHeaderDetailsIndent(unsigned int x, unsigned int y);
			DLL_EXPORT
			bool SetHeaderDetailsTitle(const TCHAR* title, COLORREF text, unsigned int alignment);
			DLL_EXPORT
			bool SetHeaderDetailsTitleFont(const TCHAR* fontname, unsigned int fontsize,
										   bool bold, bool italic, bool underline);
			DLL_EXPORT
			bool SetHeaderDetailsDescription(const TCHAR* description, COLORREF text, unsigned int alignment);
			DLL_EXPORT
			bool SetHeaderDetailsDescriptionFont(const TCHAR* fontname, unsigned int fontsize,
												 bool bold, bool italic, bool underline);
			DLL_EXPORT
			bool SetHeaderDetailsImage(HBITMAP bitmap, 
					unsigned int width, unsigned int height, 
					COLORREF transparent, bool scale, bool grayscale);

			// ----------------------------------------------------
			// LABEL Standard Left Title
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetHeaderStandardLeftIndent(unsigned int x, unsigned int y);
			DLL_EXPORT
			bool SetHeaderStandardLeftTitle(const TCHAR* title, COLORREF text, unsigned int alignment);
			DLL_EXPORT
			bool SetHeaderStandardLeftTitleFont(const TCHAR* fontname, unsigned int fontsize,
												bool bold, bool italic, bool underline);
			DLL_EXPORT
			bool SetHeaderStandardLeftImage(HBITMAP bitmap, 
				unsigned int width, unsigned int height, 
				COLORREF transparent, bool scale, bool grayscale);

			// ----------------------------------------------------
			// ContentLink
			// ----------------------------------------------------
			DLL_EXPORT
			bool EnableContentLinkNormalMode(bool enable);
			DLL_EXPORT
			bool SetContentLinkIndent(unsigned int x, unsigned int y);
			DLL_EXPORT
			bool SetContentLinkSideImageSize(unsigned int width, unsigned int height);
			DLL_EXPORT
			bool SetContentLinkTextFont(const TCHAR* fontname, unsigned int fontsize,
										bool bold, bool italic, bool underline);
			DLL_EXPORT
			bool AddContentLink(unsigned int cmdID, HBITMAP bitmap, const TCHAR* text,
								COLORREF transparent, COLORREF color, COLORREF highlight, COLORREF bghighlight,
								unsigned int alphablending, 
								bool boldhighlight, bool underlinehighlight,
								unsigned int indent);
			DLL_EXPORT
			bool RemoveContentLink(unsigned int cmdID);
			DLL_EXPORT
			bool ClearAllContentLinks(void);

			// ----------------------------------------------------
			// LinkBar
			// ----------------------------------------------------
			DLL_EXPORT
			bool SetLinkBarIndent(unsigned int x, unsigned int y);
			DLL_EXPORT
			bool SetLinkBarHeight(unsigned int height);
			DLL_EXPORT
			bool SetLinkBarBorder(BorderSide borderside,
								  COLORREF color, unsigned int alphablending,
								  unsigned int width, 
								  unsigned int indentx, unsigned int indenty);
			DLL_EXPORT
			bool SetLinkBarBackgroundImage(HBITMAP bitmap, bool scale, 
										   bool grayscale);
			DLL_EXPORT
			bool SetLinkBarBackgroundGradient(COLORREF first, COLORREF second,
											  bool horizontal);
			DLL_EXPORT
			bool SetLinkBarTextFont(const TCHAR* fontname, unsigned int fontsize,
									bool bold, bool italic, bool underline);
			DLL_EXPORT
			bool SetLinkBarVerticalSeparator(bool show, COLORREF color, 
											 unsigned int width, unsigned int indent);
			DLL_EXPORT
			bool SetLinkBarTips(bool show, bool ontop, 
								COLORREF text, COLORREF background, unsigned int alphablending);
			DLL_EXPORT
			bool SetLinkBarTipsFont(const TCHAR* fontname, unsigned int fontsize,
									bool bold, bool italic, bool underline);

			// ----------------------------------------------------
			// Link On LinkBar
			// ----------------------------------------------------
			DLL_EXPORT
			bool AddLink(unsigned int cmdID, const TCHAR* text, const TCHAR* tips,
						 COLORREF color, COLORREF highlight, COLORREF bghighlight,
						 unsigned int alphablending, 
						 bool boldhighlight, bool underlinehighlight, 
						 unsigned int indent);
			DLL_EXPORT
			bool RemoveLink(unsigned int cmdID);
			DLL_EXPORT
			bool ClearAllLinks(void);



		private:
			// ----------------------------------------------------
			// Window Handles
			// ----------------------------------------------------
			HWND hWndLabel;
			HWND hWndParent;

			// ----------------------------------------------------
			// STRUCT - Font
			// ----------------------------------------------------
			typedef struct STRUCT_FONT_STYLE
			{
				wstring wsFontName;
				unsigned int iFontSize;
				bool bBold;
				bool bItalic;
				bool bUnderline;
			}structFontStyle;

			// ----------------------------------------------------
			// STRUCT - Line Style
			// ----------------------------------------------------
			typedef struct STRUCT_LINE_STYLE
			{
				unsigned int iLineWidth;
				COLORREF clrLineColor;
				unsigned int iLeftIndent;
				unsigned int iRightIndent;
				//LineStyle enumLineStyle;

			}structLineStyle;

			// ----------------------------------------------------
			// STRUCT - Hightlight
			// ----------------------------------------------------
			typedef struct STRUCT_HIGHLIGHT
			{
				bool bEnableHighLight;
				HighlightStyle enumHighlight;
				COLORREF clrHighlightColor;
				COLORREF clrHighlightTextColor;

				unsigned int iAlphaBlending;
				unsigned int iHighlightBorderWidth;
				unsigned int iOffSetX;
				unsigned int iOffSetY;
			}structHighlight;

			// ----------------------------------------------------
			// STRUCT - ContentLink
			// ----------------------------------------------------
			typedef struct LABEL_CONTENTLINK
			{
				UINT iCommandID;
				wstring wsText;
				wstring wsTips;

				HBITMAP hBitmapSideImage;
				COLORREF clrBitmapTransparentColor;

				RECT rectArea;
				COLORREF clrTextColor;
				COLORREF clrTextHighlightColor;
				COLORREF clrBackgroundHighlightColor;
				unsigned int iAlphaBlending;
				bool bBoldOnHighlight;
				bool bUnderlineOnHighlight;

				unsigned int iIndent;
			}structContentLink;

			// ----------------------------------------------------
			// STRUCT - Content
			// ----------------------------------------------------
			typedef struct LABEL_CONTENT
			{
				unsigned int iIndentX;
				unsigned int iIndentY;

				unsigned int iSideImageHeight;
				unsigned int iSideImageWidth;

				structFontStyle structFontStyleText;
			}structContent;

			// ----------------------------------------------------
			// STRUCT - Link
			// ----------------------------------------------------
			typedef struct LABEL_LINK
			{
				UINT iCommandID;
				wstring wsText;
				wstring wsTips;

				RECT rectArea;
				COLORREF clrTextColor;
				COLORREF clrTextHighlightColor;
				COLORREF clrBackgroundHighlightColor;
				unsigned int iAlphaBlending;
				bool bBoldOnHighlight;
				bool bUnderlineOnHighlight;

				unsigned int iIndent;
			}structLink;

			// ----------------------------------------------------
			// STRUCT - LinkBar
			// ----------------------------------------------------
			typedef struct LABEL_LINK_BAR
			{
				// X/Y Indent/OffSet
				unsigned int iIndentX;
				unsigned int iIndentY;

				// Header Height
				unsigned int iHeight;

				// Border Style
				structLineStyle structLeftBorder;
				structLineStyle structRightBorder;
				structLineStyle structTopBorder;
				structLineStyle structBottomBorder;

				// Background Color
				COLORREF clrGradientFirstColor;
				COLORREF clrGradientSecondColor;
				bool bGradientHorizontal;

				// Background Image/Bitmap
				HBITMAP hBackgroundBitmap;
				bool bBackgroundScale;
				bool bBackgroundGrayScale;
				bool bDrawBackgroundImage;

				structFontStyle structFontStyleText;

				bool bShowVerticalBar;
				COLORREF clrVerticalBarColor;
				unsigned int iVerticalBarWidth;
				unsigned int iVerticalBarIndent;

				bool bShowBarTips;
				bool bShowTipsOnTop;
				COLORREF clrBarTipsTextColor;
				COLORREF clrBarTipsBackgroundColor;
				unsigned int iBarTipsAlphaBlending;
				structFontStyle structFontStyleTips;

			}structLinkBar;

			// ----------------------------------------------------
			// STRUCT - Header Style - Details
			// ( Re-used By Standard Style! )
			// ----------------------------------------------------
			typedef struct LABEL_HEADER_DETAILS_STYLE
			{
				unsigned int iIndentX;
				unsigned int iIndentY;

				HBITMAP hBitmapSideImage;
				unsigned int iBitmapWidth;
				unsigned int iBitmapHeight;
				bool bBitmapGrayScale;
				bool bBitmapScale;
				COLORREF clrBitmapTransparentColor;

				wstring wsTitle;
				structFontStyle structFontStyleTitle;
				COLORREF clrTitleColor;
				unsigned int iTitleTextAlignment;

				wstring wsDescription;
				structFontStyle structFontStyleDescription;
				COLORREF clrDescriptionColor;
				unsigned int iDescriptionTextAlignment;

			}structLabelHeaderDetailsStyle;

			// ----------------------------------------------------
			// STRUCT - Header
			// ----------------------------------------------------
			typedef struct LABEL_HEADER
			{
				// X/Y Indent/OffSet
				unsigned int iIndentX;
				unsigned int iIndentY;

				// Header Height
				unsigned int iHeight;

				// Border Style
				structLineStyle structLeftBorder;
				structLineStyle structRightBorder;
				structLineStyle structTopBorder;
				structLineStyle structBottomBorder;

				// Background Color
				COLORREF clrGradientFirstColor;
				COLORREF clrGradientSecondColor;
				bool bGradientHorizontal;

				// Background Image/Bitmap
				HBITMAP hBackgroundBitmap;
				bool bBackgroundScale;
				bool bBackgroundGrayScale;
				bool bDrawBackgroundImage;

				// Header's Contents
				structLabelHeaderDetailsStyle LabelHeaderDetailsStyle;
				structLabelHeaderDetailsStyle LabelHeaderStandardStyle_Left;
				//structLabelHeaderDetailsStyle LabelHeaderStandardStyle_Center;
				//structLabelHeaderDetailsStyle LabelHeaderStandardStyle_Right;

			}structLabelHeader;

			// ----------------------------------------------------
			// STRUCT - Body
			// ----------------------------------------------------
			typedef struct LABEL_BODY
			{
				// Border Style
				structLineStyle structLeftBorder;
				structLineStyle structRightBorder;
				structLineStyle structTopBorder;
				structLineStyle structBottomBorder;

				// Background Color
				COLORREF clrGradientFirstColor;
				COLORREF clrGradientSecondColor;
				bool bGradientHorizontal;

				// Background Image/Bitmap
				HBITMAP hBackgroundBitmap;
				bool bBackgroundScale;
				bool bBackgroundGrayScale;
				bool bDrawBackgroundImage;

			}structLabelBody;

			// ----------------------------------------------------
			// REAL Variables
			// ----------------------------------------------------
			bool bUseHighQualitySmoothingMode;
			bool bUseClearType;
			bool bContentLinkNormalMode;
			structLabelBody		LabelBody;
			structLabelHeader	LabelHeader;
			structContent		LabelContent;
			structLinkBar		LinkBar;
			structHighlight		LabelBodyHighlight;
			structHighlight		LabelHeaderHighlight;
			structHighlight		LabelLinkBarHighlight;

			// ----------------------------------------------------
			// To keep track the Size & Position of Header/LinkBar
			// ----------------------------------------------------
			RECT rectHeader;
			RECT rectLinkBar;
			bool bIsMouseOverHeader;
			bool bIsMouseOverContentLink;
			bool bIsMouseOverLinkBar;

			// ----------------------------------------------------
			// Body OnClick's Command ID
			// ----------------------------------------------------
			int iBodyOnClickCommandID;

			// ----------------------------------------------------
			// Header OnClick's Command ID
			// ----------------------------------------------------
			int iHeaderOnClickCommandID;

			// ----------------------------------------------------
			// Links (For LinkBar)
			// ----------------------------------------------------
			vector<InnoStage::GUI::EnhancedLabel::structLink> vLinkBars;

			// ----------------------------------------------------
			// Links (For Content)
			// ----------------------------------------------------
			vector<InnoStage::GUI::EnhancedLabel::structContentLink> vContentLinks;

			// ----------------------------------------------------
			// REAL Variables
			// ----------------------------------------------------
			unsigned int iMouseX;
			unsigned int iMouseY;
			bool bOnMouseLeftDown;
			bool bOnMouseRightDown;
			bool bOnMouseHover;
			bool bOnMouseLeave;
			bool bOnMouseMove;

			// ----------------------------------------------------
			// ProductKey Variables
			// ----------------------------------------------------
			static wstring wsProductName;
			static wstring wsCompanyName;
			static wstring wsProductDescription;
			static wstring wsProductKey;
			static wstring wsProductAuthID;



			bool _DoPainting(HWND hWnd, HDC dc);
			bool _DrawStandard(Graphics *graphics, structLabelHeaderDetailsStyle *standard,
							   RectF *rectfHeader);
			bool _DrawDetails(Graphics *graphics, structLabelHeaderDetailsStyle *details,
							  RectF *rectfHeader);
			bool _DrawBorder(Graphics *graphics, RectF *rectf, 
							 structLineStyle *line, BorderSide borderside,
							 bool controlframe);
			bool _DrawText(Graphics *graphics, const TCHAR* text, 
						   structFontStyle* fontstyle,
						   Color *color, RectF *rectf, 
						   unsigned int alignment, bool verticalcenter,
						   bool bolddefault, unsigned int *fontheight);
			bool _DrawContentLinks(Graphics *graphics, RectF *rectf);
			bool _DrawLinks(Graphics *graphics, RectF *rectf);

			bool _ConvertBitmapToGray(Bitmap *bitmap);



			bool _IsMouseOnHeader(unsigned int x, unsigned int y);
			bool _IsMouseOnContentLink(unsigned int x, unsigned int y);
			bool _IsMouseOnLinkBar(unsigned int x, unsigned int y);
			int _GetContentLinkCommandID(unsigned int x, unsigned int y);
			int _GetLinkBarCommandID(unsigned int x, unsigned int y);

			bool _InitVals(void);
		};
	};
};

#endif // _INNOSTAGE_GUI_ENHANCED_LABEL_






