'=====================================================
'                                                    '
'        ---------------------------------           '                                                  
'        MouseOverControls.inc (Version 5)           '
'        ---------------------------------           '
'                                                    '
' This include file will let you know when the mouse ' 
' position is over a control that you specify.       '
'                                                    '
'                    By Andy.                        '
'                                                    '
'=====================================================

$ifndef __windowssdk_inc__
    $define __winreg_inc__
    $include "windowssdk.inc"
$endif

'=====================================================
' We need this function to get the mouse co-ordinates.
'=====================================================

$ifndef __windowssdk_inc__
    declare "user32",GetCursorPos(pPoint:POINTAPI),INT
    declare "user32",DestroyWindow(uint hWnd),int
$endif

Type MOCPos
     Def MOxposition:int
     Def MOyposition:int
Endtype

Def MOpt:MOCpos

int MOoldx = 0
int MOoldy = 0
int Momx = 0
int MOmy = 0

'===================================================================
' Somewhere to store the window and control co-ordinates, sizes etc.
'
' 1,000 windows and 10,000 controls.
'
'===================================================================
int MOControlDown[10000],MOControlAcross[10000],MOControlWidth[10000],MOControlHeight[10000]
int MOControlNumber[10000],MOControlTrack[10000],MOControlOverNumber[10000]
int MOWindowDown[1000],MOWindowAcross[1000],MOWindowWidth[1000],MOWindowHeight[1000],MOWindowOverNumber[1000]
int MOWindowLeft[1000],MOWindowRight[1000],MOWindowTop[1000],MOWindowBottom[1000]
UINT MOControlsWindow[10000],MOWindowPointer[1000]
string MOWindowName[1000],MOWindowDesc[1000],MOControlType[10000]
string MOMouseOverType = ""

'=====================
' Some variables used.
'=====================
int MOControlIndex,MOWindowIndex,MOControlXpos,MOControlYpos,MOWindowXpos,MOWindowYpos
int MOYcounter,MOZcounter,MOWcounter,MOWMcounter
int MOControlUpdated,MOWindowUpdated
int MONoLongerOver,MOMouseIsOverWindow,MOMouseIsOverControl,MOWindowMovedCheck
int MOMouseOverClick = 0
int MOWindowMovedLeft,MOWindowMovedRight,MOWindowMovedUp,MOWindowMovedDown
int MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
int MOOldWindowLeft,MOOldWindowRight,MOOldWindowTop,MOOldWindowBottom
int MOoffx = 0
int MOoffy = 0
int MOClick = 0
int MODone = 0
int MOlx = 0
int MOly = 0
int MOMoving = 0
int Mol,Mot,MOw,MOh
int MOwl,MOwt,MOww,MOwh
uint MOOldWindow

'============================================================
' Here we store a window's name after the OPENWINDOW command. 
'============================================================
sub SetWindowName(window MOWindowIn,string MOWindowNameIn),int
    SetWindowLong(MOWindowIn.hwnd,GWL_USERDATA,&MOWindowNameIn)
return 0
endsub

'============================================================================================
' Store the control co-ordinates, but first check to see if the control for that window
' has already been stored - if so update the Handle of the window for that control, otherwise
' it has not been stored before - so store it.
'============================================================================================
sub MouseOverControl(window MOMyWin,int MOMyControl,opt int MOMMakeBorder)

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOMyWin.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

	 WindowForMouse(MOMyWin,MOMyWinDescX)

	 MOControlUpdated = 0

	 '================================================================================
	 ' If control details have already been stored - update the window Handle details.
	 '
	 ' Closing a window and then re-opening it again causes that window to change It's
	 ' Handle details, so always update each control with the current window Handle.
	 '================================================================================
	 if MOControlIndex >= 1
		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOMyControl and MOWindowName[MOZcounter] = ltrim$(MOMyWinDescX)
				  MOControlsWindow[MOZcounter] = MOMyWin.hwnd
				  MOControlUpdated = 1
				  breakfor
			  endif
		 next MOZcounter
	 endif

	 '==================================================================
	 ' Control details have not yet been stored - so here we store them.
	 '==================================================================
	 if MOControlUpdated = 0
		 MOControlIndex += 1
		 GetSize MOMyWin,MOControlAcross[MOControlIndex],MOControlDown[MOControlIndex],MOControlWidth[MOControlIndex],MOControlHeight[MOControlIndex],MOMyControl
		 MOControlNumber[MOControlIndex] = MOMyControl
		 MOControlsWindow[MOControlIndex] = MOMyWin.hwnd
		 MOWindowName[MOControlIndex]   = ltrim$(MOMyWinDescX)
       MOControlTrack[MOControlIndex] = 1
		 MOControlOverNumber[MOControlIndex] = 0
	 endif

return 0
endsub

sub ButtonStyle(window MOMyWin,int MOMyControl)

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOMyWin.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

	 WindowForMouse(MOMyWin,MOMyWinDescX)

	 MOControlUpdated = 0

	 '================================================================================
	 ' If control details have already been stored - update the window Handle details.
	 '
	 ' Closing a window and then re-opening it again causes that window to change It's
	 ' Handle details, so always update each control with the current window Handle.
	 '================================================================================

	 if MOControlIndex >= 1
		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOMyControl and MOWindowName[MOZcounter] = ltrim$(MOMyWinDescX)
				  MOControlsWindow[MOZcounter] = MOMyWin.hwnd
				  MOControlUpdated = 1

              ModifyStyle MOMyWin,WS_DLGFRAME,0,MOMyControl
              RedrawFrame MOMyWin,MOMyControl

				  breakfor
			  endif
		 next MOZcounter
	 endif
return 0
endsub

'=============================================================================================
' Here we check to see if the mouse is over a control - 0 false, 1 Moved over, 2 Remains over. 
'=============================================================================================
sub MouseOver(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    for MOZcounter = 1 to MOControlIndex
        if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
           if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1

              if MOControlType[MOZcounter] = ""

                  string MOControlName = ""
						POINT MOWindowInp
						MOWindowInp.x = MOUSEX()
						MOWindowInp.y = MOUSEY()

						ScreenToClient(MOControlsWindowIn.hwnd,MOWindowInp)
						
						HWND MOHandle = ChildWindowFromPoint(MOControlsWindowIn.hwnd,MOWindowInp)
						
						IF MOHandle THEN
							GetClassName(MOHandle,MOControlName,255)
							
							' Here we Handle the different button types
							IF UCASE$(MOControlName) = UCASE$("Button") THEN
								DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
								
								IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
								IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
							ENDIF
					
						ENDIF

						MOControlType[MOZcounter] = ucase$(MOControlName) 

              endif

              if MOControlOverNumber[MOZcounter] = 0
                 MOMouseIsOverControl = 1
                 MOControlOverNumber[MOZcounter] = 1 
                 MOMouseOverType = MOControlType[MOZcounter]
              else
                 MOMouseIsOverControl = 2
                 MOMouseOverType = MOControlType[MOZcounter]
              endif
           else
              MOMouseIsOverControl = 0
              MOMouseOverType = ""
           endif
           breakfor
        endif
    next MOZcounter

return MOMouseIsOverControl
endsub

'===============================================================================================
' Here we check if control was pointed to but is no longer pointed at - Returns 1 true, 0 false.  
'===============================================================================================
sub MouseMovedOff(window MOControlsWindowIn,INT MOMovedOff),int

    MONoLongerOver = 0

    for MOYcounter = 1 to MOControlIndex
        if MOControlNumber[MOYcounter] = MOMovedOff and MOControlsWindow[MOYcounter] = MOControlsWindowIn.hwnd and MOControlTrack[MOYcounter] = 1
           if MOControlOverNumber[MOYcounter] = 1 and MOMouseIsOverControl <> 2
              MOControlOverNumber[MOYcounter] = 0
              MONoLongerOver = 1 
           endif
           breakfor
        endif
    next MOYcounter

return MONoLongerOver
endsub

sub ControlClick(window MOControlsWindowIn,INT MOButtonIndex),int

stoptimer MOControlsWindowIn

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseOverClick = 0
    MOMouseOverType = ""

    if mousedown(1)

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1
                 MOMouseOverClick = 1
				  endif
				  breakfor
			  endif
		 next MOZcounter
    endif  

starttimer MOControlsWindowIn,50

return MOMouseOverClick
endsub

sub ControlClickUp(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1
                 if mousedown(1)
                    MOMouseIsOverControl = 1
                 else
                    MOMouseIsOverControl = 0
                 endif
				  endif
				  breakfor
			  endif
		 next MOZcounter

   do:until mousedown(1) = 0 

return MOMouseIsOverControl
endsub

sub ControlRClick(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    if mousedown(2)

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1

					  if MOControlType[MOZcounter] = ""

							string MOControlName = ""
							POINT MOWindowInp
							MOWindowInp.x = MOUSEX()
							MOWindowInp.y = MOUSEY()

							ScreenToClient(MOControlsWindowIn.hwnd,MOWindowInp)
							
							HWND MOHandle = ChildWindowFromPoint(MOControlsWindowIn.hwnd,MOWindowInp)
							
							IF MOHandle THEN
								GetClassName(MOHandle,MOControlName,255)
								
								' Here we Handle the different button types
								IF UCASE$(MOControlName) = UCASE$("Button") THEN
									DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
									
									IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
									IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
								ENDIF
						
							ENDIF

							MOControlType[MOZcounter] = ucase$(MOControlName) 

					  endif

					  if MOControlOverNumber[MOZcounter] = 0
						  MOMouseIsOverControl = 1
						  MOControlOverNumber[MOZcounter] = 1 
						  MOMouseOverType = MOControlType[MOZcounter]
					  else
						  MOMouseIsOverControl = 2
						  MOMouseOverType = MOControlType[MOZcounter]
					  endif
				  else
					  MOMouseIsOverControl = 0
					  MOMouseOverType = ""
				  endif
				  breakfor
			  endif
		 next MOZcounter
   endif  

return MOMouseIsOverControl
endsub

sub ControlRClickUp(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    if mousedown(2)

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1

					  if MOControlType[MOZcounter] = ""

							string MOControlName = ""
							POINT MOWindowInp
							MOWindowInp.x = MOUSEX()
							MOWindowInp.y = MOUSEY()

							ScreenToClient(MOControlsWindowIn.hwnd,MOWindowInp)
							
							HWND MOHandle = ChildWindowFromPoint(MOControlsWindowIn.hwnd,MOWindowInp)
							
							IF MOHandle THEN
								GetClassName(MOHandle,MOControlName,255)
								
								' Here we Handle the different button types
								IF UCASE$(MOControlName) = UCASE$("Button") THEN
									DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
									
									IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
									IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
								ENDIF
						
							ENDIF

							MOControlType[MOZcounter] = ucase$(MOControlName) 

					  endif

					  if MOControlOverNumber[MOZcounter] = 0
						  MOMouseIsOverControl = 1
						  MOControlOverNumber[MOZcounter] = 1 
						  MOMouseOverType = MOControlType[MOZcounter]
					  else
						  MOMouseIsOverControl = 2
						  MOMouseOverType = MOControlType[MOZcounter]
					  endif
				  else
					  MOMouseIsOverControl = 0
					  MOMouseOverType = ""
				  endif
				  breakfor
			  endif
		 next MOZcounter
   endif 

   do:until mousedown(2) = 0 

return MOMouseIsOverControl
endsub

'===========================================================================
' Store the window co-ordinates, but first check to see if the window
' has already been stored - if so update the Handle of the window, otherwise
' it has not been stored before - so store it.
'===========================================================================
sub WindowForMouse(window MOMyWin,string MyWinDesc)

MOWindowUpdated = 0

'================================================================================
' If window details have already been stored - update the window Handle details.
'
' Closing a window and then re-opening it again causes that window to change It's
' Handle details, so always update each control with the current window Handle.
'================================================================================
if MOWindowIndex >= 1
   for MOWcounter = 1 to MOWindowIndex
       if MOWindowDesc[MOWcounter] = ltrim$(MyWinDesc)
          MOWindowPointer[MOWcounter] = MOMyWin.hwnd
          MOWindowUpdated = 1
          breakfor
       endif
   next MOWcounter
endif

'=================================================================
' Window details have not yet been stored - so here we store them.
'=================================================================
if MOWindowUpdated = 0
   MOWindowIndex += 1
   GetSize MOMyWin,MOWindowAcross[MOWindowIndex],MOWindowDown[MOWindowIndex],MOWindowWidth[MOWindowIndex],MOWindowHeight[MOWindowIndex]
   MOWindowPointer[MOWindowIndex]    = MOMyWin.hwnd
   MOWindowDesc[MOWindowIndex]       = ltrim$(MyWinDesc)
   MOWindowOverNumber[MOWindowIndex] = 0

    int a,d,w,h
	 GetSize MOMyWin,a,d,w,h
    MOWindowLeft[MOWcounter] = a
    MOWindowTop[MOWcounter]  = d

endif

GetSize MOMyWin,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
MOOldWindow = MOMyWin.hwnd

return 0
endsub

'==============================================================================
' Here we check to see if the mouse is over the window - 0 false, 1 Moved over. 
'==============================================================================
sub TrackWindow(window MOWindowIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

	 GetCursorPos(MOpt)
	 MOWindowXpos = MOpt.MOxposition
	 MOWindowYpos = MOpt.MOyposition

	 for MOWcounter = 1 to MOWindowIndex
	     if MOWindowPointer[MOWcounter] = MOWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)

		     '=============================================
		     ' Update the window with it's new coordinates.
		     '=============================================

		     GetSize MOWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter]
 
           int a,d,w,h
		     GetSize MOWindowIn,a,d,w,h


'setcaption MOWindowIn,str$(MOWindowLeft[MOWcounter])+ " ol " + str$(MOOldWindowLeft) + " R " + str$(MOWindowRight[MOWcounter]) + " T " + str$(MOWindowTop[MOWcounter]) + " B " + str$(MOWindowBottom[MOWcounter])


if MOWindowLeft[MOWcounter] <> a and MOWindowTop[MOWcounter] <> d and MOWindowRight[MOWcounter] = a + w and MOWindowBottom[MOWcounter] = d + h
'openconsole
'closeconsole

MOWindowLeft[MOWcounter] = a
MOWindowTop[MOWcounter]  = d
endif


           'Window resize left check   
           if MOOldWindow = MOWindowIn.hwnd and MOOldWindowAcross <> MOWindowAcross[MOWcounter] and MOOldWindowDown = MOWindowDown[MOWcounter] and MOOldWindowWidth <> MOWindowWidth[MOWcounter] and MOOldWindowHeight = MOWindowHeight[MOWcounter]
			     GetSize MOWindowIn,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
              MOWindowMovedLeft = 1
           else
              MOWindowMovedLeft = 0
           endif 

           'Window resize right check
           if MOOldWindow = MOWindowIn.hwnd and MOOldWindowAcross = MOWindowAcross[MOWcounter] and MOOldWindowDown = MOWindowDown[MOWcounter] and MOOldWindowWidth <> MOWindowWidth[MOWcounter] and MOOldWindowHeight = MOWindowHeight[MOWcounter]
			     GetSize MOWindowIn,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
              MOWindowMovedRight = 1
           else
              MOWindowMovedRight = 0
           endif 

           'Window resize top check
           if MOOldWindow = MOWindowIn.hwnd and MOOldWindowAcross = MOWindowAcross[MOWcounter] and MOOldWindowDown <> MOWindowDown[MOWcounter] and MOOldWindowWidth = MOWindowWidth[MOWcounter] and MOOldWindowHeight <> MOWindowHeight[MOWcounter]
			     GetSize MOWindowIn,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
              MOWindowMovedUp = 1
           else
              MOWindowMovedUp = 0
           endif

           'Window resize bottom check
           if MOOldWindow = MOWindowIn.hwnd and MOOldWindowAcross = MOWindowAcross[MOWcounter] and MOOldWindowDown = MOWindowDown[MOWcounter] and MOOldWindowWidth = MOWindowWidth[MOWcounter] and MOOldWindowHeight <> MOWindowHeight[MOWcounter]
			     GetSize MOWindowIn,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
              MOWindowMovedDown = 1
           else
              MOWindowMovedDown = 0
           endif

           
           'New co-orfinates for the window
           if MOOldWindow = MOWindowIn.hwnd and MOOldWindowAcross <> MOWindowAcross[MOWcounter] or MOOldWindowDown <> MOWindowDown[MOWcounter] or MOOldWindowWidth <> MOWindowWidth[MOWcounter] or MOOldWindowHeight <> MOWindowHeight[MOWcounter]
			     GetSize MOWindowIn,MOOldWindowAcross,MOOldWindowDown,MOOldWindowWidth,MOOldWindowHeight
				  MOWindowLeft[MOWcounter]   = MOOldWindowAcross
				  MOWindowRight[MOWcounter]  = MOOldWindowAcross + MOOldWindowWidth
				  MOWindowTop[MOWcounter]    = MOOldWindowDown
				  MOWindowBottom[MOWcounter] = MOOldWindowDown + MOOldWindowHeight

              MOOldWindowLeft   = MOOldWindowAcross
              MOOldWindowRight  = MOOldWindowAcross + MOOldWindowWidth
              MOOldWindowTop    = MOOldWindowDown
              MOOldWindowBottom = MOOldWindowDown + MOOldWindowHeight 

              MOWindowMovedCheck = 1
           else
              MOWindowMovedCheck = 0
           endif 

		     '======================================================
		     ' Here we check to see if the mouse is over the window.
		     '======================================================

		     if MOWindowXpos >= MOWindowAcross[MOWcounter] and MOWindowXpos <= MOWindowAcross[MOWcounter] + MOWindowWidth[MOWcounter] and MOWindowYpos >= MOWindowDown[MOWcounter] and MOWindowYpos <= MOWindowDown[MOWcounter] + MOWindowHeight[MOWcounter] 
			     MOMouseIsOverWindow = 1
		     else
			     MOMouseIsOverWindow = 0
		     endif
		     breakfor
	     endif
	 next MOWcounter

    '===========================================================
    ' Update the controls with their new co-ordinates and sizes. 
    '===========================================================

	 for MOWMcounter = 1 to MOControlIndex

 		  if MOControlsWindow[MOWMcounter] = MOWindowIn.hwnd and MOWindowName[MOWMcounter] = ltrim$(MOMyWinDescX)
           getsize MOWindowIn,MOControlAcross[MOWMcounter],MOControlDown[MOWMcounter],MOControlWidth[MOWMcounter],MOControlHeight[MOWMcounter],MOControlNumber[MOWMcounter]
		  endif

	 next MOWMcounter

return MOMouseIsOverWindow
endsub

'====================================
' Start tracking an existing control.
'====================================
sub StartTrackingControl(window MOControlsWindowIn,int MOControlNumberIn),int
    int MOStartTrackingControlValue = 0
	 for MOZcounter = 1 to MOControlIndex
		  if MOControlNumber[MOZcounter] = MOControlNumberIn and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
			  MOControlTrack[MOZcounter] = 1
           MOStartTrackingControlValue = 1
			  breakfor
		  endif
	 next MOZcounter
return MOStartTrackingControlValue
endsub

'===================================
' Stop tracking an existing control.
'===================================
sub StopTrackingControl(window MOControlsWindowIn,int MOControlNumberIn),int
    int MOStopTrackingControlValue = 0
	 for MOZcounter = 1 to MOControlIndex
		  if MOControlNumber[MOZcounter] = MOControlNumberIn and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
			  MOControlTrack[MOZcounter] = 0
           MOStopTrackingControlValue = 1
			  breakfor
		  endif
	 next MOZcounter
return MOStopTrackingControlValue
endsub

'=============================================
' Removes a control from the specified window.
'=============================================
sub DeleteControl(window MOControlsWindowIn,int MOControlNumberIn),int
    IF CONTROLEXISTs(MOControlsWindowIn,MOControlNumberIn)
       DestroyWindow(GETCONTROLHANDLE(MOControlsWindowIn,MOControlNumberIn))
		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOControlNumberIn and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  MOControlNumber[MOZcounter] = 10000
				  breakfor
			  endif
		 next MOZcounter
       Return 1
    endif
return 0
endsub

'=====================================
' Check if a control is being tracked.
'=====================================
sub TrackingControl(window MOControlsWindowIn,int MOControlNumberIn),int
    int ControlBeingTrackedValue = 0
	 for MOZcounter = 1 to MOControlIndex
		  if MOControlNumber[MOZcounter] = MOControlNumberIn and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
			  if MOControlTrack[MOZcounter] = 1
              ControlBeingTrackedValue = 1
           endif
			  breakfor
		  endif
	 next MOZcounter
return ControlBeingTrackedValue
endsub

'================================================
' Creates a Button and registers it for tracking.
'================================================
sub CreateButton(window MOWindowIn,string MOButtonTextIn,int MOButAcross,int MOButDown,int MOButLength,int MOButHeight,int MOButtonNumber)
	 IF !CONTROLEXISTs(MOWindowIn,MOButtonNumber)
		 uint dwStyle = WS_VISIBLE | WS_CHILD | WS_TABSTOP
		 CreateWindowEx(0, "BUTTON", MOButtonTextIn, dwStyle | BS_PUSHBUTTON,MOButAcross,MOButDown,MOButLength,MOButHeight,MOWindowIn.hwnd,MOButtonNumber,GetModuleHandle(0), 0)
		 MouseOverControl(MOWindowIn,MOButtonNumber)
	 endif
return
endsub

'==================================================
' Creates a Checkbox and registers it for tracking.
'==================================================
sub CreateCheckBox(window MOWindowIn,string MOButtonTextIn,int MOButAcross,int MOButDown,int MOButLength,int MOButHeight,int MOButtonNumber)
	 IF !CONTROLEXISTs(MOWindowIn,MOButtonNumber)
		 uint dwStyle = WS_VISIBLE | WS_CHILD | WS_TABSTOP
		 CreateWindowEx(0, "BUTTON", MOButtonTextIn, dwStyle | BS_AUTOCHECKBOX,MOButAcross,MOButDown,MOButLength,MOButHeight,MOWindowIn.hwnd,MOButtonNumber,GetModuleHandle(0), 0)
		 MouseOverControl(MOWindowIn,MOButtonNumber)
	 endif
return
endsub

'=====================================================
' Creates a Radiobutton and registers it for tracking.
'=====================================================
sub CreateRadio(window MOWindowIn,string MOButtonTextIn,int MOButAcross,int MOButDown,int MOButLength,int MOButHeight,int MOButtonNumber)
	 IF !CONTROLEXISTs(MOWindowIn,MOButtonNumber)
		 uint dwStyle = WS_VISIBLE | WS_CHILD | WS_TABSTOP
		 CreateWindowEx(0, "BUTTON", MOButtonTextIn, dwStyle | BS_AUTORADIOBUTTON,MOButAcross,MOButDown,MOButLength,MOButHeight,MOWindowIn.hwnd,MOButtonNumber,GetModuleHandle(0), 0)
		 MouseOverControl(MOWindowIn,MOButtonNumber)
	 endif
return
endsub

sub CreateStatic(window MOWindowIn,string MOButtonTextIn,int MOButAcross,int MOButDown,int MOButLength,int MOButHeight,int MOButtonNumber)
	 IF !CONTROLEXISTs(MOWindowIn,MOButtonNumber)
		 uint dwStyle = WS_VISIBLE | WS_CHILD
		 CreateWindowEx(0, "STATIC", MOButtonTextIn, dwStyle ,MOButAcross,MOButDown,MOButLength,MOButHeight,MOWindowIn.hwnd,MOButtonNumber,GetModuleHandle(0), 0)
		 MouseOverControl(MOWindowIn,MOButtonNumber)
	 endif
return
endsub

'=======================================================================================
' Here we check to see if the mouse is over any specific control type - 0 false, 1 true. 
'=======================================================================================
SUB MouseOverControlType(WINDOW MOWindowIn,string MOControlTypeIn),int 
	 string MOControlName = ""
	 POINT MOmop
	 MOmop.x = MOUSEX()
	 MOmop.y = MOUSEY()
	 ScreenToClient(MOWindowIn.hwnd,MOmop)
	
	 HWND MOHandle = ChildWindowFromPoint(MOWindowIn.hwnd,MOmop)
	
	 IF MOHandle THEN
		 GetClassName(MOHandle,MOControlName,255)
		
		 ' Here we Handle the different button types
		 IF UCASE$(MOControlName) = UCASE$("Button") THEN
			 DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
		 ENDIF
	 ENDIF

    ' B - Button
    ' C - Checkbox
    ' E - Edit
    ' L - Listbox
    ' R - Radio
    ' S - Static
    ' V - Listview

    if ucase$(MOControlName) = "BUTTON"      and ucase$(MOControlTypeIn) = "B" then return 1 
    if ucase$(MOControlName) = "CHECKBOX"    and ucase$(MOControlTypeIn) = "C" then return 1 
    if ucase$(MOControlName) = "EDIT"        and ucase$(MOControlTypeIn) = "E" then return 1 
    if ucase$(MOControlName) = "LISTBOX"     and ucase$(MOControlTypeIn) = "L" then return 1 
    if ucase$(MOControlName) = "RADIOBUTTON" and ucase$(MOControlTypeIn) = "R" then return 1 
    if ucase$(MOControlName) = "STATIC"      and ucase$(MOControlTypeIn) = "S" then return 1 
    if ucase$(MOControlName) = "LISTVIEW"    and ucase$(MOControlTypeIn) = "V" then return 1 
	
	 RETURN 0
ENDSUB

'=========================================================================
' Here we check to see if the mouse is over any control - 0 false, 1 true. 
'=========================================================================
SUB MouseOverAnyControl(WINDOW MOWindowIn),int 
	 string MOControlName = ""
	 POINT MOWindowInp
	 MOWindowInp.x = MOUSEX()
	 MOWindowInp.y = MOUSEY()
	 ScreenToClient(MOWindowIn.hwnd,MOWindowInp)
	
	 HWND MOHandle = ChildWindowFromPoint(MOWindowIn.hwnd,MOWindowInp)
	
	 IF MOHandle THEN
		 GetClassName(MOHandle,MOControlName,255)
		
		 ' Here we Handle the different button types
		 IF UCASE$(MOControlName) = UCASE$("Button") THEN
			 DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
			
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
		 ENDIF

	 ENDIF

    if ucase$(MOControlName) = "BUTTON"      then return 1 
    if ucase$(MOControlName) = "CHECKBOX"    then return 1 
    if ucase$(MOControlName) = "EDIT"        then return 1 
    if ucase$(MOControlName) = "LISTBOX"     then return 1 
    if ucase$(MOControlName) = "RADIOBUTTON" then return 1 
    if ucase$(MOControlName) = "STATIC"      Then return 1 
    if ucase$(MOControlName) = "LISTVIEW"    then return 1

return 0
ENDSUB

'==============================================================
' Here we check to see what type of control the mouse is over.
'
' Return values (a string in uppercase):
'
' "BUTTON"       
' "CHECKBOX"     
' "EDIT"        
' "LISTBOX"     
' "RADIOBUTTON"  
' "STATIC"      
' "LISTVIEW" 
' "CAPTION"  
' "EMERGENCEWNDCLASS" - over the window, but not over a control
' "" - Not over the window.
'
'==============================================================
SUB MouseOverWhichType(WINDOW MOWindowIn),string 
	 string MOControlName = ""
	 POINT MOWindowInp
	 MOWindowInp.x = MOUSEX()
	 MOWindowInp.y = MOUSEY()
	 ScreenToClient(MOWindowIn.hwnd,MOWindowInp)
	
	 HWND MOHandle = ChildWindowFromPoint(MOWindowIn.hwnd,MOWindowInp)
	
	 IF MOHandle THEN
	 	 GetClassName(MOHandle,MOControlName,255)
		
		 ' Here we Handle the different button types
		 IF UCASE$(MOControlName) = UCASE$("Button") THEN
			 DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
		 ENDIF
 
	 ENDIF

    int MOTrw = TrackWindow(MOWindowIn)

	 if MOTrw = 1 and MOControlName = ""
		 MOControlName = "Caption"
	 endif 

return ucase$(MOControlName)
ENDSUB

'==============================================================================
' Here we check to see if the mouse is over the caption area - 0 false, 1 true. 
'==============================================================================
SUB MouseOverCaption(WINDOW MOWindowIn),int 
	 string MOControlName = ""
	 POINT MOWindowInp
	 MOWindowInp.x = MOUSEX()
	 MOWindowInp.y = MOUSEY()
	 ScreenToClient(MOWindowIn.hwnd,MOWindowInp)

	 HWND MOHandle = ChildWindowFromPoint(MOWindowIn.hwnd,MOWindowInp)
	
	 IF MOHandle THEN
	 	 GetClassName(MOHandle,MOControlName,255)
		
		 ' Here we Handle the different button types
		 IF UCASE$(MOControlName) = UCASE$("Button") THEN
			 DWORD dwStyle = GetWindowLong(MOHandle, GWL_STYLE)
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTOCHECKBOX THEN MOControlName = "CHECKBOX"
			 IF (dwStyle & BS_TYPEMASK) = BS_AUTORADIOBUTTON THEN MOControlName = "RADIOBUTTON"
		 ENDIF
 
	 ENDIF

    int MOTrw = TrackWindow(MOWindowIn)

	 if MOTrw = 1 and MOControlName = "" 
		 return 1
	 endif 

return 0
ENDSUB

'===============================================
' You can use this to see if a window has focus. 
'===============================================
sub WindowHasFocus(window MOUsingWindow),int 
    if MOUsingWindow = GetForegroundWindow()
       return 1
    endif

return 0
endsub

'===============================================================================
' You can use this to see if a window is minimised / maximised / normal / moved. 
'===============================================================================
sub WindowMinimised(window MOMyWindowMin),int
	 if IsWindowVisible(MOMyWindowMin.hwnd)
		 if IsIconic(MOMyWindowMin.hwnd) 
          return 1 
		endif
    endif
return 0
endsub

sub WindowMinimized(window MOMyWindowMin),int
	 if IsWindowVisible(MOMyWindowMin.hwnd)
		 if IsIconic(MOMyWindowMin.hwnd) 
          return 1 
		endif
    endif
return 0
endsub

sub WindowMaximised(window MOMyWindowMax),int
	 if IsWindowVisible(MOMyWindowMax.hwnd)
		 if IsZoomed(MOMyWindowMax.hwnd) 
          return 1 
		endif
    endif
return 0
endsub

sub WindowMaximized(window MOMyWindowMax),int
	 if IsWindowVisible(MOMyWindowMax.hwnd)
		 if IsZoomed(MOMyWindowMax.hwnd) 
          return 1 
		endif
    endif
return 0
endsub

sub WindowNormal(window MOMyWindowNorm),int
	 if IsWindowVisible(MOMyWindowNorm.hwnd)
		 if !IsIconic(MOMyWindowNorm.hwnd)
			 if !IsZoomed(MOMyWindowNorm.hwnd) 
             return 1
          endif 
		endif
    endif
return 0
endsub

sub WindowMoved(window MOMyWindowIn),int 
return MOWindowMovedCheck
endsub

'=========================
' Start tracking a window.
'=========================
SUB StartTracking(WINDOW MOWindowIn,opt int MOMyTimerSpeed,opt int MOMyTimerID),int 
	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    MOWindowMovedCheck = 0

    if MOMyTimerSpeed < 1
       MOMyTimerSpeed = 50
    endif

    if MOMyTimerID > 0
       starttimer MOWindowIn,MOMyTimerSpeed,MOMyTimerID
    else
       starttimer MOWindowIn,MOMyTimerSpeed
    endif

return 0
endsub

'========================
' Stop tracking a window.
'========================
SUB StopTracking(WINDOW MOWindowIn,opt int MOMyTimerID),int 
	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOWindowIn.hwnd, GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    MOWindowMovedCheck = 0

    if MOMyTimerID > 0
       stoptimer MOWindowIn,MOMyTimerID
    else
       stoptimer MOWindowIn
    endif

return 0
endsub

'============================================================
' Tells you if the mouse is over the left border of a window.
'============================================================
sub MouseOverLeft(window MOControlsWindowIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd, GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    int MOaa,MOdd,MOww,MOhh
    GetSize MOControlsWindowIn,MOaa,MOdd,MOww,MOhh 

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter]
		     breakfor
	     endif

	 next MOWcounter

    int MOCordiff = abs(MOaa - MOControlXpos)

    if MOCordiff = 3 or MOCordiff = 2 and MOControlYpos and MOWindowYpos >= MOWindowDown[MOWcounter] and MOWindowYpos <= MOWindowDown[MOWcounter] + MOWindowHeight[MOWcounter] 
       return 1
    endif

return 0
endsub

'============================================================
' Tells you if the mouse is over the right border of a window.
'============================================================
sub MouseOverRight(window MOControlsWindowIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter]
		     breakfor
	     endif

	 next MOWcounter

    int MOCordiff = MOControlXpos - (MOWindowAcross[MOWcounter] + MOWindowWidth[MOWcounter])

    if MOCordiff = -3 or MOCordiff = -2 and MOControlYpos and MOWindowYpos >= MOWindowDown[MOWcounter] and MOWindowYpos <= MOWindowDown[MOWcounter] + MOWindowHeight[MOWcounter] 
       return 1
    endif

return 0
endsub

'===========================================================
' Tells you if the mouse is over the top border of a window.
'===========================================================
sub MouseOverTop(window MOControlsWindowIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter]
		     breakfor
	     endif

	 next MOWcounter

    if MOControlYpos =  MOWindowDown[MOWcounter] and MOWindowXpos >= MOWindowAcross[MOWcounter] and MOWindowXpos <= MOWindowAcross[MOWcounter] + MOWindowWidth[MOWcounter] 
       return 1 
    endif

return 0
endsub

'==============================================================
' Tells you if the mouse is over the bottom border of a window.
'==============================================================
sub MouseOverBottom(window MOControlsWindowIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter]
 		     breakfor
	     endif

	 next MOWcounter

    int MOCordiff = abs(MOControlYpos - (MOWindowDown[MOWcounter] + MOWindowHeight[MOWcounter]))

    if MOCordiff = 3 and MOWindowXpos >= MOWindowAcross[MOWcounter] and MOWindowXpos <= MOWindowAcross[MOWcounter] + MOWindowWidth[MOWcounter] 
       return 1 
    endif

return 0
endsub

'================================================
' Tells you if the left co-ordinate of a control.
'================================================
sub ControlLeft(window MOControlsWindowIn,int MOControlNumberIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter],MOControlNumberIn
		     breakfor
	     endif

	 next MOWcounter

    return MOWindowAcross[MOWcounter]

return 0
endsub

'=================================================
' Tells you if the right co-ordinate of a control.
'=================================================
sub ControlRight(window MOControlsWindowIn,int MOControlNumberIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter],MOControlNumberIn
		     breakfor
	     endif

	 next MOWcounter

    return MOWindowAcross[MOWcounter] + MOWindowWidth[MOWcounter]

return 0
endsub

'===============================================
' Tells you if the top co-ordinate of a control.
'===============================================
sub ControlTop(window MOControlsWindowIn,int MOControlNumberIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter],MOControlNumberIn
		     breakfor
	     endif

	 next MOWcounter

    return MOWindowDown[MOWcounter]

return 0
endsub

'==================================================
' Tells you if the bottom co-ordinate of a control.
'==================================================
sub ControlBottom(window MOControlsWindowIn,int MOControlNumberIn),int

	 string MOMyWinDescX = ""
	 pointer MOProp = GetWindowLong(MOControlsWindowIn.hwnd,GWL_USERDATA)		
	 IF MOProp THEN MOMyWinDescX = *<string>MOProp
	 delete MOProp

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

	 for MOWcounter = 1 to MOWindowIndex

	     if MOWindowPointer[MOWcounter] = MOControlsWindowIn.hwnd and MOWindowDesc[MOWcounter] = ltrim$(MOMyWinDescX)
		     GetSize MOControlsWindowIn,MOWindowAcross[MOWcounter],MOWindowDown[MOWcounter],MOWindowWidth[MOWcounter],MOWindowHeight[MOWcounter],MOControlNumberIn
		     breakfor
	     endif

	 next MOWcounter

    return MOWindowDown[MOWcounter] + MOWindowHeight[MOWcounter]

return 0
endsub

sub WindowResizeLeft(window MOWindowIn),int 
    return MOWindowMovedLeft
return 0
endsub

sub WindowResizeRight(window MOWindowIn),int 
    return MOWindowMovedRight
return 0
endsub

sub WindowResizeTop(window MOWindowIn),int 
    return MOWindowMovedUp
return 0
endsub

sub WindowResizeBottom(window MOWindowIn),int 
    return MOWindowMovedDown
return 0
endsub

sub WindowResizeTopLeft(window MOWindowIn),int 
'setcaption MOWindowIn,str$(MOWindowMovedLeft) + " " + str$(MOWindowMovedUp) + " -- " + str$(MOOldWindowAcross)
    if MOWindowMovedLeft = 1
       TrackWindow(MOWindowIn) 
       if MOWindowMovedUp = 1
          return 1
       endif
    endif
return 0
endsub

sub MouseOffsetX(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    for MOZcounter = 1 to MOControlIndex
        if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
           if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1
              return MOControlXpos - MOControlAcross[MOZcounter]
           endif
           breakfor
        endif
    next MOZcounter

return 0
endsub

sub MouseOffsetY(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

    for MOZcounter = 1 to MOControlIndex
        if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
           if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1
              return MOControlYpos - MOControlDown[MOZcounter]
           endif
           breakfor
        endif
    next MOZcounter

return 0 
endsub

sub ControlDrag(window MOControlsWindowIn,INT MOButtonIndex),int

stoptimer MOControlsWindowIn

     GetCursorPos(MOpt)

	  if MOoldx <> MOpt.MOxposition and MOoldy <> MOpt.MOyposition
		  MOoldx = MOpt.MOxposition
		  MOoldy = MOpt.MOyposition
	  else
        starttimer MOControlsWindowIn,50
		  return 0
	  endif

    GETSIZE MOControlsWindowIn, MOwl, MOwt, Moww, Mowh

    for MOZcounter = 1 to MOControlIndex
        if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
           MOw = MOControlWidth[MOZcounter]
           MOh = MOControlHeight[MOZcounter]
           breakfor
        endif
    next MOZcounter

do
     GetCursorPos(MOpt)
     MOControlXpos = MOpt.MOxposition
     MOControlYpos = MOpt.MOyposition

	  if MOClick = 0
	  if MOClick = 0 and MOlx <> MOControlXpos and MOly <> MOControlYpos and MouseOver(MOControlsWindowIn,MOButtonIndex)
		  MOlx = MOControlXpos
		  MOly = MOControlYpos
	  endif
     endif

	  '=============================
	  ' Control was left clicked.
	  '=============================

     if MOClick = 0
		  'if ControlClick(MOControlsWindowIn,MOButtonIndex) and MODone = 0 
		  if MODone = 0 
			  MOClick = 1
			  MOlx = MOControlXpos
			  MOly = MOControlYpos               
			  GETSIZE MOControlsWindowIn, MOl, MOt, MOw, MOh,MOButtonIndex
			  MOoffx = MouseOffsetX(MOControlsWindowIn,MOButtonIndex)
			  MOoffy = MouseOffsetY(MOControlsWindowIn,MOButtonIndex)
			  MODone = 1
		  endif
     endif

	  '=============================
	  ' Control is being moved.
	  '=============================

	  if MOClick = 1 and mousedown(1) and MOMoving = 1 and MOlx <> MOControlXpos and MOly <> MOControlYpos
        Momx = 0
        Momy = 0
		  MOmx = MOControlXpos 
		  MOmx = MOmx - MOwl - 5 - MOoffx
		  MOmy = MOControlYpos 
		  MOmy = MOmy - MOwt - 28 - MOoffy 
		  setsize MOControlsWindowIn,MOmx,MOmy,MOw,MOh,MOButtonIndex

        if MOoldx <> MOmx or MOoldy <> MOmy
           MOoldx = MOmx
           MOoldy = MOmy
        endif

	  endif

	  '=============================
	  ' Finished moving the control.
	  '=============================

	  if MOClick = 1 and mousedown(1) = 0 and MOMoving = 1
		  MOmx = MOControlXpos 
		  MOmx = MOmx - MOwl - 5 - MOoffx
		  MOmy = MOControlYpos 
		  MOmy = MOmy - MOwt - 28 - MOoffy
		  setsize MOControlsWindowIn,MOmx,MOmy,MOw,MOh,MOButtonIndex
		  setfocus MOControlsWindowIn,MOButtonIndex 
		  MOClick = 0
		  MODone = 0
		  MOMoving = 0
        break
	  endif

	  if MOClick = 1 and MOlx <> MOControlXpos and MOly <> MOControlYpos  
		  MOMoving = 1
		  MOmx = MOControlXpos 
		  MOmy = MOControlYpos 
	  endif

     'sleep(20)

until MOMoving = 0
starttimer MOControlsWindowIn,50
setfocus MOControlsWindowIn

return MOMoving 
endsub

sub ControlResizeL(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1

             int MOlr = MouseOffsetX(MOControlsWindowIn,MOButtonIndex)
				  if MOlr <=2 and MOlr <=4 
						  MOMouseIsOverControl = 1
                    setcursor MOControlsWindowIn,@CSWAIT
				  else
						  MOMouseIsOverControl = 0
				  endif

				  breakfor
              endif
			  endif
		 next MOZcounter

   'do:until mousedown(1) = 0 

	if MOMouseIsOverControl = 0
		setcursor MOControlsWindowIn,@CSARROW
	endif

	setcaption MOControlsWindowIn,str$(MOMouseIsOverControl)

return MOMouseIsOverControl
endsub

sub ControlResizeR(window MOControlsWindowIn,INT MOButtonIndex),int

    GetCursorPos(MOpt)
    MOControlXpos = MOpt.MOxposition
    MOControlYpos = MOpt.MOyposition

    MOMouseIsOverControl = 0
    MOMouseOverType = ""

		 for MOZcounter = 1 to MOControlIndex
			  if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
				  if MOControlXpos >= MOControlAcross[MOZcounter] and MOControlXpos <= MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] and MOControlYpos >= MOControlDown[MOZcounter] and MOControlYpos <= MOControlDown[MOZcounter] + MOControlHeight[MOZcounter] and MOControlTrack[MOZcounter] = 1

                 if mousedown(1)
						  int MOrr = MouseOffsetX(MOControlsWindowIn,MOButtonIndex)
						  if MOrr = MOControlWidth[MOZcounter] -2


				  if MOControlXpos = MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter] -2
								  MOMouseIsOverControl = 1
              endif
								  'setcursor MOControlsWindowIn,@CSWAIT
						  else
								  MOMouseIsOverControl = 0
						  endif
                 endif
				  breakfor
              endif 
			  endif
		 next MOZcounter

   'do:until mousedown(1) = 0 

	if MOMouseIsOverControl = 0
		'setcursor MOControlsWindowIn,@CSARROW
	endif

	setcaption MOControlsWindowIn,str$(MOMouseIsOverControl)

return MOMouseIsOverControl
endsub

sub ControlWidth(window MOControlsWindowIn,INT MOButtonIndex),int

    for MOZcounter = 1 to MOControlIndex
        if MOControlNumber[MOZcounter] = MOButtonIndex and MOControlsWindow[MOZcounter] = MOControlsWindowIn.hwnd
           'return MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter]
openconsole
do:until inkey$ <> ""
closeconsole

           breakfor
        endif
    next MOZcounter

return MOControlAcross[MOZcounter] + MOControlWidth[MOZcounter]
endsub


'=============================
' End of MouseOverControls.inc
'=============================
