
'=====================================================
'                                                    '
'        ---------------------------------           '                                                  
'          CustomWindow.inc (Version 10)             '
'        ---------------------------------           '
'                                                    '
'               Library version 4.2                  '  
'                                                    '
'     This include file will let you create a        ' 
'          custom menu / custom window.              '
'                                                    '
'                    By Andy.                        '
'                                                    '
'=====================================================

$ifndef __MouseOverControls_inc__
    $define __MouseOverControls_inc__
    $IncluDE "MouseOverControls.inc"
$endif

$use "customwindow10.lib"

'========================================================================================
'
' Default control error messages, 1 = on, 0 = off.
'
' Used to give you an error message when adding a new menu item AND the new control ID
' is already in use or the control's menu does not exist.  
'
'========================================================================================

extern cwErrorMessages as int 

cwErrorMessages = 1

'========================================================================================
'
' Default settings for normal & custom windows.
'
'========================================================================================

'Library external variables used by a window.
extern cwNormalWindow as int   
EXTERN cwPictureWidth as int   
EXTERN cwPictureHeight as int
EXTERN cwMenuItm as int  
EXTERN cwCaptionPosition as INT  
EXTERN cwAcross as int  

cwNormalWindow = 0 '<-- Set to 1 for a normal window (Default), 0 for a custom window (no Max box).

'Minimise and close images - image size is (36 x 26) used for a vustom window.
uint cwMinOn = loadimage(getstartpath + "minon.jpg",@IMGSCALABLE) '<-- Image for mouse over min button.
uint cwMinOff = loadimage(getstartpath + "minoff.jpg",@IMGSCALABLE) '<-- Image for mouse not over min button.
uint cwCloseOn = loadimage(getstartpath + "closeon.jpg",@IMGSCALABLE) '<-- Image for mouse over close button.
uint cwCloseoff = loadimage(getstartpath + "closeoff.jpg",@IMGSCALABLE) '<-- Image for mouse not over close button.

cwPictureWidth     = 36 'Custom window program icon width.

if cwNormalWindow  = 0
   cwPictureHeight = 26 'Custom window program icon height.
else
   cwPictureHeight = 0
endif

cwAcross           = 10 'Custom window program icon start position.
cwCaptionPosition  = cwPictureWidth 'Custom window caption start position.

'========================================================================================
'
' Library exteranl functions.
'
'========================================================================================

declare extern CreateCaption(window WinIn,int CaptionID,string CaptionIn,int MinIn,int CloseIn),int
declare extern CreateBorder(window WinIn,int IconIn,opt uint ColorIn),int
declare extern CreateNormalWindow(window WinIn),int
declare extern MyMenuTitle(string ButText,int ControlID,opt Uint FColourIn,opt Uint BColourIn,opt Uint HFColourIn,opt Uint HBColourIn),int
declare extern MyMenuItem(string ButText,string ShortcutText,int ControlID,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn),int
declare extern MyPopupTitle(string ButText,int ControlID,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn),int
declare extern MyPopupTitle2(string ButText,string ShortcutText,int ControlID,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn),int
declare extern MyPopupEnd(),int
declare extern MyPopupEnd2(),int
declare extern MyPopupItem(string ButText,string ShortcutText,int ControlID,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn),int
declare extern MyPopupItem2(string ButText,string ShortcutText,int ControlID,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn),int
declare extern MySeparator(int ControlID,opt int ColorFIn),int
declare extern MyPopupSeparator(int ControlID,opt int ColorFIn),int
declare extern MyPopupSeparator2(int ControlID,opt int ColorFIn),int
declare extern MyMenuUpdate(window WinIn),int
declare extern MyMenuEnd(window WinIn),int
declare extern HighlightMenuItems(window WinIn),int
declare extern ShowMenuItems(window WinIn,int MenuID),int
declare extern HideMenuItems(window WinIn,int MenuID),int
declare extern MenuClicked(window WinIn,int MenuID),int
declare extern MenuRefresh(window WinIn,int MenuID),int
declare extern HideAllMenuItems(window WinIn),int
declare extern EnableControls(window WinIn)
declare extern MenuChanged(window WinIn),int
declare extern MenuClickOff(window WinIn),int
declare extern MenuCheck(window WinIn),int
declare extern ExtractResource(id:INT, restype:INT, filename:STRING)
declare extern cwSubClassControl(WINDOW parent,INT id)
declare extern cwUnSubClassControl(WINDOW parent,INT id)
declare extern WindowResize(window WinIn,int CaptionIn,int MinIn,int CloseIn),int
declare extern MyWindowDone(window WinIn,int CaptionIn,int MinIn,int CloseIn),int
declare extern WindowMinSize(int MinXin,int MinYin,opt int MaxXin,opt int MaxYin),int 
declare extern DisablePopup(window WinIn,int ControlIn),int
declare extern EnablePopup(window WinIn,int ControlIn),int
declare extern DisableMenuTitle(window WinIn,int ControlIn),int
declare extern EnableMenuTitle(window WinIn,int ControlIn),int
declare extern DisableItem(window WinIn,int ControlIn),int
declare extern EnableItem(window WinIn,int ControlIn),int
declare extern SetItemTextFont(window WinIn,string FontIn,int SizeIn,int WeightIn,int StyleIn,int ControlIn),int
declare extern SetItemShortcutFont(window WinIn,string FontIn,int SizeIn,int WeightIn,int StyleIn,int ControlIn),int
declare extern SetItemColor(window WinIn,int ControlIn,int FcolorIn,int BcolorIn),int
declare extern SetShortcutColor(window WinIn,int ControlIn,int FcolorIn,int BcolorIn),int
declare extern SetItemState(window WinIn,int ControlIn,int StateIn),int 
declare extern GetItemState(window WinIn,int ControlIn),int
declare extern SetItemText(window WinIn,int ControlIn,string TextIn),int
declare extern SetItemShortcutText(window WinIn,int ControlIn,string TextIn),int
declare extern GetItemText(window WinIn,int ControlIn),string
declare extern GetItemShortcutText(window WinIn,int ControlIn),string
declare extern CheckStyleType(window WinIn,int ControlIn),int
declare extern SetItemIcon(window WinIn,int ControlID,uint IconIn),int
declare extern SetItemTextNow(window WinIn,int ControlIn,string TextIn),int
declare extern MyNewMenuItem(window WinIn,int MenuIn,string ButText,string ShortcutText,int ControlID,int PositionIn,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 
declare extern MyNewPopupItem(window WinIn,int MenuIn,string ButText,string ShortcutText,int ControlID,int PositionIn,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 
declare extern MyNewPopup2Item(window WinIn,int MenuIn,string ButText,string ShortcutText,int ControlID,int PositionIn,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 
declare extern DeleteMenuItem(window WinIn,int ControlID),int
declare extern CountMenuItems(window WinIn,int MenuIn),int
declare extern CountPopupItems(window WinIn,int MenuIn),int
declare extern CountPopup2Items(window WinIn,int MenuIn),int
declare extern MyNewSeparator(window WinIn,int MenuIn,int ControlID,int PositionIn,opt string ButText,opt string ShortcutText,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 
declare extern MyNewPopSeparator(window WinIn,int MenuIn,int ControlID,int PositionIn,opt string ButText,opt string ShortcutText,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 
declare extern MyNewPop2Separator(window WinIn,int MenuIn,int ControlID,int PositionIn,opt string ButText,opt string ShortcutText,opt int ControlIcon,opt int StyleIn,opt int ColorFIn,opt int ColorBIn,opt int TypeIn),int 

'========================================================================================
'
' Library external variables.
'
'========================================================================================

extern cwGetLibraryVersion as string 
cwGetLibraryVersion = "4.2"

extern cwShortcutCount as int 
extern cwStylesCount as int 
extern cwStartVShadowPos as int 
extern ShortcutExists as int 
extern cwShortcutSizeT as int
extern PopShortcutExists as int 
extern StyleExists as int 
extern cwStyleSizeT as int 
extern cwShortcutSizeP as int 
extern cwMenuCountUp as int 
extern cwShortcutCheck as int 
extern cwStylesCheck as int 
EXTERN cwl,cwt,cww,cwh AS INT                  
EXTERN cwYloop AS INT
EXTERN cwZloop AS INT
EXTERN cwMinPos AS INT
EXTERN cwClosePos AS INT
EXTERN cwMyControlsBeginAt AS INT
EXTERN cwMyControlsEndAt AS INT
EXTERN cwCaptionWidth AS INT
EXTERN cwMenuCount AS INT
EXTERN cwItemCount AS INT
EXTERN cwTotalMenuItems AS INT
EXTERN cwSeparatorItems AS INT
EXTERN cwMenuItems AS INT
EXTERN cwMenus[100] AS INT
extern cwMenusCount[100] as int
EXTERN cwMenusFC[100] AS INT
EXTERN cwMenusBC[100] AS INT
EXTERN cwMenusHFC[100] AS INT
EXTERN cwMenusHBC[100] AS INT
extern cwControls[1000] as int
extern cwMenuItemStyleType[100,1000] as int 
extern cwTitle2Styles[100,1000] as int 
extern cwPopParent[100,1000] as int 
extern cwPopsList[100,1000] as int 
EXTERN cwMenuTitles[100,1000] AS INT
EXTERN cwMenuItemT[100,1000] AS INT
EXTERN cwMenuItemD[100,1000] AS INT
EXTERN cwMenuItemDtype[100,1000] AS INT
extern cwMenuItemStyle[100,1000] as int
extern cwMenuItemState[100,1000] as int
extern cwMenuItemFg[100,1000] as int
extern cwMenuItemBg[100,1000] as int
extern cwMenuItemFgD[100,1000] as int
extern cwMenuItemBgD[100,1000] as int
extern cwMenuItemFgS[100,1000] as int
extern cwMenuItemBgS[100,1000] as int
extern cwMenuItemFontName[100,1000] as string  
extern cwMenuItemFontSize[100,1000] as int 
extern cwMenuItemFontWeight[100,1000] as int 
extern cwMenuItemFontStyle[100,1000] as int
extern cwMenuItemSFontName[100,1000] as string  
extern cwMenuItemSFontSize[100,1000] as int 
extern cwMenuItemSFontWeight[100,1000] as int 
extern cwMenuItemSFontStyle[100,1000] as int
EXTERN cwMenuItemI[100,1000] AS INT
EXTERN cwMenuPopup[100,1000] AS INT
EXTERN cwMenuItemParent[100,1000] AS INT
EXTERN cwMenuItemParent2[100,1000] AS INT
EXTERN cwMenuItemShow[100,1000] AS INT
extern cwPopupDisabled[100,1000] as int 
EXTERN cwMenuPopupCount AS INT
extern cwItemDisabled[100,1000] as int 
extern cwItemDisabledID[100,1000] as int 
extern cwMenuItemPos[100,1000] as int 
extern cwPopItemPos[100,1000] as int 
extern cwPopItemIndex[100,1000] as int 
extern cwPop2ItemPos[100,1000] as int 
extern cwPop2ItemIndex[100,1000] as int 
extern cwMenuIndex as int 
EXTERN cwPopupShowing[1000] AS INT
EXTERN cwPopupShowingCount AS INT
EXTERN cwPopupHide AS INT
EXTERN cwNotOver AS INT
EXTERN cwMenuClick[1000] AS INT
EXTERN cwMenuHighlted[1000] AS INT
EXTERN cwLongestMenuItem AS INT
extern cwSeparatorHeight as int
EXTERN cwMenupopups AS INT
EXTERN cwMenuIcon AS INT
EXTERN cwDisplayItems AS INT
EXTERN cwDisplayOver AS INT
EXTERN cwShowingMenu AS INT
EXTERN cwShowingParent AS INT
EXTERN cwa,cwb,cwpop1 as int
EXTERN cwPopitm AS INT
EXTERN cwMenuStore AS INT
EXTERN cwPreviousMouseOver AS INT
EXTERN cwCurrentTitle AS INT
EXTERN cwCurrentPopup AS INT
extern cwOriginalSize as int 
extern cwPreviousWidth as int 
extern cwPreviousWidth2 as int 
EXTERN cwMenuItemText[100,1000] AS string
extern cwMenuCShortcuts[100,1000] as int 
extern cwMenuItemShortcutText[100,1000] as string 
extern cwMenuCStyle[100,1000] as int 
extern cwCurrentWindow as window
extern cwMinControlID as int
extern cwCloseControlID as int 
extern cwCaptionControlID as int
extern cwTotalDown as int 
extern cwl88 as int
extern cwt88 as int
extern cww88 as int
extern cwh88 as int
extern cwInsertOffset as int 
extern cwMTLit as int 
extern cwDefaultTextSize as int 
extern cwDefaultTextFont as string
extern cwDefaultTextWeight as int
extern cwDefaultTextStyle as int
extern cwDefaultFC as int
extern cwDefaultBC as int 
extern cwDefaultHFC as int 
extern cwDefaultHBC as int
extern cwCurrentItem as int
extern cwDisplayingMenuTitle as int 
extern cwItemsDownOffset as int 
extern cwItemsAcrossOffset as int
extern cwDefaultItemBackgroundColor as int 
extern cwDefaultItemForegroundColor as int
extern cwDefaultItemFHighlightColor as int 
extern cwDefaultItemBHighlightColor as int
extern cwDefaultSeparatorColor as int
extern cwMTFC as int
extern cwMTBC as int  
extern cwItemHeight as int
extern cwSpacerSize as int
extern cwIconSize as int
extern cwStyleSize as int
extern cwStylePad as int 
extern cwPadding as int
extern cwRightPad as int
extern cwShortcutSize as int 
extern cwPopupSymbol as string
extern cwExtraSpace as int 
extern cwSpacerSizeOffset as int 
extern cwIconOffset as int 
extern cwStyleOffset as int
extern cwShortcutOffset as int 
extern cwTextOffset as int
extern cwRightPadOffset as int 
extern cwStylePadOffset as int 
extern cwNowH as int 
extern cwPrevH as int
extern cwPopStore as int 
extern cwPop2Store as int 
extern cwItemsIndex as int 
extern cwMenuList[1000] as int

'========================================================================================
'
' Default menu & menu titles settings.
'
'========================================================================================

cwMenuItm               = cwPictureHeight          'Menu down starting position.
cwItemsDownOffset       = 0                        'Menu down starting position offset.
cwItemsAcrossOffset     = 0                        'Menu across starting position offset.
cwDefaultTextSize       = 10                       'Default Menu Title / Menu item / Popup text font height.
cwDefaultTextFont       = "Arial"                  'Default Menu Title / Menu item / Popup text font.
cwDefaultTextStyle      = @TOPMOST|SS_NOTIFY|0x200 'Default Menu Title / Menu item / Popup style.
cwDefaultTextWeight     = 400                      'Default Menu Title / Menu item / Popup text weight.
cwDefaultFC             = rgb(0,0,0)               'Default Menu Title foreground colour.
cwDefaultBC             = rgb(255,255,255)         'Default Menu Title Background colour.
cwDefaultHFC            = rgb(0,0,0)               'Default Menu Title Highlighted foreground colour.
cwDefaultHBC            = rgb(135,206,250)         'Default Menu Title Highlighted Background colour.

'Note, cwDefaultTextStyle :-
'
'Always have @TOPMOST (appears top most on screen), SS_NOTIFY (so we can detect if clicked)
'0x200 (verically centers the text.
'Best to append to these three settings if you want to add additional styles!
'

'========================================================================================
'
' Default menu item (including popup titles & popups) setting.
'
'========================================================================================

'Each menu item consists of these components (in order and excluding the item text itself):
 
cwSpacerSize   = 10  'Indentation width before icons.
cwIconSize     = 20  'Icon width. 
cwStyleSize    = 20  'Width of checkbox / radiobuttons.
cwStylePad     = 10  'Width after checkbox / radiobutton.
cwExtraSpace   = 25  'Additional space for the menu item's text.
cwPadding      = 20  'Width of shortcut text size.
cwShortcutSize = 80  'Width of shortcut text.
cwRightPad     = 10  'Width after shortcut text. 
 	
cwItemHeight   = 20  'Height of menu items / popup titles / popup items.

cwSeparatorHeight = 2                      'Default separator height.
cwDefaultSeparatorColor = rgb(192,192,192) 'Default separator colour.

cwPopupSymbol  = ">" 'Popup title symbol.

cwDefaultItemBackgroundColor = RGB(211,211,211) 'Default menu item background color (non-highligthed).
cwDefaultItemForegroundColor = RGB(1,0,0)       'Default menu item text color (non-highligthed).
cwDefaultItemFHighlightColor = rgb(255,0,0)     'Default menu item text highlight color.
cwDefaultItemBHighlightColor = rgb(135,206,250) 'Default menu item highlight color.

'========================================================================================
'
' Default menu item control Id offsets.
'
'========================================================================================

cwSpacerSizeOffset = 50000 'Default indent control Id.
cwIconOffset       = 52000 'Default icon control Id.
cwStyleOffset      = 54000 'Default checkbox control Id.
cwStylePadOffset   = 56000 'Default indent control Id.
cwTextOffset       = 58000 'Default text control Id.
cwShortcutOffset   = 60000 'Default shortcut text control Id.
cwRightPadOffset   = 62000 'Default right padding control Id.

'========================================================================================
'
' End of default settings - do not change the following code...
'
'========================================================================================

cwDisplayingMenuTitle = 0
int cwNewSize = 0

sub RegisterControls(window WinIn),int
	 MouseOverControl(WinIn,cwMinControlID)   
	 MouseOverControl(WinIn,cwCloseControlID) 
	 MouseOverControl(WinIn,cwCaptionControlID)
return 0
endsub

sub MouseOverMenu(window WinIn),int

    if cwDisplayItems = 0 then return 0

    'No longer over the menu.
    if cwDisplayItems > 0 
		 if cwNowH > 0 and cwPrevH > 0 and cwNowH = cwPrevH
			 return 0
		 endif
    endif

return 1
endsub

sub CheckWindow(window WinIn),int

     'Close the menu when no longer over it and user has left clicked.
	  if cwNowH > 0 and cwPrevH > 0 and cwNowH = cwPrevH and mousedown(1)
		  HideAllmenuItems(WinIn)
	  endif

	  'Detect if the mouse is over the close box or not.
	  if MouseOver(WinIn,cwCloseControlID)
		  showimage WinIn,cwCloseOn,@IMGSCALABLE,cwClosePos+cwNewSize,0
        showimage WinIn,cwMinOff,@IMGSCALABLE,cwMinPos+cwNewSize,0
        goto cwMinCloseCheckLabel
	  else
		  showimage WinIn,cwCloseOff,@IMGSCALABLE,cwClosePos+cwNewSize,0
	  endif

	  'Detect if the mouse is over the minimise box or not.
	  if MouseOver(WinIn,cwMinControlID)
		  showimage WinIn,cwMinOn,@IMGSCALABLE,cwMinPos+cwNewSize,0
		  showimage WinIn,cwCloseOff,@IMGSCALABLE,cwClosePos+cwNewSize,0
	  else
		  showimage WinIn,cwMinOff,@IMGSCALABLE,cwMinPos+cwNewSize,0
	  endif

     label cwMinCloseCheckLabel
	  'Close window clicked.
	  if ControlClick(WinIn,cwCloseControlID)
		  stoptimer WinIn
		  closewindow WinIn
     else
        goto cwMinCheckLabel
	  endif

     label cwMinCheckLabel
	  'Minimised clicked.
	  if ControlClick(WinIn,cwMinControlID)
		  showwindow WinIn,@SWMINIMIZED
	  endif

     MenuCheck(WinIn)

return 0
endsub

'Routine to resize / move the window.
sub MoveTheWindow(window WinIn),int
	  getsize cwCurrentWindow,cwl88,cwt88,cww88,cwh88
	  if cwPreviousWidth2 <> cww88
		  cwPreviousWidth2 = cww88
		  cwNewSize = 0
		  cwNewSize = cwPreviousWidth2 - cwOriginalSize
		  setsize cwCurrentWindow,cwCaptionPosition,1,cwCaptionWidth+cwNewSize,cwPictureHeight,cwCaptionControlID
		  setsize cwCurrentWindow,cwMinPos+cwNewSize,1,cwCaptionWidth+cwNewSize,cwPictureHeight,cwMinControlID
		  setsize cwCurrentWindow,cwClosePos+cwNewSize,1,cwCaptionWidth+cwNewSize,cwPictureHeight,cwCloseControlID
		  TrackWindow(WinIn)
	  endif
return 0
endsub

'Delete custom window images when closing a window and un-subclass the caption control.
sub CloseCaption(),int
	 cwUnSubClassControl(cwCurrentWindow,cwCaptionControlID)
	 if cwCloseOn  then deleteimage cwCloseOn,@IMGSCALABLE
	 if cwCloseOff then deleteimage cwCloseOff,@IMGSCALABLE
	 if cwMinOn    then deleteimage cwMinOn,@IMGSCALABLE
	 if cwMinOff   then deleteimage cwMinOff,@IMGSCALABLE 
return 0
endsub

'=====================================================
'                                                    '
'       ------------------------------------         '                                                  
'       End of CustomWindow.inc (Version 10)         '
'       ------------------------------------         '
'                                                    '
'               Library version 4.2                  '  
'                                                    ' 
'=====================================================

