'******************************************************************
'                                                                 '
'             IWB key word case conveter include file             '
'                                                                 ' 
'******************************************************************

'Used only for precision timing...
DECLARE CDECL EXTERN _memset(dst AS POINTER,value AS CHAR,count AS UINT)

'**********************************************************
'      A pointer array to store all IWB keywords, "p"     ' 
'**********************************************************

CONST WordsPerLine = 400
CONST CharactersPerLine = 512
CONST IWBkeywords = 1665

TYPE MYUDT
     STRING words 
ENDTYPE
POINTER p			
p = NEW(MYUDT,IWBkeywords)
SETTYPE p,MYUDT

'**********************************************************
'                   Others pointers used.                 ' 
'**********************************************************

TYPE MYUDT2
     STRING aWord 
ENDTYPE
POINTER w			
w = NEW(MYUDT2,WordsPerLine)
SETTYPE w,MYUDT2

TYPE MYUDT3
     STRING Delimiter
ENDTYPE
POINTER d			
d = NEW(MYUDT3,WordsPerLine)
SETTYPE d,MYUDT3

'**********************************************************
'                  Keyword index pointers                 ' 
'**********************************************************

'Non @ keywords
POINTER pIndex
TYPE MYUD4
     INT Entry[100,100,35]
ENDTYPE		
pIndex = NEW(MYUD4,5) 
SETTYPE pIndex,MYUD4

POINTER pRange	
TYPE newudp
     INT Range[100,100,1] 
ENDTYPE
pRange = NEW(newudp,5) 
SETTYPE pRange,newudp

'@ keywords
POINTER pIndexAt
TYPE MYUD5
     INT Entry[100,100,35] 
ENDTYPE		
pIndexAt = NEW(MYUD5,5) 
SETTYPE pIndexAt,MYUD5

POINTER pRangeAt	
TYPE newudp2
     INT Range[100,100,5] 
ENDTYPE
pRangeAt = NEW(newudp2,5) 
SETTYPE pRangeAt,newudp2

'**********************************************************
'                 Variable size settings                  ' 
'                                                         ' 
' 512 characters per line - variables "dIn" and "LineOut" '
' 400 words per line - variables "WordIn", "aWord"        '
' 400 delimeters per line e.g. ",+,-,(,),[,] etc...       '
'**********************************************************
ISTRING dIn[512]			'Characters per line to read in
ISTRING ClipdIn[512,50000]	'Characters per line to read in
ISTRING LineOut[512,1]	'Character to write to file per line
ISTRING WordIn[400]		'Number of words per line

'**********************************************************
'          Delimiters used to separate key words.         '
'**********************************************************
ISTRING CheckLetter[20] = " ,'-+()[]=:<>&|" + CHR$(9) + CHR$(34) 'Includes tabs and quotations.

'**********************************************************
'                  Other variables used.                  '
'**********************************************************

CONST WM_CHILD = 0x22
 
FILE myFile,outFile
WINDOW win,w1,w2,form
LOGFONT lf
ISTRING KeyWordLetters[30] = "ABCDEFGHIJKLNMOPQRSTUVWXYZ$_" 'Keyword start letters / characters.
ISTRING ProgName[260]
ISTRING ProgPath[260]
ISTRING fileNames[260]
ISTRING fileSource[260]
ISTRING IWBpath[260]
STRING ProgsOpen[100]
STRING PreferenceWord[30]
ISTRING ClipText[500000]
STRING MyIniPath
STRING LastLetter
STRING Letter
STRING NewWord
STRING Text,IniFile,WordOut,UseThis,BlockSearch,NewBlockName,OldBlockName
STRING filter
STRING ns
ISTRING OpenWith[256] = "explorer.exe"	'Open the output file with your IDE.
'ISTRING OpenWith[32] = "C:\\test\\Wordpad.exe"	'Alternative program to open the output file with.
POINTER x1,x2,f
POINTER lock
FLOAT TimingmSec,OverHead
UINT64 Freq,StartCount,StopCount,hTooltip
UINT dwStyle = WS_CHILD|WS_TABSTOP
UINT hdc,font,oldfont
UINT handle
UINT hIcon
UINT hEdit,lpFn
UINT ButtonType
INT OptionName[30]
INT nv,FromToolsMenu,CancelAdd,SpacesToAddFromTools,BlockType
INT SetOptionUcase,SetOptionAdd,SetOptionOnly,SetOptionIgnoreS,SetOptionIgnoreB,SetOptionIgnoreQ
INT SetOptionRemoveDels,SetOptionRemoveTabs,SetOptionRemoveEmpty,SetOptionOutput
INT SetOptionProgress,SetOptionClose
STRING ShowToolCloseBox,ShowOutputProg,ShowFontSize,ShowFontName,ShowTextForeGround,ShowTextBackGround
STRING ShowHColour,ShowBColour,ShowHStyle,ShowBStyle,ShowTips,ShowEnglish,ShowTimeout,ShowIcon
INT height,weight,SendToClipBoard,WordsNeeded,LettersNeeded,SaveToFile,ButtonStyles
INT WordCount,OpenProgs,BlockComment,ConvertDone,BlockStart,BlockEnd,Match,WindowState
INT hdesk,hnext,style,Lines,LineCount,ClipBoard,a,x,xy,y,z
INT SourceIsFile,SourceIsIDE,Down,SetSpacing
INT startat5,startat6,startat7,WinSize,BlockFound,BlockName
INT SaveFileC,SaveClipC,SearchFileC ,SearchIDEC,flags,col,EditorType
STRING fontname = "Arial"
INT size = 12
INT LineGap = 24
INT Speed = 100

'*************************************************
'     IWB ini file & program icon file paths     " 
'*************************************************
STRING MyPathToIWB = "" 
STRING IconPath = "" 

'************************************************'      
'                                                '     
'     Program startup preference defaults        '
'                                                '
'         Most use 1 for on, 0 for off.          '
'                                                '           
'*************************************************
INT DefaultSource = 0			'1 = File, 2 = IDE, 3 = Clipboard. 
INT DefaultDestination = 0		'1 = File, 2 = Clipboard.
INT ClipBoardToClipBoard = 0  '1 = Source & destnation is from / to the clipboard (overrides previous two defaults). 
INT DontOpenTheWindow = 0		'1 = Don't open the window just convert (from / to clipboard) & end program.
INT ShowTheToolTips = 0			'Show tooltips on screen.
INT Ucase = 0 						'Convert to uppercase.
INT Regardless = 0				'Only convert keywords not already typed in upper or lowercase.
INT SetSingle = 0  				'Don't convert single comment lines. 'This is a comment.
INT SetBlock = 0					'Ignore block comments /* bla bla bla */.
INT IgnoreQuotes = 0				'Ignore any words in quotations "This ia a quote"
INT RemoveSpaces = 0    		'Remove spaces from delimiters.
INT RemoveTabs = 0      		'Remove tabs.
INT RemoveEmptyLines = 0     	'Remove lines with nothing in them.
INT IndentSpaces = 0          'Add 'x' number of spaces to start of lines. 
INT OpenOutputFile = 0  		'Open output file after conversion.
INT ShowProgress = 0				'Show processed lines on screen, 0 = quicker.
INT CloseWhenDone = 0			'Close program when finished converting.
INT SleepTime = 1000				'Delay time before closing program - e.g. 1000 = 1 second.
INT TimePrecision = 10			'Timing precision e.g. 10 places. 
INT OptimiseForSpeed = 0		'1 = Optimise for speed, will override some preferences above.
INT English = 0 

IF OptimiseForSpeed = 1
   ClipBoardToClipBoard = 0
   Regardless = 0
   SetSingle = 0
   SetBlock = 0
   IgnoreQuotes = 0
   RemoveSpaces = 0
   RemoveTabs = 0
   RemoveEmptyLines = 0
   ShowProgress = 0   
ENDIF

'Options you want to show on screen ( listed here in screen order from 'Only convert...' ).
INT ShowUcase = 0
INT ShowRegardless = 0
INT ShowIndentSpaces = 0
INT ShowSetSingle = 0
INT ShowSetBlock = 0
INT ShowIgnoreQuotes = 0
INT ShowRemoveSpaces = 0
INT ShowRemoveTabs = 0
INT ShowRemoveEmptyLines = 0
INT ShowOpenOutputFile = 0
INT ShowShowProgress = 0
INT ShowCloseWhenDone = 0

SETID "CFTEXT",1
SETID "GHND",0x42
handle = GlobalAlloc(@GHND,500000)
lock = GlobalLock(handle)

ENUM Constants 'Our window controls.
     MenuQuit = 100
     MenuHelp
     MenuWindow
     MenuDialog  
     MenuConsole
     MenuH1
     MenuS1
     MenuSpaces
     MenuBlock
     MenuRemove
     MenuChange
     MenuSave
     SearchFile
     SearchFrom
     SearchTo
     SearchIDE
     SaveFile
     SaveClip
     Spaces1
     Spaces2
     Spaces6
     Radio1
     Radio2
     Spaces3
     Spaces4
     Spaces5 
     oShowUcase
	  oDhowUcase
	  oShowOnly 
	  oShowAdd
	  oShowIgnoreS
	  oShowIgnoreB
	  oShowIgnoreQ
	  oShowRemoveDels
	  oShowRemoveTabs
	  oShowRemoveEmpty
	  oShowOutPut
	  oShowProgress
     oShowClose 
     EditorStatic
     OptionEditor1
     OptionEditor2
     OptionEditor3
     OptionStatic1
     OptionStatic2
     OptionStatic3
     OptionStatic4
     OptionStatic5
     OptionStatic6
     OptionStatic7
     OptionToolCloseStatic
     OptionTitle
     OptionUcase 
     OptionOnly
     OptionAdd
     OptionIgnoreS
     OptionIgnoreB
     OptionIgnoreQ 
     OptionRemoveDels
     OptionRemoveTabs
     OptionRemoveEmpty
     OptionOutput 
     OptionOpen
     OptionProgress
     OptionClose
     OptionSource
     OptionDestination
     OptionIWB
     OptionIcon
     OptionTimeout
     OptionSave
     OptionDefault
     OptionCancel
     SourceFile
     SourceIDE
     SourceClipBoard
     Cancel
	  STATIC_1
     UpperC
     LowerC
     DoRegardless
     Spacing
     SpaceBox
     SpaceWord
     IgnoreDels 
     IgnoreSingle
     IgnoreBlock
     IgnoreQuotations
     RemoveTheSpaces
     RemoveTheTabs 
     DoEmpty
     DoOpen
     DoProgress
     DoClose 
     STATIC_2
     STATIC_3
     SaveAs
     SaveAsClip
     OptionOpenWithStatic
     OptionFontStatic
     OptionFontStatic2
     OptionTextStatic
     OptionTextStatic2
     OptionHStatic
     OptionHStatic2
     OptionSStatic
     OptionButtonStatic
     OptionBalloonStatic
     OptionEnglishStatic
     OptionToolCloseBox
     OptionOpenWithBox
     OptionFontBox
     OptionFontSizeBox
     BrowseIni
     BrowseIco
     OptionFontBrowse 
     OptionFBox
     OptionBBox
     OptionHBox
     OptionNHBox
     OptionSBox
     OptionTextFBox
     OptionTextBBox
     OptionButtonBox
     OptionBalloonBox 
     OptionEnglishBox
     GO
     CLOSE
ENDENUM

'Startup options and controls.
PreferenceWord[1]  = "INT Ucase"
PreferenceWord[2]  = "INT Regardless"
PreferenceWord[3]  = "INT SetSingle"
PreferenceWord[4]  = "INT SetBlock"
PreferenceWord[5]  = "INT IgnoreQuotes"
PreferenceWord[6]  = "INT RemoveSpaces"
PreferenceWord[7]  = "INT RemoveTabs"
PreferenceWord[8]  = "INT RemoveEmptyLines"
PreferenceWord[9]  = "INT IndentSpaces"
PreferenceWord[10] = "INT OpenOutputFile"
PreferenceWord[11] = "INT ShowProgress"
PreferenceWord[12] = "INT CloseWhenDone"
PreferenceWord[13] = "INT ShowUcase"
PreferenceWord[14] = "INT ShowIndentSpaces"
PreferenceWord[15] = "INT ShowRegardless"
PreferenceWord[16] = "INT ShowSetSingle"
PreferenceWord[17] = "INT ShowSetBlock"
PreferenceWord[18] = "INT ShowIgnoreQuotes"
PreferenceWord[19] = "INT ShowRemoveSpaces"
PreferenceWord[20] = "INT ShowRemoveTabs"
PreferenceWord[21] = "INT ShowRemoveEmptyLines"
PreferenceWord[22] = "INT ShowOpenOutputFile"
PreferenceWord[23] = "INT ShowShowProgress"
PreferenceWord[24] = "INT ShowCloseWhenDone"

OptionName[1]  = OptionUcase
OptionName[2]  = OptionOnly
OptionName[3]  = OptionIgnoreS
OptionName[4]  = OptionIgnoreB
OptionName[5]  = OptionIgnoreQ
OptionName[6]  = OptionRemoveDels
OptionName[7]  = OptionRemoveTabs
OptionName[8]  = OptionRemoveEmpty
OptionName[9]  = OptionAdd
OptionName[10] = OptionOutput
OptionName[11] = OptionProgress
OptionName[12] = OptionClose
OptionName[13] = oShowUcase
OptionName[14] = oShowAdd
OptionName[15] = oShowOnly 
OptionName[16] = oShowIgnoreS
OptionName[17] = oShowIgnoreB
OptionName[18] = oShowIgnoreQ
OptionName[19] = oShowRemoveDels
OptionName[20] = oShowRemoveTabs
OptionName[21] = oShowRemoveEmpty
OptionName[22] = oShowOutPut
OptionName[23] = oShowProgress
OptionName[24] = oShowClose

'*************************************************
'            Build word sizes indexes            '
'*************************************************
'                                                '
' For all keywords using the first letters       '   
' get the maximum length and the number of times '
' in occurs.                                     '
'                                                ' 
' Example - take keywords beginnig with "A"      '
' and look at these keywords -                   '
'                   AND, ABS, ASC.               '
'                                                '
' It tells us there are only 3 keywords that     ' 
' begin with "A" and are 3 characters in length. '
'                                                ' 
' So if you were checking for the keyword "ASC"  '
' there on no point searching thropugh all of    '
' the "A" keywords until you find "ASC".         '
'                                                '
' Just search AND, ABS, ASC.                     '
'                                                '                                                '
' It's much faster.                              ' 
'                                                '
' Indexes:                                       '
'                                                '
' Index   - Keywords exclusind "@" keywords.     ' 
' IndexAt - "@" keywords only.                   '
'                                                '
' The above indexes store:                       '
' Start letter                                   '
' Length                                         '
' Keyword refence number for the array Words[x]  '
'                                                '
' Indexes:                                       '
'                                                '
' IndexTo   - Keywords exclusind "@" keywords.   ' 
' IndexToAt - "@" keywords only.                 ' 
'                                                '
' The above indexes store how many times         '
' a word of a given length occurs.               '
' This gives us our search range e.g. 3 words.   '
'                                                '
'*************************************************
SUB BuildWordSize()
	 INT qq = 0
	 INT inw = 0
	 INT inl = 0
	 INT ina = 0
	 INT c[100]
    FOR z = 1 TO 100
		  c[z] = 0
    NEXT z
    '@ keywords.
	 FOR a = 1 TO 805
		  IF LastLetter <> MID$(#p[a].Words,2,1)
			  FOR z = 2 TO 100 
				   c[z] = 0
			  NEXT z 
			  LastLetter = MID$(#p[a].Words,2,1)
		  ENDIF
        qq = LEN(#p[a].Words)-1
		  c[qq] = c[qq] + 1
        inw = INSTR(KeyWordLetters,MID$(#p[a].Words,2,1))
        inl = LEN(#p[a].Words)-1
        ina = c[LEN(#p[a].Words)-1]
		  #pIndexAt[1].Entry[inw,inl,ina] = a
        #pRangeAt[1].Range[inw,inl,0] = ina
	 NEXT a
    'All other keywords.
	 FOR a = 806 TO 1661
		  IF LastLetter <> MID$(#p[a].Words,1,1)
			  FOR z = 2 TO 100
				   c[z] = 0
			  NEXT z 
			  LastLetter = MID$(#p[a].Words,1,1)
		  ENDIF
		  c[LEN(#p[a].Words)] ++ 
		  #pIndex[1].Entry[INSTR(KeyWordLetters,MID$(#p[a].Words,1,1)),LEN(#p[a].Words),c[LEN(#p[a].Words)]] = a
		  #pRange[1].Range[INSTR(KeyWordLetters,MID$(#p[a].Words,1,1)),LEN(#p[a].Words),0] = c[LEN(#p[a].Words)]
	 NEXT a
RETURN
ENDSUB

SUB LoadPreferenceIniFile()
    MyIniPath = RTRIM$(LTRIM$(GetIniFileOthers("MyPathToIWB")))
	 IWBpath = REGGETSTRING("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders","Local AppData")
	 IWBpath = IWBpath + "\\IonicWind\\IWBasic3\\IWBDev.ini"
	 IF OPENFILE(MyFile,IWBpath,"R") = 0
		 CLOSEFILE MyFile
	 ELSE
       IWBpath = MyIniPath 
		 IF OPENFILE(MyFile,IWBpath,"R") = 0
			 CLOSEFILE MyFile
		 ELSE
			 MESSAGEBOX (0,"Cannot find your IWBDev.ini file.\n\n Please amend 'STRING MyPathToIWB' (line no 9) in the ConvertPreferences.ini file","Error",@MB_OK|@MB_ICONSTOP)
			 END
		 ENDIF
	 ENDIF

    hIcon = LOADIMAGE(GETSTARTPATH + "\\Bin\\Convert.ico", @IMGICON)

    IF hIcon = 0
       hIcon = LOADIMAGE(RTRIM$(LTRIM$(GetIniFileOthers("IconPath"))),@IMGICON)
    ENDIF
	 EditorType = val(GetIniFileOthers("EditorType"))
	 ShowIcon = GetIniFileOthers("IconPath")
	 ShowUcase = GetIniFileValues("ShowUcase")
	 ShowRegardless = GetIniFileValues("ShowRegardless")
	 ShowSetSingle = GetIniFileValues("ShowSetSingle")
	 ShowSetBlock = GetIniFileValues("ShowSetBlock")
	 ShowIgnoreQuotes = GetIniFileValues("ShowIgnoreQuotes")
	 ShowRemoveSpaces = GetIniFileValues("ShowRemoveSpaces")
	 ShowRemoveTabs = GetIniFileValues("ShowRemoveTabs")
	 ShowRemoveEmptyLines = GetIniFileValues("ShowRemoveEmptyLines")
	 ShowIndentSpaces = GetIniFileValues("ShowIndentSpaces")
	 ShowOpenOutputFile = GetIniFileValues("ShowOpenOutputFile")
	 ShowShowProgress = GetIniFileValues("ShowShowProgress")
	 ShowCloseWhenDone = GetIniFileValues("ShowCloseWhenDone")
    DefaultSource = VAL(GetIniFileOthers("OptionSource"))
    DefaultDestination = VAL(GetIniFileOthers("OptionDestination"))
	 ShowTimeout = GetIniFileOthers("SleepTime")
	 ShowToolCloseBox = GetIniFileOthers("CloseAfterCreatingAtool")
    ShowOutputProg = GetIniFileOthers("OpenWith[256]")
    ShowFontSize = GetIniFileOthers("size")
    size = val(ShowFontSize)
    ShowFontName = GetIniFileOthers("fontname")
    FontName = ShowFontName
    ShowTextForeGround = GetIniFileOthers("ForeGround")
    ShowTextBackGround = GetIniFileOthers("BackGround")
    ShowHColour = GetIniFileOthers("Hon")
    ShowBColour = GetIniFileOthers("Hoff")
    ShowHStyle = GetIniFileOthers("HStyle")
    ShowBStyle = GetIniFileOthers("ButtonType")
    ShowTips = GetIniFileOthers("ShowTheToolTips")
    ShowEnglish = GetIniFileOthers("English")

	 IF INSTR(ShowOutputProg,"\\")
		 DO
		    OpenWith = MID$(OpenWith,INSTR(OpenWith,"\\")+1,LEN(OpenWith))
		 UNTIL INSTR(OpenWith,"\\") = 0
	 ENDIF

   string ButtonTypeS = GetIniFileOthers("ButtonType")
	IF ButtonTypeS  = "@BUTTON"
      ButtonType   = 1
		ButtonStyles = 0x50800009|@CTLBTNDEFAULT|@TABSTOP
	ENDIF
	IF ButtonTypeS  = "@SYSBUTTON"
      ButtonType   = 13
		ButtonStyles = @CTLBTNDEFAULT|@TABSTOP
	ENDIF

RETURN
ENDSUB

SUB CopyStringToClipboard(istring Itext[500000])
    EmptyClipBoard()
	 HGLOBAL handle =  GlobalAlloc(GHND,LEN(Itext)+1)
	 pointer lock = GlobalLock(handle)
	 memcpy(lock, Itext, LEN(Itext)+1)
	 GlobalUnlock(handle)
	 OpenClipboard(w1.hwnd)
	 EmptyClipboard()
	 SetClipboardData(CF_TEXT,handle)
	 CloseClipboard()
ENDSUB

sub ReadClipBoard()
    WordsNeeded = 0
    LettersNeeded = 0
    LineCount = 1
	 OpenClipboard(win.hWnd)
	 handle = GetClipboardData(@CFTEXT)
	 lock = GlobalLock(handle)
	 ClipText = #<STRING>lock
	 GlobalUnlock(handle)
	 CloseClipboard()
	 FOR a = 1 to len(ClipText)
	  	  istring add[2] = mid$(ClipText,a,1)
		  if add = chr$(13)
			  a ++
			  add = mid$(ClipText,a,1)
			  LineCount ++
			  GOTO DoNext
		  endif
        LettersNeeded ++
		  ClipdIn[0,LineCount] = ClipdIn[0,LineCount] + add 
	 LABEL DoNext
	 NEXT a 
return
endsub

SUB GetIniFileValues(STRING StringIn),INT
    INT BreakOut = 0
    INT ExistingValue = 0
    ProgPath  = GETSTARTPATH + "\\Bin\\ConvertPreferences.ini"
	 IF OPENFILE(myFile,ProgPath,"R") = 0
       WHILE(READ myFile,dIn = 0)
				 IF INSTR(dIn,StringIn)
					 x = 0
					 DO 
						x++
						IF MID$(dIn,x,1) = "1" OR MID$(dIn,x,1) = "0"
							ExistingValue = VAL(MID$(dIn,x,1))
							BreakOut = 1
							BREAK 
						ENDIF
					 UNTIL x = LEN(dIn) 
				 ENDIF
				 IF BreakOut = 1 THEN BREAK
	    ENDWHILE
    ENDIF
    CLOSEFILE myFile 
RETURN ExistingValue
ENDSUB

SUB GetIniFileOthers(STRING StringIn),STRING
    INT BreakOut = 0
    STRING ExistingString = ""
    ProgPath  = GETSTARTPATH + "\\Bin\\ConvertPreferences.ini"
	 IF OPENFILE(myFile,ProgPath,"R") = 0
       WHILE(READ myFile,dIn = 0)
             IF StringIn = "ButtonType" AND INSTR(dIn,"ButtonType")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,1,LEN(ExistingString))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF
             IF StringIn = "IconPath" AND INSTR(dIn,"IconPath")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,2,LEN(ExistingString)-2)
                   SleepTime = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "EditorType" AND INSTR(dIn,"EditorType")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+2,1)
						 DefaultSource = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "OptionSource" AND INSTR(dIn,"DefaultSource")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+2,1)
						 DefaultSource = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF
             IF StringIn = "OptionDestination" AND INSTR(dIn,"DefaultDestination")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+2,1)
						 DefaultDestination = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "SleepTime" AND INSTR(dIn,"SleepTime")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,1,LEN(ExistingString))
                   SleepTime = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "MyPathToIWB" AND INSTR(dIn,"MyPathToIWB")
                IF INSTR(dIn,"=") 
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,2,LEN(ExistingString)-2)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "IconPath" AND INSTR(dIn,"IconPath")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,2,LEN(ExistingString)-2)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "CloseAfterCreatingAtool" AND INSTR(dIn,"CloseAfterCreatingAtool")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = LTRIM$(MID$(ExistingString,1,LEN(ExistingString)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "OpenWith[256]" AND INSTR(dIn,"OpenWith[256]")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,2,LEN(ExistingString)-2)
                   SleepTime = VAL(ExistingString)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "size" AND INSTR(dIn,"size")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,1,LEN(ExistingString))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "fontname" AND INSTR(dIn,"fontname")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,2,LEN(ExistingString)-2)
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "ForeGround" AND INSTR(dIn,"ForeGround")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "BackGround" AND INSTR(dIn,"BackGround")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "Hon" AND INSTR(dIn,"Hon")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "Hoff" AND INSTR(dIn,"Hoff")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "HStyle" AND INSTR(dIn,"HStyle")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "ButtonType" AND INSTR(dIn,"ButtonType")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = LTRIM$(MID$(dIn,INSTR(dIn,"=")+1,LEN(Din)))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "ShowTheToolTips" AND INSTR(dIn,"ShowTheToolTips")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,1,LEN(ExistingString))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

             IF StringIn = "English" AND INSTR(dIn,"English")
                IF INSTR(dIn,"=")
                   x = INSTR(dIn,"=")
                   ExistingString = MID$(dIn,INSTR(dIn,"=")+1,LEN(Din))
						 y = INSTR(ExistingString,"'")
						 ExistingString = MID$(ExistingString,1,y-1)
						 ExistingString = RTRIM$(ExistingString)
						 ExistingString = LTRIM$(ExistingString)
						 ExistingString = MID$(ExistingString,1,LEN(ExistingString))
                   BreakOut = 1
                   BREAK
                ENDIF 
             ENDIF

	    ENDWHILE
    ENDIF
    CLOSEFILE myFile 
RETURN ExistingString
ENDSUB

SUB ShowToolTips()
    hTooltip=TOOLTIPCONTROL(w1,@TTS_ALWAYSTIP|@TTS_NOANIMATE|@TTS_NOFADE|@TTS_BALLOON,0)
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,SourceFile),w1.hWnd,"Convert code from a file"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,SourceIDE),w1.hWnd,"Convert your currently selected IDE code"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,Cancel),w1.hWnd,"Let's start again"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,Spacing),w1.hWnd,"Add spaces to the start of each line"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,UpperC),w1.hWnd,"Convert all keywords to uppercase"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,LowerC),w1.hWnd,"Convert all keywords to lowercase"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,IgnoreSingle),w1.hWnd,"Don't convert keywords in single line comments"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,IgnoreBlock),w1.hWnd,"Don't convert keywords block comments"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,IgnoreQuotations),w1.hWnd,"Don't convert keywords inside quotations"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,RemoveTheSpaces),w1.hWnd,"Remove spaces from around delimiters"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,RemoveTheTabs),w1.hWnd,"Remove tabs from each line"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,DoEmpty),w1.hWnd,"Remove all lines with nothing in them"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,DoRegardless),w1.hWnd,"Only convert keywords not already matching your case selection"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,DoOpen),w1.hWnd,"Open the converted output file"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,DoProgress),w1.hWnd,"Show conversion progress"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,DoClose),w1.hWnd,"Close this program after the conversion is complete"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,SaveAs),w1.hWnd,"Select a file to save the converted code to"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,GO),w1.hWnd,"Convert the code now!"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w1,Close),w1.hWnd,"Close this program"
	 height=20
	 weight =700
	 ZeroMemory(lf,LEN(LOGFONT))
	 lstrcpynA(lf.lfFaceName,"Arial",32)
	 hdc = GetHDC(form)
	 lf.lfHeight = -MulDiv(height,GetDeviceCaps(hdc,90 /*LOGPIXELSY*/),72)
	 lf.lfWeight = weight
	 font = CreateFontIndirectA(lf)
	 oldfont = SendMessageA(hTooltip,WM_GETFONT,0,0)
	 SendMessageA(hTooltip,WM_SETFONT,NULL,0)
	 SendMessageA(hTooltip,WM_SETFONT,font,1)
	 IF(oldfont) THEN DeleteObject(oldfont)
	 ReleaseHDC(form,hdc)
	 SENDMESSAGE hTooltip,TTM_SETMAXTIPWIDTH,0,130
	 SENDMESSAGE hTooltip,TTM_SETTITLEA,1,"IWB converter"
RETURN
ENDSUB

SUB ShowSettingsToolTips()
    hTooltip=TOOLTIPCONTROL(w1,@TTS_ALWAYSTIP|@TTS_NOANIMATE|@TTS_NOFADE|@TTS_BALLOON,0)
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowUcase),w2.hWnd,"Show 'upper / lowercase' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowAdd),w2.hWnd,"Show 'Add x number of spaces to lines' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowOnly),w2.hWnd,"Show 'Only convert keywords not already typed in that case' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowIgnoreS),w2.hWnd,"Show 'Ignore single line comments' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowIgnoreB),w2.hWnd,"Show 'Ignore block comments' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowIgnoreQ),w2.hWnd,"Show 'Ignore words in quotations' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowRemoveDels),w2.hWnd,"Show 'Remove spacing from around delimiters' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowRemoveTabs),w2.hWnd,"Show 'Remove tabbing from lines' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowRemoveEmpty),w2.hWnd,"Show 'Remove lines with nothing in them' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowOutPut),w2.hWnd,"Show 'Open output file in the IDE' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowProgress),w2.hWnd,"Show 'Show progress' option on screen"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,oShowClose),w2.hWnd,"Show 'Close when finished' option on screen"

	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionUcase),w2.hWnd,"Enable 'convert to uppercase' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionAdd),w2.hWnd,"Enable 'Add x number of spaces to the start of each line' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionOnly),w2.hWnd,"Enable 'Only convert keywords not already typed in that case' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionIgnoreS),w2.hWnd,"Enable 'Ignore words after a comment out character (') on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionIgnoreB),w2.hWnd,"Enable 'Ignore words in block comments' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionIgnoreQ),w2.hWnd,"Enable 'Ignore words in quotations on' start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionRemoveDels),w2.hWnd,"Enable 'Remove spacing from around delimiters' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionRemoveTabs),w2.hWnd,"Enable 'Remove tabbing from lines' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionRemoveEmpty),w2.hWnd,"Enable 'Remove lines with nothing in them' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionOutput),w2.hWnd,"Enable 'Open output file in the IDE' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionProgress),w2.hWnd,"Enable 'Show progress' on start up"
	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionClose),w2.hWnd,"Enable 'Close when finished' on start up"

	 TTADDTOOL hTooltip,@TTF_SUBCLASS|@TTF_IDISHWND|@TTF_CENTERTIP,GETCONTROLHANDLE(w2,OptionStatic3),w2.hWnd,"Your default code source, 1 for file, 2 for the IDE or 3 the clipboard"

	 height = 16
	 weight = 500
	 ZeroMemory(lf,LEN(LOGFONT))
	 lstrcpynA(lf.lfFaceName,"Arial",32)
	 hdc = GetHDC(form)
	 lf.lfHeight = -MulDiv(height,GetDeviceCaps(hdc,90 /*LOGPIXELSY*/),72)
	 lf.lfWeight = weight
	 font = CreateFontIndirectA(lf)
	 oldfont = SendMessageA(hTooltip,WM_GETFONT,0,0)
	 SendMessageA(hTooltip,WM_SETFONT,NULL,0)
	 SendMessageA(hTooltip,WM_SETFONT,font,1)
	 IF(oldfont) THEN DeleteObject(oldfont)
	 ReleaseHDC(form,hdc)
	 SENDMESSAGE hTooltip,TTM_SETMAXTIPWIDTH,0,130
	 SENDMESSAGE hTooltip,TTM_SETTITLEA,1,"IWB converter"
RETURN
ENDSUB

SUB ReadKeyWords(),INT 'IWB keywords.
'@
#p[1].words ="@ALPHA"
#p[2].words ="@AUTOSCALE"
#p[3].words ="@BACKENABLED"
#p[4].words ="@BLOCKCOPY"
#p[5].words ="@BLTALPHA"
#p[6].words ="@BLTCOPY"
#p[7].words ="@BLTHFLIP"
#p[8].words ="@BLTROTOZOOM"
#p[9].words ="@BLTSCALED"
#p[10].words ="@BLTSHADOW"
#p[11].words ="@BLTTRANS"
#p[12].words ="@BLTTRANSALPHA"
#p[13].words ="@BLTTRANSHFLIP"
#p[14].words ="@BLTTRANSROTOZOOM"
#p[15].words ="@BLTTRANSSCALED"
#p[16].words ="@BLTTRANSSHADOW"
#p[17].words ="@BLTTRANSVFLIP"
#p[18].words ="@BLTVFLIP"
#p[19].words ="@BORDER"
#p[20].words ="@BROWSELOAD"
#p[21].words ="@BROWSEPRINT"
#p[22].words ="@BROWSER"
#p[23].words ="@BROWSESEARCH"
#p[24].words ="@BROWSESTOP"
#p[25].words ="@BUTTON"
#p[26].words ="@CANCELNAV"
#p[27].words ="@CAPTION"
#p[28].words ="@CBEN_BEGINEDIT"
#p[29].words ="@CBEN_DELETEITEM"
#p[30].words ="@CBEN_DRAGBEGINA"
#p[31].words ="@CBEN_DRAGBEGINW"
#p[32].words ="@CBEN_ENDEDITA"
#p[33].words ="@CBEN_ENDEDITW"
#p[34].words ="@CBEN_GETDISPINFO"
#p[35].words ="@CBEN_GETDISPINFOA"
#p[36].words ="@CBEN_GETDISPINFOW"
#p[37].words ="@CBEN_INSERTITEM"
#p[38].words ="@CBNCLOSEUP"
#p[39].words ="@CBNDBLCLICK"
#p[40].words ="@CBNDROPDOWN"
#p[41].words ="@CBNEDITCHANGE"
#p[42].words ="@CBNEDITUPATE"
#p[43].words ="@CBNEDITUPDATE"
#p[44].words ="@CBNERRSPACE"
#p[45].words ="@CBNKILLFOCUS"
#p[46].words ="@CBNSELCHANGE"
#p[47].words ="@CBNSELENDCANCEL"
#p[48].words ="@CBNSELENDOK"
#p[49].words ="@CBNSETFOCUS"
#p[50].words ="@CHECKBOX"
#p[51].words ="@CLASS"
#p[52].words ="@CODE"
#p[53].words ="@COMBOBOX"
#p[54].words ="@CONTROLID"
#p[55].words ="@CSARROW"
#p[56].words ="@CSCUSTOM"
#p[57].words ="@CSIDL_ADMINTOOLS"
#p[58].words ="@CSIDL_ALTSTARTUP"
#p[59].words ="@CSIDL_APPDATA"
#p[60].words ="@CSIDL_BITBUCKET"
#p[61].words ="@CSIDL_CDBURN_AREA"
#p[62].words ="@CSIDL_COMMON_ADMINTOOLS"
#p[63].words ="@CSIDL_COMMON_ALTSTARTUP"
#p[64].words ="@CSIDL_COMMON_APPDATA"
#p[65].words ="@CSIDL_COMMON_DESKTOPDIRECTORY"
#p[66].words ="@CSIDL_COMMON_DOCUMENTS"
#p[67].words ="@CSIDL_COMMON_FAVORITES"
#p[68].words ="@CSIDL_COMMON_MUSIC"
#p[69].words ="@CSIDL_COMMON_OEM_LINKS"
#p[70].words ="@CSIDL_COMMON_PICTURES"
#p[71].words ="@CSIDL_COMMON_PROGRAMS"
#p[72].words ="@CSIDL_COMMON_STARTMENU"
#p[73].words ="@CSIDL_COMMON_STARTUP"
#p[74].words ="@CSIDL_COMMON_TEMPLATES"
#p[75].words ="@CSIDL_COMMON_VIDEO"
#p[76].words ="@CSIDL_COMPUTERSNEARME"
#p[77].words ="@CSIDL_CONNECTIONS"
#p[78].words ="@CSIDL_CONTROLS"
#p[79].words ="@CSIDL_COOKIES"
#p[80].words ="@CSIDL_DESKTOP"
#p[81].words ="@CSIDL_DESKTOPDIRECTORY"
#p[82].words ="@CSIDL_DRIVES"
#p[83].words ="@CSIDL_FAVORITES"
#p[84].words ="@CSIDL_FONTS"
#p[85].words ="@CSIDL_HISTORY"
#p[86].words ="@CSIDL_INTERNET"
#p[87].words ="@CSIDL_INTERNET_CACHE"
#p[88].words ="@CSIDL_LOCAL_APPDATA"
#p[89].words ="@CSIDL_MYDOCUMENTS"
#p[90].words ="@CSIDL_MYMUSIC"
#p[91].words ="@CSIDL_MYPICTURES"
#p[92].words ="@CSIDL_MYVIDEO"
#p[93].words ="@CSIDL_NETHOOD"
#p[94].words ="@CSIDL_NETWORK"
#p[95].words ="@CSIDL_PERSONAL"
#p[96].words ="@CSIDL_PRINTERS"
#p[97].words ="@CSIDL_PRINTHOOD"
#p[98].words ="@CSIDL_PROFILE"
#p[99].words ="@CSIDL_PROGRAM_FILES"
#p[100].words ="@CSIDL_PROGRAM_FILES_COMMON"
#p[101].words ="@CSIDL_PROGRAM_FILES_COMMONX86"
#p[102].words ="@CSIDL_PROGRAM_FILESX86"
#p[103].words ="@CSIDL_PROGRAMS"
#p[104].words ="@CSIDL_RECENT"
#p[105].words ="@CSIDL_RESOURCES"
#p[106].words ="@CSIDL_RESOURCES_LOCALIZED"
#p[107].words ="@CSIDL_SENDTO"
#p[108].words ="@CSIDL_STARTMENU"
#p[109].words ="@CSIDL_STARTUP"
#p[110].words ="@CSIDL_SYSTEM"
#p[111].words ="@CSIDL_SYSTEMX86"
#p[112].words ="@CSIDL_TEMPLATES"
#p[113].words ="@CSIDL_WINDOWS"
#p[114].words ="@CSWAIT"
#p[115].words ="@CTCOMBOAUTOHSCROLL"
#p[116].words ="@CTCOMBODROPDOWN"
#p[117].words ="@CTCOMBODROPLIST"
#p[118].words ="@CTCOMBOSIMPLE"
#p[119].words ="@CTCOMBOSORT"
#p[120].words ="@CTEDITAUTOH"
#p[121].words ="@CTEDITAUTOV"
#p[122].words ="@CTEDITCENTER"
#p[123].words ="@CTEDITLEFT"
#p[124].words ="@CTEDITMULTI"
#p[125].words ="@CTEDITNUMBER"
#p[126].words ="@CTEDITPASS"
#p[127].words ="@CTEDITRETURN"
#p[128].words ="@CTEDITRIGHT"
#p[129].words ="@CTEDITRO"
#p[130].words ="@CTLBTNBITMAP"
#p[131].words ="@CTLBTNDEFAULT"
#p[132].words ="@CTLBTNFLAT"
#p[133].words ="@CTLBTNMULTI"
#p[134].words ="@CTLEDITPASS"
#p[135].words ="@CTLISTCOLUMNS"
#p[136].words ="@CTLISTEXTENDED"
#p[137].words ="@CTLISTMULTI"
#p[138].words ="@CTLISTNOTIFY"
#p[139].words ="@CTLISTSORT"
#p[140].words ="@CTLISTSTANDARD"
#p[141].words ="@CTLISTTABS"
#p[142].words ="@CTLSTCBITMAP"
#p[143].words ="@CTLSTCMULTI"
#p[144].words ="@CTLSTCSIMPLE"
#p[145].words ="@CTLSTCTRANS"
#p[146].words ="@CTSCROLLHORIZ"
#p[147].words ="@CTSCROLLVERT"
#p[148].words ="@DTN_CLOSEUP"
#p[149].words ="@DTN_DATETIMECHANGE"
#p[150].words ="@DTN_DROPDOWN"
#p[151].words ="@DTN_FORMATA"
#p[152].words ="@DTN_FORMATQUERYA"
#p[153].words ="@DTN_FORMATQUERYW"
#p[154].words ="@DTN_FORMATW"
#p[155].words ="@DTN_USERSTRINGA"
#p[156].words ="@DTN_USERSTRINGW"
#p[157].words ="@DTN_WMKEYDOWNA"
#p[158].words ="@DTN_WMKEYDOWNW"
#p[159].words ="@DTS_APPCANPARSE"
#p[160].words ="@DTS_LONGDATEFORMAT"
#p[161].words ="@DTS_RIGHTALIGN"
#p[162].words ="@DTS_SHORTDATEFORMAT"
#p[163].words ="@DTS_SHOWNONE"
#p[164].words ="@DTS_TIMEFORMAT"
#p[165].words ="@DTS_UPDOWN"
#p[166].words ="@EDCANUNDO"
#p[167].words ="@EDCHARFROMLINE"
#p[168].words ="@EDCOPY"
#p[169].words ="@EDCUT"
#p[170].words ="@EDDELETESEL"
#p[171].words ="@EDEMPTYUNDO"
#p[172].words ="@EDGETFIRSTLINE"
#p[173].words ="@EDGETLIMITTEXT"
#p[174].words ="@EDGETLINE"
#p[175].words ="@EDGETLINECOUNT"
#p[176].words ="@EDGETLINELENGTH"
#p[177].words ="@EDGETMODIFIED"
#p[178].words ="@EDGETSELECTION"
#p[179].words ="@EDIT"
#p[180].words ="@EDLINEFROMCHAR"
#p[181].words ="@EDPASTE"
#p[182].words ="@EDREPLACESEL"
#p[183].words ="@EDSETLIMITTEXT"
#p[184].words ="@EDSETMARGINS"
#p[185].words ="@EDSETMODIFIED"
#p[186].words ="@EDSETSELECTION"
#p[187].words ="@EDUNDO"
#p[188].words ="@ENCHANGE"
#p[189].words ="@ENENTERKEY"
#p[190].words ="@ENERRSPACE"
#p[191].words ="@ENHSCROLL"
#p[192].words ="@ENKILLFOCUS"
#p[193].words ="@ENM_DROPFILES"
#p[194].words ="@ENM_PROTECTED"
#p[195].words ="@ENMAXTEXT"
#p[196].words ="@ENMCHANGE"
#p[197].words ="@ENMKEYEVENTS"
#p[198].words ="@ENMMOUSEEVENTS"
#p[199].words ="@ENMNONE"
#p[200].words ="@ENMREQUESTRESIZE"
#p[201].words ="@ENMSCROLL"
#p[202].words ="@ENMSELCHANGE"
#p[203].words ="@ENMUPDATE"
#p[204].words ="@ENREQUESTRESIZE"
#p[205].words ="@ENSELCHANGE"
#p[206].words ="@ENSETFOCUS"
#p[207].words ="@ENTABKEY"
#p[208].words ="@ENUPDATE"
#p[209].words ="@ENVSCROLL"
#p[210].words ="@EXCLIENTEDGE"
#p[211].words ="@EXCONTROL"
#p[212].words ="@EXLEFT"
#p[213].words ="@EXRIGHT"
#p[214].words ="@EXSTATICEDGE"
#p[215].words ="@EXWINDOWEDGE"
#p[216].words ="@FALT"
#p[217].words ="@FCONTROL"
#p[218].words ="@FILE_ARCHIVE"
#p[219].words ="@FILE_COMPRESSED"
#p[220].words ="@FILE_DEVICE"
#p[221].words ="@FILE_DIRECTORY"
#p[222].words ="@FILE_ENCRYPTED"
#p[223].words ="@FILE_HIDDEN"
#p[224].words ="@FILE_NORMAL"
#p[225].words ="@FILE_READONLY"
#p[226].words ="@FILE_SYSTEM"
#p[227].words ="@FIXEDSIZE"
#p[228].words ="@FNOINVERT"
#p[229].words ="@FORWARDENABLED"
#p[230].words ="@FSHIFT"
#p[231].words ="@FVIRTKEY"
#p[232].words ="@GETHEADERS"
#p[233].words ="@GETNAVURL"
#p[234].words ="@GETPOSTDATA"
#p[235].words ="@GETSTATUSTEXT"
#p[236].words ="@GETTITLE"
#p[237].words ="@GOBACK"
#p[238].words ="@GOFORWARD"
#p[239].words ="@GOHOME"
#p[240].words ="@GOSTOP"
#p[241].words ="@GROUP"
#p[242].words ="@GROUPBOX"
#p[243].words ="@HDN_BEGINDRAG"
#p[244].words ="@HDN_BEGINTRACK"
#p[245].words ="@HDN_BEGINTRACKW"
#p[246].words ="@HDN_DIVIDERDBLCLICK"
#p[247].words ="@HDN_DIVIDERDBLCLICKW"
#p[248].words ="@HDN_ENDDRAG"
#p[249].words ="@HDN_ENDTRACK"
#p[250].words ="@HDN_ENDTRACKW"
#p[251].words ="@HDN_GETDISPINFO"
#p[252].words ="@HDN_GETDISPINFOW"
#p[253].words ="@HDN_ITEMCHANGED"
#p[254].words ="@HDN_ITEMCHANGEDW"
#p[255].words ="@HDN_ITEMCHANGING"
#p[256].words ="@HDN_ITEMCHANGINGW"
#p[257].words ="@HDN_ITEMCLICK"
#p[258].words ="@HDN_ITEMCLICKW"
#p[259].words ="@HDN_ITEMDBLCLICK"
#p[260].words ="@HDN_ITEMDBLCLICKW"
#p[261].words ="@HDN_TRACK"
#p[262].words ="@HDN_TRACKW"
#p[263].words ="@HDS_BUTTONS"
#p[264].words ="@HDS_DRAGDROP"
#p[265].words ="@HDS_FULLDRAG"
#p[266].words ="@HDS_HIDDEN"
#p[267].words ="@HDS_HORZ"
#p[268].words ="@HDS_HOTTRACK"
#p[269].words ="@HFLIP"
#p[270].words ="@HIDDEN"
#p[271].words ="@HITWINDOW"
#p[272].words ="@HSCROLL"
#p[273].words ="@IDABORT"
#p[274].words ="@IDBEFORENAV"
#p[275].words ="@IDCANCEL"
#p[276].words ="@IDCHANGEWINDOW"
#p[277].words ="@IDCHAR"
#p[278].words ="@IDCLOSEWINDOW"
#p[279].words ="@IDCONTINUE"
#p[280].words ="@IDCONTROL"
#p[281].words ="@IDCREATE"
#p[282].words ="@IDDESTROY"
#p[283].words ="@IDDOCUMENTCOMPLETE"
#p[284].words ="@IDDOWNLOADBEGIN"
#p[285].words ="@IDDOWNLOADCOMPLETE"
#p[286].words ="@IDDRAGDROP"
#p[287].words ="@IDDRAGENTER"
#p[288].words ="@IDDRAGFEEDBACK"
#p[289].words ="@IDDRAGLEAVE"
#p[290].words ="@IDDRAGOVER"
#p[291].words ="@IDDXUPDATE"
#p[292].words ="@IDERASEBACKGROUND"
#p[293].words ="@IDHSCROLL"
#p[294].words ="@IDIGNORE"
#p[295].words ="@IDINITDIALOG"
#p[296].words ="@IDKEYDOWN"
#p[297].words ="@IDKEYUP"
#p[298].words ="@IDLBUTTONDBLCLK"
#p[299].words ="@IDLBUTTONDN"
#p[300].words ="@IDLBUTTONUP"
#p[301].words ="@IDMENUINIT"
#p[302].words ="@IDMENUPICK"
#p[303].words ="@IDMOUSEMOVE"
#p[304].words ="@IDMOVE"
#p[305].words ="@IDMOVING"
#p[306].words ="@IDNAVCOMPLETE"
#p[307].words ="@IDNAVIGATEERROR"
#p[308].words ="@IDNEWWINDOW2"
#p[309].words ="@IDNEWWINDOW3"
#p[310].words ="@IDNO"
#p[311].words ="@IDOK"
#p[312].words ="@IDPAINT"
#p[313].words ="@IDPROGRESSCHANGE"
#p[314].words ="@IDRBUTTONDBLCLK"
#p[315].words ="@IDRBUTTONDN"
#p[316].words ="@IDRBUTTONUP"
#p[317].words ="@IDREQCLEAR"
#p[318].words ="@IDRETRY"
#p[319].words ="@IDSETCURSOR"
#p[320].words ="@IDSIZE"
#p[321].words ="@IDSIZECHANGED"
#p[322].words ="@IDSIZING"
#p[323].words ="@IDSTATUSTEXTUPDATE"
#p[324].words ="@IDTIMER"
#p[325].words ="@IDTITLECHANGE"
#p[326].words ="@IDTRYAGAIN"
#p[327].words ="@IDVSCROLL"
#p[328].words ="@IDYES"
#p[329].words ="@IMGBITMAP"
#p[330].words ="@IMGCURSOR"
#p[331].words ="@IMGEMF"
#p[332].words ="@IMGICON"
#p[333].words ="@IMGMAPCOLORS"
#p[334].words ="@IMGOEM"
#p[335].words ="@IMGSCALABLE"
#p[336].words ="@IPN_FIELDCHANGED"
#p[337].words ="@JOYTYPE_FLIGHTSTICK"
#p[338].words ="@JOYTYPE_GAMEPAD"
#p[339].words ="@JOYTYPE_HEADTRACKER"
#p[340].words ="@JOYTYPE_RUDDER"
#p[341].words ="@JOYTYPE_TRADITIONAL"
#p[342].words ="@JOYTYPE_UNKNOWN"
#p[343].words ="@JOYTYPE_WHEEL"
#p[344].words ="@LBNDBLCLK"
#p[345].words ="@LBNERRSPACE"
#p[346].words ="@LBNKILLFOCUS"
#p[347].words ="@LBNSELCANCEL"
#p[348].words ="@LBNSELCHANGE"
#p[349].words ="@LBNSETFOCUS"
#p[350].words ="@LISTBOX"
#p[351].words ="@LISTVIEW"
#p[352].words ="@LPARAM"
#p[353].words ="@LSDASH"
#p[354].words ="@LSDASHDOT"
#p[355].words ="@LSDASHDOTDOT"
#p[356].words ="@LSDOT"
#p[357].words ="@LSINSIDE"
#p[358].words ="@LSSOLID"
#p[359].words ="@LVDELETEALL"
#p[360].words ="@LVDELETECOLUMN"
#p[361].words ="@LVDELETEITEM"
#p[362].words ="@LVFINDITEM"
#p[363].words ="@LVGETCOLUMNTEXT"
#p[364].words ="@LVGETCOLWIDTH"
#p[365].words ="@LVGETCOUNT"
#p[366].words ="@LVGETSELCOUNT"
#p[367].words ="@LVGETSELECTED"
#p[368].words ="@LVGETTEXT"
#p[369].words ="@LVGETTOPINDEX"
#p[370].words ="@LVINSERTCOLUMN"
#p[371].words ="@LVINSERTITEM"
#p[372].words ="@LVNBEGINLABELEDIT"
#p[373].words ="@LVNCOLUMNCLICK"
#p[374].words ="@LVNDELETEITEM"
#p[375].words ="@LVNENDLABELEDIT"
#p[376].words ="@LVNINSERTITEM"
#p[377].words ="@LVNITEMCHANGED"
#p[378].words ="@LVNITEMCHANGING"
#p[379].words ="@LVNKEYDOWN"
#p[380].words ="@LVSALIGNLEFT"
#p[381].words ="@LVSALIGNTOP"
#p[382].words ="@LVSAUTOARRANGE"
#p[383].words ="@LVSEDITLABELS"
#p[384].words ="@LVSETCOLUMNTEXT"
#p[385].words ="@LVSETCOLWIDTH"
#p[386].words ="@LVSETSELECTED"
#p[387].words ="@LVSETTEXT"
#p[388].words ="@LVSICON"
#p[389].words ="@LVSLIST"
#p[390].words ="@LVSNOCOLUMNHEADER"
#p[391].words ="@LVSNOLABELWRAP"
#p[392].words ="@LVSNOSCROLL"
#p[393].words ="@LVSNOSORTHEADER"
#p[394].words ="@LVSREPORT"
#p[395].words ="@LVSSHOWSELALWAYS"
#p[396].words ="@LVSSINGLESEL"
#p[397].words ="@LVSSMALLICON"
#p[398].words ="@LVSSORTASCENDING"
#p[399].words ="@LVSSORTDESCENDING"
#p[400].words ="@MAXBOX"
#p[401].words ="@MAXIMIZED"
#p[402].words ="@MB_ABORTRETRYIGNORE"
#p[403].words ="@MB_CANCELTRYCONTINUE"
#p[404].words ="@MB_ICONEXCLAMATION"
#p[405].words ="@MB_ICONINFORMATION"
#p[406].words ="@MB_ICONQUESTION"
#p[407].words ="@MB_ICONSTOP"
#p[408].words ="@MB_OK"
#p[409].words ="@MB_OKCANCEL"
#p[410].words ="@MB_RETRYCANCEL"
#p[411].words ="@MB_YESNO"
#p[412].words ="@MB_YESNOCANCEL"
#p[413].words ="@MCN_GETDAYSTATE"
#p[414].words ="@MCN_SELCHANGE"
#p[415].words ="@MCN_SELECT"
#p[416].words ="@MCS_DAYSTATE"
#p[417].words ="@MCS_MULTISELECT"
#p[418].words ="@MCS_NOTODAY"
#p[419].words ="@MCS_NOTODAYCIRCLE"
#p[420].words ="@MCS_WEEKNUMBERS"
#p[421].words ="@MDIFRAME"
#p[422].words ="@MENUCHECK"
#p[423].words ="@MENUDISABLE"
#p[424].words ="@MENUNUM"
#p[425].words ="@MENUPICK"
#p[426].words ="@MESSAGE"
#p[427].words ="@MINBOX"
#p[428].words ="@MINIMIZED"
#p[429].words ="@MOUSEX"
#p[430].words ="@MOUSEY"
#p[431].words ="@MULTISELECT"
#p[432].words ="@MYMESSAGE"
#p[433].words ="@NAVIGATE"
#p[434].words ="@NMCLICK"
#p[435].words ="@NMDBLCLK"
#p[436].words ="@NMKILLFOCUS"
#p[437].words ="@NMOUTOFMEMORY"
#p[438].words ="@NMRCLICK"
#p[439].words ="@NMRDBLCLK"
#p[440].words ="@NMRETURN"
#p[441].words ="@NMSETFOCUS"
#p[442].words ="@NOAUTODRAW"
#p[443].words ="@NOCAPTION"
#p[444].words ="@NORESIZE"
#p[445].words ="@NOTIFYCODE"
#p[446].words ="@NWMF_FIRST"
#p[447].words ="@NWMF_FIRST_USERINITED"
#p[448].words ="@NWMF_FORCETAB"
#p[449].words ="@NWMF_FORCEWINDOW"
#p[450].words ="@NWMF_FROMDIALOGCHILD"
#p[451].words ="@NWMF_FROMPROXY"
#p[452].words ="@NWMF_HTMLDIALOG"
#p[453].words ="@NWMF_INACTIVETAB"
#p[454].words ="@NWMF_OVERRIDEKEY"
#p[455].words ="@NWMF_SHOWHELP"
#p[456].words ="@NWMF_SUGGESTTAB"
#p[457].words ="@NWMF_SUGGESTWINDOW"
#p[458].words ="@NWMF_UNLOADING"
#p[459].words ="@NWMF_USERALLOWED"
#p[460].words ="@NWMF_USERINITED"
#p[461].words ="@NWMF_USERREQUESTED"
#p[462].words ="@OPAQUE"
#p[463].words ="@PBS_MARQUEE"
#p[464].words ="@PBS_SMOOTH"
#p[465].words ="@PBS_VERTICAL"
#p[466].words ="@PGF_DEPRESSED"
#p[467].words ="@PGF_GRAYED"
#p[468].words ="@PGF_HOT"
#p[469].words ="@PGF_INVISIBLE"
#p[470].words ="@PGF_NORMAL"
#p[471].words ="@PGN_CALCSIZE"
#p[472].words ="@PGN_SCROLL"
#p[473].words ="@PGS_AUTOSCROLL"
#p[474].words ="@PGS_DRAGNDROP"
#p[475].words ="@PGS_HORZ"
#p[476].words ="@PGS_VERT"
#p[477].words ="@QUAL"
#p[478].words ="@RADIOBUTTON"
#p[479].words ="@RBBS_BREAK"
#p[480].words ="@RBBS_CHILDEDGE"
#p[481].words ="@RBBS_FIXEDBMP"
#p[482].words ="@RBBS_FIXEDSIZE"
#p[483].words ="@RBBS_GRIPPERALWAYS"
#p[484].words ="@RBBS_HIDDEN"
#p[485].words ="@RBBS_NOGRIPPER"
#p[486].words ="@RBBS_NOVERT"
#p[487].words ="@RBBS_VARIABLEHEIGHT"
#p[488].words ="@RBN_AUTOSIZE"
#p[489].words ="@RBN_BEGINDRAG"
#p[490].words ="@RBN_CHILDSIZE"
#p[491].words ="@RBN_DELETEDBAND"
#p[492].words ="@RBN_DELETINGBAND"
#p[493].words ="@RBN_ENDDRAG"
#p[494].words ="@RBN_GETOBJECT"
#p[495].words ="@RBN_HEIGHTCHANGE"
#p[496].words ="@RBN_LAYOUTCHANGED"
#p[497].words ="@RBS_AUTOSIZE"
#p[498].words ="@RBS_BANDBORDERS"
#p[499].words ="@RBS_DBLCLKTOGGLE"
#p[500].words ="@RBS_FIXEDORDER"
#p[501].words ="@RBS_REGISTERDROP"
#p[502].words ="@RBS_TOOLTIPS"
#p[503].words ="@RBS_VARHEIGHT"
#p[504].words ="@RBS_VERTICALGRIPPER"
#p[505].words ="@REFRESH"
#p[506].words ="@RESACCEL"
#p[507].words ="@RESBITMAP"
#p[508].words ="@RESCURSOR"
#p[509].words ="@RESDATA"
#p[510].words ="@RESDIALOG"
#p[511].words ="@RESGROUPCURSOR"
#p[512].words ="@RESGROUPICON"
#p[513].words ="@RESICON"
#p[514].words ="@RESMENU"
#p[515].words ="@RESMESSAGETABLE"
#p[516].words ="@RESSTRING"
#p[517].words ="@RESVERSION"
#p[518].words ="@RGNBUTTON"
#p[519].words ="@RICHEDIT"
#p[520].words ="@RMBLACK"
#p[521].words ="@RMCOPYPEN"
#p[522].words ="@RMMASKNOTPEN"
#p[523].words ="@RMMASKPEN"
#p[524].words ="@RMMASKPENNOT"
#p[525].words ="@RMMERGENOTPEN"
#p[526].words ="@RMMERGEPEN"
#p[527].words ="@RMMERGEPENNOT"
#p[528].words ="@RMMMERGENOTPEN"
#p[529].words ="@RMNOP"
#p[530].words ="@RMNOT"
#p[531].words ="@RMNOTCOPYPEN"
#p[532].words ="@RMNOTMASKPEN"
#p[533].words ="@RMNOTMERGEPEN"
#p[534].words ="@RMNOTXORPEN"
#p[535].words ="@RMWHITE"
#p[536].words ="@RMXORPEN"
#p[537].words ="@ROTOZOOM"
#p[538].words ="@RTALIGNCENTER"
#p[539].words ="@RTALIGNLEFT"
#p[540].words ="@RTALIGNRIGHT"
#p[541].words ="@RTCANUNDO"
#p[542].words ="@RTCHARFROMLINE"
#p[543].words ="@RTCOPY"
#p[544].words ="@RTCUT"
#p[545].words ="@RTDELETESEL"
#p[546].words ="@RTEMPTYUNDO"
#p[547].words ="@RTFINDTEXT"
#p[548].words ="@RTGETEVENTMASK"
#p[549].words ="@RTGETFIRSTLINE"
#p[550].words ="@RTGETLIMITTEXT"
#p[551].words ="@RTGETLINE"
#p[552].words ="@RTGETLINECOUNT"
#p[553].words ="@RTGETLINELENGTH"
#p[554].words ="@RTGETMODIFIED"
#p[555].words ="@RTGETSELECTION"
#p[556].words ="@RTGETSELTEXT"
#p[557].words ="@RTGETTEXTLENGTH"
#p[558].words ="@RTHIDESEL"
#p[559].words ="@RTLINEFROMCHAR"
#p[560].words ="@RTLOAD"
#p[561].words ="@RTPASTE"
#p[562].words ="@RTPASTESPECIAL"
#p[563].words ="@RTPRINT"
#p[564].words ="@RTREPLACESEL"
#p[565].words ="@RTSAVE"
#p[566].words ="@RTSCROLL"
#p[567].words ="@RTSETALIGNMENT"
#p[568].words ="@RTSETCHAROFFSET"
#p[569].words ="@RTSETDEFAULTCOLOR"
#p[570].words ="@RTSETDEFAULTFONT"
#p[571].words ="@RTSETEVENTMASK"
#p[572].words ="@RTSETLIMITTEXT"
#p[573].words ="@RTSETLINEWIDTH"
#p[574].words ="@RTSETMARGINS"
#p[575].words ="@RTSETMODIFIED"
#p[576].words ="@RTSETSELCOLOR"
#p[577].words ="@RTSETSELECTION"
#p[578].words ="@RTSETSELFONT"
#p[579].words ="@RTUNDO"
#p[580].words ="@SBBOTTOM"
#p[581].words ="@SBENDSCROLL"
#p[582].words ="@SBLEFT"
#p[583].words ="@SBLINEDOWN"
#p[584].words ="@SBLINELEFT"
#p[585].words ="@SBLINERIGHT"
#p[586].words ="@SBLINEUP"
#p[587].words ="@SBPAGEDOWN"
#p[588].words ="@SBPAGELEFT"
#p[589].words ="@SBPAGERIGHT"
#p[590].words ="@SBPAGEUP"
#p[591].words ="@SBRIGHT"
#p[592].words ="@SBTHUMBPOS"
#p[593].words ="@SBTHUMBTRACK"
#p[594].words ="@SBTOP"
#p[595].words ="@SCALED"
#p[596].words ="@SCROLLBAR"
#p[597].words ="@SCROLLDOWN"
#p[598].words ="@SCROLLLEFT"
#p[599].words ="@SCROLLRIGHT"
#p[600].words ="@SCROLLUP"
#p[601].words ="@SDALPHA"
#p[602].words ="@SDANGLE"
#p[603].words ="@SDBLTTYPE"
#p[604].words ="@SDFRAME"
#p[605].words ="@SDHEIGHT"
#p[606].words ="@SDSCALE"
#p[607].words ="@SDSHADOW"
#p[608].words ="@SDSHADOWX"
#p[609].words ="@SDSHADOWY"
#p[610].words ="@SDTRANSKEY"
#p[611].words ="@SDWIDTH"
#p[612].words ="@SDXPOS"
#p[613].words ="@SDXVEL"
#p[614].words ="@SDYPOS"
#p[615].words ="@SDYVEL"
#p[616].words ="@SFITALIC"
#p[617].words ="@SFSTRIKEOUT"
#p[618].words ="@SFUNDERLINE"
#p[619].words ="@SHADOW"
#p[620].words ="@SIZE"
#p[621].words ="@SNDASYNC"
#p[622].words ="@SNDLOOP"
#p[623].words ="@SNDNOSTOP"
#p[624].words ="@SNDSYNC"
#p[625].words ="@STATIC"
#p[626].words ="@STATUS"
#p[627].words ="@SWHIDE"
#p[628].words ="@SWMAXIMIZED"
#p[629].words ="@SWMINIMIZED"
#p[630].words ="@SWRESIZE"
#p[631].words ="@SWRESTORE"
#p[632].words ="@SWSETPANES"
#p[633].words ="@SWSETPANETEXT"
#p[634].words ="@SWSHOW"
#p[635].words ="@SYSBUTTON"
#p[636].words ="@SYSMENU"
#p[637].words ="@TABSTOP"
#p[638].words ="@TB_BOTTOM"
#p[639].words ="@TB_ENDTRACK"
#p[640].words ="@TB_LINEDOWN"
#p[641].words ="@TB_LINEUP"
#p[642].words ="@TB_PAGEDOWN"
#p[643].words ="@TB_PAGEUP"
#p[644].words ="@TB_THUMBPOSITION"
#p[645].words ="@TB_THUMBTRACK"
#p[646].words ="@TB_TOP"
#p[647].words ="@TBBOTTOM"
#p[648].words ="@TBBUTTONCHECK"
#p[649].words ="@TBBUTTONGROUP"
#p[650].words ="@TBENABLEBUTTON"
#p[651].words ="@TBFLAT"
#p[652].words ="@TBFROMHANDLE"
#p[653].words ="@TBGETBUTTONHEIGHT"
#p[654].words ="@TBGETBUTTONSTATE"
#p[655].words ="@TBGETBUTTONWIDTH"
#p[656].words ="@TBLEFT"
#p[657].words ="@TBLIST"
#p[658].words ="@TBNOALIGN"
#p[659].words ="@TBNORESIZE"
#p[660].words ="@TBRESIZE"
#p[661].words ="@TBRIGHT"
#p[662].words ="@TBS_AUTOTICKS"
#p[663].words ="@TBS_BOTH"
#p[664].words ="@TBS_BOTTOM"
#p[665].words ="@TBS_ENABLESELRANGE"
#p[666].words ="@TBS_FIXEDLENGTH"
#p[667].words ="@TBS_HORZ"
#p[668].words ="@TBS_LEFT"
#p[669].words ="@TBS_NOTHUMB"
#p[670].words ="@TBS_NOTICKS"
#p[671].words ="@TBS_RIGHT"
#p[672].words ="@TBS_TOOLTIPS"
#p[673].words ="@TBS_TOP"
#p[674].words ="@TBS_VERT"
#p[675].words ="@TBSETBITMAPSIZE"
#p[676].words ="@TBSETBUTTONSIZE"
#p[677].words ="@TBSETBUTTONSTYLE"
#p[678].words ="@TBSETLABELS"
#p[679].words ="@TBSETTIP"
#p[680].words ="@TBTOOLTIPS"
#p[681].words ="@TBTOP"
#p[682].words ="@TBTRANSPARENT"
#p[683].words ="@TBWRAPABLE"
#p[684].words ="@TCN_GETOBJECT"
#p[685].words ="@TCN_KEYDOWN"
#p[686].words ="@TCN_SELCHANGE"
#p[687].words ="@TCN_SELCHANGING"
#p[688].words ="@TCS_BOTTOM"
#p[689].words ="@TCS_BUTTONS"
#p[690].words ="@TCS_EX_FLATSEPARATORS"
#p[691].words ="@TCS_EX_REGISTERDROP"
#p[692].words ="@TCS_FIXEDWIDTH"
#p[693].words ="@TCS_FLATBUTTONS"
#p[694].words ="@TCS_FOCUSNEVER"
#p[695].words ="@TCS_FOCUSONBUTTONDOWN"
#p[696].words ="@TCS_FORCEICONLEFT"
#p[697].words ="@TCS_FORCELABELLEFT"
#p[698].words ="@TCS_HOTTRACK"
#p[699].words ="@TCS_MULTILINE"
#p[700].words ="@TCS_MULTISELECT"
#p[701].words ="@TCS_OWNERDRAWFIXED"
#p[702].words ="@TCS_RAGGEDRIGHT"
#p[703].words ="@TCS_RIGHT"
#p[704].words ="@TCS_RIGHTJUSTIFY"
#p[705].words ="@TCS_SCROLLOPPOSITE"
#p[706].words ="@TCS_SINGLELINE"
#p[707].words ="@TCS_TABS"
#p[708].words ="@TCS_TOOLTIPS"
#p[709].words ="@TCS_VERTICAL"
#p[710].words ="@TOOLWINDOW"
#p[711].words ="@TOPMOST"
#p[712].words ="@TRANS"
#p[713].words ="@TRANSALPHA"
#p[714].words ="@TRANSHFLIP"
#p[715].words ="@TRANSPARENT"
#p[716].words ="@TRANSROTOZOOM"
#p[717].words ="@TRANSSCALED"
#p[718].words ="@TRANSSHADOW"
#p[719].words ="@TRANSVFLIP"
#p[720].words ="@TREEVIEW"
#p[721].words ="@TTF_ABSOLUTE"
#p[722].words ="@TTF_CENTERTIP"
#p[723].words ="@TTF_DI_SETITEM"
#p[724].words ="@TTF_IDISHWND"
#p[725].words ="@TTF_RTLREADING"
#p[726].words ="@TTF_SUBCLASS"
#p[727].words ="@TTF_TRACK"
#p[728].words ="@TTF_TRANSPARENT"
#p[729].words ="@TTN_GETDISPINFOA"
#p[730].words ="@TTN_GETDISPINFOW"
#p[731].words ="@TTN_POP"
#p[732].words ="@TTN_SHOW"
#p[733].words ="@TTS_ALWAYSTIP"
#p[734].words ="@TTS_BALLOON"
#p[735].words ="@TTS_NOANIMATE"
#p[736].words ="@TTS_NOFADE"
#p[737].words ="@TTS_NOPREFIX"
#p[738].words ="@TVNBEGINDRAG"
#p[739].words ="@TVNBEGINLABELEDIT"
#p[740].words ="@TVNBEGINRDRAG"
#p[741].words ="@TVNDELETEITEM"
#p[742].words ="@TVNENDLABELEDIT"
#p[743].words ="@TVNGETDISPINFO"
#p[744].words ="@TVNGETINFOTIP"
#p[745].words ="@TVNITEMEXPANDED"
#p[746].words ="@TVNITEMEXPANDING"
#p[747].words ="@TVNKEYDOWN"
#p[748].words ="@TVNSELCHANGED"
#p[749].words ="@TVNSELCHANGING"
#p[750].words ="@TVNSETDISPINFO"
#p[751].words ="@TVNSINGLEEXPAND"
#p[752].words ="@TVSCHECKBOXES"
#p[753].words ="@TVSDISABLEDRAGDROP"
#p[754].words ="@TVSEDITLABELS"
#p[755].words ="@TVSFULLROWSELECT"
#p[756].words ="@TVSHASBUTTONS"
#p[757].words ="@TVSHASLINES"
#p[758].words ="@TVSINFOTIP"
#p[759].words ="@TVSLINESATROOT"
#p[760].words ="@TVSNOHSCROLL"
#p[761].words ="@TVSNONEVENHEIGHT"
#p[762].words ="@TVSNOSCROLL"
#p[763].words ="@TVSNOTOOLTIPS"
#p[764].words ="@TVSRTLREADING"
#p[765].words ="@TVSSHOWSELALWAYS"
#p[766].words ="@TVSSINGLEEXPAND"
#p[767].words ="@TVSTRACKSELECT"
#p[768].words ="@TYPEBFILE"
#p[769].words ="@TYPEBITFIELD"
#p[770].words ="@TYPEBYTE"
#p[771].words ="@TYPECHAR"
#p[772].words ="@TYPEDIALOG"
#p[773].words ="@TYPEDOUBLE"
#p[774].words ="@TYPEFILE"
#p[775].words ="@TYPEFLOAT"
#p[776].words ="@TYPEINT"
#p[777].words ="@TYPEINT64"
#p[778].words ="@TYPEMEMORY"
#p[779].words ="@TYPEPOINTER"
#p[780].words ="@TYPESCHAR"
#p[781].words ="@TYPESTRING"
#p[782].words ="@TYPESWORD"
#p[783].words ="@TYPEUINT"
#p[784].words ="@TYPEUINT64"
#p[785].words ="@TYPEUSER"
#p[786].words ="@TYPEWINDOW"
#p[787].words ="@TYPEWORD"
#p[788].words ="@TYPEWSTRING"
#p[789].words ="@UDS_ALIGNLEFT"
#p[790].words ="@UDS_ALIGNRIGHT"
#p[791].words ="@UDS_ARROWKEYS"
#p[792].words ="@UDS_AUTOBUDDY"
#p[793].words ="@UDS_HORZ"
#p[794].words ="@UDS_HOTTRACK"
#p[795].words ="@UDS_NOTHOUSANDS"
#p[796].words ="@UDS_SETBUDDYINT"
#p[797].words ="@UDS_WRAP"
#p[798].words ="@USEDEFAULT"
#p[799].words ="@USERERROR"
#p[800].words ="@VFLIP"
#p[801].words ="@VSCROLL"
#p[802].words ="@WPARAM"
#p[803].words ="@XAXIS"
#p[804].words ="@YAXIS"
#p[805].words ="@ZAXIS"

'$
#p[806].words ="$ASM"
#p[807].words ="$DEFINE"
#p[808].words ="$ELIF"
#p[809].words ="$ELIFDEF"
#p[810].words ="$ELIFNDEF"
#p[811].words ="$ELSE"
#p[812].words ="$EMIT"
#p[813].words ="$ENDASM"
#p[814].words ="$ENDIF"
#p[815].words ="$ENDREGION"
#p[816].words ="$ERROR"
#p[817].words ="$IF"
#p[818].words ="$IFDEF"
#p[819].words ="$IFNDEF"
#p[820].words ="$INCLUDE"
#p[821].words ="$MACRO"
#p[822].words ="$MAIN"
#p[823].words ="$OPTION"
#p[824].words ="$REGION"
#p[825].words ="$TYPEDEF"
#p[826].words ="$UNDECLARE"
#p[827].words ="$UNDEF"
#p[828].words ="$USE"
#p[829].words ="$WARNING"
#p[830].words ="$WHEREDEFINED"

'A
#p[831].words ="ABS"
#p[832].words ="ACOS"
#p[833].words ="ACOSD"
#p[834].words ="ADDACCELERATOR"
#p[835].words ="ADDMENUITEM"
#p[836].words ="ADDSTRING"
#p[837].words ="ALIAS"
#p[838].words ="ALLOCHEAP"
#p[839].words ="ALLOCMEM"
#p[840].words ="AND"
#p[841].words ="ANIM_LOOP"
#p[842].words ="ANIM_ONCE"
#p[843].words ="ANIM_PINGPONG"
#p[844].words ="ANIM_STOP"
#p[845].words ="ANYTYPE"
#p[846].words ="APPEND$"
#p[847].words ="APPENDMENU"
#p[848].words ="AS"
#p[849].words ="ASC"
#p[850].words ="ASIN"
#p[851].words ="ASIND"
#p[852].words ="ATAN"
#p[853].words ="ATAND"
#p[854].words ="ATTACHBROWSER"
#p[855].words ="ATTACHSCREEN"
#p[856].words ="AUTODEFINE"

'B
#p[857].words ="BACKBUFFER"
#p[858].words ="BACKPEN"
#p[859].words ="BASELEN"
#p[860].words ="BEGININSERTMENU"
#p[861].words ="BEGINMENU"
#p[862].words ="BEGINPOPUP"
#p[863].words ="BFILE"
#p[864].words ="BPP"
#p[865].words ="BREAK"
#p[866].words ="BREAKFOR"
#p[867].words ="BROWSECMD"
#p[868].words ="BYREF"
#p[869].words ="BYVAL"

'C
#p[870].words ="CALENDARCONTROL"
#p[871].words ="CALL"
#p[872].words ="CALLOBJECTMETHOD"
#p[873].words ="CASE"
#p[874].words ="CASE&"
#p[875].words ="CATCH"
#p[876].words ="CBEADDSTRING"
#p[877].words ="CBEDELETESTRING"
#p[878].words ="CBEGETSELECTED"
#p[879].words ="CBEGETSTRING"
#p[880].words ="CBEGETSTRINGCOUNT"
#p[881].words ="CBEINSERTSTRING"
#p[882].words ="CBESETIMAGELIST"
#p[883].words ="CBESETINDENT"
#p[884].words ="CBESETSELECTED"
#p[885].words ="CCGETCOLOR"
#p[886].words ="CCGETCURSEL"
#p[887].words ="CCGETFIRSTDAYOFWEEK"
#p[888].words ="CCGETMINIMUMRECT"
#p[889].words ="CCGETSCROLLDELTA"
#p[890].words ="CCGETTODAY"
#p[891].words ="CCSETCOLOR"
#p[892].words ="CCSETCURSEL"
#p[893].words ="CCSETFIRSTDAYOFWEEK"
#p[894].words ="CCSETSCROLLDELTA"
#p[895].words ="CCSETTODAY"
#p[896].words ="CDECL"
#p[897].words ="CEIL"
#p[898].words ="CENTERWINDOW"
#p[899].words ="CHAR"
#p[900].words ="CHECKDROPFORMAT"
#p[901].words ="CHECKMENUITEM"
#p[902].words ="CHR$"
#p[903].words ="CIRCLE"
#p[904].words ="CLASS"
#p[905].words ="CLEAR"
#p[906].words ="CLOSECONSOLE"
#p[907].words ="CLOSEDIALOG"
#p[908].words ="CLOSEFILE"
#p[909].words ="CLOSEPRINTER"
#p[910].words ="CLOSESCREEN"
#p[911].words ="CLOSEWINDOW"
#p[912].words ="CLS"
#p[913].words ="COLOR"
#p[914].words ="COLORREQUEST"
#p[915].words ="COM"
#p[916].words ="COMBOBOXEX"
#p[917].words ="COMENUMBEGIN"
#p[918].words ="COMENUMNEXT"
#p[919].words ="COMGETLASTERROR"
#p[920].words ="COMREF"
#p[921].words ="CONST"
#p[922].words ="CONTEXTMENU"
#p[923].words ="CONTROL"
#p[924].words ="CONTROLCMD"
#p[925].words ="CONTROLEX"
#p[926].words ="CONTROLEXISTS"
#p[927].words ="COPYFILE"
#p[928].words ="COPYRGN"
#p[929].words ="COS"
#p[930].words ="COSD"
#p[931].words ="COSH"
#p[932].words ="COSHD"
#p[933].words ="CREATE"
#p[934].words ="CREATE3DSCREEN"
#p[935].words ="CREATECOMOBJECT"
#p[936].words ="CREATEDIALOG"
#p[937].words ="CREATEDIR"
#p[938].words ="CREATEMAPDATA"
#p[939].words ="CREATEMENU"
#p[940].words ="CREATEREGKEY"
#p[941].words ="CREATESCREEN"
#p[942].words ="CREATESPRITE"

'D
#p[943].words ="D3DCAMERA"
#p[944].words ="D3DCOMMAND"
#p[945].words ="D3DDELETE"
#p[946].words ="D3DLIGHT"
#p[947].words ="D3DMOVE"
#p[948].words ="D3DRENDER"
#p[949].words ="D3DSCENE"
#p[950].words ="D3DSETQUALITY"
#p[951].words ="D3DSETRENDERMODE"
#p[952].words ="D3DSHAPE"
#p[953].words ="DATA"
#p[954].words ="DATABEGIN"
#p[955].words ="DATABLOCK"
#p[956].words ="DATAEND"
#p[957].words ="DATE$"
#p[958].words ="DATETIMEPICKER"
#p[959].words ="DBBINDDATE"
#p[960].words ="DBBINDDATEPARAM"
#p[961].words ="DBBINDPARAMETER"
#p[962].words ="DBBINDTIME"
#p[963].words ="DBBINDTIMEPARAM"
#p[964].words ="DBBINDTIMESTAMP"
#p[965].words ="DBBINDTIMESTAMPPARAM"
#p[966].words ="DBBINDVARIABLE"
#p[967].words ="DBCARDINALITY"
#p[968].words ="DBCONNECT"
#p[969].words ="DBCONNECTDSN"
#p[970].words ="DBCREATEMDBDISCONNECT"
#p[971].words ="DBENUMDRIVERS"
#p[972].words ="DBEXECSQL"
#p[973].words ="DBEXECUTE"
#p[974].words ="DBFREESQL"
#p[975].words ="DBGET"
#p[976].words ="DBGETDATA"
#p[977].words ="DBGETDATE"
#p[978].words ="DBGETERRORCODE"
#p[979].words ="DBGETERRORTEXT"
#p[980].words ="DBGETFIRST"
#p[981].words ="DBGETLAST"
#p[982].words ="DBGETNEXT"
#p[983].words ="DBGETNUMCOLS"
#p[984].words ="DBGETPREV"
#p[985].words ="DBGETTIME"
#p[986].words ="DBGETTIMESTAMP"
#p[987].words ="DBISNULL"
#p[988].words ="DBLISTCOLUMNS"
#p[989].words ="DBLISTTABLES"
#p[990].words ="DBPREPARESQL"
#p[991].words ="DEBUGPRINT"
#p[992].words ="DECLARE"
#p[993].words ="DEF"
#p[994].words ="DEFAULT"
#p[995].words ="DEFINE_GUID"
#p[996].words ="DELETE"
#p[997].words ="DELETEFILE"
#p[998].words ="DELETEIMAGE"
#p[999].words ="DELETEREGKEY"
#p[1000].words ="DELETERGN"
#p[1001].words ="DELETESTRING"
#p[1002].words ="DIALOG"
#p[1003].words ="DICTADD"
#p[1004].words ="DICTCREATE"
#p[1005].words ="DICTFREE"
#p[1006].words ="DICTGETKEY"
#p[1007].words ="DICTGETNEXTASSOC"
#p[1008].words ="DICTGETSTARTASSOC"
#p[1009].words ="DICTGETVALUE"
#p[1010].words ="DICTLOOKUP"
#p[1011].words ="DICTREMOVE"
#p[1012].words ="DICTREMOVEALL"
#p[1013].words ="DIM"
#p[1014].words ="DO"
#p[1015].words ="DOMODAL"
#p[1016].words ="DOUBLE"
#p[1017].words ="DRAWAALINE"
#p[1018].words ="DRAWALPHALINE"
#p[1019].words ="DRAWFILLEDRECT"
#p[1020].words ="DRAWLINE"
#p[1021].words ="DRAWMAP"
#p[1022].words ="DRAWMODE"
#p[1023].words ="DRAWRECT"
#p[1024].words ="DRAWSPRITE"
#p[1025].words ="DRAWSPRITEXY"
#p[1026].words ="DTPGETMCCOLOR"
#p[1027].words ="DTPGETSYSTEMTIME"
#p[1028].words ="DTPSETFORMAT"
#p[1029].words ="DTPSETMCCOLOR"
#p[1030].words ="DTPSETSYSTEMTIME"
#p[1031].words ="DXCREATEMAP"
#p[1032].words ="DXDRAWALLSPRITES"
#p[1033].words ="DXDRAWMAP"
#p[1034].words ="DXDRAWSPRITE"
#p[1035].words ="DXENDTRY"
#p[1036].words ="DXFILL"
#p[1037].words ="DXFLIP"
#p[1038].words ="DXGETMAPCOUNT"
#p[1039].words ="DXGETMAPHEIGHT"
#p[1040].words ="DXGETMAPTILE"
#p[1041].words ="DXGETMAPWIDTH"
#p[1042].words ="DXGETSPRITEDATA"
#p[1043].words ="DXHITANY"
#p[1044].words ="DXHITSPRITE"
#p[1045].words ="DXHITSPRITETILE"
#p[1046].words ="DXLOADMAP"
#p[1047].words ="DXLOADPALETTE"
#p[1048].words ="DXMOVEMAP"
#p[1049].words ="DXMOVESPRITE"
#p[1050].words ="DXNEWMAP"
#p[1051].words ="DXREMOVESPRITE"
#p[1052].words ="DXSAVEMAP"
#p[1053].words ="DXSCROLLMAP"
#p[1054].words ="DXSETCOLOR"
#p[1055].words ="DXSETMAPTILE"
#p[1056].words ="DXSETSPRITEDATA"
#p[1057].words ="DXSPRITE"
#p[1058].words ="DXTRY"
#p[1059].words ="DYNAMIC_CAST"

'E
#p[1060].words ="EACH"
#p[1061].words ="ELLIPSE"
#p[1062].words ="ELSE"
#p[1063].words ="ELSEIF"
#p[1064].words ="ENABLECONTROL"
#p[1065].words ="ENABLEMENU"
#p[1066].words ="ENABLEMENUITEM"
#p[1067].words ="ENABLETABS"
#p[1068].words ="END"
#p[1069].words ="ENDCATCH"
#p[1070].words ="ENDCLASS"
#p[1071].words ="ENDENUM"
#p[1072].words ="ENDIF"
#p[1073].words ="ENDINTERFACE"
#p[1074].words ="ENDMENU"
#p[1075].words ="ENDPAGE"
#p[1076].words ="ENDPOPUP"
#p[1077].words ="ENDREGION"
#p[1078].words ="ENDSELECT"
#p[1079].words ="ENDSUB"
#p[1080].words ="ENDTRY"
#p[1081].words ="ENDTYPE"
#p[1082].words ="ENDUNION"
#p[1083].words ="ENDWHILE"
#p[1084].words ="ENDWITH"
#p[1085].words ="ENTER"
#p[1086].words ="ENUM"   '<----------------
#p[1087].words ="EOF" '<----------------
#p[1088].words ="ESC" 
#p[1089].words ="EXECUTE"
#p[1090].words ="EXP" 
#p[1091].words ="EXPORT"
#p[1092].words ="EXSTYLE"
#p[1093].words ="EXTERN" 

'F
#p[1094].words ="FACOS"
#p[1095].words ="FACOSD"
#p[1096].words ="FADE"
#p[1097].words ="FADEPALETTE"
#p[1098].words ="FASIN"
#p[1099].words ="FASIND"
#p[1100].words ="FATAN"
#p[1101].words ="FATAND"
#p[1102].words ="FCOS"
#p[1103].words ="FCOSD"
#p[1104].words ="FCOSH"
#p[1105].words ="FCOSHD"
#p[1106].words ="FILE"
#p[1107].words ="FILEREQUEST"
#p[1108].words ="FILL_POINT"
#p[1109].words ="FILL_SOLID"
#p[1110].words ="FILL_WIREFRAME"
#p[1111].words ="FILLPALETTE"
#p[1112].words ="FILLSCREEN"
#p[1113].words ="FINDCLOSE"
#p[1114].words ="FINDNEXT"
#p[1115].words ="FINDOPEN"
#p[1116].words ="FLIP"
#p[1117].words ="FLOAT"
#p[1118].words ="FLOODFILL"
#p[1119].words ="FLOOR"
#p[1120].words ="FLT"
#p[1121].words ="FLUSHKEYS"
#p[1122].words ="FONTREQUEST"
#p[1123].words ="FOR"
#p[1124].words ="FREECOMSTRING"
#p[1125].words ="FREEHEAP"
#p[1126].words ="FREELIB"
#p[1127].words ="FREEMAP"
#p[1128].words ="FREEMEM"
#p[1129].words ="FREESPRITE"
#p[1130].words ="FRONTBUFFER"
#p[1131].words ="FRONTPEN"
#p[1132].words ="FSIN"
#p[1133].words ="FSIND"
#p[1134].words ="FSINH"
#p[1135].words ="FSINHD"
#p[1136].words ="FTAN"
#p[1137].words ="FTAND"
#p[1138].words ="FTANH"
#p[1139].words ="FTANHD"

'G
#p[1140].words ="GDI32"
#p[1141].words ="GET"
#p[1142].words ="GETBITMAPSIZE"
#p[1143].words ="GETBROWSERINTERFACE"
#p[1144].words ="GETBUFFERHEIGHT"
#p[1145].words ="GETBUFFERPITCH"
#p[1146].words ="GETBUFFERPOINTER"
#p[1147].words ="GETBUFFERWIDTH"
#p[1148].words ="GETCAPTION"
#p[1149].words ="GETCARETPOSITION"
#p[1150].words ="GETCLIENTSIZE"
#p[1151].words ="GETCOMOBJECT"
#p[1152].words ="GETCOMPROPERTY"
#p[1153].words ="GETCONTROLHANDLE"
#p[1154].words ="GETCONTROLTEXT"
#p[1155].words ="GETDATA"
#p[1156].words ="GETDEFAULTPRINTER"
#p[1157].words ="GETDRAGKEYSTATE"
#p[1158].words ="GETDRAGPOINT"
#p[1159].words ="GETDROPDATA"
#p[1160].words ="GETDXVERSION"
#p[1161].words ="GETEXCEPTIONCODE"
#p[1162].words ="GETEXCEPTIONINFORMATION"
#p[1163].words ="GETFOLDERPATH"
#p[1164].words ="GETHDC"
#p[1165].words ="GETJOYSTICKAXISCOUNT"
#p[1166].words ="GETJOYSTICKBUTTONCOUNT"
#p[1167].words ="GETJOYSTICKCOUNT"
#p[1168].words ="GETJOYSTICKNAME"
#p[1169].words ="GETJOYSTICKTYPE"
#p[1170].words ="GETKEY"
#p[1171].words ="GETKEYSTATE"
#p[1172].words ="GETMAPCOUNT"
#p[1173].words ="GETMAPDATA"
#p[1174].words ="GETMAPHEIGHT"
#p[1175].words ="GETMAPPIXELHEIGHT"
#p[1176].words ="GETMAPPIXELWIDTH"
#p[1177].words ="GETMAPWIDTH"
#p[1178].words ="GETPALETTECOLOR"
#p[1179].words ="GETPIXEL"
#p[1180].words ="GETPOSITION"
#p[1181].words ="GETPROGRESSPOSITION"
#p[1182].words ="GETRESOURCELENGTH"
#p[1183].words ="GETSCREENSIZE"
#p[1184].words ="GETSCROLLPOS"
#p[1185].words ="GETSCROLLRANGE"
#p[1186].words ="GETSELECTED"
#p[1187].words ="GETSIZE"
#p[1188].words ="GETSPINNERBASE"
#p[1189].words ="GETSPINNERBUDDY"
#p[1190].words ="GETSPINNERPOSITION"
#p[1191].words ="GETSPINNERRANGEMAX"
#p[1192].words ="GETSPINNERRANGEMIN"
#p[1193].words ="GETSPRITEDELAY"
#p[1194].words ="GETSPRITEFRAMES"
#p[1195].words ="GETSPRITEHEIGHT"
#p[1196].words ="GETSPRITEPITCH"
#p[1197].words ="GETSPRITEPOINTER"
#p[1198].words ="GETSPRITESTATE"
#p[1199].words ="GETSPRITETYPE"
#p[1200].words ="GETSPRITEVELX"
#p[1201].words ="GETSPRITEVELY"
#p[1202].words ="GETSPRITEWIDTH"
#p[1203].words ="GETSTARTPATH"
#p[1204].words ="GETSTARTPATHW"
#p[1205].words ="GETSTATE"
#p[1206].words ="GETSTRING"
#p[1207].words ="GETSTRINGCOUNT"
#p[1208].words ="GETTEXTSIZE"
#p[1209].words ="GETTHUMBPOS"
#p[1210].words ="GETTRACKBARLINESIZE"
#p[1211].words ="GETTRACKBARPAGESIZE"
#p[1212].words ="GETTRACKBARPOSITION"
#p[1213].words ="GETTRACKBARRANGEMAX"
#p[1214].words ="GETTRACKBARRANGEMIN"
#p[1215].words ="GETUSERDATA"
#p[1216].words ="GLOBAL"
#p[1217].words ="GOSUB"
#p[1218].words ="GOTO"
#p[1219].words ="GUID"

'H
#p[1220].words ="HCDELETEITEM"
#p[1221].words ="HCGETITEMCOUNT"
#p[1222].words ="HCGETITEMDATA"
#p[1223].words ="HCGETITEMRECT"
#p[1224].words ="HCGETITEMTEXT"
#p[1225].words ="HCGETITEMWIDTH"
#p[1226].words ="HCINSERTITEM"
#p[1227].words ="HCSETIMAGELIST"
#p[1228].words ="HCSETITEMDATA"
#p[1229].words ="HCSETITEMJUSTIFY"
#p[1230].words ="HCSETITEMTEXT"
#p[1231].words ="HCSETITEMWIDTH"
#p[1232].words ="HEADERCONTROL"
#p[1233].words ="HEAP"
#p[1234].words ="HEAPCLEAR"
#p[1235].words ="HEX$"

'I
#p[1236].words ="IF"
#p[1237].words ="IMPLEMENTS"
#p[1238].words ="IMPORT"
#p[1239].words ="INKEY$"
#p[1240].words ="INPUT"
#p[1241].words ="INSERT"
#p[1242].words ="INSERTMENU"
#p[1243].words ="INSERTSTRING"
#p[1244].words ="INSTR"
#p[1245].words ="INT"
#p[1246].words ="INT64"
#p[1247].words ="INTERFACE"
#p[1248].words ="INTRAND"
#p[1249].words ="IPCLEARADDRESS"
#p[1250].words ="IPCONTROL"
#p[1251].words ="IPGETADDRESS"
#p[1252].words ="IPGETADDRESSDWORD"
#p[1253].words ="IPISBLANK"
#p[1254].words ="IPSETADDRESS"
#p[1255].words ="IPSETADDRESSDWORD"
#p[1256].words ="IPSETRANGE"
#p[1257].words ="ISARRAY"
#p[1258].words ="ISREF"
#p[1259].words ="ISSELECTED"
#p[1260].words ="ISTRING"
#p[1261].words ="ISWINDOWCLOSED"
#p[1262].words ="ISWINDOWHIDDEN"
#p[1263].words ="ITSTRING"
#p[1264].words ="IWSTRING"

'J
#p[1265].words ="JOYDOWN"
#p[1266].words ="JOYX"
#p[1267].words ="JOYY"
#p[1268].words ="JOYZ"
#p[1269].words ="JUMP"

'K
#p[1270].words ="KERNEL32"
#p[1271].words ="KEYDOWN"

'L
#p[1272].words ="LABEL"
#p[1273].words ="LCASE$"
#p[1274].words ="LEAVE"
#p[1275].words ="LEFT$"
#p[1276].words ="LEN"
#p[1277].words ="LET"
#p[1278].words ="LINE"
#p[1279].words ="LINETO"
#p[1280].words ="LINKEDLIST"
#p[1281].words ="LISTADD"
#p[1282].words ="LISTADDHEAD"
#p[1283].words ="LISTCREATE"
#p[1284].words ="LISTGETDATA"
#p[1285].words ="LISTGETFIRST"
#p[1286].words ="LISTGETNEXT"
#p[1287].words ="LISTGETPOS"
#p[1288].words ="LISTREMOVE"
#p[1289].words ="LISTREMOVEALL"
#p[1290].words ="LOADIMAGE"
#p[1291].words ="LOADMAPDATA"
#p[1292].words ="LOADMENU"
#p[1293].words ="LOADPALETTE"
#p[1294].words ="LOADRESOURCE"
#p[1295].words ="LOADSPRITE"
#p[1296].words ="LOADTOOLBAR"
#p[1297].words ="LOCATE"
#p[1298].words ="LOCK"
#p[1299].words ="LOCKBUFFER"
#p[1300].words ="LOCKSPRITE"
#p[1301].words ="LOG"
#p[1302].words ="LOG10"
#p[1303].words ="LOGFONT"
#p[1304].words ="LOGPEN"
#p[1305].words ="LTRIM$"
#p[1306].words ="LVKEYDOWN"
#p[1307].words ="LVN_ENDLABELEDIT"

'M
#p[1308].words ="MAPDRAWMODE"
#p[1309].words ="MAPMASKCOLOR"
#p[1310].words ="MATRIXIDENTITY"
#p[1311].words ="MATRIXMULTIPLY"
#p[1312].words ="MATRIXROTATION"
#p[1313].words ="MATRIXTRANSLATION"
#p[1314].words ="MEMORY"
#p[1315].words ="MENU"
#p[1316].words ="MENUITEM"
#p[1317].words ="MENUTITLE"
#p[1318].words ="MESSAGEBOX"
#p[1319].words ="MID$"
#p[1320].words ="MILLISECS"
#p[1321].words ="MODIFY"
#p[1322].words ="MODIFYEXSTYLE"
#p[1323].words ="MODIFYSTYLE"
#p[1324].words ="MOUSEDOWN"
#p[1325].words ="MOUSEX"
#p[1326].words ="MOUSEY"
#p[1327].words ="MOVE"
#p[1328].words ="MOVEMAP"
#p[1329].words ="MOVESPRITE"

'N
#p[1330].words ="NEW"
#p[1331].words ="NEWMAP"
#p[1332].words ="NEXT"
#p[1333].words ="NMHDR"
#p[1334].words ="NOT"
#p[1335].words ="NULL"

'O
#p[1336].words ="OEM"
#p[1337].words ="OFFSETOF"
#p[1338].words ="ON"
#p[1339].words ="ONCONTROL"
#p[1340].words ="ONEXIT"
#p[1341].words ="ONMENUPICK"
#p[1342].words ="ONMESSAGE"
#p[1343].words ="OPENCONSOLE"
#p[1344].words ="OPENFILE"
#p[1345].words ="OPENPRINTER"
#p[1346].words ="OPENWINDOW"
#p[1347].words ="OPT"
#p[1348].words ="OR"

'P
#p[1349].words ="PAGERCONTROL"
#p[1350].words ="PALETTEINDEX"
#p[1351].words ="PCFORWARDMOUSE"
#p[1352].words ="PCGETBUTTONSTATE"
#p[1353].words ="PCGETPOS"
#p[1354].words ="PCRECALCSIZE"
#p[1355].words ="PCSETBACKCOLOR"
#p[1356].words ="PCSETBORDERSIZE"
#p[1357].words ="PCSETBUTTONSIZE"
#p[1358].words ="PCSETCHILD"
#p[1359].words ="PCSETCHILDHWND"
#p[1360].words ="PCSETPOS"
#p[1361].words ="PLAYMIDI$"
#p[1362].words ="PLAYWAVE"
#p[1363].words ="POINT"
#p[1364].words ="POINTER"
#p[1365].words ="POPHEAP"
#p[1366].words ="POPUP"
#p[1367].words ="PRINT"
#p[1368].words ="PRINTWINDOW"
#p[1369].words ="PRIVATE"
#p[1370].words ="PROGRESSCONTROL"
#p[1371].words ="PROGRESSSTEPIT"
#p[1372].words ="PROJECTGLOBAL"
#p[1373].words ="PROTECTED"
#p[1374].words ="PRTDIALOG"
#p[1375].words ="PSET"
#p[1376].words ="PUBLIC"
#p[1377].words ="PUSHHEAP"
#p[1378].words ="PUT"

'R
#p[1379].words ="RAND"
#p[1380].words ="RASTERMODE"
#p[1381].words ="RBADDBAND"
#p[1382].words ="RBSETBANDBITMAP"
#p[1383].words ="RBSETBANDCHILD"
#p[1384].words ="RBSETBANDCHILDHANDLE"
#p[1385].words ="RBSETBANDCOLORS"
#p[1386].words ="RBSETBANDTEXT"
#p[1387].words ="RBSHOWBAND"
#p[1388].words ="READ"
#p[1389].words ="READMEM"
#p[1390].words ="READPIXEL"
#p[1391].words ="REALLOCHEAP"
#p[1392].words ="REBARCONTROL"
#p[1393].words ="RECT"
#p[1394].words ="REDRAWFRAME"
#p[1395].words ="REGGETDWORD"
#p[1396].words ="REGGETSTRING"
#p[1397].words ="REGION"
#p[1398].words ="REGISTERDROPTARGET"
#p[1399].words ="REGSETDWORD"
#p[1400].words ="REGSETSTRING"
#p[1401].words ="RELEASEHDC"
#p[1402].words ="REM"
#p[1403].words ="REMOVEDIR"
#p[1404].words ="REMOVEDROPTARGET"
#p[1405].words ="REMOVEMENUITEM"
#p[1406].words ="REPLACE$"
#p[1407].words ="RESTORE"
#p[1408].words ="RETURN"
#p[1409].words ="RGB"
#p[1410].words ="RGBA"
#p[1411].words ="RGBTOSCREEN"
#p[1412].words ="RGNFROMBITMAP"
#p[1413].words ="RIGHT"
#p[1414].words ="RIGHT$"
#p[1415].words ="RND"
#p[1416].words ="ROTOZOOM"
#p[1417].words ="RTIMAGE"
#p[1418].words ="RTRIM$"

'S
#p[1419].words ="S2W"
#p[1420].words ="SAVEMAPDATA"
#p[1421].words ="SCHAR"
#p[1422].words ="SCREEN"
#p[1423].words ="SCROLL"
#p[1424].words ="SCROLLMAP"
#p[1425].words ="SEEDRND"
#p[1426].words ="SEEK"
#p[1427].words ="SELECT"
#p[1428].words ="SENDMESSAGE"
#p[1429].words ="SEPARATOR"
#p[1430].words ="SET_INTERFACE"
#p[1431].words ="SETBUTTONBITMAPS"
#p[1432].words ="SETBUTTONBORDER"
#p[1433].words ="SETBUTTONRGN"
#p[1434].words ="SETCAPTION"
#p[1435].words ="SETCOMPROPERTY"
#p[1436].words ="SETCONTROLCOLOR"
#p[1437].words ="SETCONTROLNOTIFY"
#p[1438].words ="SETCONTROLTEXT"
#p[1439].words ="SETCONTROLTEXTW"
#p[1440].words ="SETCURSOR"
#p[1441].words ="SETEXITCODE"
#p[1442].words ="SETFOCUS"
#p[1443].words ="SETFONT"
#p[1444].words ="SETHORIZEXTENT"
#p[1445].words ="SETHTCOLOR"
#p[1446].words ="SETICON"
#p[1447].words ="SETID"
#p[1448].words ="SETJOYSTICKDEADZONE"
#p[1449].words ="SETJOYSTICKRANGE"
#p[1450].words ="SETLBCOLWIDTH"
#p[1451].words ="SETLINESTYLE"
#p[1452].words ="SETMAPDATA"
#p[1453].words ="SETMAPVIEWPORT"
#p[1454].words ="SETMENU"
#p[1455].words ="SETPALETTECOLOR"
#p[1456].words ="SETPRECISION"
#p[1457].words ="SETPROGRESSBARCOLOR"
#p[1458].words ="SETPROGRESSDELTA"
#p[1459].words ="SETPROGRESSMARQUEE"
#p[1460].words ="SETPROGRESSPOSITION"
#p[1461].words ="SETPROGRESSRANGE"
#p[1462].words ="SETPROGRESSSTEP"
#p[1463].words ="SETSCROLLPOS"
#p[1464].words ="SETSCROLLRANGE"
#p[1465].words ="SETSELECTED"
#p[1466].words ="SETSIZE"
#p[1467].words ="SETSPINNERBASE"
#p[1468].words ="SETSPINNERBUDDY"
#p[1469].words ="SETSPINNERPOSITION"
#p[1470].words ="SETSPINNERRANGE"
#p[1471].words ="SETSPRITEDELAY"
#p[1472].words ="SETSPRITESTATE"
#p[1473].words ="SETSPRITETYPE"
#p[1474].words ="SETSPRITEVELX"
#p[1475].words ="SETSPRITEVELY"
#p[1476].words ="SETSTATE"
#p[1477].words ="SETTRACKBARLINESIZE"
#p[1478].words ="SETTRACKBARPAGESIZE"
#p[1479].words ="SETTRACKBARPOSITION"
#p[1480].words ="SETTRACKBARRANGE"
#p[1481].words ="SETTRACKBARTHUMBLENGTH"
#p[1482].words ="SETTRACKBARTICKFREQ"
#p[1483].words ="SETTYPE"
#p[1484].words ="SETUSERDATA"
#p[1485].words ="SETWINDOW"
#p[1486].words ="SETWINDOWCOLOR"
#p[1487].words ="SGN"
#p[1488].words ="SHELL32"
#p[1489].words ="SHOWCONTEXTMENU"
#p[1490].words ="SHOWDIALOG"
#p[1491].words ="SHOWIMAGE"
#p[1492].words ="SHOWWINDOW"
#p[1493].words ="SIN"
#p[1494].words ="SIND"
#p[1495].words ="SINH"
#p[1496].words ="SINHD"
#p[1497].words ="SIZEOF"
#p[1498].words ="SPACE$"
#p[1499].words ="SPINNERCONTROL"
#p[1500].words ="SPRITEALPHA"
#p[1501].words ="SPRITEANGLE"
#p[1502].words ="SPRITECOLLIDED"
#p[1503].words ="SPRITECOLLIDEDEX"
#p[1504].words ="SPRITEDRAWMODE"
#p[1505].words ="SPRITEFRAME"
#p[1506].words ="SPRITEMASKCOLOR"
#p[1507].words ="SPRITESCALEFACTOR"
#p[1508].words ="SPRITESHADOWOFFSET"
#p[1509].words ="SPRITETOBUFFER"
#p[1510].words ="SQRT"
#p[1511].words ="STARTDRAGDROP"
#p[1512].words ="STARTTIMER"
#p[1513].words ="STATIC"
#p[1514].words ="STATIC_CAST"
#p[1515].words ="STDMETHOD"
#p[1516].words ="STEP"
#p[1517].words ="STOP"
#p[1518].words ="STOPMIDI$"
#p[1519].words ="STOPTIMER"
#p[1520].words ="STR$"
#p[1521].words ="STRING"
#p[1522].words ="STRING$"
#p[1523].words ="SUB"
#p[1524].words ="SWORD"
#p[1525].words ="SYSTEM"

'T
#p[1526].words ="TABCONTROL"
#p[1527].words ="TAN"
#p[1528].words ="TAND"
#p[1529].words ="TANH"
#p[1530].words ="TANHD"
#p[1531].words ="TCDELETEALLTABS"
#p[1532].words ="TCDELETETAB"
#p[1533].words ="TCGETFOCUSTAB"
#p[1534].words ="TCGETITEMDATA"
#p[1535].words ="TCGETROWCOUNT"
#p[1536].words ="TCGETSELECTEDTAB"
#p[1537].words ="TCGETTABCOUNT"
#p[1538].words ="TCGETTABTEXT"
#p[1539].words ="TCHIGHLIGHTTAB"
#p[1540].words ="TCHITTEST"
#p[1541].words ="TCINSERTTAB"
#p[1542].words ="TCSETFOCUSTAB"
#p[1543].words ="TCSETIMAGE"
#p[1544].words ="TCSETIMAGELIST"
#p[1545].words ="TCSETITEMDATA"
#p[1546].words ="TCSETMINTABSIZE"
#p[1547].words ="TCSETSELECTEDTAB"
#p[1548].words ="TCSETTABTEXT"
#p[1549].words ="TCSETTIP"
#p[1550].words ="THEN"
#p[1551].words ="THIS"
#p[1552].words ="THREAD"
#p[1553].words ="THROW"
#p[1554].words ="TIME$"
#p[1555].words ="TIMER"
#p[1556].words ="TO"
#p[1557].words ="TOOLTIPCONTROL"
#p[1558].words ="TRACKBARCONTROL"
#p[1559].words ="TRY"
#p[1560].words ="TSTRING"
#p[1561].words ="TTADDTOOL"
#p[1562].words ="TTDELETETOOL"
#p[1563].words ="TTRELAYMESSAGE"
#p[1564].words ="TTSETTOOLRECT"
#p[1565].words ="TVDELETEALLITEMS"
#p[1566].words ="TVDELETEITEM"
#p[1567].words ="TVGETITEMDATA"
#p[1568].words ="TVGETITEMTEXT"
#p[1569].words ="TVGETSELECTEDITEM"
#p[1570].words ="TVINSERTITEM"
#p[1571].words ="TVSELECTITEM"
#p[1572].words ="TVSETITEMDATA"
#p[1573].words ="TVSETITEMTEXT"
#p[1574].words ="TYPE"
#p[1575].words ="TYPE_NAME"
#p[1576].words ="TYPEDEF"
#p[1577].words ="TYPEOF"

'U
#p[1578].words ="UCASE$"
#p[1579].words ="UINT"
#p[1580].words ="UINT64"
#p[1581].words ="UNION"
#p[1582].words ="UNLOCKBUFFER"
#p[1583].words ="UNLOCKSPRITE"
#p[1584].words ="UNTIL"
#p[1585].words ="USER"
#p[1586].words ="USER32"
#p[1587].words ="USING"

'V
#p[1588].words ="VAL"
#p[1589].words ="VEC3ADD"
#p[1590].words ="VEC3CROSS"
#p[1591].words ="VEC3DOT"
#p[1592].words ="VEC3LENGTH"
#p[1593].words ="VEC3LERP"
#p[1594].words ="VEC3NORMALIZE"
#p[1595].words ="VEC3SUB"
#p[1596].words ="VEC4ADD"
#p[1597].words ="VEC4CROSS"
#p[1598].words ="VEC4DOT"
#p[1599].words ="VEC4LENGTH"
#p[1600].words ="VEC4LERP"
#p[1601].words ="VEC4NORMALIZE"
#p[1602].words ="VEC4SUB"
#p[1603].words ="VIRTUAL"
#p[1604].words ="VOID"
#p[1605].words ="VSYNC"

'W
#p[1606].words ="W2S"
#p[1607].words ="WAIT"
#p[1608].words ="WAITCON"
#p[1609].words ="WAITKEY"
#p[1610].words ="WAITUNTIL"
#p[1611].words ="WAPPEND$"
#p[1612].words ="WCHR$"
#p[1613].words ="WEND"
#p[1614].words ="WHEAP"
#p[1615].words ="WHERE"
#p[1616].words ="WHEX$"
#p[1617].words ="WHILE"
#p[1618].words ="WINDOW"
#p[1619].words ="WINSTR"
#p[1620].words ="WINTECT"
#p[1621].words ="WITH"
#p[1622].words ="WLCASE$"
#p[1623].words ="WLEFT$"
#p[1624].words ="WLTRIM$"
#p[1625].words ="WM_GETTEXT"
#p[1626].words ="WM_KILLFOCUS"
#p[1627].words ="WM_SETFOCUS"
#p[1628].words ="WM_SETTEXT"
#p[1629].words ="WMID$"
#p[1630].words ="WORD"
#p[1631].words ="WRIGHT$"
#p[1632].words ="WRITE"
#p[1633].words ="WRITEALPHAPIXEL"
#p[1634].words ="WRITEMEM"
#p[1635].words ="WRITEPIXEL"
#p[1636].words ="WRITEPIXELFAST"
#p[1637].words ="WRITEPRINTER"
#p[1638].words ="WRITETEXT"
#p[1639].words ="WRTRIM$"
#p[1640].words ="WSPACE$"
#p[1641].words ="WSTR$"
#p[1642].words ="WSTRING"
#p[1643].words ="WSTRING$"
#p[1644].words ="WUCASE$"
#p[1645].words ="WUSING"
#p[1646].words ="WVAL"

'_
#p[1647].words = "__ASM"
#p[1648].words = "__DELETE"
#p[1649].words = "__GET"
#p[1650].words = "__NEW"
#p[1651].words = "__POWER"
#p[1652].words = "__PUT"
#p[1653].words = "__READ"
#p[1654].words = "__READMEM"
#p[1655].words = "__WRITE"
#p[1656].words = "__WRITEMEM"
#p[1657].words = "_ASM"
#p[1658].words = "_DUP$"
#p[1659].words = "_ENDASM"
#p[1660].words = "_WDUPSTR"
#p[1661].words = "_WSTRAPPEND"

RETURN 0
ENDSUB 

