'Developer's Image Library - Converted "ILU.h" Import Include file
'By: Todd Riggins(www.exodev.com)

$USE "ILU.lib"

CONST ILU_VERSION_1_6_5						=1
CONST ILU_VERSION							=165

CONST ILU_FILTER							=0x2600
CONST ILU_NEAREST							=0x2601
CONST ILU_LINEAR							=0x2602
CONST ILU_BILINEAR							=0x2603
CONST ILU_SCALE_BOX							=0x2604
CONST ILU_SCALE_TRIANGLE					=0x2605
CONST ILU_SCALE_BELL						=0x2606
CONST ILU_SCALE_BSPLINE						=0x2607
CONST ILU_SCALE_LANCZOS3					=0x2608
CONST ILU_SCALE_MITCHELL					=0x2609

'Error types
CONST ILU_INVALID_ENUM						=0x0501
CONST ILU_OUT_OF_MEMORY						=0x0502
CONST ILU_INTERNAL_ERROR					=0x0504
CONST ILU_INVALID_VALUE						=0x0505
CONST ILU_ILLEGAL_OPERATION					=0x0506
CONST ILU_INVALID_PARAM						=0x0509

'Values
CONST ILU_PLACEMENT						=0x0700
CONST ILU_LOWER_LEFT						=0x0701
CONST ILU_LOWER_RIGHT						=0x0702
CONST ILU_UPPER_LEFT						=0x0703
CONST ILU_UPPER_RIGHT						=0x0704
CONST ILU_CENTER						=0x0705
CONST ILU_CONVOLUTION_MATRIX					=0x0710
CONST ILU_VERSION_NUM						=0x0DE2

'Filters
/*
#define ILU_FILTER_BLUR					0x0803
#define ILU_FILTER_GAUSSIAN_3x3				0x0804
#define ILU_FILTER_GAUSSIAN_5X5				0x0805
#define ILU_FILTER_EMBOSS1				0x0807
#define ILU_FILTER_EMBOSS2				0x0808
#define ILU_FILTER_LAPLACIAN1				0x080A
#define ILU_FILTER_LAPLACIAN2				0x080B
#define ILU_FILTER_LAPLACIAN3				0x080C
#define ILU_FILTER_LAPLACIAN4				0x080D
#define ILU_FILTER_SHARPEN1				0x080E
#define ILU_FILTER_SHARPEN2				0x080F
#define ILU_FILTER_SHARPEN3				0x0810
*/

TYPE ILinfo
	DEF Id:UINT						:'the image id
	DEF DataPtr:POINTER				:'the image data - Unsigned Char Pointer
	DEF Width:UINT					:'the image width
	DEF Height:UINT					:'the image height
	DEF Depth:UINT					:'the image depth
	DEF Bpp:CHAR					:'bytes per pixel (not bits) of the image
	DEF SizeOfData:UINT				:'the total size of the data (in bytes)
	DEF Format:UINT					:'image format (in IL enum style)
	DEF EnumType:UINT				:'image type (in IL enum style)
	DEF Origin:UINT					:'origin of the image
	DEF Palette:POINTER				:'the image palette
	DEF PalType:UINT				:'palette type
	DEF PalSize:UINT				:'palette size
	DEF CubeFlags:UINT				:'flags for what cube map sides are present
	DEF NumNext:UINT				:'number of images following
	DEF NumMips:UINT				:'number of mipmaps
	DEF NumLayers:UINT				:'number of layers
ENDTYPE

TYPE ILpointf
	DEF x:FLOAT
	DEF y:FLOAT
ENDTYPE

TYPE ILpointi
	DEF x:INT
	DEF y:INT
ENDTYPE

'ImageLib Utility Functions
DECLARE IMPORT,iluAlienify(),INT
DECLARE IMPORT,iluBlurAvg(Iter:UINT),INT
DECLARE IMPORT,iluBlurGaussian(Iter:UINT),INT
DECLARE IMPORT,iluBuildMipmaps(),INT
DECLARE IMPORT,iluColoursUsed(),UINT
DECLARE IMPORT,iluCompareImage(Comp:UINT),INT
DECLARE IMPORT,iluContrast(Contrast:FLOAT),INT
DECLARE IMPORT,iluCrop(XOff:UINT,YOff:UINT,ZOff:UINT,Width:UINT,Height:UINT,Depth:UINT),INT
DECLARE IMPORT,iluDeleteImage(Id:UINT)
DECLARE IMPORT,iluEdgeDetectE(),INT
DECLARE IMPORT,iluEdgeDetectP(),INT
DECLARE IMPORT,iluEdgeDetectS(),INT
DECLARE IMPORT,iluEmboss(),INT
DECLARE IMPORT,iluEnlargeCanvas(Width:UINT,Height:UINT,Depth:UINT),INT
DECLARE IMPORT,iluEnlargeImage(XDim:FLOAT,YDim:FLOAT,ZDim:FLOAT),INT
DECLARE IMPORT,iluEqualize(),INT
DECLARE IMPORT,iluErrorString(Error:UINT),POINTER
DECLARE IMPORT,iluFlipImage(),INT
DECLARE IMPORT,iluGammaCorrect(Gamma:FLOAT),INT
DECLARE IMPORT,iluGenImage(),UINT
DECLARE IMPORT,iluGetImageInfo(InfoPtr:POINTER) :'<----- Pointer to a ILinfo structure
DECLARE IMPORT,iluGetInteger(Mode:UINT),INT
DECLARE IMPORT,iluGetIntegerv(Mode:UINT,ParamINT:POINTER)
DECLARE IMPORT,iluGetString(StringName:UINT),POINTER
DECLARE IMPORT,iluImageParameter(PName:UINT,Param:UINT)
DECLARE IMPORT,iluInit()
DECLARE IMPORT,iluInvertAlpha(),INT
DECLARE IMPORT,iluLoadImage(FileName:POINTER),UINT
DECLARE IMPORT,iluMirror(),INT
DECLARE IMPORT,iluNegative(),INT
DECLARE IMPORT,iluNoisify(Tolerance:FLOAT),INT
DECLARE IMPORT,iluPixelize(PixSize:UINT),INT
DECLARE IMPORT,iluRegionfv(Points:POINTER, n:UINT) :'<----- "Points" is a pointer to a ILpointf structure
DECLARE IMPORT,iluRegioniv(Points:POINTER, n:UINT) :'<----- "Points" is a pointer to a ILpointf structure
DECLARE IMPORT,iluReplaceColour(Red:CHAR,Green:CHAR,Blue:CHAR,Tolerance:FLOAT),INT
DECLARE IMPORT,iluRotate(Angle:FLOAT),INT
DECLARE IMPORT,iluRotate3D(x:FLOAT,y:FLOAT,z:FLOAT,Angle:FLOAT),INT
DECLARE IMPORT,iluSaturate1f(Saturation:FLOAT),INT
DECLARE IMPORT,iluSaturate4f(r:FLOAT,g:FLOAT,b:FLOAT,Saturation:FLOAT),INT
DECLARE IMPORT,iluScale(Width:UINT,Height:UINT,Depth:UINT),INT
DECLARE IMPORT,iluScaleColours(r:FLOAT,g:FLOAT,b:FLOAT),INT
DECLARE IMPORT,iluSharpen(Factor:FLOAT,Iter:UINT),INT
DECLARE IMPORT,iluSwapColours(),INT
DECLARE IMPORT,iluWave(Angle:FLOAT),INT

'#define iluColorsUsed	iluColoursUsed
'#define iluSwapColors	iluSwapColours
'#define iluReplaceColor	iluReplaceColour
'#define iluScaleColor	iluScaleColour
